%% system specific routines

#VMS
. ( 
.   [cmd] =cmd
.   [cfile file cmd]
.   "vms_shell.com" expand_jedlib_file =cfile
.   cfile strlen {"Unable to open vms_shell.com" error} !if
.   "@" cfile strcat "/output=" strcat =cfile
  
.   "sys$login:_jed_shell.cmd_" =file
.   cfile file strcat =cfile
  
.   " \"" cmd strcat "\"" strcat =cmd
.   "starting process..." flush
.   cfile cmd strcat system pop
.   file insert_file pop
.   file delete_file
. ) shell_cmd
#end VMS

#IBMPC
. (
.   [cmd] =cmd
.   [file] "_jed_shll.cmd" =file
.   cmd " > " strcat file strcat =cmd
.   "opening pipe..." flush
.   cmd system 0 < {"system failed." error} if
.   file insert_file pop
.   file delete_file
. ) shell_cmd

#end IBMPC

#NOT_UNIX
. (
.   [dir n] =dir
  % this bit will remove final slash on DOS unless it is root dir.
.   dir strlen =n
.   dir n 1 substr "\\" strcmp n 3 <= or
.     { 
.       dir 1 n 1 - substr =dir
.     } !if
.   dir 
. ) msdos_fix_dir

. (
.   [cmd n] 
.   "Shell Command:"  Null_String Null_String read_mini =cmd 
.   cmd strlen {return} !if
.   getbuf_info pop pop exch pop
.   msdos_fix_dir change_default_dir {"Unable to chdir!" error} if

.   "*shell-output*" pop2buf erase_buffer
.   cmd shell_cmd
.   bob
. ) do_shell_cmd
#end

#UNIX
. (
.    [msg shbuf cmd] "*shell-output*" =shbuf "opening pipe..." =msg
.    "Shell Command:"  Null_String Null_String read_mini =cmd
.    cmd strlen { return } !if
   
.    "(" cmd strcat ")" strcat =cmd
.    cmd " 2>&1" strcat =cmd
   
.    getbuf_info pop pop exch pop change_default_dir {"Unable to chdir!" error} if
.    shbuf pop2buf erase_buffer
.    msg flush
.    cmd shell_cmd bob
.    msg "done" strcat flush
. ) do_shell_cmd 
#end UNIX

. (
.   [km dir]  "*shell*" =km

.   km keymap_p { 
.     km make_keymap
.     "shell_input" "^M" km definekey
.   } !if
.   getbuf_info pop pop =dir pop
#IBMPC  
.   dir msdos_fix_dir =dir
#end
.   dir change_default_dir {"Unable to chdir!" error} if
  
  
.   km pop2buf
.   km use_keymap
.   "Current Directory is " insert dir insert newline
#UNIX
.    "% " insert
#end
#IBMPC
.    "> " insert
#end
#VMS
.    "$ " insert
#end
. ) shell


. (
.    [cmd tmp prompt]
#UNIX
.    "% " =prompt "/tmp/_jed_shell_" =tmp
#end
#IBMPC
.    "> " =prompt "jedshell.jed" =tmp
#end
#VMS
.    "$ " =prompt "sys$login:_jed_shell_.jed_" =tmp
#end
  
   
.    bol prompt skip_chars
.    push_mark eol bufsubstr =cmd
.    eob bol prompt skip_chars
.    cmd looking_at {cmd insert} !if
.    eol newline
.    0 update  %% Update now so user see that things are ok
   
.    cmd strlen {
.                 getbuf_info pop pop exch pop
#IBMPC
.                 msdos_fix_dir
#end
. 		change_default_dir {"Unable to chdir!" error} if

#UNIX
.                 "( " cmd strcat ")" strcat 
. 		" > " strcat tmp strcat " 2>&1" strcat
#end
#IBMPC
.                 cmd " > " strcat tmp strcat 
#end
#VMS
.                "vms_shell.com" expand_jedlib_file dup
. 	       strlen {pop "Unable to find vms_shell.com" error} !if
.                "@" exch strcat 
. 	       "/output=" strcat tmp strcat
. 	       " " strcat cmd strcat 
#end
.      system pop
.      tmp insert_file pop
.      tmp delete_file pop
.    } if
   
.    bolp {prompt}{"\n" prompt strcat} else insert
. ) shell_input

