%_traceback = 1;
#REM            Site specific initialiation file.

This file must be present in the JED_LIBRARY.  JED loads it first--- even
before reading command line arguments.  The command line arguments are then
passed to a hook declared in this file for further processing.

In addition to some hooks, this file declares some autoloads for various
functions and defines utility functions.  Any user specific stuff should be
placed in the jed.rc (.jedrc) user startup file.  Only put here what you
believe EVERY user on your system should get!

The best way to make changes in this file is to put all your changes in a
separate file, defaults.sl.  defaults.sl is NOT distributed with JED.  Code
at the edn of this file checks for the existence of `defaults.sl' and loads
it if found. Functions occuring in this file (site.sl) may be overloaded in
defaults.sl. Making changes this way also makes it easier to upgrade to
future JED versions.

#end rem

%
%     Global Variables
%

%%% A Comma separated list of info directories to search.
variable Info_Directory;
Info_Directory = JED_LIBRARY;


%%% Column to begin a C comment--- used by c_make_comment
variable C_Comment_Column;
C_Comment_Column = 40;


variable Null_String;       Null_String = "";

#UNIX
 if (OUTPUT_RATE > 3000) OUTPUT_RATE = 0;   %% coming through a network?
#end

%%
%% Some key definitions
%%
  setkey("skip_word", "^[^[[C");  %escape right arrow.
  setkey("bskip_word", "^[^[[D");  %escape left arrow
  setkey("upcase_word", "^[U");
  setkey("downcase_word", "^[L");
  setkey("capitalize_word", "^[C");
  setkey("emacs_escape_x", "^[X");
  setkey("undo", "^Xu");  %% Also ^_ but vtxxx have problems with it
  setkey("transpose_lines", "^X^T");
  setkey("help_prefix", "^H");
  setkey("c_make_comment", "^[;");
  setkey("do_shell_cmd", "^[!");
  setkey("find_tag", "^[.");
  setkey("save_buffers", "^Xs");
  setkey("whatpos", "^X?");
  setkey("list_buffers", "^X^B");
#UNIX
  setkey("ispell", "^[$");
#end
#NOT_IBMPC
  setkey("mail", "^Xm");
#endif

%%
%%  Autoloads
%%

#IBMPC
  autoload("lpr",			"lpr");
#end
#VMS
  autoload("dcl",			"dcl");
#end
  autoload("jed_easy_help",		"jedhelp");
  autoload("query_replace_match",	"regexp");
  autoload("re_search_forward",		"regexp");
  autoload("re_search_backward",	"regexp");
  autoload("c_make_comment",		"cmisc");
  autoload("dired",			"dired");
  autoload("calendar",			"cal");
  autoload("menu_main_cmds",		"menu");
  autoload("trim_buffer",		"util");  %% trims excess lines and space
  autoload("occur",			"util");  %% find all command
  autoload("info_mode",			"info");
  autoload("list_buffers",		"buf");
  autoload("append_region",		"buf");
  autoload("write_region",		"buf");
  autoload("recover_file",		"buf");
  autoload("most_mode",			"most");
  autoload("run_most",			"most");
  autoload("compile",			"compile");
  autoload("sort",			"sort");
  autoload("untab",			"untab");
  autoload("fortran",			"fortran");
  autoload("save_buffers",		"buf");
  autoload("rot13",			"rot13");
  autoload("isearch_forward",		"isearch");
  autoload("isearch_backward",		"isearch");
  autoload("shell",			"shell");
#NOT_UNIX
  autoload("shell_cmd",			"shell");
#end
  autoload("do_shell_cmd",		"shell");
  autoload("find_tag",			"ctags");
  autoload("apropos",			"help");
  autoload("expand_keystring",		"help");
  autoload("describe_function",		"help");
  autoload("describe_variable",		"help");
  autoload("help_for_function",		"help");
  autoload("where_is",			"help");
  autoload("showkey",			"help");
  autoload("describe_mode",		"help");
  autoload("format_paragraph_hook",	"tmisc");

%%
%% By default, tabs are every TAB columns (default 8).  Calling this function
%% will allow the user to set the tabs arbitrarily and bind the TAB key
%% appropriately.
  autoload("edit_tab_stops",		"tabs");
#NOT_IBMPC
  autoload("mail",			"mail");
#endif

#UNIX
  autoload("unix_man",			"man");
  autoload("rmail",			"rmail");
  autoload("ispell",			"ispell");
  autoload("dcl",			"dcl");
#end UNIX

% Utility functions

define go_up(n) { pop(up(n)); }
define go_down(n) { pop(down(n));}
define go_left(n) { pop(left(n));}
define go_right(n) { pop(right(n));}

%% emacs-like escape-x function
define emacs_escape_x()
{
   variable f, i;
   f = Null_String; i = 0;
  
   if (MINIBUFFER_ACTIVE)
     {
	call("evaluate_cmd");
	return;
     }
   
   forever
     {
	if (is_internal(f)) 
	  {
	     call(f);
	     return;
	  }
	
	if (is_defined(f))
	  {
	     eval(f);
	     return;
	  }
	
	if (i == 1) ungetkey(13);
	ungetkey(9);
	++i;
	f = read_with_completion("M-x", Null_String, f, 'F')
     } 
}

define goto_line_cmd()
{
   read_mini("Goto line:", Null_String, Null_String);
   goto_line(integer(()));
}

define goto_column_cmd()
{
   read_mini("Goto Column:", Null_String, Null_String);
   goto_column(integer(()));
}

%% A useful hooks function---
%% There is a builtin one in slang as well that is called from C code
define runhooks(fun)
{
   if (is_defined (fun)) eval(fun);
}

%% useful functions for use in user hooks--- operate on current keymap
define local_setkey(f, key)
{
   definekey(f, key, what_keymap());
}

define local_unsetkey(key)
{
   undefinekey(key, what_keymap());
}

%%% insert a character into a buffer.
%%% This function should be called instead of 'insert' when it is desired to
%%% insert a 1 character string.  Unlike 'insert', insert_char takes an integer
%%% argument.  For example, 
%%%    'x' insert_char
%%% and 
%%%    "x" insert
%%% are functionally equivalent but insert_char is more memory efficient.
define insert_char(ch) 
{ 
   insert (char(ch));
}


%%%   insert a newline in buffer
define newline () 
{ 
   insert_char(10);
}

   
%%% insert a single space into the buffer.
define insert_single_space ()
{
   insert_char(' ');
}


define looking_at_char(ch)   % case sensitive
{
   what_char() == ch;
}


%%% returns type of file.  e.g., /usr/a.b/file.c --> c
define file_type(file)
{
   variable n;
   file = extract_filename(file);
   
   n = is_substr(file, ".");
   !if (n) return (Null_String);
   
   substr(file, n + 1, strlen(file));
}


%%% A function to contat a directory with a filename.  Basically checks
%%% for the final slash on the dir and adds on if necessary
define dircat(dir, file)
{
   variable n;
   n = strlen(dir);
   
#IBMPC
   variable slash;  slash = "\\";
   if (n)
     {
	if (strcmp(substr(dir, n, 1), slash)) dir = strcat(dir, slash);
     }
   strcat(dir, file);
#end
#UNIX
   variable slash;  slash = "/";
   if (n)
     {
	if (strcmp(substr(dir, n, 1), slash)) dir = strcat(dir, slash);
     }
   strcat(dir, file);
#end
#VMS
   % convert a.dir;1 to [.a] first
   variable f1, d1;
   dir = extract_element(dir, 0, ';');
   f1 = extract_element(dir, 1, ']');
   if (strlen(f1)) f1 = strcat(".", extract_element(f1, 0, '.'));
   d1 = extract_element(dir, 0, ']');
   strcat(d1, f1);
   if (':' != int(substr(dir, strlen(dir), 1))) strcat((), "]");
   strcat ((), file);
#end
   expand_filename(());
}

%;; scroll other window macros-- bind them yourself
define next_wind_up()
{
   otherwindow();  call("page_up");
   loop (nwindows() - 1) otherwindow();
}

define next_wind_dn()
{
   otherwindow();  call("page_down");
   loop (nwindows() - 1) otherwindow();
}

%%% Mode dedicated to facilitate the editing of C language files.  Functions
%%% that affect this mode include:
%%%
%%%   function:             default binding:
%%%   brace_bra_cmd               {
%%%   brace_ket_cmd               }
%%%   newline_and_indent          RETURN
%%%   indent_line                 TAB
%%%   goto_match                  ^\
%%%   c_make_comment              ESC ;
%%%
%%%  Variables affecting indentation include:
%%%
%%%   C_INDENT
%%%   C_BRACE
%%%   C_Comment_Column  --- used by c_make_comment
define c_mode()
{
   setmode("C", 2);
   use_keymap("global");
}

%%%  Mode for indenting and wrapping text
%%%  Functions that affect this mode include:
%%%
%%%    Function:                     Default Binding:
%%%      indent_line                     TAB
%%%      newline_and_indent              RETURN
%%%      format_paragraph                ESC Q
%%%      narrow_paragraph                ESC N
%%%
%%%  Variables include:
%%%      WRAP_INDENTS, WRAP
%%%      TAB, TAB_DEFAULT
define text_mode()
{
   setmode("Text", 1);
   use_keymap("global");
}

%%%  Generic mode not designed for anything in particular.
%%%  See:  text_mode, c_mode
define no_mode()
{
   setmode(Null_String, 0);
   use_keymap("global");
}

% Function prototypes
% These 'functions' are only here to initialize function pointers.
define _function_pop_0 (x) {0}

%%% called from mode_hook.  Returns 0 if it is desired that control return
%%% to mode_hook or 1 if mode hook should exit after calling mode_hook_ptr
variable mode_hook_pointer; mode_hook_pointer = &_function_pop_0;


%%% This is a hook called by find_file routines to set the mode
%%% for the buffer. This function takes one parameter, the filename extension
%%% and returns nothing.
define mode_hook(ext)
{
   if (mode_hook_pointer(ext)) return;
   switch(ext)
     {not (strcmp((), "c")) : c_mode}
     {not (strcmp((), "h")) : c_mode}
     {not (strcmp((), "tex")) : text_mode}
     {not (strcmp((), "txt")) : text_mode}
     {not (strcmp((), "doc")) : text_mode}
     {not (strcmp((), "f")) : fortran }
     {not (strcmp((), "for")) : fortran }
     {not (strcmp((), "dat")) : no_mode }
     {not (strcmp((), "sl")) : c_mode }
     {not (strcmp((), "rc")) : c_mode } 
#UNIX
     {not (strcmp((), "jedrc")) : c_mode } 
     {not (strcmp((), "cshrc")) : no_mode } 
     {not (strcmp((), "tcshrc")) : no_mode }
     {not (strcmp((), "login")) : no_mode } 
     {not (strcmp((), "profile")) : no_mode }
#end
#NOT_IBMPC
     {not (strcmp((), "com")) : dcl}
#endif
     {not (strcmp((), "ci")) : c_mode}
     {pop(); text_mode()} %%  default
}

%%% sets buf modified flag. If argument is 1, mark
%%% buffer as modified.  If argument is 0, mark buffer as unchanged.
define set_buffer_modified_flag(modif)
{
   getbuf_info();
   if (modif) () | 1; else () & ~(1);
   setbuf_info(());
}


%%% set undo mode for buffer.  If argument is 1, undo is on.  0 turns it off
define set_buffer_undo(modif)
{
   getbuf_info();
   if (modif) () | 32; else () & ~(32);
   setbuf_info(());
}


%%% Takes 1 parameter: 0 turn off readonly
%%%                    1 turn on readonly
define set_readonly(n)
{
   getbuf_info();
   if (n) () | 8; else () & ~(8);
   setbuf_info(());
}

%%% Takes 1 parameter: 0 turn off overwrite
%%%                    1 turn on overwrite
define set_overwrite(n)
{
   getbuf_info();
   if (n) () | 16; else () & ~(16);
   setbuf_info(());
}

define toggle_readonly()
{
   setbuf_info(getbuf_info() xor 8);
}
define toggle_overwrite()
{
   setbuf_info(getbuf_info() xor 16);
}
#IBMPC
setkey("toggle_overwrite", "^@R");     %/* insert key */
#end

define toggle_undo()
{
   setbuf_info(getbuf_info() xor 32);
}

define double_line()
{
   POINT;
   bol(); push_mark(); eol(); 
   bufsubstr(); 
   newline();
   insert(());
   =POINT;
}

define transpose_lines()
{
   variable line;
   bol(); push_mark(); push_mark(); eol(); 
   line = bufsubstr();
   go_right(1);
   del_region();
   go_up(1); bol();
   insert(line);
   newline();
   go_down(1);
   bol();
}



%%% called from main in JED executable.
%%% The top element of stack is number of command line parameters--- n. 
%%% Then the next element is argv[0], followed by the n command
%%% line parameters.  n is NOT argc, it is argc - 1.
define command_line_hook()
{
   variable n, i, file, depth, jedrc, home;
   
   jedrc = "jed.rc";
  
#UNIX
   jedrc = ".jedrc";
#end
   
   home = getenv("JED_HOME");
#VMS
%% allows JED_HOME: to be search list---
%% thanks to SYSTEM@VACMZB.chemie.Uni-Mainz.DE for suggestion
   if (strlen(home)) home = "JED_HOME:";
#end
   !if (strlen(home))
     {
	home = getenv("HOME");
#VMS
	home = "SYS$LOGIN:";
#end
     } 
   jedrc = dircat(home, jedrc);
   
   n = MAIN_ARGC;
   
   --n;  %% argv[0], here it is not used.
%
%  If batch then first argument is not used so start at second
%  Also, n is the number of effective command line parameters so reduce it.
%
   
   if (BATCH) {	--n; 2; } else 1;  =i;
%
% if first argument is -n then do NOT load init file
%
   % stuff left on stack for if 
   if (n) strcmp (command_line_arg(i), "-n"); else 1;
   if (())
     {
	depth = _stkdepth;
	if (file_status(jedrc) == 1) jedrc; else "jed.rc";
	evalfile(()); pop();
	if ( _stkdepth != depth)
	  {
	     flush(strcat ("Excess junk left on stack by ", jedrc));
	     pop(input_pending(10));
	  }

	loop (_stkdepth - depth) pop();
     }
   else if (n) ++i;
   n = n;
   n = MAIN_ARGC - i;
   !if (n) return;
%
% Is JED to emulate most?
%
   !if (strcmp(command_line_arg(i), "-most"))
     {
	run_most (i + 1);
	return;
     }
   
   while (n > 0)
     {
	file = command_line_arg(i);
	--n; ++i;
	switch(file)
	  {not(strcmp ((), "-f")) and n : eval(command_line_arg(i))}
	  {not(strcmp ((), "-g")) and n : goto_line(integer(command_line_arg(i)))}
	  {not(strcmp ((), "-s")) and n : fsearch(command_line_arg(i)); pop();}
	  {not(strcmp ((), "-l")) and n : evalfile(command_line_arg(i)); pop();}
	  {not(strcmp ((), "-i")) and n : insert_file(command_line_arg(i)); pop();}
	  {not(strcmp ((), "-2")) : splitwindow(); ++n; --i;}
	  {find_file(()); pop(); ++n; --i;}
	
	--n; ++i;
     }
}


%%% string to display at bottom of screen upon JED startup and when
%%% user executes the help function.
variable help_for_help_string;

help_for_help_string =
#VMS
 "^H -> Help:^H  Menu:?  Info:I  Apropos:A  Key:C  Function:F  Variable:V";
#end
#IBMPC
 "^H -> Help:^H  Menu:?  Info:I  Apropos:A  Key:C  Function:F  Variable:V  Mem:M";
#end
#UNIX
 "^H -> Help:^H  Menu:?  Info:I  Apropos:A  Key:C  Function:F  Variable:V  Man:M";
#end

% Load minibuffer routines now before any files are loaded.
% This will reduce fragmentation on PC.
!if (BATCH) {evalfile("mini"); pop();}


%for compatability with older versions
define read_file_from_mini() 
{
   read_with_completion( Null_String, Null_String, 'f');
}

%% startup hook
%%% Function that gets executed right before JED enters its main editing
%%% loop.  This is for last minute modifications of data structures that
%%% did not exist when startup files were loaded (e.g., minibuffer keymap)
define  jed_startup_hook()
{
   variable n, hlp, ok, mini;
   ok = 0; mini = "Mini_Map";
#IBMPC
   definekey ("next_mini_command", "^@P", mini);
   definekey ("prev_mini_command", "^@H", mini);
#end
#NOT_IBMPC
   definekey ("next_mini_command", "^[[B", mini);
   definekey ("prev_mini_command", "^[[A", mini);
#endif

   definekey ("mini_exit_minibuffer", "^M", mini);
   definekey ("exit_mini", "^[^M", mini);
  

%% if you want to startup jed with a filename use these 3 lines:
%  whatbuf "*scratch*" strcmp {return} if
%  {"Enter Filename:" read_file_from_mini dup strlen {break} if} forever
%  find_file pop

   message(help_for_help_string);
}


%%% display row and column information in minibuffer
define whatpos ()
{
   strcat(count_chars(), ", Line ");
   strcat( (), string(whatline()));
   strcat( (), " of ");
   push_spot(); eob(); 
   strcat( (), string(whatline()));
   pop_spot();
   strcat( (), " lines, Column ");
   strcat( (), string(what_column()));
   message( () );
}


%%% Search for FILE in directories specified by JED_LIBRARY returning
%%% expanded pathname if found or the Null string otherwise.
define expand_jedlib_file(f)
{
   variable n, dir, file;
   n = 0;
   forever
     {
	dir = extract_element(JED_LIBRARY, n, ',');
	!if (strlen(dir)) return (Null_String);
	file = dircat(dir, f);
	if (file_status(file) == 1) break;
	++n;
   } 
   file;
}

%%% find a file from JED_LIBRARY, returns number of lines read or 0 if not 
%%% found.
define find_jedlib_file(file)
{
   file = expand_jedlib_file(file);
   !if (strlen(file)) return(0);
   find_file(file);
}


%%
%% help function
%%

%%% name of the file to load when the help function is called.
variable Help_File;
Help_File = "jed.hlp";   %% other modes will override this.

%%% Pop up a window containing a help file.  The help file that is read
%%% in is given by the variable Help_File.
define help()
{
   variable hlp, file, buf, rows;
   hlp = "*help*";
    
   Help_File = expand_jedlib_file(Help_File);
   !if (strlen(Help_File)) error ("No help file available.");
   buf = whatbuf();
   onewindow();
   rows = pop(window_size());
   file = Help_File;
   setbuf(hlp);
   set_readonly(0);
   erase_buffer();

   insert_file(Help_File); pop();
   pop2buf(hlp);
   eob(); bskip_chars("\n");
   rows = rows / 2 - (whatline() + 1);
   bob();
   set_buffer_modified_flag(0);
   set_readonly(1);
   pop2buf(buf);
   loop (rows) enlargewin();
   message(help_for_help_string);
}

#VMS
%% This resume hook is need for VMS when returning from spawn.
%% In fact, it is NEEDED for certain JED functions on VMS so declare it.
define resume_hook()
{
   variable file;
   file = getenv("JED_FILE_NAME");
   !if (strlen(file)) return;
   
   !if (find_file(file)) error("File not found!");
}
#end VMS


%%file hooks
%%% returns backup filename.  Arguments to function are dir and file.
define make_backup_filename(dir, file)
{
#UNIX
   strcat (strcat (dir, file), "~");
#end
#IBMPC
   variable type;
   type = file_type(file);
   if (3 == strlen(type))
     {
	file = strcat (strcat (extract_element(file, 0, '.'), "."),
		       substr(type, 1, 2));
     }
   strcat (strcat (dir, file), "~");
#end  
}


%%% returns backup filename.  Arguments to function are dir and file.
define make_autosave_filename(dir, file)
{
#VMS
   file = strcat (strcat ("_$", file), ";1");
   strcat (dir, file);
#end
#UNIX
   variable p;  p = "#";
   strcat (dir, strcat (strcat (p, file), p));
#end
#IBMPC
   strcat (dir, strcat ("#", file));
#end
}

%%% breaks a filespec into dir filename--- 
%%% this routine returns dir and filename such that a simple strcat will
%%% suffice to put them together again.  For example, on unix, /a/b/c
%%% returns /a/b/ and c
define parse_filename(fn)
{
   variable f, dir, n;
      
   f = extract_filename(fn);
   n = strlen(fn) - strlen(f);
   dir = substr(fn, 1, n);
   dir; f;
}
 
%%% called AFTER a file is read in to a buffer.  FILENAME is on the stack.
define find_file_hook(file)
{
   variable dir, a, f, m;
   parse_filename(file); =f; =dir;
   
   a = make_autosave_filename(dir, f);
   if (file_time_compare(a, file) > 0) 
     {
	m = "Autosave file is newer. Use ESC-X recover_file.";
	flush(m);
        input_pending(10); pop();
	message(m);
     } 
}

%
% completions  -- everything here must be predefined
% I just push the strings onto the stack and loop 'add_completion' over them
%
  $0 = _stkdepth();

. "toggle_overwrite" "toggle_readonly" "toggle_undo" "calendar" "trim_buffer"
. "occur" "info_mode" "list_buffers" "append_region" "write_region"
. "recover_file" "compile" "sort" "untab" "fortran" "save_buffers" "rot13"
. "isearch_forward" "isearch_backward" "shell" "apropos" "describe_function"
. "describe_variable" "where_is" "showkey" "edit_tab_stops" "c_mode"
. "text_mode" "no_mode" "goto_line_cmd" "goto_column_cmd" "describe_mode"
. "evalbuffer" "open_rect" "kill_rect" "insert_rect" "copy_rect" "blank_rect"
. "dired" "re_search_forward" "re_search_backward" "query_replace_match"

#NOT_IBMPC
.  "mail" 
#end
#UNIX
. "ispell"		
#end UNIX

loop (_stkdepth - $0) add_completion(());


% save buffer if necessary
define save_buffer()
{
   variable flags, dir, file;
   getbuf_info(); =flags; pop(); =dir; =file;

   !if (flags & 1) return (message("Buffer not modified."));
   if (strlen(file))
     {
	write_buffer(dircat(dir, file)); pop();
     }
   else call ("save_buffers");
} add_completion("save_buffer");

define insert_buffer()
{
   read_with_completion("Insert Buffer:", Null_String, Null_String, 'b');
   push_spot();
   ERROR_BLOCK {pop_spot()}
   insbuf(());
   EXECUTE_ERROR_BLOCK;
}  add_completion("insert_buffer");


define help_prefix()
{
   variable c;
   
   !if (input_pending(20)) flush (help_for_help_string);
   c = int (strup(char(getkey())));
   switch (c)
     { () == 8 : help }
     { () == 'A' : apropos }
     { () == 'I' : info_mode}
     { () == '?' : menu_main_cmds}
     { () == 'F' : describe_function}
     { () == 'V' : describe_variable}
     { () == 'W' : where_is}
     { () == 'C' : showkey}
     { () == 'M' :
#UNIX
	unix_man();
#end
#IBMPC
	call("coreleft");
#end
     }
     { pop(); beep(); }
}

%%
%%  word movement definitions.  Since these vary according to editors,
%%  they are S-Lang routines.
%%

define skip_word ()
{
  while (skip_non_word_chars(), eolp()) 
    {
      if (1 != right(1)) break;
    }
   skip_word_chars();
}

define bskip_word()
{
   while (bskip_non_word_chars(), bolp())
     {
	!if (left(1)) break;
     }
}
define delete_word()
{
   push_mark(); skip_word(); del_region();
}

define xform_word(x)
{
   skip_non_word_chars();
   push_mark(); skip_word(); 
   xform_region(x);
}

define capitalize_word()
{
   xform_word('c');
}

define upcase_word()
{
   xform_word('u');
}

define downcase_word()
{
   xform_word('d');
}

define smart_set_mark_cmd ()
{
   if (markp()) pop_mark(0); else call("set_mark_cmd");
}

define flush_input()
{
     while (input_pending(0)) pop(getkey());
}

%%% Prototype Void buffer_format_in_columns();
%%% takes a buffer consisting of a sigle column of items and converts the
%%% buffer to a multi-column format.
define buffer_format_in_columns()
{
   push_spot();
   bob();
   forever 
     {
	_for (0,4,1) 
	  {
	     goto_column(() * 14 + 1);
	     if (eolp())
	       {
		  if (eobp()) 
		    {
		       pop_spot();
		       return;
		    }
		  insert_single_space;
		  del();
	       }
	  } 
	!if (down(1)) break;
	bol();
     }
   pop_spot();
}


%
%  This code fragment looks for the existence of "defaults.sl" and loads
%  it.  This file IS NOT distributed with JED.
%

if (strlen(expand_jedlib_file("defaults.sl"))) pop(evalfile("defaults"));

