%%
%%  Tab routines for JED
%%

. "Tab_Stops" is_defined 
.   {'i' 20 1 create_array ". [Tab_Stops] =Tab_Stops" eval} !if

%% The following defines the tab stops to be 8 column:
. 0 19 1 { dup 8 * 1 + exch Tab_Stops aput } _for

. (
.   [c goal]
.   what_column =c
  
.   0 19 1 { 
.            Tab_Stops aget =goal
. 	   goal c > {break} if
. 	 } _for
  
.   goal c - { " " insert} loop
  
. ) tab_to_tab_stop  "tab_to_tab_stop" "^I" setkey

. [_Tabs_Buffer]

%% emacs like edit tab stops
. (
.   [tbuf] whatbuf =_Tabs_Buffer
.   "*TabsEdit*" =tbuf
 
.   tbuf  sw2buf erase_buffer
.   0 =TAB
  
.   tbuf keymap_p
.     { tbuf make_keymap
.       "^C" tbuf undefinekey
.       "tabs_install_tab_stops" "^C^C" tbuf definekey
.     } !if
    
.   tbuf use_keymap
.   0 19 1 { Tab_Stops aget goto_column "T" insert } _for
.   newline
.   1 13 1 { dup 10 * goto_column string insert} _for
.   newline
.   13 {"1234567890" insert} loop
.   "\nTo install changes, type control-c control-c." insert
.   bob
.   0 set_buffer_modified_flag
.   1 set_overwrite
. ) edit_tab_stops

. ( 
.    [i]
.    bob
.    0 19 1 { =i
.             skip_white
. 	    eolp {break} if
. 	    what_column i Tab_Stops aput
. 	    1 right pop
. 	  } _for
	
.    i 19 1 { =i 0 i Tab_Stops aput } _for
.    0 set_buffer_modified_flag
.    whatbuf delbuf
.    whatbuf _Tabs_Buffer strcmp { _Tabs_Buffer sw2buf } if
   
. ) tabs_install_tab_stops


