/*
 *  Copyright (c) 1992, 1993 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include "config.h"
#include "buffer.h"
#include "screen.h"
#include "window.h"
#include "vterm.h"
#include "mem.h"

void vscroll_down(int r1, int r2, int num)
{
   unsigned short *old;
   int r, rp1;

   r1--; r2--;
   for (r = r2; r >= r1 + num; r--)
     {
	rp1 = r - num;
	old = Screen[r].old;
	Screen[r].line = Screen[rp1].line;
	Screen[r].n = Screen[rp1].n;
	Screen[r].flags = Screen[rp1].flags;
	Screen[r].old = Screen[rp1].old;
	Screen[r].hi0 = Screen[rp1].hi0;
	Screen[r].hi1 = Screen[rp1].hi1;
	Screen[rp1].old = old;
     }
   for (r = r1; r < r1 + num; r++)
     {
	Screen[r].line = NULL;
	Screen[r].n = 0;
	Screen[r].flags = 0;
	Screen[r].hi0 = NULL;
	Screen[r].hi1 = NULL;
	blank_line(r);
     }
}

void vscroll_up(int r1, int r2, int num)
{
   unsigned short *old;
   register int r, rp1;

   r1--; r2--;
   
   for (r = r1; r <= r2 - num; r++)
     {
	old = Screen[r].old;
	rp1 = r + num;
	Screen[r].line = Screen[rp1].line;
	Screen[r].n = Screen[rp1].n;
	Screen[r].flags = Screen[rp1].flags;
	Screen[r].old = Screen[rp1].old;
	Screen[r].hi0 = Screen[rp1].hi0;
	Screen[r].hi1 = Screen[rp1].hi1;
	Screen[rp1].old = old;
     }
   
   for (r = r2 - num + 1; r <= r2; r++)
     {
	Screen[r].line = NULL;
	Screen[r].n = 0;
	Screen[r].flags = 0;
	Screen[r].hi0 = 0;
	Screen[r].hi1 = 0;
	blank_line(r);
     }
}

void vins(char ch)
{
   int r;
   unsigned short *p, *p1;
   unsigned short *pins;

    r = Screen_Row - 1;
    if (ch > ' ') Screen[r].n += 1;
    pins = Screen[r].old + Screen_Col - 1;
    p = Screen[r].old + Window->width - 1;
    while(p > pins)
      {
	 p1 = p - 1;
	 *p = *p1;
         p = p1;
      }
    *p = ch;
}

void vdel()
{
   int r;
   register unsigned short *p, *p1, *pmax;

    r = Screen_Row - 1;
    p = Screen[r].old + Screen_Col - 1;
    pmax = Screen[r].old + Window->width - 1;
    while(p < pmax)
      {
	 p1 = p + 1;
	 *p = *p1;
	 p = p1;
      }
    *p = ' ';
}

void vdel_eol()
{
   int r;
   register unsigned short *p, *pmax;
   
   r = Screen_Row - 1;
   p = Screen[r].old + Screen_Col - 1;
   pmax = Screen[r].old + Window->width;
   /* MEMSET(p, ' ', Window->width - Screen_Col + 1); */
   
    while(p < pmax)
      {
          *p = ' ';
          p++;
      }
    *p = ' '; 
}

