#include <math.h>
#include <stdio.h>

#include "slang.h"

void help()
{
   puts("ALL statements MUST be terminated with a ';' character, e.g., quit();\n");
   puts("Available functions:");
   puts("  cos, sin, tan, atan, acos, asin, exp, log, sqrt, fabs, log10, pow, PI, E");
   puts("\nas well as intrinsic S-Lang functions.");
   puts("See S-Lang language documentation for further details.");
   puts("\nAdditional functions:");
   puts("  print -- prints string, e.g. print(\"hello world!\\n\");");
   puts("  p();     -- displays top element of the stack.");
   puts("  quit();  -- quit calculator");
   puts("\nExample: p (2.4 * E);    yields 6.52388.\n");
}      

/* The following three functions will be callable from the interpreter */
void quit_calc()
{
   exit(0);
}


void print(char *s)
{
   fputs(s, stdout);
}

void error(char *s)
{
   fprintf(stderr, "%s\n", s);
   SLang_Error = 1;
}

/* Now here is a table that provides the link between the above functions and
   the S-Lang interpreter */
SLang_Name_Type Calc_Intrinsics[] =
{
   MAKE_INTRINSIC(".print", print, VOID_TYPE, 1),
   MAKE_INTRINSIC(".quit", quit_calc, VOID_TYPE, 0),
   MAKE_INTRINSIC(".help", help, VOID_TYPE, 0),
   MAKE_INTRINSIC(".error", error, VOID_TYPE, 1),
   SLANG_END_TABLE
};
   

int main ()
{
   if (!init_SLang() 		       /* basic interpreter functions */
       || !init_SLmath() 	       /* sin, cos, etc... */
       || !init_SLfiles()	       /* file i/o */
       || !SLang_add_table(Calc_Intrinsics, "Calc"))   /* calc specifics */
     {
	fprintf(stderr, "Unable to initialize S-Lang.\n");
	exit(1);
     }
   
   SLang_User_Prompt = "CALC> ";
   SLang_load_file("calc.sl");
   SLang_Error = 0;
   fputs("Type 'help();' for help and a list of available functions.\n", stdout);
   fputs("Note also that statements end in a ';'\n", stdout);
	     
   while(1)
     {
	SLang_load_file(NULL);
	if (!SLang_Error) break;
	SLang_restart(1);
	SLang_Error = 0;
     }
   return (0);
}
