#ifndef _DAVIS_MALLOC_H__
#define _DAVIS_MALLOC_H__
/* system specific malloc prototypes and macros. */
/*
   Copyright (C) 1993 John E. Davis (davis@amy.tch.harvard.edu)
   All rights reserved.

   This file is part of S-Lang.

   S-Lang is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY.  No author or distributor accepts responsibility to
   anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.
   Refer to the S-Lang General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   S-Lang, but only under the conditions described in the S-Lang General
   Public License.  A copy of this license is supposed to have been given
   to you along with S-Lang so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among other
   things, the copyright notice and this notice must be preserved on all
   copies.
*/
#ifdef msdos
#  define VOID void
#  include <alloc.h>
#  define FREE(buf)  farfree((void far *)(buf))
#  define MALLOC(x) farmalloc((unsigned long) (x))
#  define REALLOC(buf, n) farrealloc((void far *) (buf), (unsigned long) (n))
#  define CALLOC(n, m) farcalloc((unsigned long) (n), (unsigned long) (m))
#else
#  ifndef VMS
#    ifndef HAS_MALLOC_H
#      include <malloc.h>
#    endif
#  endif
#  define VOID unsigned char
#  define FREE(p) free((VOID *)(p))
#  define MALLOC malloc
#  define REALLOC realloc
#  define CALLOC calloc
#endif


/* _DAVIS_MALLOC_H__ */
#endif 
