/***************************************************************************
 *
 * FILE NAME		: color_lib.c
 *
 * AUTHOR		: Andrew Peebles
 *
 * DESCRIPTION		: routines for handling color
 *
 * VERSIONS		: %W%
 *
 ***************************************************************************/

/*
 * standard includes
 */
#include <stdio.h>
#include <ctype.h>

#include <Xm/Xm.h>

extern Widget top;

XColor *
PixelToRGB (display, cm, pixel)
Display	*display;
Colormap cm;
unsigned long pixel;
{
  XColor *rgb = (XColor *) XtMalloc (sizeof(XColor));
  int	status;

  rgb->pixel = pixel;
  status = XQueryColor (display, cm, rgb);
  if (status == BadColor) {
    Warning (top, "XQueryColor: Bad Color");
    XtFree (rgb);
    return (NULL);
  }
  if (status == BadValue) {
    Warning (top, "XQueryColor: Bad Value");
    XtFree (rgb);
    return (NULL);
  }

  return (rgb);
}
  
