 #module MX_BULL "01-002" /*  *  *  Program:	MX_BULL  *  *  Author:	Hunter Goatley  *		Academic Computing, STH 226   *		Western Kentucky University   *		Bowling Green, KY 42101   *		goathunter@wkuvx1.bitnet  *		502-745-5251  *  *  Date:	March 8, 1991   *  *  Functional description:   *C  *	This program serves as an MX SITE transport to transfer incoming (  *	mail files to Mark London's BULLETIN.  *F  *	The MX_SITE delivery agent takes messages routed to a SITE path andG  *	feeds them into a subprocess that executes a command procedure named E  *	MX_EXE:SITE_DELIVER.COM.  There are three parameters passed to the   *	the command procedure:   *<  *		P1	- The name of a temporary file containing the message0  *			  text, including all of the RFC822 headers1  *			  (corresponding to the DATA part of an SMTP   *			  transaction).:  *		P2	- The name of a temporary file containing a list of6  *			  a messages recipients, which corresponds to the0  *			  RCPT_TO addresses of an SMTP transaction.9  *		P3	- The RFC822 address of the sender of the message, 7  *			  which corresponds to the MAIL FROM address of an   *			  SMTP transaction.  *B  *	This program expects the same parameters, except that the thirdF  *	parameter is optional.  If the third parameter is omitted, BULLETINB  *	will scan the RFC822 headers in the message for a "From:" line.C  *	If the third parameter is specified, it is expected to be a file F  *	specification.  It is assumed that SITE_DELIVER.COM has written the  *	address to this file.  *?  *	The logical MX_BULLETIN_POSTMASTER can be defined as a local C  *	username to receive error notices.  If BULLETIN returns an error @  *	while trying to add a message, and the MX_BULLETIN_POSTMASTERC  *	is defined as a valid local username, the message will be mailed %  *	to that user for further handling.   *H  *	MX_BULLETIN_POSTMASTER must be defined system-wide in executive mode:  *7  *		$ DEFINE/SYS/EXEC MX_BULLETIN_POSTMASTER GOATHUNTER   *  *  Modification history:   *,  *	01-002		Hunter Goatley		16-FEB-1993 11:06)  *		Modified to look for "@bulletin" too.   *,  *	01-001		Hunter Goatley		14-MAR-1991 14:41>  *		Added scan_for_from_line, which scans the message's RFC822;  *		headers for the "From:" line.  General cleanup on a few >  *		routines.  MX_BULL now provides an RESPOND-able address in
  *		BULLETIN.   *,  *	01-000		Hunter Goatley		 8-MAR-1991 07:20  *		Genesis.  *  */   3 /*  Include all needed structures and constants  */    #include descrip #include lib$routines  #include libdef  #include lnmdef  #include maildef #include rms #include ssdef #include str$routines  #include string   9 /* Declare the external BULLETIN routines that we call */   % unsigned long int INIT_MESSAGE_ADD(); ' unsigned long int WRITE_MESSAGE_LINE(); ' unsigned long int FINISH_MESSAGE_ADD();   7 /* Define some macros to make things a little easier */   2 #define rms_get(rab) ((rms_status = SYS$GET(rab)))6 #define err_exit(stat) {traceerr(stat); return(stat);}? #define vms_errchk2() if(!(vms_status&1)) err_exit(vms_status); : #define vms_errchk(func) {vms_status=func; vms_errchk2();}  = #define tracemsg(msg) if (trace) printf("MX_BULL: %s\n",msg); O #define traceerr(msg) if (trace) printf("MX_BULL: Error status %%X%08x\n",msg);   6 /* Define some global variables to make things easy */  0 struct FAB msgfab;				/* FAB for message text */0 struct RAB msgrab;				/* RAB for message text */4 struct FAB rcptfab;				/* FAB for recipients file */4 struct RAB rcptrab;				/* RAB for recipients file */. struct FAB fromfab;				/* FAB for FROM file */. struct RAB fromrab;				/* RAB for FROM file */2 char msgbuf[512];				/* Input buffer for msgrab */4 char rcptbuf[512];				/* Input buffer for rcptrab */4 char frombuf[512];				/* Input buffer for frombuf */ short trace;9 unsigned long int rms_status;			/* Status of RMS calls */ ; unsigned long int vms_status;			/* Status of other calls */   1 static $DESCRIPTOR(lnm_table,"LNM$SYSTEM_TABLE");   6 #define itmlstend {0,0,0,0}			/* An empty item list */5 typedef struct itmlst				/* An item list structure */  {    short buffer_length;   short item_code;   long buffer_address;   long return_length_address; 	 } ITMLST;    ITMLST   nulllist[] = {itmlstend};    ITMLST5   address_itmlst[] = {				/* MAIL$SEND_ADD_ADDRESS */   	{0, MAIL$_SEND_USERNAME, 0, 0}, 	itmlstend},7   bodypart_itmlst[] = {				/* MAIL$SEND_ADD_BODYPART */  	{0, MAIL$_SEND_RECORD, 0, 0}, 	itmlstend},8   attribute_itmlst[] = {			/* MAIL$SEND_ADD_ATTRIBUTE */ 	{0, MAIL$_SEND_TO_LINE, 0, 0}, ! 	{0, MAIL$_SEND_FROM_LINE, 0, 0},  	{0, MAIL$_SEND_SUBJECT, 0, 0},  	itmlstend}    ;    ITMLST0   trnlnm_itmlst[] = {				/* $TRNLNM item list */ 	{0, LNM$_STRING, 0, 0}, 	itmlstend}    ;      /*  *  *  Function:	open_file_rms   *  *  Functional description:   *F  *	This routine opens a sequential text file in VMS "normal text" file)  *	format.  It uses RMS to open the file.   *  *  Inputs:   *#  *	infab	- Address of the input FAB #  *	inrab	- Address of the input RAB %  *	buff	- Address of the input buffer 5  *	filename - Address of the filename to open (ASCIZ)   *  *  Outputs:  *.  *	fab and rab are modified if file is opened.  *  *  Returns:  *
  *	RMS status   *  */  unsigned long int P open_file_rms (struct FAB *infab, struct RAB *inrab, char *buff, char *filename) { !     unsigned long int rms_status;   3     *infab = cc$rms_fab;			/* Initialize the FAB */ 3     *inrab = cc$rms_rab;			/* Initialize the RAB */ B     infab->fab$b_fns = strlen(filename);	/* Set filename length */<     infab->fab$l_fna = filename;		/* Set filename address */8     infab->fab$b_fac = FAB$M_GET;		/* GET access only */>     infab->fab$b_shr = FAB$M_SHRGET+FAB$M_SHRPUT+FAB$M_SHRUPD;:     inrab->rab$l_fab = infab;			/* Let RAB point to FAB */?     inrab->rab$b_rac = RAB$C_SEQ;		/* Sequential file access */ <     inrab->rab$w_usz = 512;			/* Record size is 512 bytes */8     inrab->rab$l_ubf = buff;			/* Read to this buffer */  7     rms_status = SYS$OPEN (infab);		/* Open the file */ =     if (!(rms_status & 1))			/* If an error occurs, return */ * 	return (rms_status);			/* ... a status */<     rms_status = SYS$CONNECT (inrab);		/* Connect the RAB */6     return (rms_status);			/* Return the RMS status */ }    /*  *  *  Function:	init_sdesc  *  *  Functional description:   *)  *	Initialize a static string descriptor.   *  *  Inputs:   *2  *	sdesc	- Address of the descriptor to initialize'  *		  (of type struct dsc$descriptor_s) F  *	string	- Address of null-terminated string the descriptor describes  *  *  Outputs:  *4  *	sdesc	- Descriptor passed as sdesc is initialized  *  */  void9 init_sdesc (struct dsc$descriptor_s *sdesc, char *string)  { >     sdesc->dsc$w_length = strlen(string);	/* Set the length	*/<     sdesc->dsc$b_dtype = DSC$K_DTYPE_T;		/* Type is text		*/>     sdesc->dsc$b_class = DSC$K_CLASS_S;		/* Class is static	*/=     sdesc->dsc$a_pointer = string;		/* Point to the string	*/  }    /*  *$  *  Function:	add_to_bulletin_folder  *  *  Functional description:   *>  *	Adds a message to a BULLETIN folder by calling the external>  *	BULLETIN routines INIT_MESSAGE_ADD, WRITE_MESSAGE_LINE, and  *	FINISH_MESSAGE_ADD.  *C  *	The following constants are (may be) passed to INIT_MESSAGE_ADD:   *<  *		Subject = "" 	Causes BULLETIN to scan RFC822 headers for"  *				a "Subject:" or "Subj:" line;  *		From = "MX%"	Causes BULLETIN to scan RFC822 headers for #  *				a "Reply-to:" or "From:" line   *  *  Inputs:   *.  *	filerab	- Address of the message file's RABE  *	folder	- Address of a string descriptor for the name of the folder @  *	from	- Address of a string descriptor for the "From:" address  *  *  Outputs:  *  *	None.  *  *  Returns:  *=  *	unsigned long int - RMS status of call to INIT_MESSAGE_ADD   *  */  unsigned long int E add_to_bulletin_folder(struct RAB *filerab, void *folder, void *from)  { E     unsigned long int bull_status;	/* Status from INIT_MESSAGE_ADD */ L     struct dsc$descriptor_s msg_line;	/* Descriptor for a line of the msg */7     static $DESCRIPTOR(subject,"");	/* Subject is "" */   @     /* Call BULLETIN routine to initialize adding the message */  <     INIT_MESSAGE_ADD (folder, from, &subject, &bull_status);  -     if (!(bull_status & 1)){					/* Error? */  	return(bull_status);      }   I     /*	Loop reading message lines until end-of-file.  For each line read, C 	create a string descriptor for it and call the BULLETIN routine to  	add the line. */   ?     while (rms_get(filerab) != RMS$_EOF){		/* Loop until EOF */ B 	filerab->rab$l_rbf[filerab->rab$w_rsz] = 0;	/* End byte = NULL */A 	init_sdesc(&msg_line, filerab->rab$l_rbf);	/* Now build desc. */ 8 	WRITE_MESSAGE_LINE (&msg_line);			/* Add to BULLETIN */     }   @     FINISH_MESSAGE_ADD();		/* Call BULLETIN routine to finish */  (     tracemsg("Message added to folder");8     return(SS$_NORMAL);			/* Return success to caller */ }      /*  *   *  Function:	scan_for_from_line  *  *  Functional description:   *G  *	The routine scans the message's RFC822 headers for the "From:" line. 9  *	It parses out the address by extracting the <address>.   *G  *	This routine was necessary because letting BULLETIN find the "From:" H  *	line was resulting in a non-RESPONDable address for MX.  For example,  *	BULLETIN was creating:   *=  *		From: MX%"Hunter Goatley, WKU <goathunter@WKUVX1.BITNET>"   *  *	but MX needs   *)  *		From: MX%"<goathunter@WKUVX1.BITNET>"   *  *  Inputs:   *.  *	filerab	- Address of the message file's RAB  *  *  Outputs:  *J  *	final_from - Address of a character buffer to receive the final address  *  *  Returns:  *4  *	unsigned long int - binary success/failure status  *  *  Side effects:   *C  *	The message file is rewound so that subsequent GETs start at the   *	beginning of the message.  *  */  unsigned long int 9 scan_for_from_line(struct RAB *filerab, char *final_from)  { E     unsigned long int scan_status;	/* Status from INIT_MESSAGE_ADD */ L     struct dsc$descriptor_s msg_line;	/* Descriptor for a line of the msg */@     char whole_from_line[512];		/* The assembled "From:" line */9     char *filebuffer;			/* Pointer to the input buffer */ '     int i, j, x;			/* Work variables */   4     scan_status = SS$_NORMAL;			/* Assume success */=     whole_from_line[0] = '\0';			/* Initialize work buffer */   G     /*	Loop reading message lines until end-of-file or first null line, G 	which should signal the end of the RFC822 header.  For each line read, 0 	check to see if we've located the "From:" line.     */  <     filebuffer = filerab->rab$l_ubf;			/* Init buffer ptr */B     while ((rms_get(filerab) != RMS$_EOF) &&		/* Loop until EOF */; 	   ((x = filerab->rab$w_rsz) != 0)){		/* or null record */ - 	filebuffer[x] = '\0';				/* Set NULL byte */ A 	if (strncmp(filebuffer,"From:",5)==0){		/* Is it the "From:"? */    	   /* Found "From:" line */: 	   tracemsg("Found \042From:\042 line in RFC822 header");@ 	   strcpy(whole_from_line,filebuffer);		/* Copy to work buff */  A 	   /* The "From:" line may actually be split over several lines. C 	      In such cases, the remaining lines are indented by 6 spaces. B 	      To handle this, loop reading records until one is read thatA 	      doesn't begin with a blank.  As each record is read, it is B 	      trimmed and tacked on to whole_from_line, so we end up with1 	      the entire "From:" line in one buffer.  */   D 	   while((rms_get(filerab) != RMS$_EOF) &&	/* Read rest of From: */+ 		 (filebuffer[0] == ' ')){		/* ... line */ E 	      for (i = 0; filebuffer[i] == ' '; ++i);	/* Step over blanks */ C 	      strcat(whole_from_line,&filebuffer[i]);	/* Tack it on end */  	   }   A 	   /* Now have the whole "From:" line in whole_from_line.  Since ; 	      the real address is enclosed in "<>", look for it by @ 	      searching for the last "<" and reading up to the ">".  */  : 	   i = strrchr(whole_from_line,'<');		/* Find last "<" */' 	   if (i != 0){					/* Found it.... */ * 		j = strchr(i,'>');			/* Find last ">" */- 	        j = j-i+1;				/* Calc addr length */  	   } 	 	   else{ 9 		j = strlen(whole_from_line)-6;		/* Don't count From: */ 3 		i = &whole_from_line + 6;		/* in string length */  	   } ( 	   if (j < 0){					/* If neg., error */4 		tracemsg("Error - unable to locate from address");3 		strcpy(final_from,"");			/* Return null string */ + 		scan_status = 0;			/* Set error status */  	   } 
 	   else {6 		tracemsg("Found sender's address in RFC822 header");2 		strncpy(final_from, i, j);		/* Copy to caller */ 	   }	 	}     }   @     SYS$REWIND(filerab);		/* Rewind the file to the beginning */8     return(scan_status);		/* Return success to caller */ }      /*  *#  *  Function:	forward_to_postmaster   *  *  Functional description:   *E  *	If an error occurs trying to write a message to a BULLETIN folder, =  *	this routine is called to forward the message to the local   *	postmaster.  *  *  Inputs:   *.  *	filerab	- Address of the message file's RABE  *	folder	- Address of a string descriptor for the name of the folder @  *	from	- Address of a string descriptor for the "From:" addressB  *	status	- Address of longword containing the BULLETIN error code  *  *  Outputs:  *  *	None.  *  *  Returns:  *@  *	unsigned long int - binary status of call to INIT_MESSAGE_ADD  *  *  Side effects:   *G  *	The message file is rewound so that subsequent calls to this routine I  *	can be made (in case the message is to be written to several folders).   *  */  unsigned long int P forward_to_postmaster(struct RAB *filerab, void *folder, void *from, int status) { L     struct dsc$descriptor_s msg_line;	/* Descriptor for a line of the msg */$     struct dsc$descriptor_s subject;     char subject_buf[256];/     char postmaster[256];   int postmaster_len; 3     char status_msg_buf[256];   int status_msg_len; '     struct dsc$descriptor_s status_msg; H     static $DESCRIPTOR(faostr,"Failed BULLETIN message for folder !AS");>     static $DESCRIPTOR(MXBULL,"MX->SITE (BULLETIN delivery)");@     static $DESCRIPTOR(postmaster_lnm,"MX_BULLETIN_POSTMASTER");)     int send_context = 0;  int x;  int y;   !     static char *error_msgs[] = { J 	{"Error delivering message to BULLETIN folder.  BULLETIN error status:"}, 	{""}, 	{""},$ 	{"Original message text follows:"},7 	{"--------------------------------------------------"}      };  )     trnlnm_itmlst[0].buffer_length = 255; 2     trnlnm_itmlst[0].buffer_address = &postmaster;=     trnlnm_itmlst[0].return_length_address = &postmaster_len;   B     SYS$TRNLNM( 0, &lnm_table, &postmaster_lnm, 0, trnlnm_itmlst);>     if (postmaster_len == 0)		/* If logical is not defined, */6 	return(SS$_NORMAL);		/* then pretend it worked     */  ;     tracemsg("Forwarding message to local postmaster....");      subject.dsc$w_length = 255; )     subject.dsc$a_pointer = &subject_buf; J     SYS$FAO(&faostr, &subject, &subject, folder);	/* Format the subject */  C     address_itmlst[0].buffer_length = postmaster_len;		   /* To: */ A     address_itmlst[0].buffer_address = &postmaster;		   /* To: */ E     attribute_itmlst[0].buffer_length = postmaster_len;		   /* To: */ C     attribute_itmlst[0].buffer_address = &postmaster;		   /* To: */ K     attribute_itmlst[1].buffer_length = MXBULL.dsc$w_length;	   /* From: */ M     attribute_itmlst[1].buffer_address = MXBULL.dsc$a_pointer;	   /* From: */ N     attribute_itmlst[2].buffer_length = subject.dsc$w_length;	   /* Subject:*/P     attribute_itmlst[2].buffer_address = subject.dsc$a_pointer;	   /* Subject:*/  E     vms_errchk(mail$send_begin(&send_context, &nulllist, &nulllist)); D     vms_errchk(mail$send_add_address(&send_context, &address_itmlst, 			&nulllist)); H     vms_errchk(mail$send_add_attribute(&send_context, &attribute_itmlst, 			&nulllist));        for (x = 0; x < 5; x++){: 	bodypart_itmlst[0].buffer_length = strlen(error_msgs[x]);3 	bodypart_itmlst[0].buffer_address = error_msgs[x]; 1 	vms_errchk(mail$send_add_bodypart(&send_context,   		&bodypart_itmlst, &nulllist));
 	if (x == 1){ ! 	  status_msg.dsc$w_length = 256; * 	  status_msg.dsc$b_dtype = DSC$K_DTYPE_T;* 	  status_msg.dsc$b_class = DSC$K_CLASS_S;. 	  status_msg.dsc$a_pointer = &status_msg_buf;< 	  y = SYS$GETMSG (status, &status_msg, &status_msg, 15, 0); 	  if (!(y & 1))= 	     sprintf(status_msg_buf,"Error code is %%X%08x",status);* 	  else 5 	     status_msg_buf[status_msg.dsc$w_length] = '\0';-= 	  bodypart_itmlst[0].buffer_length = strlen(status_msg_buf);r7 	  bodypart_itmlst[0].buffer_address = &status_msg_buf;oD 	  vms_errchk(mail$send_add_bodypart(&send_context,&bodypart_itmlst, 		&nulllist)); 	}     }g  ?     while (rms_get(filerab) != RMS$_EOF){		/* Loop until EOF */s7 	bodypart_itmlst[0].buffer_length = filerab->rab$w_rsz;_8 	bodypart_itmlst[0].buffer_address = filerab->rab$l_rbf;1 	vms_errchk(mail$send_add_bodypart(&send_context,e  		&bodypart_itmlst, &nulllist));     }m  G     vms_errchk(mail$send_message(&send_context, &nulllist, &nulllist));dC     vms_errchk(mail$send_end(&send_context, &nulllist, &nulllist));n  4     tracemsg("Message forwarded to postmaster...."); }a   e /*  *  *  Function:	log_accounting  *  *  Functional description:   *@  *	This routine will write an accounting record for the message.  *  *  Inputs:c  *E  *	folder	- Address of a string descriptor for the name of the folder*@  *	from	- Address of a string descriptor for the "From:" addressB  *	status	- Address of longword containing the BULLETIN error code  *  *  Outputs:  *  *	None.  *  *  Returns:  *!  *	unsigned long int - RMS statusa  *  */s unsigned long intx9 log_accounting(void *folder, void *from, int bull_status)  {E     struct FAB accfab;     struct RAB accrab;>     static $DESCRIPTOR(MX_BULL_ACCNTNG,"MX_BULLETIN_ACCNTNG");     static $DESCRIPTOR(faostr,F 	"!%D MX_BULL: FOLDER=\042!AS\042, ORIGIN=\042!AS\042, STATUS=%X!XL");     char outbufbuf[256];H     struct dsc$descriptor_s outbuf = {256, DSC$K_DTYPE_T, DSC$K_CLASS_S, 		 &outbufbuf};*       int status;u.     static char bullacc[] = "MX_BULLETIN_ACC";2     static char bullaccdef[] = "MX_SITE_DIR:.DAT";  @     status = SYS$TRNLNM( 0, &lnm_table, &MX_BULL_ACCNTNG, 0, 0);     if (!(status & 1)) 	return(SS$_NORMAL);  E     tracemsg("Writing accounting information to accounting log....");      accfab = cc$rms_fab;     accrab = cc$rms_rab;B     accfab.fab$b_fns = strlen(bullacc);		/* Set filename length */<     accfab.fab$l_fna = &bullacc;		/* Set filename address */D     accfab.fab$b_dns = strlen(bullaccdef);	/* Set filename length */?     accfab.fab$l_dna = &bullaccdef;		/* Set filename address */*8     accfab.fab$b_fac = FAB$M_PUT;		/* PUT access only */>     accfab.fab$b_shr = FAB$M_SHRGET+FAB$M_SHRPUT+FAB$M_SHRUPD;@     accfab.fab$b_rfm = FAB$C_VAR;		/* Variable length records */9     accfab.fab$b_rat = FAB$M_CR;		/* Normal "text" rat */t<     accrab.rab$l_fab = &accfab;			/* Let RAB point to FAB */?     accrab.rab$b_rac = RAB$C_SEQ;		/* Sequential file access */)  <     status = SYS$OPEN (&accfab);		/* Try to open the file */%     if (status & 1)				/* Success? */ 0 	accrab.rab$l_rop = RAB$M_EOF;		/* Set to EOF */+     else					/* Couldn't open, so create */ 4 	status = SYS$CREATE (&accfab);		/* ... a new one */1     if (status & 1){				/* If either was OK... */)7 	status = SYS$CONNECT (&accrab);		/* Connect the RAB */g6 	if (status == RMS$_EOF)			/* RMS$_EOF status is OK */4 	   status = RMS$_NORMAL;		/* Change it to NORMAL */2 	if (!(status & 1)){			/* If any error occurred *// 	   tracemsg("Unable to open accounting file");F 	   traceerr(status); / 	   SYS$CLOSE (&accfab);			/* Close the file */ 0 	   return(status);			/* And return the error */ 	}     }R     else 	return(status);  E     SYS$FAO(&faostr, &outbuf, &outbuf, 0, folder, from, bull_status);R+     accrab.rab$w_rsz = outbuf.dsc$w_length;m,     accrab.rab$l_rbf = outbuf.dsc$a_pointer;     SYS$PUT (&accrab);     SYS$CLOSE (&accfab); }  r /*  * 5  *  Main routine  *  */  main(int argc, char *argv[]) {dF   struct dsc$descriptor_s folder;	/* Descriptor for the folder name */F   struct dsc$descriptor_s from_user;	/* Descriptor for "From:" line */4   static $DESCRIPTOR(MX_SITE_DEBUG,"MX_SITE_DEBUG");  <   char *from_line;			/* Pointer to dynamic "From:" buffer */>   char *folder_name;			/* Pointer to folder name in rcptbuf */2   char *atsign;				/* Pointer to "@" in rcptbuf */    int  x;				/* Work variable */I   unsigned long int bull_status;	/* Status from add_to_bulletin_folder */A  /   --argc;				/* Don't count the program name */iF   if ((argc != 2) && (argc != 3)) {	/* If too many or too few args, */=     exit(LIB$_WRONUMARG);		/* ...  exit with error status  */]   }	  @   vms_status = SYS$TRNLNM( 0, &lnm_table, &MX_SITE_DEBUG, 0, 0);   if (vms_status & 1),     trace = 1;   else     trace = 0;     /*  Open all input files  */  '   tracemsg("Opening message file....");sA   vms_errchk(open_file_rms (&msgfab, &msgrab, &msgbuf, argv[1]));**   tracemsg("Opening recipients file....");D   vms_errchk(open_file_rms (&rcptfab, &rcptrab, &rcptbuf, argv[2]));     if (argc == 2){e>      tracemsg("Using sender address from RFC822 headers....");+      scan_for_from_line(&msgrab, &frombuf);i   }-   else {1      tracemsg("Opening sender address file....");fG      vms_errchk(open_file_rms (&fromfab, &fromrab, &frombuf, argv[3]));p  6      tracemsg("Reading sender address from file....");2      rms_get(&fromrab);			/* Read the from line */<      if (!(rms_status & 1))		/* Exit if an error occurred */ 	err_exit(rms_status);  P      /* Set the end of the record read, then initialize the descriptor for it */$      frombuf[fromrab.rab$w_rsz] = 0;        SYS$CLOSE(&fromfab);e)   }						/* End of "if (argc == 2)"... */e  2   /* frombuf now has the sender's address in it */     if (strlen(frombuf) == 0) {r8 	tracemsg("Unable to find sender's address, using MX%"); 	init_sdesc(&from_user, "MX%");B   }R   else{_  7      /* Now add the MX% prefix and the double quotes */tK      from_line = malloc(4 + strlen(frombuf) + 1 + 1);	/* Allocate memory */c  E      /* Make the string repliable through MX by adding MX%"" to it */ !      strcpy(from_line,"MX%\042");d      strcat(from_line,frombuf);t      strcat(from_line,"\042");      if (trace) 8 	printf("MX_BULL: Sender's address is %s\n", from_line);I      init_sdesc (&from_user, from_line);	/* Create a string descriptor */(   })   /*H     Read through all the recipients, writing the message to all BULLETINB     folders (identified by checking for @BULLETIN in the address).   */.   rms_get(&rcptrab);				/* Read a recipient */6   while ((rms_status & 1) & (rms_status != RMS$_EOF)){1      tracemsg("Looking for BULLETIN folder....");c<      folder_name = &rcptbuf;			/* Point to receipt buffer */?      if (folder_name[0] == '<'){		/* If line begins with "<" */ 0 	++folder_name;				/*  bump over it and check */4 	atsign = strchr(rcptbuf,'@');		/*  for a "@"		   *// 	if (atsign != 0){			/* If "@" was found,	   */	C 	  if ((strncmp(atsign,"@BULLETIN",9)==0) /* Is it @BULLETIN?	   */eA 	   ||(strncmp(atsign,"@bulletin",9)==0)) {  /* or @bulletin?  */s= 	    x = atsign - folder_name;		/* Length of folder name   */t8 	    folder_name[x] = 0;			/* Terminate folder name   */E 	    init_sdesc (&folder, folder_name);	/* Initialize descriptor   */E@ 	    str$upcase(&folder, &folder);	/* Convert to uppercase    */ 	    if (trace)S; 		printf("MX_BULL: Found BULLETIN folder \042%s\042....\n",c 			folder_name);7 	    tracemsg("Adding message to BULLETIN folder....");aI 	    bull_status = add_to_bulletin_folder (&msgrab, &folder, &from_user);e 	    if (!(bull_status & 1)){T 		 traceerr(bull_status);oA 		 vms_errchk(forward_to_postmaster(&msgrab, &folder, &from_user,f 				bull_status)); 	    }6 	    log_accounting(&folder, &from_user, bull_status);? 	    SYS$REWIND(&msgrab);	/* Rewind the file for next folder */c   	  } 	}       }"3       rms_get(&rcptrab);		/* Read next recipient */u   }        /* Close the RMS files */a  +   SYS$CLOSE(&msgfab);  SYS$CLOSE(&rcptfab);i  )   tracemsg("BULLETIN message processed"); 0   exit(SS$_NORMAL);		/* Always return success */   }n