 #define module_name DRLOGIN  #define module_ident "V3.1"  /*  *	D R L O G I N  *B  *	Based on the DRLACP DECNET RLOGIN program originally written in?  *	MACRO-32 by Anthony C. McCraken, Northern Arizona University   *M  * This program uses non-transparent task to task communication techniques to K  * establish a link to a remote task. The remote task will call the Digital L  * pseudo terminal driver and establish an interactive session on the remote/  * host. This is a lot like RTPAD and SET HOST.   *F  * V3.1	- Hunter Goatley <goathunter@WKUVX1.WKU.EDU>	16-JUN-1994 09:28?  *	  Ported to run under OpenVMS AXP too (now DEC C compliant).   *A  * V3.0 - John Delgado <j_delgado@farber.harvard.edu>	 7-JUN-1994 H  *	- Rewrote it in the C language, using the same design Hunter provided  *	  in v2.0C  *	- Also ported DRLACP to use the FT driver; it no longer uses the   *	  PY/TW drivers.   *D  * V2.2 - Hunter Goatley, goathunter@WKUVX1.BITNET	26-JUN-1993 14:55C  *	  Ported to OpenVMS AXP.  DRLACP has not been ported because the B  *	  PY/TW drivers are not available, but this means an AXP system/  *	  can initiate a connection to a remote VAX.   *G  * V2.1 - Hunter Goatley <goathunter@WKUVX1.BITNET>  	24-MAY-1993 22:24 #  * 	  Added informational messages.   *J  * V2.0 - Major design change.  The program is now Event driven instead ofG  *	 interupt driven.  All work is now done in the main process and ASTs E  *	 are used only to set event and status flags.  The main I/O is now J  *	 done almost entirely with QIOs instead of QIOWs.  The main program nowI  *	 loops around handling different events.  The beginning of the loop is G  *	 is a $WAITFR that waits on an event flag.  The event flag is set by E  *	 an AST routine declared by one of 4 QIOs or a LIB$SPAWN.  The AST E  *	 routine also sets an appropriate status bit in a status longword. I  *	 The loop then immediately clears the event flag and then queries each I  *	 bit in the status longword and calls the appropriate handler for each F  *	 set bit.  These handlers clear the bit and issue appropriate QIOs.  *M  * V1.2 - Added a CHMK #0 instruction to the beginning of each AST routine to F  *	 immediately dismiss the AST.  This allows other AST to interupt anI  *	 in progress AST.  This helps prevent data overruns that are caused by H  *	 a QIOW executing at AST level preventing other ASTs from doing their	  *	 jobs.   *K  * V1.1 - Added code to accept terminal characteristics and propogate these &  *	 to the TWAnnnn:.  10-JAN-1992	 ACM  *3  * V1.0 - Original version written. 11-NOV-91   ACM   *  */    #include "local.h"   #include <ssdef.h> #include <iodef.h> #include <prcdef.h>  #include <lnmdef.h>  #include <descrip.h> #include <iodef.h> #include <dvidef.h>  #include <accdef.h>  #include <msgdef.h>  #include <ttdef.h> #include <tt2def.h>  #include <starlet.h> #include <lib$routines.h>    /*  (  * Data structures for the TERMINAL link  */ # static $DESCRIPTOR (ttdesc, "TT:");  static short ttchan; static struct iosb triosb; static struct iosb twiosb; static char ttbuff[1];   /*I  * We're gonna change some of the characteristics of the terminal so I'll I  * declare a buffer for the terminal's characteristics before the changes K  * and another for after the changes. When the program exits the terminal's L  * characteristics will be reset the way they were before they were changed.  */   & static struct dev_char otchar, ntchar;   /*  &  * Data structures for the DECNET link  */   @ static $DESCRIPTOR (sysnet,		"_NET:"); /* network device desc */3 static unsigned short snchan;			  /* I/O Channel */ 6 static struct iosb sriosb;			  /* IOSB for net read */7 static struct iosb swiosb;			  /* IOSB for net write */ " static char snbuff[CHAR_BUF_SIZE];   /*  5  * Data structures for the associated network mailbox   */ ( static $DESCRIPTOR (netbox,		"NT2TBOX"); static unsigned short nmchan;  static struct iosb nmiosb; static char mbbuff[256];   /*G  * Data for the interactive process creation and its associated mailbox   */ ; static $DESCRIPTOR (loginout, 		"SYS$SYSTEM:LOGINOUT.EXE");    char local_node[256];  int  local_node_len;   /*H  * Network connect block, TRNLNM of SYS$NET will give the access controlG  * string and the network link. The NCB descriptor will be filled in at .  * runtime with the length returned by TRNLNM.  */    static char ncb[256]; ! static $DESCRIPTOR (ncbdsc, ncb);    #define ESCHAR (28)    static int gflen;  static char gfbuf[32]; $DESCRIPTOR (gfstr, gfbuf);    /*L  * Some event flags for the asynchronous I/Os.  These will be allocated from
  * LIB$GET_EF   */   0 static int tref;		/* Terminal READ event flag */1 static int twef;		/* Terminal WRITE event flag */ / static int nref;		/* Network READ event flag */ 0 static int nwef;		/* Network WRITE event flag *// static int mref;		/* Mailbox READ event flag */ 1 static int evef;		/* EVENT complete event flag */    /*L  * A set of flags for the event loop and some definitions for the individual
  * flag bits.   */  static union {   struct {       unsigned evfl_m_trc : 1;     unsigned evfl_m_twc : 1;     unsigned evfl_m_nrc : 1;     unsigned evfl_m_nwc : 1;   } fields;    unsigned long evfl_mask; } evfl;   ( #if defined(__DECC) || defined(__DECCXX)  #pragma extern_model globalvalue extern #else  globalvalue  #endif5 	int drlogin__exit, drlogin__connect, drlogin__atmpt;    void net_mailbox_hand (void);  void net_write_hand (void);     N /*****************************************************************************  **   ** AST routines  ** O  *****************************************************************************/    /*  *	n e t _ r e a d _ a s t  *Q  * NET_READ_AST is called whenever the remote task writes to the network link. It O  * checks to see if the IOSB of the link indicates a normal read completion. If M  * if does, it writes out all of data to the terminal and then queues another M  * read to the link. If the IOSB indicates anything other than a normal read, H  * it exits with the completion status in R0 so an error message will be  * displayed on the terminal.   */  static int net_read_ast () { 
   int status;       sys$clrast(); %   if ((status = sriosb.status) & 1) {      sys$setef (evef);      evfl.fields.evfl_m_nrc = 1;      return (status);   }    sys$exit (status); }    /*  *	t t _ r e a d _ a s t  *R  * TT_READ_AST is called whenever a key is pressed on the terminal. It writes thatN  * keystroke to the network link and then queues another read to the terminal.M  * If the key happens to be the ESCAPE character, read the next character and "  * if it's a 'Q' then exit to VMS.  */  static int tt_read_ast ()  { 
   int status;      sys$clrast ();%   if ((status = triosb.status) & 1) {      if (ttbuff[0] != ESCHAR) {       sys$setef (evef); !       evfl.fields.evfl_m_trc = 1;        return SS$_NORMAL;     }      /*K      * The escape character was pressed, cancel any outstanding I/O on the  ,      * keyboard and read the next character.      */      sys$cancel (ttchan);D     chk (sys$qiow (tref, ttchan, IO$_READVBLK|IO$M_NOECHO, 0, 0, 0,  		   ttbuff, 1, 0, 0, 0, 0)); 1     if ((ttbuff[0] == 'Q') || (ttbuff[0] == 'q'))        sys$exit (SS$_NORMAL);     net_write_hand ();     return (SS$_NORMAL);   }    sys$exit (status); }    /*   *	n e t _ m a i l b o x _ a s t  *U  * NET_MAILBOX_AST checks the message type in the network associated mailbox.  If the L  * message type indicates that the network link has terminated then $EXIT isN  * called to shut down DRLOGIN.	The exit handler should take care of resetting:  * the terminal and $EXIT will cancel any outstanding I/O.  */  static void net_mailbox_ast () {    sys$clrast ();   switch (mbbuff[0]) {     case MSG$_ABORT:     case MSG$_DISCON:      case MSG$_EXIT:      case MSG$_PATHLOST:      case MSG$_PROTOCOL:      case MSG$_THIRDPARTY:      case MSG$_NETSHUT:     case MSG$_INTMSG:      /*J      * Something has caused the link to be terminated.  Probably a logout K      * on the other side but in any case this program should terminate now.       */        sys$exit (SS$_NORMAL);   }    /*M    * Some nonfatal thing, queue another read to the mailbox and return to the '    * main program which is hibernating.     */    net_mailbox_hand (); }    /*  *	t t _ w r i t e _ a s t  */  static int tt_write_ast () { 
   int status;      sys$clrast ();'   if ((status = twiosb.status) & 1) {         sys$setef (evef);       evfl.fields.evfl_m_twc = 1;      return (status);    }    sys$exit (status); }    /*  *	n e t _ w r i t e _ a s t  *A  * NET_WRITE_AST is called when a write to the NET has completed.   */  static int net_write_ast ()  { 
   int status;      sys$clrast ();%   if ((status = swiosb.status) & 1) {      sys$setef (evef);      evfl.fields.evfl_m_nwc = 1;      return (status);   }    sys$exit (status); }    /*  *	e x i t _ h a n d l e r  */  static void exit_handler ()  { #   static char crlf[3] = "\015\012";      sys$setast (0); D   sys$qiow (0, ttchan, IO$_WRITEVBLK, 0, 0, 0, crlf, 2, 0, 0, 0, 0);   sys$dassgn (ttchan);)   sys$assign (&ttdesc, &ttchan, 0, 0, 0); 0   sys$qiow (twef, ttchan, IO$_SETMODE, 0, 0, 0,	* 	    &otchar, sizeof(otchar), 0, 0, 0, 0);   sys$dassgn (ttchan);<   lib$signal (drlogin__exit, 2, local_node_len, local_node); }     N /*****************************************************************************  **   ** Handler routines  ** O  *****************************************************************************/    /*    *	t t _ r e a d _ h a n d  */  tt_read_hand ()  {    evfl.fields.evfl_m_trc = 0;	G   chk (sys$qio (nwef, snchan, IO$_WRITEVBLK, &swiosb, net_write_ast, 0,  		ttbuff, 1, 0, 0, 0, 0)); }    /*  *	n e t _ r e a d _ h a n d  *L  * A network read has completed, the keystroke needs to be transfered to theH  * pseudo terminal.  Also then NET READ COMPLETED status bit needs to beD  * cleared. Later an AST will set the PY WRITE COMPLETED status bit.  */  void net_read_hand ()  {    int count = sriosb.byte_cnt;     evfl.fields.evfl_m_nrc = 0; F   chk (sys$qio (twef, ttchan, IO$_WRITEVBLK, &twiosb, tt_write_ast, 0, 		snbuff, count, 0, 0, 0, 0)); }    /*  *	t t _ w r i t e _ h a n d  */  void tt_write_hand ()  {    evfl.fields.evfl_m_twc= 0;E   chk (sys$qio (nref, snchan, IO$_READVBLK, &sriosb, net_read_ast, 0, & 		snbuff, CHAR_BUF_SIZE, 0, 0, 0, 0)); }    /*  *	n e t _ w r i t e _ h a n d  *K  * A network write has completed.  Another pseudo terminal read needs to be M  * initiated.  Clear the NET WRITE COMPLETE status bit and queue another read I  * to the pseudo terminal.  An AST will will set the PSEUDO TERMINAL READ /  * COMPLETED status bit the read has completed.   */  void net_write_hand () {    evfl.fields.evfl_m_nwc = 0; D   chk (sys$qio (tref, ttchan, IO$_READVBLK|IO$M_NOECHO|IO$M_NOFILTR, 		&triosb, tt_read_ast, 0, 		ttbuff, 1, 0, 0, 0, 0)); }    /*"  *	n e t _ m a i l b o x _ h a n d  */  void net_mailbox_hand () { H   chk (sys$qio (mref, nmchan, IO$_READVBLK, &nmiosb, net_mailbox_ast, 0, 		mbbuff, 256, 0, 0, 0, 0)); }      /*
  *	m a i n  *G  * The main program translates the logical name SYS$NET to retrieve the H  * Network Connect Block. It then assigns channels to network device andH  * Attempts to complete the logical link. If that is successful, it willF  * assign a channel to a pseudo terminal and then queue a READ to bothK  * the network link and the pseudo terminal. It then goes into hibernation. L  * The program runs asynchronously, all the real work being done in the ASTs"  * for the queued READ operations.  *  */  main ()  { 
   int status;    static int excode;  (   static $DESCRIPTOR (lnam, "SYS$NODE");0   static $DESCRIPTOR (ltab, "LNM$SYSTEM_TABLE");     struct exit_handler_block { " 	struct exit_handler_block *flink; 	void (*exit_routine)(); 	int arg_count;  	int *status_address;  	int exit_status; .   } exhblk = {0, exit_handler, 1, &excode, 0};  ,   static char *ncbtsk = "::\"TASK=DRLACP\"";   static int ncbtsk_l = 15;   @   struct { struct item field[1]; int terminator; } trn_itm_list;  4   trn_itm_list.field[0].buflen	= sizeof(local_node);+   trn_itm_list.field[0].code	= LNM$_STRING; ,   trn_itm_list.field[0].bufadr	= local_node;1   trn_itm_list.field[0].retlen	= &local_node_len;    trn_itm_list.terminator	= 0;7   chk (sys$trnlnm (0, &ltab, &lnam, 0, &trn_itm_list));    /*  * Allocate the event flags   */      lib$get_ef (&tref);    lib$get_ef (&twef);    lib$get_ef (&nref);    lib$get_ef (&nwef);    lib$get_ef (&mref);    lib$get_ef (&evef);    /*J  * Get the nodename from off of the command line and build a DECNET access  * control string out of it.  */   3   lib$get_foreign (&gfstr, 0, &gfstr.dsc$w_length); 8   cpymem (gfstr.dsc$w_length, gfstr.dsc$a_pointer, ncb);@   cpymem (ncbtsk_l, ncbtsk, (char *)(ncb + gfstr.dsc$w_length));"   ncbdsc.dsc$w_length += ncbtsk_l;   /*M  * Assign a channel to the terminal and change it's characteristics to NOWRAP I  * and PASSTHRU.  Declare an exit handler to reset these characteristics.   */ /   chk (sys$assign (&ttdesc, &ttchan, 0, 0, 0)); 6   chk (sys$qiow (tref, ttchan, IO$_SENSEMODE, 0, 0, 0,) 		 &otchar, sizeof(otchar), 0, 0, 0, 0));    ntchar = otchar;6   ntchar.basic_chars = ntchar.basic_chars | TT$M_WRAP;@   ntchar.extended_chars = ntchar.extended_chars | TT2$M_PASTHRU;5   chk (sys$qiow (tref, ttchan, IO$_SETMODE, 0, 0, 0,  ) 		 &ntchar, sizeof(ntchar), 0, 0, 0, 0));      chk (sys$dclexh (&exhblk));   )   lib$signal (drlogin__atmpt, 1, &gfstr);  /*O  * Create a mailbox and assign a channel to the NET: template.  Then access the K  * network and attempt to establish a logical link.  If it fails then exit.   */ 8   chk (sys$crembx (0, &nmchan, 0, 0, 0, 0, &netbox, 0));   /*  * Accept the connection  */ 5   chk (sys$assign (&sysnet, &snchan, 0, &netbox, 0)); =   status = sys$qiow (nwef, snchan, IO$_ACCESS, &swiosb, 0, 0,  		     0, &ncbdsc, 0, 0, 0, 0);    if (status & 1)      status = swiosb.status;    chk (status);     /*I  * The link is now up, send the 12 byte terminal characteristics field to   * the remote process.  *M  * Post a read to the network, the associated mailbox and to the terminal and %  * then wait for something to happen.   */      sys$clref (evef);     2   sys$qiow (nwef, snchan, IO$_WRITEVBLK, 0, 0, 0, * 	    &otchar, sizeof(otchar), 0, 0, 0, 0);   tt_write_hand ();    net_mailbox_hand ();   net_write_hand ();   /*J  * Wait here for something to happen.  When any event takes place the EVEFF  * event flag will be set and one or more bits will be set in the EVFLN  * indicating which events have taken place and what action needs to be taken.  */    for (;;) {:     sys$waitfr (evef);		/* Wait for something to happen */     sys$clref (evef);      do {$       if (evfl.fields.evfl_m_trc) {	 	tt_read_hand ();		        } $       if (evfl.fields.evfl_m_nrc) {	  	net_read_hand ();		        } $       if (evfl.fields.evfl_m_twc) {	  	tt_write_hand ();		        } $       if (evfl.fields.evfl_m_nwc) {	 	net_write_hand ();		        } H     } while (evfl.evfl_mask);	/* If another event has occurred during */* 				/* this pass, continue to handle it */   }  } 