B [Inherit('Sys$Library:Starlet','Sys$Library:Pascal$Lib_Routines')])         PROGRAM Sub_Times (Input,Output);   K (************************************************************************** K *                        UNIVERSITY OF UDINE - ITALY                      * K *                            "Centro di Calcolo"                          * K *                                                                         * K *                                                                         * K *                             S U B _ T I M E S                           * K *                                                                         * K *      Language:          PASCAL                                          * K *      Author:            Franco                          Version  1.0    * K *      Created:           20-DEC-1991                                     * K *      Last Revision:     XX-XXX-XXXX  (XX)  (XX)                         * K *                                                                         * K *      Users:             CCUU                                            * K *-------------------------------------------------------------------------* K *------------------------D O C U M E N T A T I O N------------------------* K *-------------------------------------------------------------------------* K *                             S U B _ T I M E S                           * K *                                                                         * K *      Brief and  useful program to subtract one absolute system time     * K *      from one another, giving a delta time.                             * K *                                                                         * K *      You can execute SUB_TIMES using a foreign command, and passing     * K *      data using qualifier data values.                                  * K *                                                                         * K *      Used algorithm is:                                                 * K *                                                                         * K *        Delta_Time = Major_Time - Minor_Time                             * K *                                                                         * K *      You can pass MAJOR_TIME to the program using /MAJOR qualifier,     * K *      and MINOR_TIME with /MINOR qualifier; i.e.:                        * K *                                                                         * K *      $ SUB_TIMES/MAJOR=12-AUG-1991 00:01:01.00  -                       * K *                 /MINOR=11-AUG-1991 00:01:01.00                          * K *                                                                         * K *      /MAJOR and /MINOR qualifier are required.                          * K *                                                                         * K *      MAJOR time must always be GREATER THAN or EQUAL to MINOR time.     * K *      You can omit any time field (00 will be used by default), BUT      * K *      date fields.                                                       * K *                                                                         * K *      Time can be passed in standard VMS format:                         * K *                                                                         * K *                    DD-MMM-YYYY HH:MM:SS.CC                              * K *                                                                         * K *      or  using any other supported format, defining (before program     * K *      execution)  logical  name  LIB$DT_INPUT_FORMAT,  (see RUN_TIME     * K *      LIBRARY manual, Chapter 3).                                        * K *                                                                         * K *      Delta  time resulting from the difference will be displayed on     * K *      screen  by  default;  you  can  disable on-screen display, and     * K *      put result  into  a DCL local symbol, using /SYMBOL qualifier;     * K *      in example:                                                        * K *                                                                         * K *      $ SUB_TIMES/MAJOR=12-AUG-1991 00:01:01.00  -                       * K *                 /MINOR=11-AUG-1991 00:01:01.00  -                       * K *                 /SYMBOL=diff_time                                       * K *                                                                         * K *      Resulting delta-time will be put  into DIFF_TIME symbol.           * K *                                                                         * K *      BUG: resulting delta time cannot be greater than                   * K *                                                                         * K *                 9999 23:59:59.99                                        * K *                                                                         * K *           So, interval between MAJOR and MINOR time must be less        * K *           than or equal to this value.                                  * K *                                                                         * K *-------------------------------------------------------------------------* K *                           U  P  D  A  T  E  S                           * K *                                                                         * K *      V1.0         starting version.                                     * L ***************************************************************************)     TYPED     $Quad = [QUAD] RECORD	        (* Simulate  quadword unsigned  *)!                   L0,L1:Unsigned;                  END;J     $String = VARYING [80] OF Char;     (* General-purpose string       *)     VAR J     Min,                                (* Char-Array to be converted   *)J     Maj,                                (* Char-Array to be converted   *)J     Foreign :                           (* Char-Array from Forgn-comm.  *)'           PACKED ARRAY [1..80] OF Char;   J     Min_S,                              (* String from qualifier        *)J     Maj_S,                              (* String from qualifier        *)J     Diff_String,                        (* String from $ASCTIM          *)J     Sym_S : $String:='';                (* String from qualifier        *)  J     Sts,                                (* Main status from RTL         *)J     Sts1 : Unsigned;                    (* Supplementary status from RTL*)  J     Min_Q,                              (* Minor internal format time   *)J     Maj_Q,                              (* Major internal format time   *)J     Diff_Q : $Quad;                     (* Diff. Major-Minor (intern.)  *)  J     Min_Present,                        (* /MINOR  present or not       *)J     Maj_Present,                        (* /MAJOR  present or not       *)J     Sym_Present : Boolean:=False;       (* /SYMBOL present or not       *)    >     (*------------------------------------------------------*)>     (* External function; RTL. Extract n-th elemement from  *)>     (* a 'Separ'- separated string of elements              *)>     (*                                                      *)  :  [External] FUNCTION Str$Element (%DESCR Dest   : $String;:                                   %REF   El_Num : Integer;:                                   %DESCR Separ  : $String;E                                   %DESCR Sou    : $String) : Integer;      Extern;     >     (*------------------------------------------------------*)>     (*  Internal procedure. Look  for  a  certain qualifier *)>     (*  from  a parameter-passed string, and for 1 optional *)>     (*  entity. Set on TRUE or FALSE a certain boolean var. *)>     (*                                                      *)  5   PROCEDURE Look_For_Qualifier (Line,Qualif: $String; 5                                 VAR Entity : $String; 6                                 VAR Option : Boolean);       VAR        Tmp_String : $String; 7       Tmp_Position, Tmp_Length,Tmp_Rtlsts : Integer:=0;   	     BEGIN        Option:=False;)       Tmp_Position := Index(Line,Qualif);        IF Tmp_Position <= 0         THEN BEGIN             Entity:='';              Option:=False            END          ELSE BEGIN             Option:=True; '             Tmp_Length:=Length(Qualif); 6             IF Tmp_Position+Tmp_Length >= Length(Line)               THEN Entity:=''                ELSE BEGIN*                   Tmp_String:=Substr(Line,=                                      Tmp_Position+Tmp_Length, Q                                      (Length(Line)-Tmp_Position-(Tmp_Length-1))); (                   IF Tmp_String[1] = '='                     THEN BEGINN                         Tmp_String:=Substr(Tmp_String,2,Length(Tmp_String)-1);I                         Tmp_Rtlsts:= Str$Element(Entity,0,'/',Tmp_String)                        END $                     ELSE Entity:='';                 END            END      END;    >     (*------------------------------------------------------*)>     (*  Internal  procedure.  Check  required   qualifiers  *)>     (*  /MINOR and  /MAJOR,  and  relative entities (min_S, *)>     (*  maj_s);  find  optional  entity; look for optional  *)>     (*  /SYMBOL qualifier  and  entity  (ABORT  program if  *)>     (*  something is wrong!) .                              *)  $   PROCEDURE Check_Qualifiers_Syntax;  	     BEGIN        IF (NOT Maj_Present)           THEN BEGINJ             Writeln('%SUB_TIMES-E-REQMAJ, /MAJOR qualifier is required.');             $Exit(44)            END;       IF (NOT Min_Present)         THEN BEGINI             Writeln('%SUB_TIMES-E-REQMIN, /MINOR qualifier is required');              $Exit(44)            END;       IF  (Maj_S      = '')          THEN BEGINL             Writeln('%SUB_TIMES-E-MISVAL, missing "major" qualifier value');             $Exit(44)            END;       IF  (Min_S      = '')          THEN BEGINL             Writeln('%SUB_TIMES-E-MISVAL, missing "minor" qualifier value');             $Exit(44)            END;'       IF (Sym_Present AND (Sym_S = ''))          THEN BEGINM             Writeln('%SUB_TIMES-E-MISSYM, missing "symbol" qualifier value');              $Exit(44) 
           END     END;   >    (********** MAIN ******** M A I N  ******** MAIN *********)       BEGIN   3     (*--- Getting string from foreign command ---*)   "     Sts:=Lib$Get_Foreign(Foreign);    )     (*--- looking for 3 qualifiers  ---*)   ;     Look_For_Qualifier(Foreign,'/MINOR',Min_S,Min_Present); ;     Look_For_Qualifier(Foreign,'/MAJOR',Maj_S,Maj_Present); <     Look_For_Qualifier(Foreign,'/SYMBOL',Sym_S,Sym_Present);  0     (*--- checking foreign-string's syntax ---*)       Check_Qualifiers_Syntax;  G     (*--- Converting from PACKED ARRAY OF CHAR to VARYING OF CHAR ---*)        Maj:=Maj_S;      Min:=Min_S;   L     (*--- Converting 'Maj' from string to internal time format; check. ---*)  ,     Sts:=Lib$Convert_Date_String(Maj,Maj_Q);       IF (Sts <> Ss$_Normal)       THEN BEGING           Writeln('%SUB_TIMES-E-ERRCONV, error converting major time');            $Exit(Sts)           END;  L     (*--- Converting 'Min' from string to internal time format; check. ---*)  -     Sts1:=Lib$Convert_Date_String(Min,Min_Q);      IF (Sts1 <> Ss$_Normal)        THEN BEGING           Writeln('%SUB_TIMES-E-ERRCONV, error converting minor time');            $Exit(Sts1)          END;  6     (*--- Subtracting minor time from major time ---*)  +     Sts:=Lib$SUB_TIMES(Maj_Q,Min_Q,Diff_Q);     =     (*--- Minor time was NOT less than Major time; abort---*)        IF Sts = Lib$_Negtim       THEN BEGINV           Writeln('%SUB_TIMES-E-MISMATCH, MAJOR must be GREATER than MINOR!  ;-)   ');           $Exit(44)          END;  A     (*--- Generic error; may delta time be too high? Abort --- *)        IF Sts  <> Lib$_Normal       THEN BEGINM           Writeln('%SUB_TIMES-E-DELTA, DELTA TIME too high or some error: '); <           Writeln('                   Status number: ',Sts);           $Exit(Sts)           END L       ELSE BEGIN   (*--- ALl right, converting result to string format ---*)C           Sts:=$Asctim(Diff_String.Length,Diff_String.Body,Diff_Q);   
           D           IF NOT Sym_Present     (* Displaying or defining symbol *)M             THEN Writeln('%SUB_TIMES-S-RESULT, DIFFERENCE IS: ',Diff_String)  7             ELSE Sts:=Lib$Set_Symbol(Sym_S,Diff_String)          END    END.