PROGRAM MONTHLY(INPUT,OUTPUT);
CONST
   NUM_TERMS = 34;
   MAX_USERS = 200;
TYPE
   STRING    = VARYING[82] OF CHAR;
   STRING5   = PACKED ARRAY[1..6] OF CHAR;
   STRING9   = PACKED ARRAY [1..9] OF CHAR;
   STRING10  = PACKED ARRAY[1..10] OF CHAR;
   STRING23  = PACKED ARRAY [1..23] OF CHAR;
   ARRAY31   = ARRAY[1..31] OF INTEGER;

VAR
   DONE           : BOOLEAN;
   AFTER_HOURS    : BOOLEAN;

   FF             : CHAR;

   LINE, TDATE    : STRING;
   PROCESS_TYPE   : STRING;
   USER, DAY      : STRING;
   CPU            : STRING;
   LAST_DAY       : STRING;
   TERMINAL       : STRING5;
   QUEUE          : STRING5;

   TERM_NAMES     : ARRAY [1..NUM_TERMS] OF STRING5;
   USER_NAMES     : ARRAY [1..MAX_USERS] OF STRING10;

   DAY_NUM, I, J  : INTEGER;
   CPU_MONTH      : INTEGER;
   BAD_LOGINS_MONTH : INTEGER;
   PROCESS_MONTH  : INTEGER;
   NUM_USERS      : INTEGER;
   NUM_PAGES_TOTAL: INTEGER;
   LINE_NUMBER    : INTEGER;
   
   NUM_BAD_LOGINS : ARRAY[1..31] OF INTEGER;
   NUM_BAD_TERM   : ARRAY[1..NUM_TERMS] OF INTEGER;
   NUM_TERM_USES  : ARRAY[1..NUM_TERMS] OF INTEGER;
   CPU_TOTAL      : ARRAY[1..31] OF INTEGER;   (* IN SECONDS *)
   CPU_TOTAL_U    : ARRAY[1..31,1..MAX_USERS] OF INTEGER;
   CPU_U_MONTH    : ARRAY[1..MAX_USERS] OF INTEGER;
   AFTER_USERS    : ARRAY[1..MAX_USERS] OF INTEGER;
   BAD_USERS      : ARRAY[1..MAX_USERS] OF INTEGER;
   NUM_PAGES_T    : ARRAY[1..MAX_USERS] OF INTEGER;
   NUM_PAGES_L    : ARRAY[1..MAX_USERS] OF INTEGER;
   NUM_PROCESS    : ARRAY[1..31] OF INTEGER;
   NUM_AFTER      : ARRAY[1..31] OF INTEGER;

   ACCT_FILE      : TEXT;





PROCEDURE WEKDAY(%STDESCR D:STRING23; %STDESCR W:STRING9 ); FORTRAN;





PROCEDURE INITIALIZE;
VAR
   TEMP      : STRING10;
   USER_FILE : TEXT;
BEGIN
   OPEN(ACCT_FILE,'ACCOUNT.DAT',HISTORY:=OLD);
   RESET(ACCT_FILE);

   TERM_NAMES[1]  := 'OPA0: ';
   TERM_NAMES[2]  := 'RTA0: ';       TERM_NAMES[3]  := 'RTA1: ';       
   TERM_NAMES[4]  := 'RTA2: ';       TERM_NAMES[5]  := 'RTA3: ';       
   TERM_NAMES[6]  := 'RTA4: ';       TERM_NAMES[7]  := 'RTA5: ';       
   TERM_NAMES[8]  := 'RTA6: ';       TERM_NAMES[9]  := 'RTA7: ';       
   TERM_NAMES[10] := 'TXA0: ';       TERM_NAMES[11] := 'TXA1: ';       
   TERM_NAMES[12] := 'TXA2: ';       TERM_NAMES[13] := 'TXA3: ';       
   TERM_NAMES[14] := 'TXA4: ';       TERM_NAMES[15] := 'TXA5: ';       
   TERM_NAMES[16] := 'TXA6: ';       TERM_NAMES[17] := 'TXA7: ';       
   TERM_NAMES[18] := 'TXB0: ';       TERM_NAMES[19] := 'TXB1: ';
   TERM_NAMES[20] := 'TXB2: ';       TERM_NAMES[21] := 'TXB3: ';
   TERM_NAMES[22] := 'TXB4: ';       TERM_NAMES[23] := 'TXB5: ';
   TERM_NAMES[24] := 'TXB6: ';       TERM_NAMES[25] := 'TXB7: ';
   TERM_NAMES[26] := 'TXC0: ';       TERM_NAMES[27] := 'TXC1: ';       
   TERM_NAMES[28] := 'TXC2: ';       TERM_NAMES[29] := 'TXC3: ';       
   TERM_NAMES[30] := 'TXC4: ';       TERM_NAMES[31] := 'TXC5: ';       
   TERM_NAMES[32] := 'TXC6: ';       TERM_NAMES[33] := 'TXC7: ';          
   TERM_NAMES[34] := 'OTHER ';


   NUM_USERS := 0;
   OPEN(USER_FILE,'USERS.DAT',HISTORY:=OLD);
   RESET(USER_FILE);
   WHILE NOT EOF(USER_FILE) DO BEGIN
      NUM_USERS := NUM_USERS + 1;
      AFTER_USERS[NUM_USERS] := 0;
      BAD_USERS[NUM_USERS]   := 0;
      NUM_PAGES_T[NUM_USERS] := 0;
      NUM_PAGES_L[NUM_USERS] := 0;
      READLN(USER_FILE,USER_NAMES[NUM_USERS]);
      END;
   
   WRITELN(' Number of users = ', NUM_USERS);
   NUM_USERS := NUM_USERS + 1;
   USER_NAMES[NUM_USERS] := 'UNKNOWN   ';
   AFTER_USERS[NUM_USERS] := 0;
   BAD_USERS[NUM_USERS] := 0;
   (* --- BUBBLE SORT USERS NAMES --- *)
   FOR I := 1 TO NUM_USERS-2 DO
    FOR J := I+1 TO NUM_USERS-1 DO
    IF USER_NAMES[I] > USER_NAMES[J] THEN BEGIN
       TEMP := USER_NAMES[I];
       USER_NAMES[I] := USER_NAMES[J];
       USER_NAMES[J] := TEMP;
       END;

   WRITE(' Enter month and year --> ');
   READLN(TDATE);
   FF      := CHR(12);
   DONE    := FALSE;
   DAY_NUM := 0;
   LAST_DAY:= '00';
   FOR I := 1 TO 31 DO BEGIN
      NUM_BAD_LOGINS[I] := 0;
      NUM_PROCESS[I]    := 0;
      CPU_TOTAL[I]      := 0;
      NUM_AFTER[I]      := 0;
      FOR J := 1 TO NUM_USERS DO CPU_TOTAL_U[I,J] := 0;
      END;
   FOR I := 1 TO NUM_TERMS DO BEGIN
      NUM_BAD_TERM[I] := 0;
      NUM_TERM_USES[I]:= 0;
      END;
   LINE_NUMBER := 0;
   END; (* INITIALIZE *)



PROCEDURE GET_PROCESS;
(*                                                                  *)
(*  GET THE REQUIRED ENTRIES IN AN INDIVIDUAL PROCESS RECORD        *)
(*                                                                  *)
VAR  XDATE : STRING23;
     WDAY : STRING9;
     HOUR : PACKED ARRAY [1..2] OF CHAR;

BEGIN
   READLN(ACCT_FILE,PROCESS_TYPE);
   READLN(ACCT_FILE);   READLN(ACCT_FILE);
   READLN(ACCT_FILE,LINE);
   LINE_NUMBER := LINE_NUMBER + 4;
   USER  := SUBSTR(LINE,20,10);
   READLN(ACCT_FILE,LINE);
   LINE_NUMBER := LINE_NUMBER + 2;
   IF LENGTH(LINE) > 56 THEN BEGIN
      DAY   := SUBSTR(LINE,57,2);
      HOUR  := SUBSTR(LINE,69,2);
      XDATE := SUBSTR(LINE,57,23);
      END
   ELSE BEGIN
      DAY := '  ';
      HOUR := '  ';
      XDATE := '                       ';
      END;
   IF XDATE[1] = ' ' THEN XDATE[1] := '0';
   READLN(ACCT_FILE);        READLN(ACCT_FILE);
   READLN(ACCT_FILE,LINE);
   LINE_NUMBER := LINE_NUMBER + 2;
   TERMINAL := SUBSTR(LINE,20,6);
   IF LENGTH(LINE)>68 THEN CPU  := SUBSTR(LINE,67,13)
                      ELSE CPU  := '             ';
   IF SUBSTR(PROCESS_TYPE,1,6) = 'PRINT ' THEN BEGIN
      READLN(ACCT_FILE);     READLN(ACCT_FILE);
      READLN(ACCT_FILE);     READLN(ACCT_FILE);
      READLN(ACCT_FILE,LINE);
      LINE_NUMBER := LINE_NUMBER + 5;
      QUEUE := SUBSTR(LINE,20,4);
      END;
   WEKDAY(XDATE,WDAY);  
   AFTER_HOURS := ((WDAY = 'SUNDAY   ') OR (WDAY = 'SATURDAY ') OR 
                  (HOUR > '17') OR (HOUR < '06'));
   END; (* GET_PROCESS *)



PROCEDURE STORE_DATA;
(*                                                                  *)
(*  STORE RELEVANT DATA IN ARRAYS FOR POST-PROCESSING BY SUMMARIZE  *)
(*                                                                  *)
VAR
   TERM     : INTEGER;
   CPU_TIME : INTEGER;
   USER_ID  : INTEGER;
   TEMP     : STRING;


 PROCEDURE GET_TERM ( TERMINAL : STRING5; VAR TERM : INTEGER );
 (*                                                              *)
 (*  BINARY SEARCH LIST OF TERMINALS FOR THIS TERMINAL ID        *)
 (*                                                              *)
 VAR
   MID,HI,LO : INTEGER;
 BEGIN
    HI := NUM_TERMS-1;
    LO := 1;
    REPEAT
       MID := (HI + LO) DIV 2;
       IF TERMINAL <= TERM_NAMES[MID] THEN HI := MID-1;
       IF TERMINAL >= TERM_NAMES[MID] THEN LO := MID+1;
       UNTIL LO > HI;
    IF LO-1 > HI THEN TERM := MID
    ELSE TERM := NUM_TERMS;
    END; (* GET_TERM *)


 PROCEDURE GET_CPU ( CPU : STRING; VAR TIME : INTEGER );
 VAR
    D,H,M,S,F      : STRING;
    DAY,HR,MIN,SEC : INTEGER;
 BEGIN
    D := SUBSTR(CPU,1,1);
    READV(D,DAY);
    H := SUBSTR(CPU,3,2);
    READV(H,HR);
    M := SUBSTR(CPU,6,2);
    READV(M,MIN);
    S := SUBSTR(CPU,9,2);
    READV(S,SEC);
    CPU_TIME := SEC + 60*MIN + 3600*HR + 86400*DAY;
    F := SUBSTR(CPU,12,2);
    READV(F,SEC);
    IF SEC > 50 THEN CPU_TIME := CPU_TIME + 1;
    END; (* GET_CPU *)



 PROCEDURE GET_USER ( USER : STRING; VAR USER_ID : INTEGER );
 (*                                                                        *)
 (*   BINARY SEARCH LIST OF KNOWN USERS FOR THIS USER ID                   *)
 (*                                                                        *)
 VAR
   MID,HI,LO : INTEGER;
 BEGIN
    HI := NUM_USERS-1;
    LO := 1;
    REPEAT
       MID := (HI + LO) DIV 2;
       IF USER <= USER_NAMES[MID] THEN HI := MID-1;
       IF USER >= USER_NAMES[MID] THEN LO := MID+1;
       UNTIL LO > HI;
    IF LO-1 > HI THEN USER_ID := MID
    ELSE BEGIN
       WRITELN(' --- UNKNOWN ID : ',USER,' ---');
       USER_ID := NUM_USERS;
       END;
    END; (* GET_USER *)



BEGIN
   IF DAY <> LAST_DAY THEN BEGIN
      READV(DAY,DAY_NUM);
      LAST_DAY := DAY;
      END;

   IF AFTER_HOURS THEN NUM_AFTER[DAY_NUM] := NUM_AFTER[DAY_NUM] + 1;
   IF TERMINAL <> '      ' THEN BEGIN
      GET_TERM(TERMINAL,TERM);
      NUM_TERM_USES[TERM] := NUM_TERM_USES[TERM] + 1;
      END;
   GET_CPU(CPU,CPU_TIME);
   CPU_TOTAL[DAY_NUM] := CPU_TOTAL[DAY_NUM] + CPU_TIME;
   GET_USER(USER,USER_ID);
   IF AFTER_HOURS THEN AFTER_USERS[USER_ID] := AFTER_USERS[USER_ID] + 1;
   CPU_TOTAL_U[DAY_NUM,USER_ID] := CPU_TOTAL_U[DAY_NUM,USER_ID] + CPU_TIME;
   NUM_PROCESS[DAY_NUM] := NUM_PROCESS[DAY_NUM] + 1;

   IF SUBSTR(PROCESS_TYPE,1,13) = 'LOGIN FAILURE' THEN BEGIN
      NUM_BAD_LOGINS[DAY_NUM] := NUM_BAD_LOGINS[DAY_NUM] + 1;
      IF TERMINAL <> '      ' THEN NUM_BAD_TERM[TERM] := NUM_BAD_TERM[TERM] + 1;
      BAD_USERS[USER_ID] := BAD_USERS[USER_ID] + 1;
      END
   ELSE IF SUBSTR(PROCESS_TYPE,1,6) = 'PRINT ' THEN BEGIN
      READLN(ACCT_FILE);      READLN(ACCT_FILE);
      READLN(ACCT_FILE);      READLN(ACCT_FILE);
      READLN(ACCT_FILE);      READLN(ACCT_FILE,LINE);
      LINE_NUMBER := LINE_NUMBER + 6;
      TEMP := SUBSTR(LINE,24,6);
      READV(TEMP,I);
      IF (SUBSTR(QUEUE,1,1) = 'T') OR
         (SUBSTR(QUEUE,1,4) = 'LIB0') THEN BEGIN
         NUM_PAGES_T[USER_ID] := NUM_PAGES_T[USER_ID] + I;
         END
      ELSE BEGIN
         NUM_PAGES_L[USER_ID] := NUM_PAGES_L[USER_ID] + I;
         END;
      END;
   END; (* STORE_DATA *)



PROCEDURE SKIP_TO_FF;
(*                                                                  *)
(*  READ LINES UNTIL THE FIRST CHARACTER IS A FORM FEED             *)
(*                                                                  *)
VAR
   FOUND : BOOLEAN;
BEGIN
   FOUND := FALSE;
   REPEAT
      READLN(ACCT_FILE,LINE);
      LINE_NUMBER := LINE_NUMBER + 1;
      IF LENGTH(LINE) > 0 THEN FOUND := LINE[1]=FF;
      UNTIL (FOUND  OR  EOF(ACCT_FILE));
   IF EOF(ACCT_FILE) THEN DONE := TRUE;
   END; (* SKIP_TO_FF *)



PROCEDURE SUMMARIZE;
(*                                                                   *)
(*  CALCULATE MONTHLY TOTALS FROM DAILY STATISTICS                   *)
(*                                                                   *)
VAR K : INTEGER;

BEGIN
   CPU_MONTH        := 0;
   BAD_LOGINS_MONTH := 0;
   PROCESS_MONTH    := 0;
   NUM_PAGES_TOTAL  := 0;
   FOR K := 1 TO NUM_USERS DO BEGIN
      CPU_U_MONTH[K] := 0;
      NUM_PAGES_TOTAL := NUM_PAGES_TOTAL + NUM_PAGES_L[K] +
                         NUM_PAGES_T[K];
      END;
   FOR J := 1 TO 31 DO BEGIN
      PROCESS_MONTH    := PROCESS_MONTH + NUM_PROCESS[J];
      BAD_LOGINS_MONTH := BAD_LOGINS_MONTH + NUM_BAD_LOGINS[J];
      CPU_MONTH        := CPU_MONTH + CPU_TOTAL[J];
      FOR I := 1 TO NUM_USERS DO CPU_U_MONTH[I] := CPU_U_MONTH[I] + 
       CPU_TOTAL_U[J,I];
      END;
   END; (* SUMMARIZE *)



PROCEDURE PRINTOUT;
VAR
   OTPT     : TEXT;
   FNAME    : STRING;
   PERCENT  : REAL;
   HH,MM,SS : INTEGER;
   IPERCENT : INTEGER;
   LS       : INTEGER;



PROCEDURE HISTOGRAM ( PLABEL,XLABEL,YLABEL : STRING; VALUES : ARRAY31 );
VAR
    I,J,K,N,ND  : INTEGER;
    MAX,L,START : INTEGER;
    PART,SEC	: INTEGER;
    ST          : VARYING[100] OF CHAR;
    SHORT       : VARYING[7] OF CHAR;
    CHART       : PACKED ARRAY [1..55,1..120] OF CHAR;
BEGIN
   WRITELN ( OTPT, FF );
   MAX := 0;
   FOR I := 1 TO 31 DO IF VALUES[I] > MAX THEN MAX := VALUES[I];
   PART:= MAX DIV 1000 + 2;
   MAX := PART * 1000;
   SEC := MAX DIV 39;
   IF MAX > 0 THEN BEGIN
      FOR I := 1 TO 55 DO
       FOR J := 1 TO 120 DO CHART[I,J] := ' ';
      (* FRAME *)
      FOR J := 21 TO 120 DO BEGIN
         CHART[7,J] := 'O';     CHART[47,J] := 'O';
         END;
      FOR I := 8 TO 46 DO BEGIN
         CHART[I,21] := 'O';    CHART[I,120] := 'O';
         END;
      (* TIC MARKS *)
      FOR J := 19 TO 20 DO BEGIN
         CHART[7,J]  := 'O';    CHART[15,J] := 'O';
         CHART[23,J] := 'O';    CHART[31,J] := 'O';
         CHART[39,J] := 'O';    CHART[47,J] := 'O';
         END;
      (* CHART LABEL *)
      L := LENGTH ( PLABEL );
      IF L > 0 THEN BEGIN
         START := 70 - L DIV 2;
         ND    := START + L - 1;
         FOR J := START TO ND DO CHART[4,J] := PLABEL[J-START+1];
         END;
      WRITEV(SHORT,SEC:5);
      ST:='( * =' + SHORT + ' SECS )';
      FOR J:= 1 TO 17 DO CHART[5,J+START-1] := ST[J];
      (* X LABEL *)
      L := LENGTH ( XLABEL );
      IF L > 0 THEN BEGIN
         START := 70 - L DIV 2;
         ND    := START + L - 1;
         FOR J := START TO ND DO CHART[53,J] := XLABEL[J-START+1];
         END;
      (* Y LABEL *)
      L := LENGTH ( YLABEL );
      IF L > 0 THEN BEGIN
         START := 26 - L DIV 2;
         ND    := START + L - 1;
         FOR I := START TO ND DO CHART[I,2] := YLABEL[I-START+1];
         END;
      (* X TIC LABELS *)
      ST := '             5             10             15';
      ST := ST + '             20             25             30';
      FOR J := 25 TO 113 DO CHART[50,J] := ST[J-24];
      ST := '             O              O              O';
      ST := ST + '              O              O              O';
      FOR J := 25 TO 113 DO CHART[48,J] := ST[J-24];
      (* Y TIC LABELS *)
      CHART[47,15] := '0';
      FOR K := 1 TO 5 DO BEGIN
         N := 20 * K * MAX DIV 100;
         WRITEV ( SHORT, N:6 );
         FOR J := 10 TO 15 DO CHART[47-8*K,J] := SHORT[J-9];
         END;
      (* BARS *)
      FOR K := 1 TO 31 DO BEGIN
         N := ((VALUES[K]+SEC DIV 2) * 39) DIV MAX;
         IF N > 0 THEN FOR I := 46 DOWNTO 46-N DO CHART[I,23+K*3] := '*';
         END;
      (* PRINT CHART *)
      FOR I := 1 TO 55 DO BEGIN
         FOR J := 1 TO 120 DO WRITE ( OTPT, CHART[I,J] );
         WRITELN ( OTPT );
         END;
      END;      
   END; (* HISTOGRAM *)



BEGIN
   FNAME := 'ACCOUNT.OUT';
   LS := LENGTH(TDATE);
   IF LS > 3 THEN BEGIN
      HH := LS-1;
      FNAME := SUBSTR(TDATE,1,3) + SUBSTR(TDATE,HH,2) + '.OUT';
      END;
   OPEN(OTPT,FNAME);
   REWRITE(OTPT);
   WRITELN(OTPT); WRITELN(OTPT); WRITELN(OTPT);
   WRITELN(OTPT,
    '    *******************************************************************');
   WRITELN(OTPT,
    '    *                                                                 *');
   WRITELN(OTPT,
    '    *         ACCOUNTING SUMMARY FOR ',TDATE:13,'                    *');
   WRITELN(OTPT,
    '    *                                                                 *');
   WRITELN(OTPT,
    '    *******************************************************************');
   WRITELN ( OTPT );
   WRITELN ( OTPT );
   WRITELN ( OTPT );
   WRITELN ( OTPT );
   WRITELN ( OTPT );
   WRITELN ( OTPT );
   WRITELN ( OTPT );
   WRITELN(OTPT,'      Number of Processes Performed = ',PROCESS_MONTH);
   WRITELN(OTPT);
   WRITELN(OTPT,'      Number of Failed Logins       = ',BAD_LOGINS_MONTH);
   WRITELN(OTPT);
   HH := CPU_MONTH DIV 3600;
   CPU_MONTH := CPU_MONTH - 3600*HH;
   MM := CPU_MONTH DIV 60;
   CPU_MONTH := CPU_MONTH - 60*MM;
   SS := CPU_MONTH;
   WRITELN(OTPT,'      Total CPU Time Used           = ',HH,':',MM:2,':',SS:2);
   WRITELN(OTPT);
   WRITELN(OTPT,'      Total pages of printout       = ',NUM_PAGES_TOTAL);
   WRITELN(OTPT,FF);
   WRITELN(OTPT,
    '                                            Daily Breakdown ');
   WRITELN(OTPT,
    '                                            ----- ---------'); 
   WRITELN(OTPT); WRITELN(OTPT);
   WRITELN(OTPT,
    ' Day           Bad Logins        Number of Processes      After Hours',
    '         CPU Time(sec)         Approx Percent');
   WRITELN(OTPT,
    ' ---           --- ------        ------ -- ---------      ----- -----',
    '         --- ---- ---          ------ -------'); 
   WRITELN(OTPT);
   FOR I := 1 TO 31 DO BEGIN
      PERCENT := CPU_TOTAL[I];
      PERCENT := PERCENT/324.0;
      IPERCENT := TRUNC(PERCENT);
      WRITELN(OTPT,' ',I:2,'               ',NUM_BAD_LOGINS[I]:4,
       '                    ',NUM_PROCESS[I]:4,'         ',
       NUM_AFTER[I],
       '               ',CPU_TOTAL[I]:6,'             ',IPERCENT);
      END;
   WRITELN(OTPT,FF);
   WRITELN(OTPT,'                                      Individual Breakdowns');
   WRITELN(OTPT,'                                      ---------- ----------');
   WRITELN(OTPT);   WRITELN(OTPT);
   WRITELN(OTPT,
   'User ID        CPU Time    After Hours Logins   Bad Logins',
   '    Pages Printed(Laser)     Pages Printed(Line)');
   WRITELN(OTPT,
   '---- --        --- ----    ----- ----- ------   --- ------',
   '    ----- --------------     ----- -------------');
   WRITELN(OTPT);
   FOR I := 1 TO NUM_USERS DO BEGIN
      WRITELN(OTPT,USER_NAMES[I],'     ',CPU_U_MONTH[I]:6,
      '     ',AFTER_USERS[I],'        ',BAD_USERS[I],'         ',
      NUM_PAGES_T[I],'            ',NUM_PAGES_L[I]);
      END;
   WRITELN(OTPT,FF);
   WRITELN(OTPT,'    Information by Terminal');
   WRITELN(OTPT,'    ----------- -- --------');
   WRITELN(OTPT);   WRITELN(OTPT);
   WRITELN(OTPT,'  Terminal ID           Failures          Number of Uses');
   WRITELN(OTPT,'  -------- --           --------          ------ -- ----');
   WRITELN(OTPT);
   FOR I := 1 TO NUM_TERMS DO
    WRITELN(OTPT,'    ',TERM_NAMES[I],'        ',NUM_BAD_TERM[I],
               '         ',NUM_TERM_USES[I]);
   HISTOGRAM( 'DAILY CPU USAGE','DAY OF MONTH','CPU TIME',CPU_TOTAL );
   END; (* PRINTOUT *)



BEGIN (* MAIN *)
   INITIALIZE;
   SKIP_TO_FF;
   REPEAT
      GET_PROCESS;
      STORE_DATA;
      SKIP_TO_FF;
      UNTIL DONE;
   SUMMARIZE;
   PRINTOUT;
   END.
