PROGRAM YEARLY(INPUT,OUTPUT);
(*                                                       *)
(*        Summarize the monthly accounting reports       *)
(*                                                       *)
CONST
   NUM_TERMS = 42;       { Change at end of year }
   MAX_USERS = 200;
TYPE
   STRING    = VARYING[80] OF CHAR;
   STRING5   = PACKED ARRAY[1..6] OF CHAR;
   STRING10  = PACKED ARRAY[1..10] OF CHAR;
   ARRAY12   = ARRAY [1..12] OF INTEGER;

VAR
   DONE           : BOOLEAN;

   FF             : CHAR;

   LINE, TDATE    : STRING;
   USER           : STRING10;
   CPU            : STRING;
   TERMINAL       : STRING5;
   YEAR           : PACKED ARRAY [1..2] OF CHAR;

   TERM_NAMES     : ARRAY [1..NUM_TERMS] OF STRING5;
   USER_NAMES     : ARRAY [1..MAX_USERS] OF STRING10;
   MONTH_NAME     : ARRAY [1..12] OF PACKED ARRAY [1..3] OF CHAR;

   I, J           : INTEGER;
   CPU_YEAR       : INTEGER;
   BAD_LOGINS_YEAR: INTEGER;
   PROCESS_YEAR   : INTEGER;
   PAGES_YEAR     : INTEGER;
   NUM_USERS      : INTEGER;
   MONTH          : INTEGER;
   NNN : INTEGER;
      
   NUM_BAD_LOGINS : ARRAY[1..12] OF INTEGER;
   NUM_BAD_TERM   : ARRAY[1..12,1..NUM_TERMS] OF INTEGER;
   CPU_TOTAL      : ARRAY[1..12] OF INTEGER;   (* IN SECONDS *)
   CPU_TOTAL_U    : ARRAY[1..12,1..MAX_USERS] OF INTEGER;
   CPU_U_YEAR     : ARRAY[1..MAX_USERS] OF INTEGER;
   NUM_PROCESS    : ARRAY[1..12] OF INTEGER;

   ACCT_FILE      : TEXT;


PROCEDURE INITIALIZE;
VAR
   L         : INTEGER;
   TEMP      : STRING10;
   USER_FILE : TEXT;
BEGIN
   MONTH_NAME[1]  := 'JAN';          MONTH_NAME[2]  := 'FEB';
   MONTH_NAME[3]  := 'MAR';          MONTH_NAME[4]  := 'APR';
   MONTH_NAME[5]  := 'MAY';          MONTH_NAME[6]  := 'JUN';
   MONTH_NAME[7]  := 'JUL';          MONTH_NAME[8]  := 'AUG';
   MONTH_NAME[9]  := 'SEP';          MONTH_NAME[10] := 'OCT';
   MONTH_NAME[11] := 'NOV';          MONTH_NAME[12] := 'DEC';

   TERM_NAMES[1]  := 'OPA0: ';        
   
   TERM_NAMES[2]  := 'RTA0: ';
   TERM_NAMES[3]  := 'RTA1: ';        TERM_NAMES[4]  := 'RTA2: ';
   TERM_NAMES[5]  := 'RTA3: ';        TERM_NAMES[6]  := 'RTA4: ';
   TERM_NAMES[7]  := 'RTA5: ';        TERM_NAMES[8]  := 'RTA6: ';
   TERM_NAMES[9]  := 'RTA7: ';        

   TERM_NAMES[10] := 'TXA0: ';
   TERM_NAMES[11] := 'TXA1: ';        TERM_NAMES[12] := 'TXA2: ';
   TERM_NAMES[13] := 'TXA3: ';        TERM_NAMES[14] := 'TXA4: ';
   TERM_NAMES[15] := 'TXA5: ';        TERM_NAMES[16] := 'TXA6: ';
   TERM_NAMES[17] := 'TXA7: ';        

   TERM_NAMES[18] := 'TXB0: ';        TERM_NAMES[19] := 'TXB1: ';
   TERM_NAMES[20] := 'TXB2: ';        TERM_NAMES[21] := 'TXB3: ';
   TERM_NAMES[22] := 'TXB4: ';        TERM_NAMES[23] := 'TXB5: ';
   TERM_NAMES[24] := 'TXB6: ';        TERM_NAMES[25] := 'TXB7: ';
   TERM_NAMES[26] := 'TXB8: ';        TERM_NAMES[27] := 'TXB9: ';
   TERM_NAMES[28] := 'TXB10:';        TERM_NAMES[29] := 'TXB11:';
   TERM_NAMES[30] := 'TXB12:';        TERM_NAMES[31] := 'TXB13:';
   TERM_NAMES[32] := 'TXB14:';        TERM_NAMES[33] := 'TXB15:';

   TERM_NAMES[34] := 'TXC0: ';
   TERM_NAMES[35] := 'TXC1: ';        TERM_NAMES[36] := 'TXC2: ';
   TERM_NAMES[37] := 'TXC3: ';        TERM_NAMES[38] := 'TXC4: ';
   TERM_NAMES[39] := 'TXC5: ';        TERM_NAMES[40] := 'TXC6: ';
   TERM_NAMES[41] := 'TXC7: ';        TERM_NAMES[42] := 'OTHER ';

   NUM_USERS := 0;
   OPEN(USER_FILE,'USERS.DAT',HISTORY:=OLD);
   RESET(USER_FILE);
   WHILE NOT EOF(USER_FILE) DO BEGIN
      NUM_USERS := NUM_USERS + 1;
      READLN(USER_FILE,USER_NAMES[NUM_USERS]);
      END;
   NUM_USERS := NUM_USERS + 1;
   USER_NAMES[NUM_USERS] := 'UNKNOWN   ';
   (* --- BUBBLE SORT USERS NAMES --- *)
   FOR I := 1 TO NUM_USERS-1 DO
    FOR J := I+1 TO NUM_USERS DO
    IF USER_NAMES[I] > USER_NAMES[J] THEN BEGIN
       TEMP := USER_NAMES[I];
       USER_NAMES[I] := USER_NAMES[J];
       USER_NAMES[J] := TEMP;
       END;

   REPEAT
      WRITE(' Enter year --> ');
      READLN(TDATE);
      L := LENGTH ( TDATE );
      UNTIL L > 1;
   YEAR[2] := TDATE[L];
   YEAR[1] := TDATE[L-1];

   FF      := CHR(12);
   DONE    := FALSE;
   FOR I := 1 TO 12 DO BEGIN
      NUM_BAD_LOGINS[I] := 0;
      NUM_PROCESS[I]    := 0;
      CPU_TOTAL[I]      := 0;
      FOR J := 1 TO NUM_USERS DO CPU_TOTAL_U[I,J] := 0;
      FOR J := 1 TO NUM_TERMS DO NUM_BAD_TERM[I,J] := 0;
      END;
   END; (* INITIALIZE *)






 PROCEDURE GET_TERM ( TERMINAL : STRING5; VAR TERM : INTEGER );
 (*                                                              *)
 (*  BINARY SEARCH LIST OF TERMINALS FOR THIS TERMINAL ID        *)
 (*                                                              *)
 VAR
   MID,HI,LO : INTEGER;
 BEGIN
    HI := NUM_TERMS-1;
    LO := 1;
    REPEAT
       MID := (HI + LO) DIV 2;
       IF TERMINAL <= TERM_NAMES[MID] THEN HI := MID-1;
       IF TERMINAL >= TERM_NAMES[MID] THEN LO := MID+1;
       UNTIL LO > HI;
    IF LO-1 > HI THEN TERM := MID
    ELSE TERM := NUM_TERMS;
    END; (* GET_TERM *)



 PROCEDURE GET_CPU ( CPU : STRING; VAR TIME : INTEGER );
 VAR
    H,M,S         : STRING;
    HR,MIN,SEC    : INTEGER;
 BEGIN
    H := SUBSTR(CPU,1,3);
    READV(H,HR);
    M := SUBSTR(CPU,5,2);
    READV(M,MIN);
    S := SUBSTR(CPU,8,2);
    READV(S,SEC);
    TIME := SEC + 60*MIN + 3600*HR;
    END; (* GET_CPU *)



 PROCEDURE GET_USER ( USER : STRING10; VAR USER_ID : INTEGER );
 (*                                                                        *)
 (*   BINARY SEARCH LIST OF KNOWN USERS FOR THIS USER ID                   *)
 (*                                                                        *)
 VAR
   MID,HI,LO : INTEGER;
 BEGIN
    HI := NUM_USERS;
    LO := 1;
    REPEAT
       MID := (HI + LO) DIV 2;
       IF USER <= USER_NAMES[MID] THEN HI := MID-1;
       IF USER >= USER_NAMES[MID] THEN LO := MID+1;
       UNTIL LO > HI;
    IF LO-1 > HI THEN USER_ID := MID
    ELSE BEGIN
       WRITELN(' --- UNKNOWN ID : ',USER,' ---');
       USER_ID := NUM_USERS;
       END;
    END; (* GET_USER *)




PROCEDURE SKIP_TO_FF;
(*                                                                  *)
(*  READ LINES UNTIL THE FIRST CHARACTER IS A FORM FEED             *)
(*                                                                  *)
VAR
   FOUND : BOOLEAN;
BEGIN
   FOUND := FALSE;
   REPEAT
      READLN(ACCT_FILE,LINE);
      NNN := NNN + 1;
      IF LENGTH(LINE) > 0 THEN FOUND := LINE[1]=FF;
      UNTIL (FOUND  OR  EOF(ACCT_FILE));
   IF EOF(ACCT_FILE) THEN DONE := TRUE;
   END; (* SKIP_TO_FF *)



PROCEDURE GET_MONTH;
VAR
   FNAME       : STRING;
   LINE        : STRING;
   WORK        : STRING;
   PAGES_MONTH : INTEGER;
BEGIN
   FNAME := MONTH_NAME[MONTH] + YEAR + '.OUT';
   OPEN ( ACCT_FILE,FNAME,HISTORY:=OLD,ERROR:=CONTINUE );
   IF STATUS(ACCT_FILE) = 0 THEN BEGIN
      WRITELN( 'READING ',MONTH_NAME[MONTH],' FILE');
      RESET ( ACCT_FILE );
      READLN ( ACCT_FILE, LINE );
      NNN := NNN + 1;
      IF LENGTH ( LINE ) < 5 THEN BEGIN   (* 'empty' APPEARS ON THE FIRST LINE
                                          OF AN EMPTY FILE *)

      REPEAT
         READLN ( ACCT_FILE, LINE );
         NNN := NNN + 1;
         UNTIL (LENGTH(LINE)>14) AND (SUBSTR ( LINE, 7, 6 ) = 'Number');
      WORK := SUBSTR ( LINE, 43, 6 );
      READV ( WORK, NUM_PROCESS[MONTH] );

      READLN ( ACCT_FILE );
      READLN ( ACCT_FILE, LINE );
      NNN := NNN + 2;
      WORK := SUBSTR ( LINE, 43, 6 );
      READV ( WORK, NUM_BAD_LOGINS[MONTH] );

      READLN ( ACCT_FILE );
      READLN ( ACCT_FILE, LINE );
      NNN := NNN + 2;
      WORK := SUBSTR ( LINE, 46, 9 );
      GET_CPU ( WORK, CPU_TOTAL[MONTH] );

      READLN ( ACCT_FILE );
      READLN ( ACCT_FILE, LINE );
      NNN := NNN + 2;
      WORK := SUBSTR ( LINE, 43, 6 );
      READV(WORK,PAGES_MONTH);
      PAGES_YEAR := PAGES_YEAR + PAGES_MONTH;

      SKIP_TO_FF;     SKIP_TO_FF;
      READLN ( ACCT_FILE );   READLN ( ACCT_FILE );   READLN ( ACCT_FILE );
      READLN ( ACCT_FILE );   READLN ( ACCT_FILE );   READLN ( ACCT_FILE );
      READLN ( ACCT_FILE );
      NNN := NNN + 7;

      REPEAT
         READLN ( ACCT_FILE, LINE );
         NNN := NNN + 1;
         IF LENGTH ( LINE ) > 3 THEN BEGIN
            USER := SUBSTR ( LINE, 1, 10 );
            GET_USER ( USER, I );


  { FIX THIS AFTER DEC, 1986 !!!!!! }
{         IF MONTH <10 THEN WORK := SUBSTR ( LINE, 23, 6 ) }
{         ELSE WORK := SUBSTR ( LINE, 16, 6 ); }
            WORK := SUBSTR ( LINE, 16, 6 );


            READV ( WORK, CPU_TOTAL_U[MONTH,I] );
            END;
         UNTIL SUBSTR ( LINE, 1, 1 ) = FF;

      READLN ( ACCT_FILE );   READLN ( ACCT_FILE );   READLN ( ACCT_FILE );
      READLN ( ACCT_FILE );   READLN ( ACCT_FILE );   READLN ( ACCT_FILE );
      READLN ( ACCT_FILE );
      NNN := NNN + 7;

      REPEAT
         READLN ( ACCT_FILE, LINE );
         NNN := NNN + 1;
         IF LENGTH ( LINE ) > 3 THEN BEGIN
            TERMINAL := SUBSTR ( LINE, 5, 6 );
            GET_TERM ( TERMINAL, I );
            WORK := SUBSTR ( LINE, 26, 3 );
            READV ( WORK, NUM_BAD_TERM[MONTH,I] );
            END;
         UNTIL EOF ( ACCT_FILE ) OR ( TERMINAL = 'OTHER ' );

      END;
      CLOSE ( ACCT_FILE );
      END;
   END; (* GET_MONTH *)



PROCEDURE SUMMARIZE;
(*                                                      *)
(*  CALCULATE YEARLY TOTALS FROM MONTHLY STATISTICS     *)
(*                                                      *)
VAR
   SUM : INTEGER;
BEGIN
   CPU_YEAR         := 0;
   BAD_LOGINS_YEAR  := 0;
   PROCESS_YEAR     := 0;
   FOR I := 1 TO NUM_USERS DO CPU_U_YEAR[I] := 0;
   FOR J := 1 TO 12 DO BEGIN
      PROCESS_YEAR    := PROCESS_YEAR + NUM_PROCESS[J];
      BAD_LOGINS_YEAR := BAD_LOGINS_YEAR + NUM_BAD_LOGINS[J];
      CPU_YEAR        := CPU_YEAR + CPU_TOTAL[J];
      FOR I := 1 TO NUM_USERS DO CPU_U_YEAR[I] := CPU_U_YEAR[I] + 
       CPU_TOTAL_U[J,I];
      END;
   FOR I := 1 TO NUM_TERMS DO BEGIN
      SUM := 0;
      FOR J := 1 TO 12 DO SUM := SUM + NUM_BAD_TERM[J,I];
      NUM_BAD_TERM[1,I] := SUM;
      END;
   END; (* SUMMARIZE *)





PROCEDURE PRINTOUT;
VAR
   OTPT     : TEXT;
   FNAME    : STRING;
   PERCENT  : REAL;
   HH,MM,SS : INTEGER;
   IPERCENT : INTEGER;
   LS       : INTEGER;


PROCEDURE HISTOGRAM ( PLABEL,XLABEL,YLABEL : STRING; VALUES : ARRAY12 );
VAR
    I,J,K,N,ND  : INTEGER;
    MAX,L,START : INTEGER;
    PART,SEC	: INTEGER;
    ST          : VARYING[100] OF CHAR;
    SHORT       : VARYING[7] OF CHAR;
    CHART       : PACKED ARRAY [1..55,1..120] OF CHAR;
BEGIN
   WRITELN ( OTPT, FF );
   MAX := 0;
   FOR I := 1 TO 12 DO IF VALUES[I] > MAX THEN MAX := VALUES[I];
   PART:= MAX DIV 10000 + 2;
   MAX := PART * 10000;
   SEC := MAX DIV 39;
   IF MAX > 0 THEN BEGIN
      FOR I := 1 TO 55 DO
       FOR J := 1 TO 120 DO CHART[I,J] := ' ';
      (* FRAME *)
      FOR J := 21 TO 120 DO BEGIN
         CHART[7,J] := 'O';     CHART[47,J] := 'O';
         END;
      FOR I := 8 TO 46 DO BEGIN
         CHART[I,21] := 'O';    CHART[I,120] := 'O';
         END;
      (* TIC MARKS *)
      FOR J := 19 TO 20 DO BEGIN
         CHART[7,J]  := 'O';    CHART[15,J] := 'O';
         CHART[23,J] := 'O';    CHART[31,J] := 'O';
         CHART[39,J] := 'O';    CHART[47,J] := 'O';
         END;
      (* CHART LABEL *)
      L := LENGTH ( PLABEL );
      IF L > 0 THEN BEGIN
         START := 70 - L DIV 2;
         ND    := START + L - 1;
         FOR J := START TO ND DO CHART[4,J] := PLABEL[J-START+1];
         END;
      WRITEV(SHORT,SEC:5);
      ST:='( * =' + SHORT + ' SECS )';
      FOR J:= 1 TO 17 DO CHART[5,J+START-1] := ST[J];
      (* X LABEL *)
      L := LENGTH ( XLABEL );
      IF L > 0 THEN BEGIN
         START := 70 - L DIV 2;
         ND    := START + L - 1;
         FOR J := START TO ND DO CHART[53,J] := XLABEL[J-START+1];
         END;
      (* Y LABEL *)
      L := LENGTH ( YLABEL );
      IF L > 0 THEN BEGIN
         START := 26 - L DIV 2;
         ND    := START + L - 1;
         FOR I := START TO ND DO CHART[I,2] := YLABEL[I-START+1];
         END;
      (* X TIC LABELS *)
      ST := 'JAN     FEB     MAR     APR     MAY     JUN';
      ST := ST + '     JUL     AUG     SEP     OCT     NOV     DEC';
      FOR J := 25 TO 115 DO CHART[49,J] := ST[J-24];
      (* Y TIC LABELS *)
      CHART[47,15] := '0';
      FOR K := 1 TO 5 DO BEGIN
         N := 20 * K * MAX DIV 100;
         WRITEV ( SHORT, N:6 );
         FOR J := 10 TO 15 DO CHART[47-8*K,J] := SHORT[J-9];
         END;
      (* BARS *)
      FOR K := 1 TO 12 DO BEGIN
         N := ((VALUES[K]+SEC DIV 2) * 39) DIV MAX;
         IF N > 0 THEN FOR I := 46 DOWNTO 46-N DO CHART[I,18+K*8] := '*';
         END;
      (* PRINT CHART *)
      FOR I := 1 TO 55 DO BEGIN
         FOR J := 1 TO 120 DO WRITE ( OTPT, CHART[I,J] );
         WRITELN ( OTPT );
         END;
      END;      
   END; (* HISTOGRAM *)



BEGIN
   FNAME := 'YEAR' + YEAR + '.OUT';
   OPEN(OTPT,FNAME);
   REWRITE(OTPT);
   WRITELN(OTPT); WRITELN(OTPT); WRITELN(OTPT);
   WRITELN(OTPT,
    '    *******************************************************************');
   WRITELN(OTPT,
    '    *                                                                 *');
   WRITELN(OTPT,
    '    *                YEARLY ACCOUNTING SUMMARY FOR ',YEAR,
    '                 *');
   WRITELN(OTPT,
    '    *                                                                 *');
   WRITELN(OTPT,
    '    *******************************************************************');
   WRITELN(OTPT);  WRITELN(OTPT);  WRITELN(OTPT);  WRITELN(OTPT);
   WRITELN(OTPT,'    Number of Processes Performed = ',PROCESS_YEAR);
   WRITELN(OTPT);
   WRITELN(OTPT,'    Number of Failed Logins       = ',BAD_LOGINS_YEAR);
   WRITELN(OTPT);
   WRITELN(OTPT,'    Number of Pages of Printout   = ',PAGES_YEAR);
   WRITELN(OTPT);
   HH       := CPU_YEAR DIV 3600;
   CPU_YEAR := CPU_YEAR - 3600*HH;
   MM       := CPU_YEAR DIV 60;
   CPU_YEAR := CPU_YEAR - 60*MM;
   SS       := CPU_YEAR;
   WRITELN(OTPT,'    Total CPU Time Used           = ',HH,':',MM:2,':',SS:2);
   WRITELN(OTPT);
   WRITELN(OTPT,FF);
   WRITELN(OTPT,
    '                            Monthly Breakdown ');
   WRITELN(OTPT,
    '                            ------- ---------'); 
   WRITELN(OTPT); WRITELN(OTPT);
   WRITELN(OTPT,
    ' Month         Number of Processes             CPU Time(sec)',
    '         Approx Percent');
   WRITELN(OTPT,
    ' -----         ------ -- ---------             --- ---- --- ',
    '         ------ -------'); 
   WRITELN(OTPT);
   FOR I := 1 TO 12 DO BEGIN
      PERCENT := CPU_TOTAL[I];
      PERCENT := PERCENT/6804.0;
      IPERCENT := TRUNC(PERCENT);
      WRITELN(OTPT,'  ',I:2,'                 ',NUM_PROCESS[I]:5,
       '                       ',CPU_TOTAL[I]:7,'           ',IPERCENT);
      END;
   WRITELN(OTPT,FF);
   WRITELN(OTPT,'     CPU Individual Breakdowns');
   WRITELN(OTPT,'     --- ---------- ----------');
   WRITELN(OTPT);   WRITELN(OTPT);
   WRITELN(OTPT,'  User ID               CPU Time');
   WRITELN(OTPT,'  ---- --               --- ----');
   WRITELN(OTPT);
   FOR I := 1 TO NUM_USERS DO
    WRITELN(OTPT,' ',USER_NAMES[I],'              ',CPU_U_YEAR[I]:6);
   WRITELN(OTPT,FF);
   WRITELN(OTPT,'      Login Failures by Terminal');
   WRITELN(OTPT,'      ----- -------- -- --------');
   WRITELN(OTPT);   WRITELN(OTPT);
   WRITELN(OTPT,'  Terminal ID           Failures');
   WRITELN(OTPT,'  -------- --           --------');
   WRITELN(OTPT);
   FOR I := 1 TO NUM_TERMS DO WRITELN(OTPT,'    ',TERM_NAMES[I],'         ',
    NUM_BAD_TERM[1,I]);
   HISTOGRAM ( 'Monthly CPU Usage','Month','CPU Usage In Seconds',CPU_TOTAL);
   END; (* PRINTOUT *)



BEGIN (* MAIN *)
   NNN := 0;
   INITIALIZE;
   FOR MONTH := 1 TO 12 DO GET_MONTH;
   SUMMARIZE;
   PRINTOUT;
   END.
