/*
 * Program:	Standard server login - VMS version
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 * Co-Author:   Yehavi Bourvine, The Hebrew University of Jerusalem
 *              Internet: Yehavi@VMS.HUJI.AC.IL
 *
 * Date:	7 July 1994
 *
 * Copyright 1994 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made available
 * "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
 
#include <uaidef.h>
#include <rmsdef.h>

/* Standard string descriptor */
struct DESC {
        short   length, type;   /* Length of string and descriptor type */
        char    *address;       /* Buffer's address */
        };

/* Item list for passing parameters to the mail routines */
struct ITEM_LIST {
        short   length,         /* Buffer length */
                code;           /* Item/action code */
        char    *buffer;        /* Input buffer address */
        int     *Olength;       /* Where to place length of result (if requeste */
        };


/* Server log in
 * Accepts: user name string
 *	    password string
 *	    optional place to return home directory
 * Returns: T if password validated, NIL otherwise
 */

long server_login (char *username,char *password,char **home,int argc,char *argv[])
{
    int sys$getuai(), sys$hash_password();
    int status, uai_flags;
    unsigned long uai_pwd[2], putative_pw[2];
    unsigned short uai_salt;
    unsigned char uai_encrypt;
    struct DESC usernameD, passwordD;
    char        *p,
        Username[256], Password[256];

        struct  ITEM_LIST itmlst[] = {
         {sizeof(uai_flags),           UAI$_FLAGS,     &uai_flags,     NULL},
         {sizeof(uai_encrypt),          UAI$_ENCRYPT,   &uai_encrypt,   NULL},
         {sizeof(uai_salt),            UAI$_SALT,      &uai_salt,      NULL},
         {8,                           UAI$_PWD,       uai_pwd,        NULL},
         {0, 0, NULL, NULL }
    };

/* If the password or the username are empty - return error (HUJI) */
    if((*username == '\0') || (*password == '\0'))
        return NIL;     /* No such user */

/* Do not ruin the username - copy it elsewhere */
        strcpy(Username, username);
        strcpy(Password, password);
    ucase(Username);
    ucase(Password);

    usernameD.address = Username;
    usernameD.length = strlen(username);
    usernameD.type = 0;
    status = sys$getuai(0, 0, &usernameD, itmlst, 0, 0, 0);
    if (status == RMS$_RNF || (UAI$M_DISACNT & uai_flags))
    {
        /* A record was not found for this username, or the guy's disuser'd */
        return NIL;
    }
    if((status & 0x1) == 0)
        return NIL;                 /* unexpected error of some kind */

    /* Now hash the putative password to see if it matches the one on file. */

    passwordD.address = Password;
    passwordD.length = strlen(password);
    passwordD.type = 0;
    status = sys$hash_password(&passwordD, uai_encrypt, uai_salt, &usernameD,
                               putative_pw);
    if((status & 0x1) == 0)
        return NIL;

    if ((putative_pw[0] != uai_pwd[0]) || putative_pw[1] != uai_pwd[1])
    {
        return(NIL);
    }

/* All ok. Now try getting the mail directory from the mail file. If not found,
   then try to get the VMS login directory. */
    vms_mail_get_user_directory(Username, home);
    return T;
}
