/*
 * Program:	Netnews mail routines - VMS stripped-down version.
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 * Co-author:   Yehavi Bourvine, The Hebrew University of Jerusalem.
 *              Internet: Yehavi@VMS.HUJI.AC.IL
 *
 * Date:	13 July 1994
 *
 * Copyright 1994 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made
 * available "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
extern int errno;		/* just in case */
#include "mail.h"
#include "osdep.h"
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/time.h>
#include "news.h"
#include "rfc822.h"
#include "misc.h"

/* Netnews mail subscribe to bboard
 * Accepts: mail stream
 *	    bboard to add to subscription list
 * Returns: T on success, NIL on failure
 */

long news_subscribe_bboard (MAILSTREAM *stream,char *mailbox)
{
  int fd,fdo;
  char *s,*txt;
  char tmp[MAILTMPLEN];
  struct stat sbuf;
  long ret = NIL;
				/* open .newsrc file */
  if ((fd = open (NEWSRC,O_RDWR|O_CREAT,
		  (int) mail_parameters (NIL,GET_SUBPROTECTION,NIL))) < 0) {
    mm_log ("Can't update news state",ERROR);
    return NIL;
  }
  fstat (fd,&sbuf);		/* get size of data */
  read (fd,1 + (txt = (char *) fs_get (sbuf.st_size + 2)),sbuf.st_size);
  txt[0] = '\n';		/* make searches easier */
  txt[sbuf.st_size + 1] = '\0';	/* tie off string */
				/* make backup file */
  strcat (strcpy (tmp,myhomedir ()),"/.oldnewsrc");
  if ((fdo = open (tmp,O_WRONLY|O_CREAT,
		   (int) mail_parameters (NIL,GET_SUBPROTECTION,NIL))) >= 0) {
    write (fdo,txt + 1,sbuf.st_size);
    close (fdo);
  }
  sprintf (tmp,"\n%s:",mailbox);/* see if already subscribed */
  if (strstr (txt,tmp)) {	/* well? */
    sprintf (tmp,"Already subscribed to newsgroup %s",mailbox);
    mm_log (tmp,WARN);
  }
  else {
    sprintf (tmp,"\n%s!",mailbox);
    if (s = strstr (txt,tmp)) {	/* if unsubscribed, just change one byte */
      lseek (fd,strchr (s,'!') - (txt + 1),L_SET);
      write (fd,":",1);		/* now subscribed */
    }
    else {			/* write new entry at end of file */
      lseek (fd,sbuf.st_size,L_SET);
      sprintf (tmp,"%s:\n",mailbox);
      write (fd,tmp,strlen (tmp));
    }
    fsync (fd);			/* drop changes */
    ret = T;
  }
  close (fd);			/* close off file */
  fs_give ((void **) &txt);	/* free database */
  return ret;
}

/* Netnews mail unsubscribe to bboard
 * Accepts: mail stream
 *	    bboard to delete from subscription list
 * Returns: T on success, NIL on failure
 */

long news_unsubscribe_bboard (MAILSTREAM *stream,char *mailbox)
{
  int fd,fdo;
  char *s,*txt;
  char tmp[MAILTMPLEN];
  struct stat sbuf;
  long ret = NIL;
				/* open .newsrc file */
  if ((fd = open (NEWSRC,O_RDWR|O_CREAT,
		  (int) mail_parameters (NIL,GET_SUBPROTECTION,NIL))) < 0) {
    mm_log ("Can't update news state",ERROR);
    return NIL;
  }
  fstat (fd,&sbuf);		/* get size of data */
  read (fd,1 + (txt = (char *) fs_get (sbuf.st_size + 2)),sbuf.st_size);
  txt[0] = '\n';		/* make searches easier */
  txt[sbuf.st_size + 1] = '\0';	/* tie off string */
				/* make backup file */
  strcat (strcpy (tmp,myhomedir ()),"/.oldnewsrc");
  if ((fdo = open (tmp,O_WRONLY|O_CREAT,
		   (int) mail_parameters (NIL,GET_SUBPROTECTION,NIL))) >= 0) {
    write (fdo,txt + 1,sbuf.st_size);
    close (fdo);
  }
  sprintf (tmp,"\n%s!",mailbox);/* see if already unsubscribed */
  if (!strstr (txt,tmp)) {	/* well? */
    sprintf (tmp,"\n%s:",mailbox);
    if (s = strstr (txt,tmp)) {	/* already there as subscribed? */
      lseek (fd,strchr (s,':') - (txt + 1),L_SET);
      write (fd,"!",1);		/* now unsubscribed */
    }
    else {			/* otherwise write new entry */
      lseek (fd,sbuf.st_size,L_SET);
      sprintf (tmp,"%s!\n",mailbox);
      write (fd,tmp,strlen (tmp));
    }
    fsync (fd);			/* drop changes */
    ret = T;
  }
  close (fd);			/* close off file */
  fs_give ((void **) &txt);	/* free database */
  return ret;
}

/* Read netnews database
 * Accepts: pointer to netnews database handle (handle NIL if first time)
 * Returns: character string for netnews database or NIL if done
 * Note - uses strtok() mechanism
 */

char *news_read (void **sdb)
{
  int fd;
  char *s,*t,tmp[MAILTMPLEN];
  struct stat sbuf;
  if (!*sdb) {			/* first time through? */
    if ((fd = open (NEWSRC,O_RDONLY,NIL)) < 0) return NIL;
    fstat (fd,&sbuf);		/* get file size and read data */
    read (fd,s = (char *) (*sdb = fs_get (sbuf.st_size + 1)),sbuf.st_size);
    close (fd);			/* close file */
    s[sbuf.st_size] = '\0';	/* tie off string */
    if (t = strtok (s,"\n")) return t;
  }
				/* subsequent times through database */
  else if (t = strtok (NIL,"\n")) return t;
  fs_give (sdb);		/* free database */
  return NIL;			/* all done */
}
