#if !defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: mailcmd.c,v 4.187 1994/06/16 23:03:55 mikes Exp $";
#endif
/*----------------------------------------------------------------------

            T H E    P I N E    M A I L   S Y S T E M

   Laurence Lundblade and Mike Seibel
   Networks and Distributed Computing
   Computing and Communications
   University of Washington
   Administration Builiding, AG-44
   Seattle, Washington, 98195, USA
   Internet: lgl@CAC.Washington.EDU
             mikes@CAC.Washington.EDU

   Please address all bugs and comments to "pine-bugs@cac.washington.edu"

   Copyright 1989-1994  University of Washington

    Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee to the University of
   Washington is hereby granted, provided that the above copyright notice
   appears in all copies and that both the above copyright notice and this
   permission notice appear in supporting documentation, and that the name
   of the University of Washington not be used in advertising or publicity
   pertaining to distribution of the software without specific, written
   prior permission.  This software is made available "as is", and
   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  
   Pine and Pico are trademarks of the University of Washington.
   No commercial use of these trademarks may be made without prior
   written permission of the University of Washington.

   Pine is in part based on The Elm Mail System:
    ***********************************************************************
    *  The Elm Mail System  -  Revision: 2.13                             *
    *                                                                     *
    * 			Copyright (c) 1986, 1987 Dave Taylor              *
    * 			Copyright (c) 1988, 1989 USENET Community Trust   *
    ***********************************************************************
 

  ----------------------------------------------------------------------*/

/*======================================================================
     mailcmd.c
     The meat and pototoes of mail processing here:
       - initial command processing and dispatch
       - save message
       - capture address off incoming mail
       - jump to specific numbered message
       - open (broach) a new folder
       - search message headers (where is) command
  ====*/

#include "headers.h"


#ifdef ANSI
void      cmd_delete(struct pine *, MSGNO_S *, int);
void      cmd_undelete(struct pine *, MSGNO_S *, int);
void      cmd_reply(struct pine *, MSGNO_S *, int);
void      cmd_forward(struct pine *, MSGNO_S *, int);
void      cmd_bounce(struct pine *, MSGNO_S *, int);
void      cmd_print(struct pine *, MSGNO_S *, int);
void      cmd_take_addr(struct pine *, MSGNO_S *, int);
void      cmd_save(struct pine *, MSGNO_S *, int, int);
void      cmd_export(struct pine *, MSGNO_S *, int, int);
void      cmd_pipe(struct pine *, MSGNO_S *, int);
void      cmd_flag(struct pine *, MSGNO_S *, int);
int	  save(char *, CONTEXT_S *, MESSAGECACHE *);
void      pipe_attachment(long, ATTACH_S *);
void	  select_sort(struct pine *, int);
void	  aggregate_select(struct pine *, MSGNO_S *, int);
int	  select_number(MAILSTREAM *, MSGNO_S *, long);
int	  select_date(MAILSTREAM *, MSGNO_S *, long);
int	  select_text(MAILSTREAM *, MSGNO_S *, long);
int	  select_flagged(MAILSTREAM *, MSGNO_S *, long);
void	  apply_command(struct pine *, MSGNO_S *, int);
ATTACH_S *attachments(int);
char	 *mcdate2ctime(MESSAGECACHE *);
void	  run_viewer(char *, BODY *);
int	  display_attachment(long, ATTACH_S *);
void	  save_attachment(int, long, ATTACH_S *);
void	  display_text_att(long, ATTACH_S *);
void	  jump_to(MSGNO_S *, int, int);
void	  search_headers(MAILSTREAM *, int, MSGNO_S *);
char	 *build_sequence(MSGNO_S *, long *);
int	  pseudo_selected(char *, MSGNO_S *, long *);
ADDRESS  *paste_together(ADDRESS *, ADDRESS *);
ADDRESS  *cpyadrlst(ADDRESS *);
void      eliminate_dups(ADDRESS *);
int       dup_addrs(ADDRESS *, ADDRESS *);

#else
void      cmd_delete();
void      cmd_undelete();
void      cmd_reply();
void      cmd_forward();
void      cmd_bounce();
void      cmd_print();
void      cmd_take_addr();
void      cmd_save();
void      cmd_export();
void      cmd_pipe();
void      cmd_flag();
int       save();
void      pipe_attachment();
void	  aggregate_select();
int	  select_number();
int	  select_date();
int	  select_text();
int	  select_flagged();
void	  apply_command();
void      select_sort();
ATTACH_S *attachments();
void      save_attachment();
int       display_attachment();
void      run_viewer();
char     *mcdate2ctime();
void	  display_text_att();
void	  jump_to();
void	  search_headers();
char	 *build_sequence();
int	  pseudo_selected();
ADDRESS  *paste_together();
ADDRESS  *cpyadrlst();
void      eliminate_dups();
int       dup_addrs();
#endif


/*
 * List of Select options used by apply_* functions...
 */
static char *sel_pmt1 = "ALTER message selection : ";
static char *sel_pmt1x = "APPLY command or ALTER message selection : ";
static ESCKEY_S sel_opts1[] = {
    {'b', 'b', "B", "Broaden selctn"},
    {'n', 'n', "N", "Narrow selctn"},
    {'c', 'c', "C", NULL},
    {'a', 'a', "A", "unselect All"},
    {-1,  'd', "D", "Do command"},
    {-1, 0, NULL, NULL}
};


static char *sel_pmt2 = "SELECT criteria : ";
static ESCKEY_S sel_opts2[] = {
    {'n', 'n', "N", "Number"},
    {'d', 'd', "D", "Date"},
    {'t', 't', "T", "Text"},
    {'s', 's', "S", "Status"},
    {'c', 'c', "C", "select Current"},
    {'a', 'a', "A", "select All"},
    {-1, 0, NULL, NULL}
};


static char *sel_pmt3 = "APPLY command : ";
static ESCKEY_S sel_opts3[] = {
    {'d', 'd',  "D", "Del"},
    {'u', 'u',  "U", "Undel"},
    {'r', 'r',  "R", "Reply"},
    {'f', 'f',  "F", "Forward"},
    {'y', 'y',  "Y", "prYnt"},
    {'t', 't',  "T", "TakeAddr"},
    {'s', 's',  "S", "Save"},
    {'e', 'e',  "E", "Export"},
    { -1,   0, NULL, NULL},
    { -1,   0, NULL, NULL},
#ifdef	LATER
    {'b', 'b', "B", "Bounce"},
#endif
    {-1, 0, NULL, NULL}
};


static char *sel_flag = 
    "Select New, Deleted, Answered, or Important messages ? ";
static char *sel_flag_not = 
    "Select NOT New, NOT Deleted, NOT Answered or NOT Tagged msgs ? ";
static ESCKEY_S sel_flag_opt[] = {
    {'n', 'n', "N", "New"},
    {'d', 'd', "D", "Deleted"},
    {'a', 'a', "A", "Answered"},
    {'i', 'i', "I", "Important"},
    {'!', '!', "!", "Not"},
    {-1, 0, NULL, NULL}
};

static char *sel_date = "Select On, Before or Since the date to be entered ? ";
static ESCKEY_S sel_date_opt[] = {
    {'o', 'o', "O", "On"},
    {'b', 'b', "B", "Before"},
    {'s', 's', "S", "Since"},
    {-1, 0, NULL, NULL}
};

static char *sel_text =
    "Select based on To, From, Cc, or Subject fields or All message text ? ";
static ESCKEY_S sel_text_opt[] = {
    {'t', 't', "T", "To"},
    {'f', 'f', "F", "From"},
    {'c', 'c', "C", "Cc"},
    {'s', 's', "S", "Subject"},
    {'a', 'a', "A", "All Text"},
    {-1, 0, NULL, NULL}
};

static char *select_num =
  "Enter comma-delimited list of numbers (dash between ranges): ";

static char *flag_text = "Flag New, Deleted, Answered, or Important ? ";
static char *flag_text2	=
    "Flag NOT New, NOT Deleted, NOT Answered, or NOT Important ? ";
static ESCKEY_S flag_text_opt[] = {
    {'n', 'n', "N", "New"},
    {'d', 'd', "D", "Deleted"},
    {'a', 'a', "A", "Answered"},
    {'i', 'i', "I", "Important"},
    {'!', '!', "!", "Not"},
    {-1, 0, NULL, NULL}
};


 
/*----------------------------------------------------------------------
         The giant switch on the commands for index and viewing

  Input:  command  -- The command char/code
          in_index -- flag indicating command is from index
          orig_command -- The original command typed before pre-processing
  Output: force_mailchk -- Set to tell caller to force call to new_mail().

  Result: Manifold

          Returns 1 if the message number or attachment to show changed 
 ---*/
int
process_cmd(state, msgmap, command, in_index, orig_command, force_mailchk)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  command, in_index, orig_command;
     int	 *force_mailchk;
{
    int           question_line, a_changed, is_unread;
    long          new_msgno, del_count, old_msgno, cur_msgno, i;
    char         *new_folder, prompt[80+MAXFOLDER];
    MESSAGECACHE *mc;
    CONTEXT_S    *tc;
    ATTACH_S	 *a;
#ifdef	DOS
    extern long coreleft();
#endif

    dprint(4, (debugfile, "\n - process_cmd((%d)%c) -\n",
                                                 command, (char)command));

    question_line         = -3;
    state->status_changed = 0;
    state->mangled_screen = 0;
    state->mangled_footer = 0;
    state->mangled_header = 0;
    state->next_screen    = SCREEN_FUN_NULL;
    cur_msgno		  = mn_get_cur(msgmap);
    old_msgno             = cur_msgno;
    mc                    = NULL;
    a_changed             = 0;
    *force_mailchk        = 0;

    switch (command)
      {
          /*------------- Help --------*/
        case PF1:
        case OPF1:
        case OOPF1:
        case '?':
        case ctrl('G'):
          if(state->nr_mode) {
              q_status_message(1, 3, 5, "No help text currently available");
              break;
          }
	  /*
	   * We're not using the h_mail_view portion of this right now because
	   * that call is being handled in scrolltool() before it gets
	   * here.  Leave it in case we change how it works.
	   */
          helper(in_index?h_mail_index : h_mail_view,
		 in_index?"HELP FOR FOLDER INDEX VIEW":"HELP FOR MESSAGE VIEW",
		 0);
          dprint(2, (debugfile,"MAIL_CMD: did help command\n"));
          state->mangled_screen = 1;
          break;


          /*--------- Return to main menu ------------*/
        case PF3: 
        case 'm':
          if(state->nr_mode && command == 'm')
            goto bogus;
          if(state->nr_mode && command == PF3)
	    goto do_quit;
          state->next_screen = main_menu_screen;
#ifdef	DOS
	  flush_index_cache();		/* save room on PC */
#endif
          dprint(2, (debugfile,"MAIL_CMD: going back to main menu"));
          break;


          /*------- View mail or attachment --------*/
        case ctrl('M'):
        case ctrl('J'):
	  if(!in_index) {
	    q_status_message(0, 0, 2,
		    "\007No default command in View Message Screen");
	    break;
	  }
	  /* fall through */
        case PF4:
        case 'v':
	  if(in_index) {
	    if(mn_get_total(msgmap) < 1L) {
		q_status_message(0, 1, 3, "\007No message to view");
            }
	    else if(mn_total_cur(msgmap) > 1L){
		q_status_message1(0, 1, 3,
			"\007Can only view one message at a time!%s",
			(F_ON(F_ENABLE_ZOOM,ps_global))? " Try Zoom Cmd.":"");
	    }
            else {
		state->next_screen = mail_view_screen;
#ifdef	DOS
		flush_index_cache();		/* save room on PC */
#endif
            }
	  }else {

            /*------- View Attachment -----------*/
            a = attachments(question_line);
            state->mangled_footer = 1;
            if(a != NULL) {
              ESCKEY_S labels[4];
	      int      ret;

	      labels[0].ch      = 's';
	      labels[0].rval    = 's';
	      labels[0].name    = "S";
	      labels[0].label   = "Save";

	      labels[1].ch      = 'v';
	      labels[1].rval    = 'v';
	      labels[1].name    = "V";
	      labels[1].label   = "View";

	      labels[2].ch      = '|';
	      labels[2].rval    = '|';
	      labels[2].name    = "|";
	      labels[2].label   = "Pipe";

              labels[3].ch      = -1;
	      sprintf(prompt,"Save, View or Pipe attachment %s ? (s/v/|) [s] ",
		      a->number);
              ret = radio_buttons(prompt, question_line, 0, labels, 's',
				  'x', 0, NO_HELP);

	      switch(ret) {
		case 's':
                  save_attachment(question_line,mn_m2raw(msgmap,cur_msgno),a);
		  break;
		case 'v':
                  a_changed = display_attachment(mn_m2raw(msgmap,cur_msgno),a);
		  break;
 		case '|':
 		  pipe_attachment(mn_m2raw(msgmap, cur_msgno), a);
 		  break;
		/* ^C */
		case 'x':
		  q_status_message(0, 0, 2, "\007Attachment cancelled");
		  break;
	      }
            }
	  }
          break;


          /*---------- Previous message ----------*/
        case PF5: 
        case KEY_UP:
        case 'p':
        case ctrl('P'):		    
	  if(mn_get_total(msgmap) < 1L){
	      q_status_message(0, 1, 3, "\007No message in folder");
	  }
	  else if(mn_total_cur(msgmap) > 1L){
	      q_status_message1(0,0,2,
				"\007%s msgs selected.  Try paging commands!",
				long2string(mn_total_cur(msgmap)));
	  }
	  else if(cur_msgno > 1L){
	      mn_dec_cur(state->mail_stream, msgmap);
	      if(cur_msgno == mn_get_cur(msgmap))
		q_status_message(0, 0, 1,
			       "\007Already on first message in Zoomed Index");
	      else
		cur_msgno = mn_get_cur(msgmap);
	  }
	  else
	    q_status_message(0, 0, 1, "Already on first message");

          break;


          /*---------- Next Message ----------*/
        case PF6:
        case KEY_DOWN:
        case 'n':
        case ctrl('N'):
	  if(mn_total_cur(msgmap) > 1L){
	      q_status_message1(0,0,2,
				"\007%s msgs selected. Try paging commands!",
				long2string(mn_total_cur(msgmap)));
	  }
	  else if(mn_get_total(msgmap) > 0L
		  && cur_msgno < mn_get_total(msgmap)){
	      mn_inc_cur(state->mail_stream, msgmap);
	      if(cur_msgno == mn_get_cur(msgmap))
		q_status_message(0,0,1,"\007No more messages in Zoomed Index");
	      else
		cur_msgno = mn_get_cur(msgmap);
          }
	  else{
	      sprintf(prompt, "\007No m%s",
		      (mn_get_total(msgmap) > 0)
		        ? "ore messages" : "essages in folder");

	      if(!state->nr_mode
		 && (IS_NEWS(state->mail_stream)
		     || (state->context_current->use & CNTXT_INCMNG))){
		  char nextfolder[MAXPATH];

		  strcpy(nextfolder, state->cur_folder);
		  if(next_folder(nextfolder, nextfolder,
				 state->context_current, FALSE))
		    strcat(prompt, ".  Press TAB for next folder.");
		  else
		    strcat(prompt, ".  No more folders to TAB to.");
	      }

	      q_status_message(0, 0, 1, prompt);

	      if(!IS_NEWS(state->mail_stream))
		*force_mailchk = 1;
	  }
          break;


          /*---------- Delete message ----------*/
        case PF9: 
        case 'd':
        case KEY_DEL:
          if(state->nr_mode) {
	    if(command == PF9)
	      goto do_forward;
	    else
              goto bogus;
	  }

	  cmd_delete(state, msgmap, 0);
	  cur_msgno = mn_get_cur(msgmap);
	  break;
          

          /*---------- Undelete message ----------*/
        case PF10:
        case 'u':
          if(state->nr_mode) {
	    if(command == PF10)
	      goto do_jump;
	    else
              goto bogus;
	  }

	  cmd_undelete(state, msgmap, 0);
          break;


          /*---------- Reply to message ----------*/
        case PF11: 
        case 'r':
          if(state->anonymous && command == PF11) {
	    if(in_index)
	      goto do_sortindex;
	    else
	      goto do_index;
	  }

          if(state->nr_mode && command == PF11)
	    goto do_print;
          if(state->nr_mode)
            goto bogus;

	  cmd_reply(state, msgmap, 0);
	  cur_msgno = mn_get_cur(msgmap);
          break;


          /*---------- Forward message ----------*/
        case PF12: 
        case 'f':
do_forward:
          if(command == PF12) {
	    if(state->anonymous)
              goto bogus;
	    if(state->nr_mode)
	      goto do_save;
	  }

	  cmd_forward(state, msgmap, 0);
	  cur_msgno = mn_get_cur(msgmap);
          break;


          /*---------- Quit pine ------------*/
        case 'q':
        case OPF3:
          if(state->nr_mode && command == OPF3)
            goto do_export;
do_quit:
	  state->next_screen = quit_screen;
	  dprint(1, (debugfile,"MAIL_CMD: quit\n"));		    
          break;


          /*---------- Compose message ----------*/
        case OPF4:		    
        case 'c':
          if(state->anonymous)
            goto bogus;
          state->prev_screen = in_index ? mail_index_screen :
                                        mail_view_screen;
#ifdef	DOS
	  flush_index_cache();		/* save room on PC */
#endif
          compose_screen(state);
          state->mangled_screen = 1;
          break;


          /*--------- Folders menu ------------*/
	case OPF5: 
        case 'l':
          if(state->anonymous)
	    goto bogus;
          if(state->nr_mode) {
	    if(command == OPF5)
	      goto do_sortindex;
	    goto bogus;
	  }
          state->next_screen = folder_screen;
#ifdef	DOS
	  flush_index_cache();		/* save room on PC */
#endif
          dprint(2, (debugfile,"MAIL_CMD: going to folder/collection menu"));
          break;


          /*---------- Open specific new folder ----------*/
        case OPF6:
        case 'g':
          if(state->nr_mode)
            goto bogus;

	  tc = (state->context_last
		      && !(state->context_current->type & FTYPE_BBOARD)) 
                       ? state->context_last : state->context_current;

          new_folder = broach_folder(question_line, 1, &tc);
#ifdef	DOS
	  if(new_folder && *new_folder == '{' && coreleft() < 20000){
	      q_status_message(0, 0, 2,
			       "\007Not enough memory to open IMAP folder");
	      new_folder = NULL;
	  }
#endif
          if(new_folder != NULL) {
              dprint(9, (debugfile, "do_broach_folder (%s, %s)\n",
                         new_folder, tc->context));
              if(do_broach_folder(new_folder, tc) > 0)
                  /* so we go out and come back into the index */
                  state->next_screen = mail_index_screen;
          }
          break;
    	  
    	    
          /*------- Go to index (or zoom) ----------*/
        case OPF7:
        case 'i':
do_index:
          if(!in_index) {
#ifdef	DOS
	      flush_index_cache();		/* save room on PC */
#endif
              state->next_screen = mail_index_screen;
          }else {
	      if(command == OPF7)
		goto do_zoom;
	      else
		q_status_message(0, 0, 3, "\007Already in Index");
          }
          break;


          /*------- Zoom -----------*/
do_zoom:
        case 'z':
	  if(F_OFF(F_ENABLE_ZOOM,state) || !in_index)
	    goto bogus;

	  /*
	   * Right now the way zoom is implemented is sort of silly.
	   * There are two per-message flags where just one and a 
	   * global "zoom mode" flag to suppress messags from the index
	   * should suffice.
	   */
	  if(mn_get_total(msgmap) < 1L){
	      q_status_message(0,2,3,"\007No messages to zoom on");
	  }
	  else if(any_flagged(state->mail_stream, msgmap,MN_HIDE)){
	      dprint(4, (debugfile, "\n\n ---- Exiting ZOOM mode ----\n"));
	      q_status_message(0, 0, 2, "Index Zoom Mode is now off");
	      for(i = 1L; i <= mn_get_total(msgmap); i++){
		  if(get_flag(state->mail_stream, msgmap, i, MN_HIDE))
		    set_flag(state->mail_stream, msgmap, i, MN_HIDE, 0);
	      }
	  }
	  else{					/* ENTER zoomed index mode */
	      dprint(4, (debugfile, "\n\n ---- Entering ZOOM mode ----\n"));
	      del_count = 0L;
	      if(any_flagged(state->mail_stream, msgmap, MN_TEMP)){
		  long first = 0L;
		  for(i = 1L; i <= mn_get_total(msgmap); i++){
		      if(!get_flag(state->mail_stream, msgmap, i, MN_TEMP)){
			  set_flag(state->mail_stream, msgmap, i, MN_HIDE, 1);
		      }
		      else{
			  del_count++;
			  if(!first)
			    first = i;
		      }
		  }

		  if(!get_flag(state->mail_stream, msgmap, cur_msgno, MN_TEMP))
		    mn_set_cur(msgmap, first);
	      }
	      else
		q_status_message(0,1,3,
				 "\007No selected messages to zoom on");

	      if(del_count)
		q_status_message2(0, 1, 2,
				  "Entering Zoomed Index of %s message%s",
				  comatose(del_count), plural(del_count));
	  }

          break;


          /*---------- Jump To ----------*/
       case '0':
       case '1':
       case '2':
       case '3':
       case '4':
       case '5':
       case '6':
       case '7':
       case '8':
       case '9':
          if(F_OFF(F_ENABLE_JUMP,state))
	      goto bogus;
       case OOPF7:
       case 'j':
do_jump:
	  jump_to(msgmap, question_line,
		  (command >= '0' && command <= '9') ? command : '\0');
	  cur_msgno		= mn_get_cur(msgmap);
	  state->mangled_footer = 1;
	  break;


          /*---------- Search (where is command) ----------*/
       case OPF8:
       case ctrl('W'):
       case 'w':		/* Note, whereis only effective in Index */
	  search_headers(state->mail_stream, question_line, msgmap);
	  cur_msgno		= mn_get_cur(msgmap);
	  state->mangled_footer = 1;
          break;


          /*---------- print message on paper ----------*/
        case OPF9:
        case 'y':
do_print:
          if(state->anonymous || (state->nr_mode && command == OPF9))
            goto bogus;

          if(mn_get_total(msgmap) < 1L){
              q_status_message(0, 1, 3, "\007No message in folder");
	      break;
	  }

	  cmd_print(state, msgmap, 0);
          break;


          /*---------- Take Address ----------*/
        case OPF10:
        case 't':
          if(state->nr_mode)
            goto bogus;

	  cmd_take_addr(state, msgmap, 0);
          break;


          /*---------- Save Message ----------*/
        case OPF11: 
        case 's':
          if(state->anonymous || (state->nr_mode && command == OPF11))
            goto bogus;
do_save:
          if(mn_get_total(msgmap) == 0) {
              q_status_message(0, 0, 2, "\007No message in folder to save");
              break;
          }

          cmd_save(state, msgmap, question_line, 0);
	  cur_msgno = mn_get_cur(msgmap);
          break;


          /*---------- Export message ----------*/
        case OPF12:
        case 'e':
          if(state->anonymous || (state->nr_mode && command == OPF12))
            goto bogus;
do_export:
          if(mn_get_total(msgmap) == 0) {
              q_status_message(0, 0, 2, "\007No message in folder");
              break;
          }

          cmd_export(state, msgmap, question_line, 0);
	  cur_msgno = mn_get_cur(msgmap);
          state->mangled_footer = 1;

          break;


          /*---------- Expunge ----------*/
        case OOPF3:
        case 'x':
          if(state->nr_mode || !in_index)
            goto bogus;

          dprint(2, (debugfile, "\n - expunge -\n"));
	  if(IS_NEWS(state->mail_stream)){
              q_status_message(1, 2, 4,
	                      "eXclude of deleted news not implemented yet.");
              break;
	  } else if(READONLY_FOLDER){
              q_status_message(1, 2, 4, "Can't expunge. Folder is read-only");
              break;
          }

	  if((del_count = count_flagged(state->mail_stream, "DELETED")) == 0){
	     q_status_message(1, 2, 4, 
		"Nothing to Expunge!  No messages marked \"Deleted\".");
	     *force_mailchk = 1;
	     break;
	  }

	  if(F_OFF(F_AUTO_EXPUNGE,state)) {
	      int ret;

	      sprintf(prompt, "Expunge %ld message%s from %s", del_count,
		      plural(del_count), pretty_fn(state->cur_folder));
	      state->mangled_footer = 1;
	      if((ret = want_to(prompt, 'y', 'x', NO_HELP, 0, 0)) == 'n'){
		  break;
	      }else if(ret == 'x') {		/* ^C */
		  Writechar('\007', 0);
		  break;
	      }
	  }

	  /*
	   * clean up pine's local flags so the flagged count's stay
	   * consistent...
	   */
	  if(!any_flagged(state->mail_stream, msgmap, MN_NONE)){
	      for(i = 1L; i <= mn_get_total(msgmap); i++){
		  (void) mail_fetchstructure(state->mail_stream,
					     mn_m2raw(state->msgmap, i),
					     NULL);
		  mc = mail_elt(state->mail_stream, mn_m2raw(msgmap, i));

		  if(mc && mc->deleted)
		    set_flag(state->mail_stream, msgmap, i,
			     (MN_HIDE|MN_EXLD|MN_TEMP), 0);
	      }
	  }

          dprint(8,(debugfile, "Expunge max:%ld cur:%ld kill:%d\n",
                    mn_get_total(msgmap), cur_msgno, del_count));
          StartInverse();
          PutLine0(0, 0, "**");			/* indicate delay */
	  MoveCursor(state->ttyo->screen_rows -3, 0);
          fflush(stdout);

          mail_expunge(state->mail_stream);
          dprint(2,(debugfile,"expunge complete cur:%ld max:%ld\n",
		    mn_get_cur(msgmap),
		    mn_get_total(msgmap)));

          /*
	   * mm_exists and mm_expunge take care of updating max_msgno
	   * and selecting a new message should the selected get removed
	   */
          reset_check_point();
          sort_current_folder();
          cur_msgno = mn_get_cur(msgmap);
          PutLine0(0, 0, "  ");			/* indicate delay's over */
          EndInverse();
          fflush(stdout);
          if(state->expunge_count > 0) {
              q_status_message3(0, 0, 3,
                        "Expunged %s message%s from folder \"%s\"",
                         long2string(state->expunge_count),
                         plural(state->expunge_count),
			 pretty_fn(state->cur_folder));
              state->expunge_count = 0;
          }else if(F_ON(F_AUTO_EXPUNGE,state)) {
              q_status_message1(0, 0, 3,
                        "No messages to expunge from folder \"%s\"",
			 pretty_fn(state->cur_folder));
	  }
          break;


          /*------- Unexclude -----------*/
	case OOPF4:
        case '&':
	  if(!in_index)
	    goto bogus;
	  else
            q_status_message(1, 2, 3,
			   IS_NEWS(state->mail_stream)
			     ? "\007Unexclude command not implemented yet"
			     : "\007Unexclude not available for mail folders");
          break;


          /*------- Make Selection -----------*/
/*BUG:	case OOPF5: doesn't work */
        case ';':
	  if(!in_index || F_OFF(F_ENABLE_AGG_OPS, state)
	     || ps_global->ops_under_apply)
	    goto bogus;

	  if(mn_get_total(msgmap) > 0L){
	      aggregate_select(state, msgmap, question_line);
	      cur_msgno = mn_get_cur(msgmap);
	  }
	  else
	    q_status_message(0, 0, 2, "\007No message in folder");

          break;


          /*------- Apply command -----------*/
	case OOPF5:
        case 'a':
	  if(!in_index || F_OFF(F_ENABLE_AGG_OPS, state))
	    goto bogus;

	  if(mn_get_total(msgmap) > 0L){
	      if(ps_global->ops_under_apply)
		aggregate_select(state, msgmap, question_line);
	      else if(any_flagged(state->mail_stream, msgmap, MN_TEMP) < 1L)
		q_status_message(0, 1, 2,
		       "\007No messages to Apply command to.  Try \"Select\"");
	      else
		apply_command(state, msgmap, question_line);

	      cur_msgno = mn_get_cur(msgmap);
	  }
	  else
	    q_status_message(0, 0, 2, "\007No message in folder");

          break;


          /*-------- Sort command -------*/
	case OOPF6:
        case '$':
do_sortindex:
	  if(!in_index)
	      goto bogus;
	  dprint(1, (debugfile,"MAIL_CMD: sort\n"));		    
	  select_sort(state, question_line);
	  state->mangled_body = 1;
	  state->mangled_footer = 1;
	  clear_index_cache();
	  sort_current_folder();
          break;


          /*------- Skip to next interesting message -----------*/
        case OOPF8:
        case TAB :
          if(mn_get_total(msgmap) > 0) {
              new_msgno = next_sorted_flagged((F_UNDEL 
					       | ((IS_NEWS(state->mail_stream))
						    ? 0 : F_UNSEEN)
					       | F_OR_FLAG),
					      state->mail_stream,
					      cur_msgno + 1L, &is_unread);
              if(is_unread){
                  if(new_msgno > 0){
		      mn_set_cur(msgmap, new_msgno);
                      cur_msgno = new_msgno;
                  }
	      }
	  }

	  /*
	   * If there weren't any unread messages left, OR there
	   * aren't any messages at all, we may want to offer  to
	   * go on to the next folder...
	   */
	  if(!is_unread || mn_get_total(msgmap) <= 0){
	      char ret = 'n';

	      if(!state->nr_mode
		 && (state->context_current
		    && (state->context_current->use&(CNTXT_INCMNG|CNTXT_NEWS)))
		 && context_isambig(state->cur_folder)){
		  char nextfolder[MAXPATH];
		  int  another = 0, lastf;

		  strcpy(nextfolder, state->cur_folder);
		  while(1){
		      if(lastf = !(next_folder(nextfolder, nextfolder,
					       state->context_current, TRUE))){
			  if(strucmp(state->cur_folder, state->inbox_name)){
			      sprintf(prompt, "No more %ss.  Return to \"%s\"",
				     (state->context_current->use&CNTXT_INCMNG)
				       ? "incoming folder" : "news group", 
				      state->inbox_name);
			      ret = want_to(prompt, 'y', 'x', NO_HELP, 0, 0);
			      if(ret == 'y'){
				  if(do_broach_folder(state->inbox_name,
						   state->context_current) > 0)
				    state->next_screen = mail_index_screen;
			      }
			  }
			  else
			    q_status_message1(0, 0, 1, "No more %ss",
				     (state->context_current->use&CNTXT_INCMNG)
				        ? "incoming folder" : "news group");


			  break;
		      }

		      sprintf(prompt, "%sView next %s \"%s\"? ",
			      (another++) ? "" : "No more messages.  ",
			      (state->context_current->use&CNTXT_INCMNG)
				 ? "Incoming folder" : "news group",
			      nextfolder);

		      /*
		       * When help gets added, this'll have to become
		       * a loop like the rest...
		       */
		      if(F_OFF(F_AUTO_OPEN_NEXT_UNREAD, state)){
			  static ESCKEY_S next_opt[] = {
			      {'y', 'y', "Y", "Yes"},
			      {'n', 'n', "N", "No"},
			      {TAB, 'n', "Tab", "NextNew"},
			      {-1, 0, NULL, NULL}
			  };

			  ret = radio_buttons(prompt, -3, 0, next_opt, 'y',
					      'x', 0, NO_HELP);
			  if(ret == 'x'){
			      q_status_message(0,0,1,"\007Command cancelled");
			      break;
			  }
		      }

		      if(ret == 'y' || F_ON(F_AUTO_OPEN_NEXT_UNREAD, state)){
			  if(do_broach_folder(nextfolder,
					      state->context_current) > 0)
			    state->next_screen = mail_index_screen;

			  break;
		      }
		  }
	      }
	      else{
		  if(mn_get_total(msgmap) > 0)
		    q_status_message1(0, 0, 1, "No more %s messages",
			    IS_NEWS(state->mail_stream) ? "undeleted" : "new");
		  else
		    q_status_message(0, 1, 3, "\007No message in folder");
	      }
	  }

          break;


          /*------- Toggle Full Headers -----------*/
	case OOPF9: 
        case 'h':
          if(F_OFF(F_ENABLE_FULL_HDR,state))
            goto bogus;
          state->full_header = !state->full_header;
          q_status_message1(0, 0, 2, "Display of full headers is now o%s",
                           state->full_header ? "n" : "ff");
          a_changed = 1;
          break;


          /*------- Bounce -----------*/
	case OOPF10:
        case 'b':
          if(F_OFF(F_ENABLE_BOUNCE,state))
            goto bogus;

          if(command == PF12) {
	    if(state->anonymous)
              goto bogus;
	    if(state->nr_mode)
	      goto do_save;
	  }

	  cmd_bounce(state, msgmap, 0);
	  cur_msgno = mn_get_cur(msgmap);
          break;


          /*------- Flag -----------*/
	case OOPF11:
        case '*':
	  if(F_OFF(F_ENABLE_FLAG,state))
	    goto bogus;

          dprint(4, (debugfile, "\n - flag message -\n"));
          if(mn_get_total(msgmap) <= 0L) {
              q_status_message(0, 1, 3,"\007No message in folder");
              break;
          }

          if(READONLY_FOLDER){
              q_status_message(1, 1, 3,
                               "Can't flag message. Folder is read-only");
              break;
          }

          if(state->io_error_on_stream) {
              state->io_error_on_stream = 0;
              mail_check(state->mail_stream); /* forces write */
          }

	  cmd_flag(state, msgmap, 0);
	  cur_msgno = mn_get_cur(msgmap);

          break;


#ifndef DOS
          /*------- Pipe message -----------*/
	case OOPF12:
        case '|':
	  if(F_ON(F_ENABLE_PIPE,state)){
	      cmd_pipe(state, msgmap, 0);
	      break;
	  }
#endif


          /*--------- Default, unknown command ----------*/
        default:
        bogus:
	  bogus_command(orig_command, F_ON(F_USE_FK,state) ? "F1" : "?");
          break;
      }

    /*
     * Here we try to avoid unsightly message queue buildup.
     * The problem is several messages may have queued up as the result
     * of an error or something, so we want to write all but the last 
     * one here.  The last will get written in the loop that called
     * us.  What we really want to avoid is having some error message
     * bubble up after the next command that the user executes.
     */
    while(messages_queued(NULL) > 1)
      sleep(display_message('x'));

    return(cur_msgno != old_msgno || a_changed);
}



/*----------------------------------------------------------------------
   Complain about bogus input

  Args: ch -- input command to complain about
	help -- string indicating where to get help

 ----*/
void
bogus_command(cmd, help)
    int   cmd;
    char *help;
{
    q_status_message4(0, 0, 2,
	     "\007Command \"%s\" not defined for this screen.%s%s%s",
             pretty_command(cmd),
	     (help) ? " Use " : "",
	     (help) ?  help   : "",
	     (help) ? " for help" : "");
}



/*----------------------------------------------------------------------
   Execute DELETE message command

  Args: state --  Various satate info
        msgmap --  map of c-client to local message numbers

 Result: with side effect of "current" message delete flag set

 ----*/
void
cmd_delete(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    int           is_unread;
    long	  cur_msgno, new_msgno, del_count = 0;
    char	 *sequence = NULL, prompt[128];
    MESSAGECACHE *mc;

    dprint(4, (debugfile, "\n - delete message -\n"));
    if(mn_get_total(msgmap) <= 0L) {
	q_status_message(0, 1, 3,"\007No message in folder");
	return;
    }

    cur_msgno = mn_get_cur(msgmap);
    if(READONLY_FOLDER){
	q_status_message(1,1,3,"Can't delete message. Folder is read-only");
	return;
    }

    if(state->io_error_on_stream) {
	state->io_error_on_stream = 0;
	mail_check(state->mail_stream); /* forces write */
    }

    if(!agg || !(sequence = build_sequence(msgmap, &del_count))){
	if(del_count < 0L)
	  return;			/* we were told to bail */
	else
	  del_count = 1L;		/* must be deleting single message */

	(void)mail_fetchstructure(state->mail_stream,
				  mn_m2raw(state->msgmap, cur_msgno), NULL);
	mc = mail_elt(state->mail_stream, mn_m2raw(msgmap, cur_msgno));
	if(!mc || state->dead_stream) {
	    q_status_message1(1, 1, 3,
			     "Can't delete message %s. Error accessing folder",
			      long2string(cur_msgno));
	    return;
	}

	if(cur_msgno >= mn_get_total(msgmap))
	  strcpy(prompt, "Last message ");
	else
	  sprintf(prompt, "Message %ld ", cur_msgno);

	if(!mc->deleted){
	    clear_index_cache_ent(cur_msgno);
	    sequence = cpystr(long2string(mn_m2raw(msgmap, cur_msgno)));
	}
	else
	  strcat(prompt, "already ");
    }

    dprint(3,(debugfile, "Delete: msg %s%s\n",
	      (sequence) ? sequence : long2string(cur_msgno),
	      (sequence) ? "" : " ALREADY DELETED"));

    if(sequence){
	mail_setflag(state->mail_stream, sequence, "\\DELETED");
	fs_give((void **)&sequence);
	state->status_changed = 1;
	check_point_change();
	update_titlebar_status(mail_elt(state->mail_stream,
					mn_m2raw(msgmap, cur_msgno)));
    }

    if(del_count == 1L){
	is_unread = 1;
	if((IS_NEWS(state->mail_stream)
	    || (state->context_current->use & CNTXT_INCMNG))
	   || F_ON(F_DEL_SKIPS_DEL, state))
	  new_msgno = next_sorted_flagged(F_UNDEL, state->mail_stream,
					  cur_msgno + 1, &is_unread);
	if(F_OFF(F_DEL_SKIPS_DEL,state) && cur_msgno < mn_get_total(msgmap)){
	    mn_inc_cur(state->mail_stream, msgmap);
	    cur_msgno = mn_get_cur(msgmap);
	}
	else if(F_ON(F_DEL_SKIPS_DEL,state) && is_unread){
	    /* more interesting mail, goto next msg */
	    mn_set_cur(msgmap, new_msgno);
	    cur_msgno = new_msgno;
	}

	if(prompt[0])
	  strcat(prompt, "deleted");

	if((IS_NEWS(state->mail_stream)
	    || (state->context_current->use & CNTXT_INCMNG))
	   && !state->nr_mode && !is_unread){
	    char nextfolder[MAXPATH];

	    if(prompt[0] == '\0')
	      strcat(prompt, "Last undeleted message");

	    strcpy(nextfolder, state->cur_folder);
	    if(next_folder(nextfolder,nextfolder,state->context_current,FALSE))
	      strcat(prompt, ".  Press TAB for next folder.");
	    else
	      strcat(prompt, ".  No more folders to TAB to.");
	}
    }
    else
      sprintf(prompt, "%ld selected messages marked for deletion", del_count);

    if(prompt[0])
      q_status_message(0,1,3, prompt);

    mn_set_cur(msgmap, cur_msgno);
}



/*----------------------------------------------------------------------
   Execute UNDELETE message command

  Args: state --  Various satate info
        msgmap --  map of c-client to local message numbers

 Result: with side effect of "current" message delete flag UNset

 ----*/
void
cmd_undelete(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    long	  cur_msgno, del_count = 0;
    char	 *sequence = NULL;
    ENVELOPE     *e;
    MESSAGECACHE *mc;

    dprint(4, (debugfile, "\n - undelete -\n"));
    if(mn_get_total(msgmap) < 1L) {
	q_status_message(0, 1, 3, "\007No message in folder");
	return;
    }

    cur_msgno = mn_get_cur(msgmap);
    if(READONLY_FOLDER){
	q_status_message(1,1,3,"Can't undelete message. Folder is read-only");
	return;
    }

    if(!agg || !(sequence = build_sequence(msgmap, &del_count))){
	if(del_count < 0L)
	  return;			/* we were told to bail */
	else
	  del_count = 1L;		/* must be deleting single message */

	e  = mail_fetchstructure(state->mail_stream,mn_m2raw(msgmap,cur_msgno),
				 NULL); 
	mc = mail_elt(state->mail_stream, mn_m2raw(msgmap, cur_msgno));
	if(!e || !mc || state->dead_stream) {
	    q_status_message(1, 1, 4,
			     "Can't undelete message. Error accessing folder");
	    return;
	}
	else if(mc->deleted) {
	    clear_index_cache_ent(cur_msgno);
	    sequence = cpystr(long2string(mn_m2raw(msgmap, cur_msgno)));
	}
	else{
	    q_status_message(0, 1, 2, 
			    "\007Can't undelete a message that isn't deleted");
	    return;
	}
    }

    dprint(3,(debugfile, "Undeleted: msg %s\n",
	      (sequence) ? sequence : "already deleted"));

    if(sequence){
	mail_clearflag(state->mail_stream, sequence, "\\DELETED");
	fs_give((void **)&sequence);
	state->status_changed = 1;

	if(del_count == 1L){
	    mc = mail_elt(state->mail_stream, mn_m2raw(msgmap, cur_msgno));
	    update_titlebar_status(mc);
	    q_status_message(0, 1, 3,
			    "Deletion mark removed, message won't be deleted");
	}
	else
	  q_status_message2(0, 1, 3,
			    "Deletion mark removed from %s message%s",
			    comatose(del_count), plural(del_count));

	if(state->io_error_on_stream) {
	    state->io_error_on_stream = 0;
	    mail_check(state->mail_stream); /* forces write */
	}
	else
	  check_point_change();
    }
}



/*----------------------------------------------------------------------
   Execute FLAG message command

  Args: state --  Various satate info
        msgmap --  map of c-client to local message numbers

 Result: with side effect of "current" message FLAG flag set or UNset

 ----*/
void
cmd_flag(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    int           r, setflag = 1, usersetflag;
    long	  i, raw_msgno, flagged = 0L;
    char	 *sequence, *flag, *userflag;

    if(agg && !pseudo_selected("FLAG", msgmap, &raw_msgno))
      return;

    while(1){
	r = radio_buttons((setflag) ? flag_text : flag_text2,
			  -3, 0, flag_text_opt, 'i', 'x', 0, NO_HELP);

	if(r == 'x'){
	    q_status_message(0, 0, 2, "\007Flag message cancelled");
	    return;
	}
	else if(r == '!')
	  setflag = !setflag;
	else
	  break;
    }

    flag = (r == 'd') ? "\\DELETED" : 
	     (r == 'n') ? "\\SEEN" :
		(r == 'a') ? "\\ANSWERED" : "\\FLAGGED";

    userflag = (r == 'd') ? "Deleted" : 
		 (r == 'n') ? "New" :
		   (r == 'a') ? "Answered" : "Important";

    usersetflag = setflag;
    /* goofy case because we don't tell the user the real flag name */
    if(r == 'n')
      setflag = !setflag;

    /* BUG: 1 million message mailbox may pop this array... */
    sequence = fs_get((7 * (size_t)mn_total_cur(msgmap)) + 1);
    *sequence = '\0';
    for(i = mn_first_cur(msgmap); i > 0L; i = mn_next_cur(msgmap)){
	/* if not already set, go on... */
	if(get_flag(state->mail_stream, msgmap, i,
		    (r == 'd') ? MN_DEL :
		      (r == 'n') ? MN_SEEN :
			(r == 'a') ? MN_ANS : MN_FLAG)
	   == setflag)
	  continue;

	if(*sequence)
	  strcat(sequence, ",");

	strcat(sequence, long2string(mn_m2raw(msgmap, i)));
	clear_index_cache_ent(i);
	check_point_change();
	flagged++;
    }

    if(!*sequence){
	if(mn_total_cur(msgmap) <= 1)
	  q_status_message3(0,1,3,"Message %s already %sflagged %s",
			    long2string(mn_get_cur(msgmap)),
			    usersetflag ? "" : "un", userflag);
	else
	  q_status_message2(0,1,3,"Selected messages already %sflagged %s",
			    usersetflag ? "" : "un", userflag);
	return;
    }

    dprint(3,(debugfile, "Flag_cmd: msgs %s, %s %s\n", sequence,
	      setflag ? "set" : "cleared", flag));

    if(setflag)
      mail_setflag(state->mail_stream, sequence, flag);
    else
      mail_clearflag(state->mail_stream, sequence, flag);

    fs_give((void **)&sequence);

    if(mn_total_cur(msgmap) <= 1L){
	sprintf(tmp_20k_buf, "Message %s %sflagged %s",
		long2string(mn_get_cur(msgmap)), usersetflag ? "": "un",
		userflag);
    }else{
	if(flagged == mn_total_cur(msgmap) || flagged == 0L)
	  sprintf(tmp_20k_buf, "%ld messages %sflagged %s",
		  mn_total_cur(msgmap), usersetflag ? "" : "un",
		  userflag);
	else
	  sprintf(tmp_20k_buf, "%ld message%s %sflagged %s, %ld unchanged",
		  flagged, plural(flagged), usersetflag ? "" : "un", userflag,
		  mn_total_cur(msgmap) - flagged);
    }

    q_status_message(0, 1, 3, tmp_20k_buf);

    if(agg && raw_msgno){			/* restore array */
	i = mn_raw2m(msgmap, raw_msgno);
	mn_reset_cur(msgmap, i);
    }

    state->status_changed = 1;
}



/*----------------------------------------------------------------------
   Execute REPLY message command

  Args: state --  Various satate info
        msgmap --  map of c-client to local message numbers

 Result: reply sent or not

 ----*/
void
cmd_reply(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    long raw_msgno, cur_msgno;

    if(mn_get_total(msgmap) > 0L){
#ifdef	DOS
	flush_index_cache();		/* save room on PC */
#endif
	if(agg && !pseudo_selected("REPLY", msgmap, &raw_msgno))
	  return;

	reply(state);

	if(agg && raw_msgno){		/* restore array */
	    cur_msgno = mn_raw2m(msgmap, raw_msgno);
	    mn_reset_cur(msgmap, cur_msgno);
	}

	state->mangled_screen = 1;
    }
    else
      q_status_message(0, 0, 2, "\007No message in folder");
}



/*----------------------------------------------------------------------
   Execute FORWARD message command

  Args: state --  Various satate info
        msgmap --  map of c-client to local message numbers

 Result: selected message[s] forwarded or not

 ----*/
void
cmd_forward(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    long raw_msgno, cur_msgno;

    if(mn_get_total(msgmap) > 0L) {
#ifdef	DOS
	flush_index_cache();		/* save room on PC */
#endif
	if(agg && !pseudo_selected("FORWARD", msgmap, &raw_msgno))
	  return;

	forward(state);

	if(agg && raw_msgno){		/* restore array */
	    cur_msgno = mn_raw2m(msgmap, raw_msgno);
	    mn_reset_cur(msgmap, cur_msgno);
	}

	if(state->anonymous)
	  state->mangled_footer = 1;
	else
	  state->mangled_screen = 1;
    }
    else
      q_status_message(0, 0, 2, "\007Folder is empty. No message to forward");
}



/*----------------------------------------------------------------------
   Execute BOUNCE message command

  Args: state --  Various satate info
        msgmap --  map of c-client to local message numbers

 Result: selected message[s] bounced or not

 ----*/
void
cmd_bounce(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    long raw_msgno, cur_msgno;

    if(mn_get_total(msgmap) > 0L) {
#ifdef	DOS
	flush_index_cache();		/* save room on PC */
#endif
	if(agg && !pseudo_selected("BOUNCE", msgmap, &raw_msgno))
	  return;

	bounce(state);
	if(agg && raw_msgno){		/* restore array */
	    cur_msgno = mn_raw2m(msgmap, raw_msgno);
	    mn_reset_cur(msgmap, cur_msgno);
	}

	if(state->anonymous)
	  state->mangled_footer = 1;
	else
	  state->mangled_screen = 1;
    }
    else
      q_status_message(0, 0, 2, "\007Folder is empty. No message to resend");
}



/*----------------------------------------------------------------------
   Execute save message command: prompt for folder and call function to save

  Args: screen_line    --  Line on the screen to prompt on
        message        --  The MESSAGECACHE entry of message to save

 Result: The folder lister can be called to make selection; mangled screen set

   This does the prompting for the folder name to save to, possibly calling 
 up the folder display for selection of folder by user.                 
 ----*/
void
cmd_save(state, msgmap, screen_line, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int          screen_line;
     int	  agg;
{
    char       new_folder[MAXFOLDER+1], prompt[MAXFOLDER+80], nmsgs[32], *p;
    HelpType   help;
    int        rc, saveable_count = 0;
    long       i, cur_msgno, raw_msgno, number_saved = 0L;
    static     char folder[MAXFOLDER+1] = {'\0'};
    static     CONTEXT_S *last_context = NULL;
    CONTEXT_S *cntxt = NULL, *tc;
    ESCKEY_S   ekey[5];
    ENVELOPE  *e = NULL;
    MESSAGECACHE *mc;

    dprint(4, (debugfile, "\n - saving message -\n"));

    if(agg && !pseudo_selected("SAVE", msgmap, &raw_msgno))
      return;

    if(mn_total_cur(msgmap) <= 1L){
	nmsgs[0] = '\0';
	e = mail_fetchstructure(state->mail_stream,
				mn_m2raw(msgmap, mn_get_cur(msgmap)), NULL);
	if(!e) {
	    q_status_message(1, 2, 4,
			     "\007Can't save message. Error accessing folder");
	    goto jumpout;
	}
    }
    else
      sprintf(nmsgs, "%s msgs ", comatose(mn_total_cur(msgmap)));

    /* start with the default save context */
    if((cntxt = default_save_context(state->context_list)) == NULL)
       cntxt = state->context_list;

    if(e && (ps_global->save_msg_rule == MSG_RULE_FROM
	       || ps_global->save_msg_rule == MSG_RULE_SENDER
	       || ps_global->save_msg_rule == MSG_RULE_RECIP)){

	int        i, start, end;
	char      *folder_name;

	if(ps_global->save_msg_rule == MSG_RULE_FROM)
	  folder_name = e->from ? e->from->mailbox 
				  : e->sender ? e->sender->mailbox : NULL;
	else if(ps_global->save_msg_rule == MSG_RULE_SENDER)
	  folder_name = e->sender ? e->sender->mailbox
				    : e->from ? e->from->mailbox : NULL;
	else if(ps_global->mail_stream
		&& ps_global->mail_stream->mailbox[0] == '*') /* IS_NEWS ? */
	  folder_name = (ps_global->mail_stream->mailbox[1] == '{')
			   ? strchr(ps_global->mail_stream->mailbox, '}') + 1
			   : &ps_global->mail_stream->mailbox[1];
	else
	  folder_name = e->to ? e->to->mailbox : NULL;

	/*
	 * Now fish out the user's name from the mailbox portion of
	 * the address and put it in folder.
	 */
	if(!get_uname(folder_name, folder, MAXFOLDER+1))
	  strcpy(folder, DEFAULT_SAVE);
    }
    else if(ps_global->save_msg_rule == MSG_RULE_LAST){
	if(last_context)
	  cntxt = last_context;
	else
	  strcpy(folder, DEFAULT_SAVE);
    }
    else
      strcpy(folder, DEFAULT_SAVE);

    /* how many context's can be saved to... */
    for(tc = state->context_list; tc; tc = tc->next)
      if(!(tc->type&FTYPE_BBOARD))
        saveable_count++;

    /* set up extra command option keys */
    rc = 0;
    ekey[rc].ch      = ctrl('T');
    ekey[rc].rval    = 2;
    ekey[rc].name    = "^T";
    ekey[rc++].label = "To Fldrs";

    if(saveable_count > 1){
	ekey[rc].ch      = ctrl('P');
	ekey[rc].rval    = 10;
	ekey[rc].name    = "^P";
	ekey[rc++].label = "Prev Collection";

	ekey[rc].ch      = ctrl('N');
	ekey[rc].rval    = 11;
	ekey[rc].name    = "^N";
	ekey[rc++].label = "Next Collection";
    }

    if(F_ON(F_ENABLE_TAB_COMPLETE, ps_global)){
	ekey[rc].ch      = TAB;
	ekey[rc].rval    = 12;
	ekey[rc].name    = "TAB";
	ekey[rc++].label = "Complete";
    }

    ekey[rc].ch = -1;

    *new_folder = '\0';
    help = NO_HELP;
    ps_global->mangled_footer = 1;
    while(1) {
	/* only show collection number if more than one available */
	if(ps_global->context_list->next){
	    sprintf(prompt, "SAVE %sto folder in <%.25s> [%s] : ",
		    nmsgs, cntxt->label[0], folder);
	}
	else
	  sprintf(prompt, "SAVE %sto folder [%s] : ", nmsgs, folder);

        rc = optionally_enter(new_folder, screen_line, 0, MAXFOLDER, 1, 0,
                              prompt, ekey, help, 0);

	if(rc == -1){
	    q_status_message(1, 1, 3, "\007Error reading folder name");
	    goto jumpout;
	}
	else if(rc == 1){
	    q_status_message(0, 0, 2, "\007Save message cancelled");
	    goto jumpout;
	}
	else if(rc == 2) {
	    void (*redraw)() = ps_global->redrawer;

	    push_titlebar_state();
	    rc = folder_lister(ps_global,SaveMessage,cntxt,&cntxt,new_folder,
			       ps_global->context_list, NULL);
            ClearScreen();
	    pop_titlebar_state();
	    redraw_titlebar();
            if(ps_global->redrawer = redraw) /* reset old value, and test */
              (*ps_global->redrawer)();

	    if(F_ON(F_SELECT_WO_CONFIRM, ps_global) && rc){
	      rc = 0;         /* reset rc and pop out... */
	      break;
	    }
	}
	else if(rc == 3){
            help = (help == NO_HELP) ? h_oe_save : NO_HELP;
	}
	else if(rc == 10){			/* Previous collection */
	    CONTEXT_S *start;
	    start = cntxt;
	    tc    = cntxt;

	    while(1){
		if((tc = tc->next) == NULL)
		  tc = ps_global->context_list;

		if(tc == start)
		  break;

		if((tc->type&FTYPE_BBOARD) == 0)
		  cntxt = tc;
	    }
	}
	else if(rc == 11){			/* Next collection */
	    tc = cntxt;

	    do
	      if((cntxt = cntxt->next) == NULL)
		cntxt = ps_global->context_list;
	    while((cntxt->type&FTYPE_BBOARD) && cntxt != tc);
	}
	else if(rc == 12){			/* file name completion! */
	    if(!folder_complete(cntxt, new_folder))
	      Writechar('\007', 0);

	}
	else if(rc != 4)
          break;
    }

    dprint(9, (debugfile, "rc = %d, \"%s\"  \"%s\"\n", rc, new_folder,folder));
    if(rc == 1 || (!*new_folder && !*folder) || (rc == 2 && !*new_folder)) {
        q_status_message(0,0,2,"\007No folder named; save message cancelled");
	goto jumpout;
    }

    removing_trailing_white_space(new_folder);
    removing_leading_white_space(new_folder);

    last_context = cntxt;		/* remember for next time */
    if(!*new_folder)
      strcpy(new_folder, folder);
    else
      strcpy(folder, new_folder);

    /* is it a nickname? */
    if(context_isambig(new_folder)
       && (p = folder_is_nick(new_folder, cntxt->folders))){
	strcpy(new_folder, p);
    }

    for(i = mn_first_cur(msgmap); i > 0L; i = mn_next_cur(msgmap)){
	if((e=mail_fetchstructure(state->mail_stream,mn_m2raw(msgmap,i),NULL))
	   && (mc=mail_elt(ps_global->mail_stream, mn_m2raw(msgmap,i)))){
	    if(!save(new_folder, cntxt, mc)){
		dprint(1, (debugfile,
			   "FAILED save of msg-id <%s>\n",
			   (e && e->message_id) ? e->message_id : "NONE"));

		if(mn_total_cur(msgmap) > 1L && number_saved)
		  q_status_message1(0, 1, 3,
				    "%ld message saved before error occurred",
				    (void *)number_saved);

		goto jumpout;
	    }

	    number_saved++;
	    if(!mc->deleted && !READONLY_FOLDER
	       && F_ON(F_SAVE_DELETES, ps_global)){
		char sequence[16];

		sprintf(sequence, "%ld", mn_m2raw(msgmap, i));
		mail_setflag(ps_global->mail_stream, sequence, "\\DELETED");
		ps_global->mangled_header = 1;
		ps_global->status_changed = 1;
		clear_index_cache_ent(i);
		check_point_change();
	    }
	}
	else{
	    q_status_message(1, 2, 4,
			     "\007Can't save message. Error accessing folder");
	    goto jumpout;
	}
    }

    if(mn_total_cur(msgmap) <= 1L){
	if(ps_global->context_list->next && context_isambig(new_folder)){
	    sprintf(tmp_20k_buf, 
		    "Message %s copied to \"%.15s%s\" in <%.15s%s>",
		    long2string(mn_get_cur(msgmap)), new_folder,
		    (strlen(new_folder) > 15) ? "..." : "",
		    cntxt->label[0],
		    (strlen(cntxt->label[0]) > 15) ? "..." : "");
	}
	else
	  sprintf(tmp_20k_buf, "Message %s copied to folder \"%.27s%s\"",
		  long2string(mn_get_cur(msgmap)), new_folder,
		  (strlen(new_folder) > 27) ? "..." : "");

	if(F_ON(F_SAVE_DELETES, ps_global))
	  strcat(tmp_20k_buf, " and marked deleted");
    }
    else
      sprintf(tmp_20k_buf, "%ld messages saved%s", number_saved, 
	      F_ON(F_SAVE_DELETES, ps_global)?" and deleted":"");

    q_status_message(0, 1, 3, tmp_20k_buf);

    if(F_ON(F_SAVE_ADVANCES, state)){
	mn_inc_cur(state->mail_stream, msgmap);
	cur_msgno = mn_get_cur(msgmap);
    }

  jumpout:
    if(agg && raw_msgno){			/* restore array */
	cur_msgno = mn_raw2m(msgmap, raw_msgno);
	mn_reset_cur(msgmap, cur_msgno);
    }
}




#ifdef VMS
int
save(folder, context, message)
     char         *folder;
     CONTEXT_S    *context;
     MESSAGECACHE *message;
{
   return (int) vms_move_folder(folder, context, message);
}
#else	/* VMS */
/*----------------------------------------------------------------------
        Do the work of actually saving message in a folder

    Args: folder  -- The folder to save the message in
          message -- The MESSAGECACHE entry of message to save

  Result: Returns 0 if message couldn't be saved
          returns 1 if it was saved

Just gather the message pieces and let c-client handle the rest...
 ----*/
int
save(folder, context, message)
     char         *folder;
     CONTEXT_S    *context;
     MESSAGECACHE *message;
{
    int         rc, rv;
    char       *tmp, *save_folder, *flags, *date;
    long        mlen;
    STORE_S    *so;
    STRING      msg;
    MAILSTREAM *save_stream = NULL;
    SourceType  src;
#ifdef	DOS
    struct {			/* hack! stolen from dawz.c */
	int fd;
	unsigned long pos;
    } d;
    extern STRINGDRIVER dawz_string;

    src = FileStar;
#else
    src = CharStar;
#endif

    /*
     * time to start depending on c-client for this!  Use context_append
     * and context_create to do the dirty work, but first, set up
     * storage object...
     */
    if(!(so = so_get(src, NULL, WRITE_ACCESS))){
	q_status_message(1,2,4,"\007Problem creating space for message text.");
	return(0);
    }

#ifdef	DOS
    /* set append file and install dos_gets so message header 
     * and text is fetched directly to disk...
     */
    mailgets    = dos_gets;
    append_file = (FILE *) so_text(so);
#endif

    if(!(tmp = mail_fetchheader(ps_global->mail_stream, message->msgno))){
	so_give(&so);
	return(0);
    }
#ifndef	DOS
    else
      so_puts(so, tmp);
#endif

    if(!(tmp = mail_fetchtext(ps_global->mail_stream, message->msgno))){
	so_give(&so);
	return(0);
    }
#ifndef	DOS
    else
      so_puts(so, tmp);
#endif

    so_seek(so, 0L, 0);				/* just in case */

    /*
     * What's really needed is a way to pipe this crap right into
     * context_append...
     */
    /* set up string driver */
#ifdef	DOS
    d.fd  = fileno((FILE *)so_text(so));
    d.pos = 0L;
    if((mlen = filelength(d.fd)) < message->rfc822_size){
	q_status_message3(1, 2, 4, 
			 "\007Message to save shrank!  (#%ld: %ld --> %ld)",
			  (void *)message->msgno, (void *)message->rfc822_size,
			  (void *)mlen);
	dprint(1, (debugfile,
		   "BOTCH: %ld save shrank mc->size == %ld, string == %ld\n",
		   message->msgno, message->rfc822_size, mlen));
	so_give(&so);
	return(0);
    }

    INIT(&msg, dawz_string, (void *)&d, mlen);
#else
    if((mlen = strlen((char *)so_text(so))) < message->rfc822_size){
	q_status_message3(1, 2, 4, 
			 "\007Message to save shrank!  (#%ld: %ld --> %ld)",
			  (void *)message->msgno, (void *)message->rfc822_size,
			  (void *)mlen);
	dprint(1, (debugfile,
		   "BOTCH: %ld save shrank mc->size == %ld, string == %ld\n",
		   message->msgno, message->rfc822_size, mlen));
	so_give(&so);
	return(0);
    }

    INIT(&msg, mail_string, (void *)so_text(so), mlen);
#endif

    save_folder = (strucmp(folder, ps_global->inbox_name) == 0)
                   ? ps_global->VAR_INBOX_PATH : folder;

    save_stream = context_same_stream(context->context,
				      save_folder,
				      ps_global->mail_stream);

    if(!save_stream && ps_global->mail_stream != ps_global->inbox_stream)
      save_stream = context_same_stream(context->context,
					save_folder,
					ps_global->inbox_stream);


    /*
     * bulid message's internal date and flags
     */
    date    = cpystr(mail_date(tmp_20k_buf, message));
    tmp     = NULL;
    flags   = tmp_20k_buf;		/* NOTE: "flags" use overloaded */
    if(message->deleted)
      for(tmp = "\\DELETED"; *tmp; tmp++)
	*flags++ = *tmp;

    if(message->answered){
	if(tmp)
	  *flags++ = ' ';

	for(tmp = "\\ANSWERED"; *tmp; tmp++)
	  *flags++ = *tmp;
    }

    if(message->flagged){
	if(tmp)
	  *flags++ = ' ';

	for(tmp = "\\FLAGGED"; *tmp; tmp++)
	  *flags++ = *tmp;
    }

    if(message->seen){
	if(tmp)
	  *flags++ = ' ';

	for(tmp = "\\SEEN"; *tmp; tmp++)
	  *flags++ = *tmp;
    }

    *flags = '\0';			/* tie off tmp_20k_buf   */
    flags  = cpystr(tmp_20k_buf);	/* point flags at a copy */

    ps_global->try_to_create = 0; 	/* set in mm_notify? */
    rv = rc = 0;
    while(!(rv = context_append_full(context->context, save_stream,
				save_folder, flags, date, &msg))){
	if(rc++ || !ps_global->try_to_create)   /* abysmal failure! */
	  break;				/* c-client returned error? */

	ps_global->try_to_create = 0;	/* reset for next time */

	/*
	 * already exists?
	 */
	if(ps_global->context_list->next && context_isambig(save_folder)){
	    sprintf(tmp_20k_buf,
		    "Folder \"%.15s%s\" in <%.15s%s> doesn't exist. Create",
		    save_folder, (strlen(save_folder) > 15) ? "..." : "",
		    context->label[0],
		    (strlen(context->label[0]) > 15) ? "..." : "");
	}
	else
	  sprintf(tmp_20k_buf,"Folder \"%.40s\" doesn't exist.  Create",
		  save_folder);

        if(want_to(tmp_20k_buf, 'y', 'n', NO_HELP, 0, 0) != 'y'){
            q_status_message(0, 1, 3, "\007Save message cancelled");
	    break;
        }

	if(!context_create(context->context, 
			  create_proto(save_stream, context, save_folder),
			  save_folder))
	  break;				/* c-client returned error? */

/* BUG: add folder to list in context if ambiguous!! */
	SETPOS((&msg), 0L);			/* reset string driver */
    }

    ps_global->try_to_create = 0;		/* reset for next time */
#ifdef	DOS
    append_file = NULL;				/* reset DOS hacks */
    mailgets    = NULL;				/* reset DOS hacks */
    mail_gc(ps_global->mail_stream, GC_TEXTS);
#endif
    fs_give((void **)&date);
    fs_give((void **)&flags);
    so_give(&so);
    return(rv);
}
#endif	/* VMS */


/*----------------------------------------------------------------------
    Export a message to a plain file in users home directory

   Args:  q_line -- screen line to prompt on
         message -- MESSAGECACHE enrty of message to export

 Result: 
 ----*/
void
cmd_export(state, msgmap, q_line, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int          q_line;
     int	  agg;
{
    HelpType  help;
    char      filename[MAXPATH+1], full_filename[MAXPATH+1],*ill;
    int       rc, new_file, failure = 0, orig_errno;
    ENVELOPE *env;
    BODY     *b;
    long      i, now, raw_msgno, count = 0L, start_of_append;
    gf_io_t   pc;
    STORE_S  *store;

    if(ps_global->restricted){
	q_status_message(1, 1, 3, "Pine demo can't export messages to files");
	return;
    }

    if(agg && !pseudo_selected("EXPORT", msgmap, &raw_msgno))
      return;

    help = NO_HELP;
    filename[0] = '\0';
    while(1) {
        char prompt[100];
#ifdef	DOS
        (void)strcpy(prompt, "File to save message text in: ");
#else
        sprintf(prompt, "EXPORT: (copy message) to file in %s directory: ",
	         F_ON(F_USE_CURRENT_DIR, ps_global) ? "current" : "home");
#endif
        rc = optionally_enter(filename, q_line, 0, MAXPATH, 1, 0,
                 prompt, NULL, help, 0);

        /*--- Help ----*/
        if(rc == 3) {
            help = (help == NO_HELP) ? h_oe_export : NO_HELP;
            continue;
        }

        removing_trailing_white_space(filename);
        removing_leading_white_space(filename);
        if(rc == 1 || filename[0] == '\0') {
            q_status_message(0, 0, 2, "\007Export message cancelled");
            return;
        }

        if(rc == 4)
          continue;


        /*-- check out and expand file name. give possible error messages --*/
        strcpy(full_filename, filename);
        if((ill = filter_filename(filename)) != NULL) {
            q_status_message1(1, 1, 3, "\007%s in file name", ill);
            display_message('x');
            sleep(3);
            continue;
        }
#ifndef	DOS
        if(full_filename[0] == '~') {
            if(fnexpand(full_filename, sizeof(full_filename)) == NULL) {
                char *p = strindex(full_filename, '/');
                if(p != NULL)
                  *p = '\0';
                q_status_message1(1, 1, 3,
                    "\007Error expanding file name: \"%s\" unknown user",
    	            full_filename);
                display_message('x');
                sleep(3);
                continue;
            }
        } else if(full_filename[0] != '/') {
#else
        if(full_filename[0] == '\\' || full_filename[1] == ':') {
	    fixpath(full_filename, MAXPATH);
	}
	else{
#endif
	    if(F_ON(F_USE_CURRENT_DIR, ps_global))
              (void)strcpy(full_filename, filename);
	    else
              build_path(full_filename, ps_global->home_dir, filename);
        }

        break; /* Must have got an OK file name */

    }


    /* ---- full_filename already contains the absolute path ---*/
    if(!can_access(full_filename, ACCESS_EXISTS)) {
        char wt, prompt[100];
        sprintf(prompt, "File \"%s\" already exists. Append message to it",
                filename);
        wt = want_to(prompt, 'y', 'n', NO_HELP, 0, 0);
        if(wt == 'n') {
            q_status_message(0, 0, 2, "\007Export message cancelled");
            return;
        }
        new_file = 0;
    } else {
        new_file = 1;
    }

    dprint(5, (debugfile, "Opening file \"%s\" for export\n", full_filename));

    if(!(store = so_get(FileStar, full_filename, WRITE_ACCESS))){
        q_status_message2(1, 2, 4,
			 "\007Error opening file \"%s\" to export message: %s",
                          full_filename, error_description(errno));
        return;
    }
    else
      gf_set_so_writec(&pc, store);

    for(i = mn_first_cur(msgmap); i > 0L; i = mn_next_cur(msgmap), count++){
	env = mail_fetchstructure(state->mail_stream, mn_m2raw(msgmap, i), &b);
	if(!env) {
	    q_status_message(1, 2, 4,
		      "\007Can't export message. Error accessing mail folder");
	    return;
	}

	/*--------- The message separator -------*/
	now = time(0);
	sprintf(tmp_20k_buf, "%sFrom %s%s%s ",
		new_file ? "" : NEWLINE,
		(env && env->from) ? env->from->mailbox
				   : "the-concourse-on-high",
		(env && env->from && env->from->host) ? "@" : "",
		(env && env->from && env->from->host) ? env->from->host : "",
		ctime(&now));

	/* write our own newline since this folder's open in binary mode
	 * under DOS...
	 */
	tmp_20k_buf[strlen(tmp_20k_buf) - 1] = '\0';

	start_of_append = ftell((FILE *)so_text(store));

	if(!so_puts(store, tmp_20k_buf)
	   || !so_puts(store, NEWLINE)
	   || !format_message(mn_m2raw(msgmap, i), env, b,
			      (FM_NEW_MESS|FM_DO_PRINT), pc)){
	    orig_errno = errno;		/* save incase things are really bad */
	    failure    = 1;		/* pop out of here */
	    break;
	}
    }

    so_give(&store);				/* release storage */
    if(failure){
#ifndef	DOS
	truncate(full_filename, start_of_append);
#endif
	dprint(1, (debugfile, "FAILED Export: file \"%s\" : %s\n",
		   full_filename,  error_description(orig_errno)));
	q_status_message2(0, 2, 4, "\007Error exporting to \"%s\" : %s",
			  filename, error_description(orig_errno));
    }
    else{
	if(mn_total_cur(msgmap) > 1L)
	  q_status_message3(0, 1, 3, "%s message%s exported to file \"%s\"",
			    long2string(count), plural(count), filename);
	else
	  q_status_message2(0, 1, 3, "Message %s exported to file \"%s\"",
			    long2string(mn_get_cur(msgmap)), filename);
    }

    if(agg && raw_msgno){			/* restore array */
	i = mn_raw2m(msgmap, raw_msgno);
	mn_reset_cur(msgmap, i);
    }
}



/*
 * Execute command to take addresses out of message and put in the address book
 *
 * Args: state  -- pine state
 *       msgmap -- the MessageMap
 *       agg    -- this is aggregate operation if set
 *
 * Result: The entry is added to an address book.
 */     
void
cmd_take_addr(state, msgmap, agg)
struct pine *state;
MSGNO_S     *msgmap;
int          agg;
{
    long      i, raw_msgno;
    ADDRESS  *addr_from,
             *addr_sender,
             *addr_reply_to,
             *addr_to,
	     *addr_cc,
	     *a,
	     *nextaddr,
	     *adrlist,
	     *one_msg_adrlist;
    ENVELOPE *env;

    dprint(4, (debugfile, "\n - taking address into address book - \n"));

    if(agg && !pseudo_selected("TAKE", msgmap, &raw_msgno))
        return;

    if(mn_get_total(msgmap) < 1L){
	q_status_message(0, 1, 3, "\007No messages to take the address from");
	return;
    }

    state->mangled_footer = 1;

    adrlist = NULL;

    for(i = mn_first_cur(msgmap); i > 0L; i = mn_next_cur(msgmap)){
	env = mail_fetchstructure(state->mail_stream, mn_m2raw(msgmap, i),
				  NULL);
	if(!env){
	    q_status_message(1, 2, 4,
	  "\007Can't take address into address book. Error accessing folder");
	    break;
	}

#ifdef OLDWAY /* in case we decide to do this afterall */
/* This oldway stuff is where I was separating the addrs into groups by
 * message with a blank line.  Dups were eliminated within each group
 * but not globally.  This seemed too confusing.
 * There is further machinery in addrbook.c to support this that we're no
 * longer doing, only it isn't ifdef'd out there.  In particular, the
 * duplicate elimination going into the addrbook there is not needed, and
 * the code that notices blank lines, prints them, and skips them is not
 * needed.
 */
	/*
	 * If this isn't the first one, put a special address in that will
	 * be used by takeaddr_screen to put a blank between the addresses
	 * from different messages.  We will use a null mailbox field to
	 * signify that this is supposed to be a blank.
	 */
	if(adrlist){
	    ADDRESS *blank;

	    blank   = mail_newaddr();
	    adrlist = paste_together(adrlist, blank);
	}
#endif /* OLDWAY */

	addr_from       = cpyadrlst(env->from);
	addr_reply_to   = cpyadrlst(env->reply_to);
	addr_sender     = cpyadrlst(env->sender);
	addr_to         = cpyadrlst(env->to);
	addr_cc         = cpyadrlst(env->cc);

#ifdef OLDWAY
	one_msg_adrlist = NULL;
	one_msg_adrlist = paste_together(one_msg_adrlist, addr_from);
	one_msg_adrlist = paste_together(one_msg_adrlist, addr_reply_to);
	one_msg_adrlist = paste_together(one_msg_adrlist, addr_sender);
	one_msg_adrlist = paste_together(one_msg_adrlist, addr_to);
	one_msg_adrlist = paste_together(one_msg_adrlist, addr_cc);

	eliminate_dups(one_msg_adrlist);

	adrlist = paste_together(adrlist, one_msg_adrlist);

#else /* !OLDWAY */

	adrlist = paste_together(adrlist, addr_from);
	adrlist = paste_together(adrlist, addr_reply_to);
	adrlist = paste_together(adrlist, addr_sender);
	adrlist = paste_together(adrlist, addr_to);
	adrlist = paste_together(adrlist, addr_cc);
#endif /* !OLDWAY */

    }

#ifndef OLDWAY
    eliminate_dups(adrlist);
#endif /* !OLDWAY */

    /* takeaddr_screen handles status messages for us */
    if(adrlist)
	takeaddr_screen(state, adrlist);

    mail_free_address(&adrlist);

    if(agg && raw_msgno){			/* restore array */
	i = mn_raw2m(msgmap, raw_msgno);
	mn_reset_cur(msgmap, i);
    }
}

/*
 * Combine two adrlists into one, beginning with the first one.
 *
 * Returns a pointer to the first if non-NULL, else a pointer to the second.
 */
ADDRESS *
paste_together(adrlist_first, adrlist_second)
ADDRESS *adrlist_first,
	*adrlist_second;
{
    ADDRESS *a;

    /* find end of first */
    for(a = adrlist_first; a && a->next; a = a->next)
	;/* do nothing */
    
    if(a){
	a->next = adrlist_second;
	return(adrlist_first);
    }
    else
	return(adrlist_second);

}


/*
 * Make a new alloc'd copy of an adrlist and return a pointer to it.
 */
ADDRESS *
cpyadrlst(addr)
ADDRESS *addr;
{
    ADDRESS *a,
	    *new,
	    *adrlist = NULL;

    for(a = addr; a; a = a->next){
	new = mail_newaddr();
	if(a->personal)
	    new->personal = cpystr(a->personal);
	if(a->adl)
	    new->adl      = cpystr(a->adl);
	if(a->mailbox)
	    new->mailbox  = cpystr(a->mailbox);
	if(a->host)
	    new->host     = cpystr(a->host);
	new->next = NULL;

	adrlist   = paste_together(adrlist, new);
    }

    return(adrlist);
}

/*
 * Look for dups in list and use hokey method of throwing them out.
 * We just set host to NULL and that will cause them to appear to be
 * group syntax with takeaddr_screen ignores.  That way we don't have to
 * worry about de-allocating properly.
 */
void
eliminate_dups(list)
ADDRESS *list;
{
    ADDRESS *a, *b;

    for(a = list; a; a = a->next){

	if(!a->host) /* already tossed */
	    continue;

	/* Check addr a versus all others */
	for(b = a->next; b; b = b->next){
	    if(dup_addrs(a, b)){
		/* throw out b */
		if(b->host)
		    fs_give((void **)&b->host); /* mark as dup */
	    }
	}
    }
}


/*
 * Returns 1 if x and y match.
 */
int
dup_addrs(x, y)
ADDRESS *x, *y;
{
    return(x && y && strucmp(x->mailbox, y->mailbox) == 0
           &&  strucmp(x->host, y->host) == 0);
}


/*----------------------------------------------------------------------
      Execute command to jump to a given message number

    Args: qline -- Line to ask question on

  Result: returns -1 or the message number to jump to
          the mangled_footer flag is set
 ----*/
void
jump_to(msgmap, qline, first_num)
     MSGNO_S *msgmap;
     int      qline, first_num;
{
    char     jump_num_string[80], *j, prompt[70];
    HelpType help;
    int      rc;
    long     jump_num;

    dprint(4, (debugfile, "\n - jump_to -\n"));

    if(mn_get_total(msgmap) < 1L) {
	q_status_message(0, 0, 2, "\007No messages to jump to");
	return;
    }

    if(first_num){
	jump_num_string[0] = first_num;
	jump_num_string[1] = '\0';
    }
    else
      jump_num_string[0] = '\0';

    if(mn_total_cur(msgmap) > 1L){
	sprintf(prompt, "Unselect %s msgs in favor of number to be entered", 
		comatose(mn_total_cur(msgmap)));
	if((rc = want_to(prompt, 'n', 0, NO_HELP, 0, 0)) == 'n')
	    return;
    }

    strcpy(prompt, "Message number to jump to : ");

    help = NO_HELP;
    while (1) {
        rc = optionally_enter(jump_num_string, qline, 0,
                              sizeof(jump_num_string) - 1, 1, 0, prompt,
                              NULL, help, 0);
        if(rc == 3) {
            help = help == NO_HELP ? h_oe_jump : NO_HELP;
            continue;
        }

        if(rc == 0 && *jump_num_string != '\0') {
	    removing_trailing_white_space(jump_num_string);
	    removing_leading_white_space(jump_num_string);
            for(j = jump_num_string; isdigit(*j) || *j == '-'; j++);
	    if(*j != '\0') {
	        q_status_message(0, 2, 2,
                           "\007Invalid number entered. Use only digits 0-9");
            } else {
                jump_num = atol(jump_num_string);
                if(jump_num < 1L) {
	            q_status_message1(1, 2, 2,
			      "\007Message number (%s) must be greater than 0",
			      long2string(jump_num));
                } else if(jump_num > mn_get_total(msgmap)) {
                    q_status_message1(1, 2, 2,
	  "\007Message number must be no more than %s, the number of messages",
		    long2string(mn_get_total(msgmap)));
                } else if(get_flag(ps_global->mail_stream, msgmap,
				   jump_num, MN_HIDE)){
	            q_status_message1(1, 2, 2,
			  "\007Message number (%s) is not in \"Zoomed Index\"",
			  long2string(jump_num));
		} else {
		    if(mn_total_cur(msgmap) > 1L){
			mn_reset_cur(msgmap, jump_num);
		    }
		    else{
			mn_set_cur(msgmap, jump_num);
		    }

		    break;
                }
            }
            jump_num_string[0] = '\0';
            display_message(NO_OP_COMMAND);
            sleep (3);
            continue;
	}

        if(rc != 4)
          break;
    }
}



/*----------------------------------------------------------------------
     Prompt for folder name to open, expand the name and return it

   Args: qline      -- Screen line to prompt on
         allow_list -- if 1, allow ^T to bring up collection lister

 Result: returns the folder name or NULL
         pine structure mangled_footer flag is set
         may call the collection lister in which case mangled screen will be set

 This prompts the user for the folder to open, possibly calling up
the collection lister if the user types ^T.
----------------------------------------------------------------------*/
char *
broach_folder(qline, allow_list, context)
    int qline, allow_list;
    CONTEXT_S **context;
{
    HelpType	help;
    static char new_folder[MAXFOLDER+1];
    char        expanded[MAXPATH+1],
                prompt[MAXFOLDER+80],
               *last_folder;
    CONTEXT_S  *tc, *tc2;
    ESCKEY_S    ekey[5];
    int         rc, inbox;

    /*
     * the idea is to provide a clue for the context the file name
     * will be saved in (if a non-imap names is typed), and to
     * only show the previous if it was also in the same context
     */
    help           = NO_HELP;
    *expanded      = '\0';
    *new_folder    = '\0';
    last_folder    = NULL;
    inbox          = strucmp(ps_global->cur_folder,ps_global->inbox_name) == 0;
    ps_global->mangled_footer = 1;

    /*
     * if we're given a valid context AND we don't have our current
     * folder open, go with what's given ELSE go with inbox collection
     */
    tc = (inbox) ? (context && *context) ? *context:ps_global->context_current
		 : ps_global->context_list;

    /* set up extra command option keys */
    rc = 0;
    ekey[rc].ch	     = (allow_list) ? ctrl('T') : 0 ;
    ekey[rc].rval    = (allow_list) ? 2 : 0;
    ekey[rc].name    = (allow_list) ? "^T" : "";
    ekey[rc++].label = (allow_list) ? "ToFldrs" : "";

    if(ps_global->context_list->next){
	ekey[rc].ch      = ctrl('P');
	ekey[rc].rval    = 10;
	ekey[rc].name    = "^P";
	ekey[rc++].label = "Prev Collection";

	ekey[rc].ch      = ctrl('N');
	ekey[rc].rval    = 11;
	ekey[rc].name    = "^N";
	ekey[rc++].label = "Next Collection";
    }

    if(F_ON(F_ENABLE_TAB_COMPLETE,ps_global)){
	ekey[rc].ch      = TAB;
	ekey[rc].rval    = 12;
	ekey[rc].name    = "TAB";
	ekey[rc++].label = "Complete";
    }

    ekey[rc].ch = -1;

    while(1) {
	/*
	 * Figure out next default value for this context.  The idea
	 * is that in each context the last folder opened is cached.
	 * It's up to pick it out and display it.  This is fine
	 * and dandy if we've currently got the inbox open, BUT
	 * if not, make the inbox the default the first time thru.
	 */
	if(allow_list){
	    if(tc->last_folder[0]){
		last_folder = (inbox) ? tc->last_folder: ps_global->inbox_name;
		sprintf(expanded, " [%s]", last_folder);
		inbox = 1;	/* pretend we're in inbox from here on  */
	    }
	    else{
		last_folder = NULL;
		*expanded = '\0';
	    }
	}

	/* only show collection number if more than one available */
	if(ps_global->context_list->next){
	    sprintf(prompt, "GOTO %s in <%.20s> %s%s: ",
		    (tc->type&FTYPE_BBOARD) ? "news group" : "folder",
		    tc->label[0], expanded, *expanded ? " " : "");
	}
	else
	  sprintf(prompt, "GOTO folder %s: ", expanded, *expanded ? " " : "");

        rc = optionally_enter(new_folder, qline, 0, MAXFOLDER, 1 ,0, prompt,
                              ekey, help, 0);

	if(rc == -1){
	    q_status_message(1, 1, 3, "\007Error reading folder name");
	    return(NULL);
	}
	else if(rc == 1){
	    q_status_message(0, 0, 2, "\007Open Folder cancelled");
	    return(NULL);
	}
	else if(rc == 2){
	    void (*redraw)() = ps_global->redrawer;

	    push_titlebar_state();
	    rc = folder_lister(ps_global, OpenFolder, tc, &tc, new_folder,
			       ps_global->context_list, NULL);
            ClearScreen();
	    pop_titlebar_state();
            redraw_titlebar();
            if(ps_global->redrawer = redraw) /* reset old value, and test */
              (*ps_global->redrawer)();

	    if(F_ON(F_SELECT_WO_CONFIRM, ps_global) && rc){
	      rc = 0;         /* reset rc and pop out... */
	      break;
	    }
	}
	else if(rc == 3){
            help = help == NO_HELP ? h_oe_broach : NO_HELP;
	}
	else if(rc == 10){			/* Previous collection */
	    tc2 = ps_global->context_list;
	    while(tc2->next && tc2->next != tc)
	      tc2 = tc2->next;

	    tc = tc2;
	}
	else if(rc == 11){			/* Next collection */
	    tc = (tc->next) ? tc->next : ps_global->context_list;
	}
	else if(rc == 12){			/* file name completion! */
	    if(!folder_complete(tc, new_folder))
	      Writechar('\007', 0);
	}
	else if(rc != 4)
          break;
    }

    removing_trailing_white_space(new_folder);
    removing_leading_white_space(new_folder);

    if(*new_folder == '\0'  && last_folder == NULL) {
        q_status_message(0, 0, 2, "\007Open folder cancelled");
        return(NULL);
    }

    if(*new_folder == '\0')
      strcpy(new_folder, last_folder);

    dprint(2, (debugfile, "broach folder, name entered \"%s\"\n",new_folder));

    /*-- Just check that we can expand this. It gets done for real later --*/
    strcpy(expanded, new_folder);
    if (! expand_foldername(expanded)) {
        dprint(1, (debugfile,
                    "Error: Failed on expansion of filename %s (save)\n", 
    	  expanded));
        return(NULL);
    }

    *context = tc;
    return(new_folder);
}




/*----------------------------------------------------------------------
    Actually attempt to open given folder 

  Args: new_folder -- The folder name to open

 Result:  1 if the folder was successfully opened
          0 if the folder open failed and went back to old folder
         -1 if open failed and no folder is left open
      
  Attempt to open the folder name given. If the open of the new folder
  fails then the previously open folder will remain open, unless
  something really bad has happened. The designate inbox will always be
  kept open, and when a request to open it is made the already open
  stream will be used. Making a folder the current folder requires
  setting the following elements of struct pine: mail_stream, cur_folder,
  current_msgno, max_msgno. Attempting to reopen the current folder is a 
  no-op.

  The first time the inbox folder is opened, usually as Pine starts up,
  it will be actually opened.
  ----*/

do_broach_folder(new_folder, new_context) 
     char      *new_folder;
     CONTEXT_S *new_context;
{
    MAILSTREAM *m;
    int         open_inbox, rv;
    char        expanded_file[MAXPATH+1], *old_folder,*old_path, *p;
    long        openmode;

#ifdef	DOS
    openmode = OP_SHORTCACHE;
#else
    openmode = 0L;
#endif
#ifdef	DEBUG
    if(debug > 8)
      openmode |= OP_DEBUG;
#endif
    dprint(1, (debugfile, "About to open folder \"%s\"    inbox: \"%s\"\n",
	       new_folder, ps_global->inbox_name));

    /*----- Little to do to if reopening same folder -----*/
    if(new_context == ps_global->context_current && ps_global->mail_stream
       && strcmp(new_folder, ps_global->cur_folder) == 0)
      return(1);			/* successful open of same folder! */

    /*--- Set flag that we're opening the inbox, a special case ---*/
    /*
     * We want to know if inbox is being opened either by name OR
     * fully qualified path...
     */
    if(open_inbox = (strucmp(new_folder, ps_global->inbox_name) == 0
       || strcmp(new_folder, ps_global->VAR_INBOX_PATH) == 0)){
	new_context = ps_global->context_list; /* restore first context */

	/*
	 * IF we're asked to open inbox AND it's already open AND
	 * the only stream, just return ELSE fall thru and close 
	 * mail_stream returning with inbox_stream as new stream...
	 */
	if(ps_global->inbox_stream 
	   && (ps_global->inbox_stream == ps_global->mail_stream))
	  return(1);
    }

    /*
     * If ambiguous foldername (not fully qualified), make sure it's
     * not a nickname for a folder in the given context...
     */
    strcpy(expanded_file, new_folder); 	/* might get reset below */
    if(!open_inbox && new_context && context_isambig(new_folder)){
	if (p = folder_is_nick(new_folder, new_context->folders)){
	    strcpy(expanded_file, p);
	    dprint(2, (debugfile, "broach_folder: nickname for %s is %s\n",
		       expanded_file, new_folder));
	}
	else if ((new_context->use & CNTXT_INCMNG)
		 && (folder_index(new_folder, new_context->folders) < 0)){
	    q_status_message1(1, 2, 4,
			    "\007Can't find Incoming Folder %s.", new_folder);
	    return(0);
	}
    }

    /*--- Opening inbox, inbox has been already opened, the easy case ---*/
    if(open_inbox && ps_global->inbox_stream != NULL ) {
        expunge_and_close(ps_global->mail_stream, ps_global->cur_folder);

	ps_global->mail_stream              = ps_global->inbox_stream;
        ps_global->new_mail_count           = 0L;
        ps_global->expunge_count            = 0L;
        ps_global->last_msgno_flagged       = 0L;
        ps_global->mail_box_changed         = 0;
        ps_global->noticed_dead_stream      = 0;
        ps_global->noticed_dead_inbox       = 0;
        ps_global->dead_stream              = 0;
        ps_global->dead_inbox               = 0;
	mn_give(&ps_global->msgmap);
	ps_global->msgmap		    = ps_global->inbox_msgmap;
	ps_global->inbox_msgmap		    = NULL;

	dprint(7, (debugfile, "%ld %ld %x\n",
		   mn_get_cur(ps_global->msgmap),
                   mn_get_total(ps_global->msgmap),
		   ps_global->mail_stream));
	/*
	 * remember last context and folder
	 */
	if(context_isambig(ps_global->cur_folder)){
	    ps_global->context_last = ps_global->context_current;
	    strcpy(ps_global->context_current->last_folder,
		 ps_global->cur_folder);
	}

	strcpy(ps_global->cur_folder, ps_global->inbox_name);
	ps_global->context_current = ps_global->context_list;
        clear_index_cache();
        sort_current_folder();		/* MUST sort before restoring msgno! */
        q_status_message2(0, 1, 3, "Opened folder \"INBOX\" with %s message%s",
                          long2string(mn_get_total(ps_global->msgmap)),
                          mn_get_total(ps_global->msgmap) != 1 ? "s" : "" );
	return(1);
    }

    if(!new_context && ! expand_foldername(expanded_file))
      return(0);

    old_folder = NULL;
    old_path   = NULL;
    /*---- now close the old one we had open if there was one ----*/
    if(ps_global->mail_stream != NULL) {
        old_folder   = cpystr(ps_global->cur_folder);
        old_path     = cpystr(ps_global->mail_stream->mailbox);
	if(strcmp(ps_global->cur_folder, ps_global->inbox_name) == 0) {
	    /*-- don't close the inbox stream, save a bit of state --*/
	    if(ps_global->inbox_msgmap)
	      mn_give(&ps_global->inbox_msgmap);

	    ps_global->inbox_msgmap = ps_global->msgmap;
	    ps_global->msgmap       = NULL;

	    dprint(2, (debugfile,
		       "Close - saved inbox state: max %ld\n",
		       mn_get_total(ps_global->inbox_msgmap)));
	} else {
            expunge_and_close(ps_global->mail_stream, ps_global->cur_folder);
	}
    }

    q_status_message1(0, 1, 1, "Opening \"%s\"...", pretty_fn(new_folder));
    flush_status_messages();		/* So they see the message */

    /* 
     * if requested, make access to folder readonly (only once)
     */
    if (ps_global->open_readonly_on_startup) {
	openmode |= OP_READONLY ;
	ps_global->open_readonly_on_startup = 0 ;
    }

    /*
     * The name "inbox" is special, so treat it so 
     * (used to by handled by expand_folder)...
     */
    if(ps_global->nr_mode)
      ps_global->noshow_warn = 1;

      m = context_open((new_context && !open_inbox) ? new_context->context:NULL,
		     NULL, 
		     (open_inbox) ? ps_global->VAR_INBOX_PATH : expanded_file,
		     openmode);

    if(ps_global->nr_mode)
      ps_global->noshow_warn = 0;

    dprint(8, (debugfile, "Opened folder %p \"%s\" (context: \"%s\")\n",
               m, (m) ? m->mailbox : "nil",
	       (new_context) ? new_context->context : "nil"));

    /* Can get m != NULL if correct passwd for remote, but wrong name */
    if(m == NULL || ((p = strindex(m->mailbox, '<')) != NULL &&
                      strcmp(p + 1, "no_mailbox>") == 0)) {
	/*-- non-existent local mailbox, or wrong passwd for remote mailbox--*/
        /* fall back to currently open mailbox */
        rv = 0;
        dprint(8, (debugfile, "Old folder: \"%s\"\n",
               old_folder == NULL ? "" : old_folder));
        if(old_folder != NULL) {
            if(strcmp(old_folder, ps_global->inbox_name) == 0){
                ps_global->mail_stream = ps_global->inbox_stream;
		if(ps_global->msgmap)
		  mn_give(&ps_global->msgmap);

		ps_global->msgmap       = ps_global->inbox_msgmap;
		ps_global->inbox_msgmap = NULL;

                dprint(8, (debugfile, "Reactivate inbox %ld %ld %p\n",
                           mn_get_cur(ps_global->msgmap),
                           mn_get_total(ps_global->msgmap),
                           ps_global->mail_stream));
                strcpy(ps_global->cur_folder, ps_global->inbox_name);
            } else {
                ps_global->mail_stream = mail_open(NULL, old_path, openmode);
                /* mm_log will take care of error message here */
                if(ps_global->mail_stream == NULL) {
                    rv = -1;
                } else {
		    mn_init(&(ps_global->msgmap),
			    ps_global->mail_stream->nmsgs);
                    ps_global->expunge_count       = 0;
                    ps_global->new_mail_count      = 0;
                    ps_global->noticed_dead_stream = 0;
                    ps_global->dead_stream         = 0;
		    ps_global->last_msgno_flagged  = 0L;

		    clear_index_cache();
                    reset_check_point();
		    if(mn_get_total(ps_global->msgmap) > 0)
		      mn_set_cur(ps_global->msgmap, 1L);

                    q_status_message1(0, 1, 3, "Folder \"%s\" reopened",
                                      old_folder);
                }
            }

	    if(rv == 0)
	      mn_set_cur(ps_global->msgmap,
			 min(mn_get_cur(ps_global->msgmap), 
			     mn_get_total(ps_global->msgmap)));

            fs_give((void **)&old_folder);
            fs_give((void **)&old_path);
        } else {
            rv = -1;
        }
        if(rv == -1) {
            q_status_message(0, 2, 4, "\007No folder opened");
	    mn_set_total(ps_global->msgmap, 0L);
	    mn_set_cur(ps_global->msgmap, -1L);
            strcpy(ps_global->cur_folder, "");
        }
        return(rv);
    } else {
        if(old_folder != NULL) {
            fs_give((void **)&old_folder);
            fs_give((void **)&old_path);
        }
    }

    /*----- success in opening the new folder ----*/
    dprint(2, (debugfile, "Opened folder \"%s\" with %ld messages\n",
	       m->mailbox, m->nmsgs));


    /*--- A Little house keeping ---*/
    ps_global->mail_stream          = m;
    ps_global->expunge_count        = 0L;
    ps_global->new_mail_count       = 0L;
    ps_global->last_msgno_flagged   = 0L;
    ps_global->noticed_dead_stream  = 0;
    ps_global->noticed_dead_inbox   = 0;
    ps_global->dead_stream          = 0;
    ps_global->dead_inbox           = 0;
    mn_init(&(ps_global->msgmap), m->nmsgs);

    /*
     * remember old folder and context...
     */
    if(context_isambig(ps_global->cur_folder))
      strcpy(ps_global->context_current->last_folder,ps_global->cur_folder);

    strcpy(ps_global->cur_folder, (open_inbox) ? ps_global->inbox_name
					       : new_folder);
    if(new_context){
	ps_global->context_last    = ps_global->context_current;
	ps_global->context_current = new_context;
    }

    reset_check_point();

    /* UWIN doesn't want to see this message */
    if(!ps_global->nr_mode)
      q_status_message7(0, 2, 4, "%s \"%s\" opened with %s message%s%s",
			IS_NEWS(ps_global->mail_stream)
			  ? "News group" : "Folder",
			pretty_fn(new_folder),
			comatose(mn_get_total(ps_global->msgmap)),
			plural(mn_get_total(ps_global->msgmap)),
			READONLY_FOLDER ?" READONLY" : "",
			NULL, NULL);

    clear_index_cache();

    ps_global->mail_box_changed = 0;

    sort_current_folder();

    if(mn_get_total(ps_global->msgmap) > 0) {
        MsgNo first_unseen;
	if(ps_global->start_entry > 0) {
	    mn_set_cur(ps_global->msgmap,
		       min(ps_global->start_entry,
			   mn_get_total(ps_global->msgmap)));
	    ps_global->start_entry = 0;
	/* if it is an incoming mailbox, goto first unseen */
        }
	else if((open_inbox || IS_NEWS(ps_global->mail_stream)
		 || (context_isambig(ps_global->cur_folder)
		     && (ps_global->context_current->use&CNTXT_INCMNG)))
		&& (first_unseen=first_sorted_flagged(F_UNSEEN|F_UNDEL,m))>=0){
	    mn_set_cur(ps_global->msgmap, first_unseen);
	}
        else{
	    mn_set_cur(ps_global->msgmap,
		       mn_get_revsort(ps_global->msgmap)
		         ? 1L
			 : mn_get_total(ps_global->msgmap));
	}
    }
    else{
	mn_set_cur(ps_global->msgmap, -1L);
    }

    /*--- If we just opened the inbox remember it's special stream ---*/
    if(open_inbox && ps_global->inbox_stream == NULL)
      ps_global->inbox_stream = ps_global->mail_stream;
	
    return(1);
}


/*----------------------------------------------------------------------
      Expunge (if confirmed) and close a mail stream

    Args: stream   -- The MAILSTREAM * to close
          folder   -- The name the folder is know by 

   Result:  Mail box is expunged and closed. A message is displayed to
             say what happened
 ----*/
void
expunge_and_close(stream, folder)
     MAILSTREAM *stream;
     char *folder;
{
    long  delete_count, max_folder, seen_not_del, saved_msgs, i;
    char  prompt_b[MAX_SCREEN_COLS+1], short_folder_name[MAXFOLDER*2+1],
          temp[MAXFOLDER*2+1];
    CONTEXT_S *save_context;
    MESSAGECACHE *mc;
    struct variable *vars = ps_global->vars;
    int ret;

    if(stream != NULL) {
        dprint(2, (debugfile, "expunge and close mail stream \"%s\"\n",
                   stream->mailbox));

        if(!stream->readonly) {

            q_status_message1(0, 0, 1, "Closing \"%s\"...", folder);
	    display_message('x');

	    /* Save read messages? */
	    if(VAR_READ_MESSAGE_FOLDER && VAR_READ_MESSAGE_FOLDER[0]
	       && stream == ps_global->inbox_stream
	       && (seen_not_del = count_flagged(stream, "SEEN UNDELETED"))) {

	      if(F_OFF(F_AUTO_READ_MSGS,ps_global)) {
                sprintf(prompt_b,
                       "Save the %ld read message%s in \"%s\"",
                         seen_not_del, plural(seen_not_del),
                         VAR_READ_MESSAGE_FOLDER);
		ret = want_to(prompt_b, 'y', 0, NO_HELP, 0, 0);
	      }
	      if(F_ON(F_AUTO_READ_MSGS,ps_global) || ret == 'y') {
	        save_context = default_save_context(ps_global->context_list);
	        if(!save_context)
		  save_context = ps_global->context_list;

		FETCH_ALL_FLAGS(stream);
		saved_msgs = 0;
		for(i=1; i <= stream->nmsgs; i++) {
		  mc = mail_elt(stream, (long)i);
		  if(mc && mc->seen && !mc->deleted) {
		    /* saved, set deleted flag in inbox */
		    if(save(VAR_READ_MESSAGE_FOLDER, save_context, mc)) {
			mail_setflag(stream, long2string(i), "\\DELETED");
			saved_msgs++;
		    }
		    /* failure */
		    else {
		      if(saved_msgs > 0) {
                        q_status_message3(0, 2, 3,
	       "Saved %ld of %ld read messages, aborted after error on msg %ld",
			   (void *)saved_msgs, (void *)seen_not_del,
			   (void *)(i+1L));
		      }else {
                        q_status_message2(0, 2, 3,
				       "Unable to save %s read messages to %s",
					long2string(seen_not_del),
					VAR_READ_MESSAGE_FOLDER);
		      }
		      break;
		    }
		  }
		}
	      }
	    }

            delete_count = count_flagged(stream, "DELETED");
            if(delete_count != 0L)  {
                max_folder =    ps_global->ttyo->screen_cols - 50;
                strcpy(temp, pretty_fn(folder));
                if(strlen(temp) > max_folder){
                   strcpy(short_folder_name, "...");
                   strcat(short_folder_name,temp + strlen(temp) -max_folder);
                } else {
                   strcpy(short_folder_name, temp);
                }
                            
		if(F_OFF(F_AUTO_EXPUNGE,ps_global)) {
                  sprintf(prompt_b,
                       "Expunge the %ld deleted message%s from \"%s\"",
                       delete_count,
                         delete_count == 1 ? "" : "s",
                         short_folder_name);
		  ret = want_to(prompt_b, 'y', 0, NO_HELP, 0, 0);
		}
                if(F_ON(F_AUTO_EXPUNGE,ps_global) || ret == 'y'){
                    q_status_message4(0, 2, 3,
                       "Closing \"%s\". Keeping %s message%s and deleting %s",
                                      pretty_fn(folder),
                                      comatose((stream->nmsgs - delete_count)),
                                      plural(stream->nmsgs - delete_count),
                                      long2string(delete_count));
                    display_message('q'); /* So they see the message */
                    mail_expunge(stream);
                } else {
                    q_status_message3(0, 2, 3,
                             "Closing folder \"%s\". Keeping all %s message%s",
                                   pretty_fn(folder), comatose(stream->nmsgs),
                                      plural(stream->nmsgs));
                    display_message('q'); /* So they see the message */
                }
            } else {
                q_status_message3(0, 2, 3,
                            "Closing folder \"%s\". Keeping all %s message%s",
                             pretty_fn(folder), comatose(stream->nmsgs),
                                  plural(stream->nmsgs));
                display_message('q'); /* So they see the message */	
            }
        } else {
            if(IS_NEWS(stream))
	      q_status_message1(0, 2, 3, "Closing news group \"%s\"",
			       pretty_fn(folder));
            else
              q_status_message1(0, 2, 3,
                       "Closing read-only folder \"%s\". No changes to save",
                              pretty_fn(folder));
            display_message('q');
        }
    }
    mail_close(stream);
}



/*----------------------------------------------------------------------
      Search the message headers as display in index
 
  Args: command_line -- The screen line to prompt on
        msg          -- The current message number to start searching at
        max_msg      -- The largest message number in the current folder

  The headers are searched exactly as they are displayed on the screen. The
search will wrap around to the beginning if not string is not found right 
away.
  ----*/
void
search_headers(stream, command_line, msgmap)
     MAILSTREAM *stream;
     int         command_line;
     MSGNO_S    *msgmap;
{
    int         rc, select_all = 0;
    long        i, sorted_msg, selected = 0L;
    char        prompt[MAX_SEARCH+50], new_string[MAX_SEARCH+1];
    HelpType	help;
    static char search_string[MAX_SEARCH+1] = { '\0' };
    static ESCKEY_S header_search_key[] = { {0, 0, NULL, NULL },
					    {ctrl('Y'), 10, "^Y", "First Msg"},
					    {ctrl('V'), 11, "^V", "Last Msg"},
					    {-1, 0, NULL, NULL} };

    dprint(4, (debugfile, "\n - search headers - \n"));

    if(mn_get_total(msgmap) < 1L){
	q_status_message(0, 0, 2, "\007No messages to search");
	return;
    }
    else if(mn_total_cur(msgmap) > 1L){
	q_status_message1(0, 0, 2, "%s msgs selected; Can't search",
			  comatose(mn_total_cur(msgmap)));
	return;
    }
    else
      sorted_msg = mn_get_cur(msgmap);

    help = NO_HELP;
    new_string[0] = '\0';

    while(1) {
	sprintf(prompt, "Word to %s [%s] : ", 
		select_all ? "match for inclusion in selected" : "search for",
		search_string);

	if(F_ON(F_ENABLE_AGG_OPS, ps_global)){
	    header_search_key[0].ch    = ctrl('X');
	    header_search_key[0].rval  = 12;
	    header_search_key[0].name  = "^X";
	    header_search_key[0].label = select_all ? "Goto Match"
						    : "Add to Selected";
	}
	else{
	    header_search_key[0].ch   = header_search_key[0].rval  = 0;
	    header_search_key[0].name = header_search_key[0].label = NULL;
	}
	
        rc = optionally_enter(new_string, command_line, 0, MAX_SEARCH, 1,
			      0, prompt, header_search_key, help, 0);

        if(rc == 3) {
            help = NO_HELP;
            continue;
        }
	else if(rc == 10){
	    q_status_message(0, 1, 3, "Searched to First Message.");
	    sorted_msg = (mn_get_total(msgmap) > 0L) ? 1L : 0L;
	    mn_set_cur(msgmap, sorted_msg);
	    return;
	}
	else if(rc == 11){
	    q_status_message(0, 1, 3, "Searched to Last Message.");
	    sorted_msg = mn_get_total(msgmap);
	    mn_set_cur(msgmap, sorted_msg);
	    return;
	}
	else if(rc == 12){
	    select_all = !select_all;
	    continue;
	}

        if(rc != 4)			/* redraw */
          break; /* redraw */
    }

    if(rc == 1 || (new_string[0] == '\0' && search_string[0] == '\0')) {
        q_status_message(0, 0, 2, "\007Search cancelled");
        return;
    }

    if(new_string[0] == '\0')
        strcpy(new_string, search_string);

    strcpy(search_string, new_string);

    for(i = sorted_msg + ((select_all)?0:1); i <= mn_get_total(msgmap); i++) {
        if(!get_flag(stream, msgmap, i, MN_HIDE) &&
	   srchstr(build_header_line(stream, msgmap, i)->line, search_string)){
	    if(select_all){
		set_flag(stream, msgmap, i, MN_TEMP, 1);
		selected++;
	    }
	    else
	      goto found;
	}
    }

    for(i = 1; i < sorted_msg; i++) {
        if(!get_flag(stream, msgmap, i, MN_HIDE) &&
	   srchstr(build_header_line(stream, msgmap, i)->line, search_string)){
	    if(select_all){
		set_flag(stream, msgmap, i, MN_TEMP, 1);
		selected++;
	    }
	    else
	      goto found;
	}
    }

    if(!select_all){
	q_status_message(0, 1, 3, "\007Word not found");
	return;
  found:
	q_status_message1(0, 1, 3, "Word found%s", i > sorted_msg ? "" :
			  ". Search wrapped to beginning"); 
	mn_set_cur(msgmap, i);
    }
    else{
	q_status_message1(0, 1, 3, "%s messages found matching word",
			  long2string(selected));
    }
}



/*----------------------------------------------------------------------
    Print current message[s]



 Filters the original header and sends stuff to printer
  ---*/
void
cmd_print(state, msgmap, agg)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  agg;
{
    char      prompt[30];
    long      i, raw_msgno;
    int	      opened;
    ENVELOPE *e;
    BODY     *b;

    if(agg && !pseudo_selected("PRINT", msgmap, &raw_msgno))
      return;

    if((i = mn_total_cur(msgmap)) > 1L)
      sprintf(prompt, "%s messages ", long2string(i));
    else
      sprintf(prompt, "message %s ", long2string(mn_get_cur(msgmap)));

    if(opened = (open_printer(prompt) == 0))
      for(i = mn_first_cur(msgmap); i > 0L; i = mn_next_cur(msgmap))
	if(!(e=mail_fetchstructure(state->mail_stream,mn_m2raw(msgmap,i),&b))
	   || !format_message(mn_m2raw(msgmap, mn_get_cur(msgmap)), e, b,
			      (FM_NEW_MESS|FM_DO_PRINT), print_char)){
	    q_status_message(0, 1, 3, "\007Error printing message");
	    break;
	}

    if(opened)
      close_printer();

    if(agg && raw_msgno){			/* restore array */
	i = mn_raw2m(msgmap, raw_msgno);
	mn_reset_cur(msgmap, i);
    }
}



/*----------------------------------------------------------------------
    Pipe message number "m"

   Args: state -- various pine state bits
	 msmap -- Message number mapping table to pipe.

   Filters the original header and sends stuff to specified command
  ---*/
void
cmd_pipe(state, msgmap, agg)
     struct pine *state;
     MSGNO_S *msgmap;
     int	  agg;
{
    ENVELOPE      *e;
    BODY	  *b;
    PIPE_S	  *syspipe;
    char          *resultfilename = NULL ;
    int            done = 0;
    long           i, raw_msgno;

    if(ps_global->restricted){
	q_status_message(0,2,2 ,"\007Pine demo can't pipe messages");
	return;
    }

    if(agg && !pseudo_selected("PIPE", msgmap, &raw_msgno))
      return;

    while (!done) {
	switch(optionally_enter(ps_global->pipe_command, -3, 0, MAXPATH, 1, 0,
				"Pipe message to : ", NULL, NO_HELP, 0)){
	  case -1 :
	    q_status_message(0,2,2 ,"\007Internal problem encountered");
	    done++;
	    break;
      
	  case 0 :
	    if(syspipe = open_system_pipe(ps_global->pipe_command,
					  &resultfilename, PIPE_USER)){
		gf_io_t pc;		/* wire up a generic putchar */

		gf_set_writec(&pc, syspipe->ifile, 0L, FileStar);
		for(i = mn_first_cur(msgmap); i > 0L; i = mn_next_cur(msgmap)){
		    if (ps_global->full_header) {
			gf_puts(mail_fetchheader(ps_global->mail_stream, 
						 mn_m2raw(msgmap, i)), pc);
			gf_puts(mail_fetchtext(ps_global->mail_stream,
					       mn_m2raw(msgmap, i)), pc);
		    } else {
			e = mail_fetchstructure(ps_global->mail_stream,
						mn_m2raw(msgmap, i), &b);
	  
			if(!format_message(mn_m2raw(msgmap, i), e, b,
					   (FM_NEW_MESS), pc)){
			    q_status_message(0, 1, 3,
					     "\007Error piping message");
			    done++;
			    break;
			}
		    }
		}

		close_system_pipe(&syspipe);
		if(!done)		/* only display if no error */
		  display_system_pipe_output(resultfilename, "PIPE MESSAGE");

		fs_give((void **)&resultfilename);
	    } else {
		q_status_message(0,2,2, "\007Error opening pipe") ;
	    }
	    done++;
	    break;   

	  case 1 :
	    q_status_message(0,2,2 ,"\007Pipe cancelled");
	    done++;
	    break;

	  case 2 :                              /* no place to escape to */
	  case 3 :                              /* no help yet   */
	  case 4 :                              /* can't suspend */
	  default :
	    break;   
	}
    }

    ps_global->mangled_footer = 1;
    if(agg && raw_msgno){			/* restore old array */
	i = mn_raw2m(msgmap, raw_msgno);
	mn_reset_cur(msgmap, i);
    }
}




/*----------------------------------------------------------------------

  ----*/        
void
pipe_attachment(msgno, a)
     long      msgno;
     ATTACH_S *a;
{
  char   *err;
  char   *resultfilename = NULL ;
  char    prompt[80] ;
  int     done = 0 ;
  PIPE_S *syspipe;

  if(ps_global->restricted){
      q_status_message(0,2,2 ,"\007Pine demo can't pipe attachments");
      return;
  }

  sprintf(prompt, "Pipe attachment %s to : ", a->number) ;
  while(!done) {
    flush_status_messages() ;
    switch(optionally_enter(ps_global->pipe_command, -3, 0, MAXPATH, 1, 0, 
			    prompt, NULL, NO_HELP, 0)){
    case -1 :
      q_status_message(0,2,2 ,"\007Internal problem encountered");
      done++;
      break;
      
    case 0 :
      if(syspipe = open_system_pipe(ps_global->pipe_command,
				    &resultfilename, PIPE_USER)){
	  gf_io_t pc;		/* wire up a generic putchar */
	  gf_set_writec(&pc, syspipe->ifile, 0L, FileStar);

	  /*------ Write the image to a temporary file ------*/
	  err = detach(ps_global->mail_stream, msgno, a->body, a->number,
		       (long *)NULL, pc, NULL);
	  if(err)
	    q_status_message1(1,3,5,"\007Error detaching for pipe: %s",err);

	  close_system_pipe(&syspipe);
	  if(err)
	    unlink(resultfilename);
	  else
	    display_system_pipe_output(resultfilename, "PIPE ATTACHMENT");

	  fs_give((void **)&resultfilename);
      } else {
	  q_status_message(0,2,2, "\007Error opening pipe") ;
      }
      done++;
      break;

    case 1 :
      q_status_message(0,2,2 ,"\007Pipe cancelled");
      done++;
      break;
      
    case 2 :                              /* no place to escape to */
    case 3 :                              /* no help yet   */
    case 4 :                              /* can't suspend */
      default :
	break;   
    }
  }
}



/*----------------------------------------------------------------------
 Prompt the user for the type of sort desired

   Args: none
   Returns: 0 if search OK (matching numbers selected by side effect)
            1 if there's a problem

  ----*/
void
aggregate_select(state, msgmap, q_line)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  q_line;
{
    long       i, diff, old_tot, old_msg;
    int        q = 0, rv = 0, hidden;
    HelpType   help = NO_HELP;
    MSGNO_S   *msgs = NULL;
    extern     MAILSTREAM *mm_search_stream;
    extern     MSGNO_S *mm_search_map, *mm_exclude_map;
    extern     int mm_search_count;

    hidden           = any_flagged(state->mail_stream, msgmap, MN_HIDE) > 0L;
    mm_search_stream = state->mail_stream;
    mm_search_count  = 0;
    mm_exclude_map   = NULL;
    mm_search_map    = msgmap;
    old_msg          = mn_get_cur(msgmap);
    diff = 0L;				/* fake the selected array */
    for(i = 1L; i <= mn_get_total(msgmap); i++){
	if(get_flag(state->mail_stream, msgmap, i, MN_TEMP)){
	    if(!diff++){
		mn_set_cur(msgmap, i);
	    }
	    else{
		mn_add_cur(msgmap, i);
	    }
	}
    }

    if(old_tot = any_flagged(state->mail_stream, msgmap, MN_TEMP)){
	sel_opts1[2].label = (get_flag(state->mail_stream,
				       msgmap, old_msg, MN_TEMP))
				? "unselect Cur" : "select Cur";
	sel_opts2[4].ch = -1;		/* disable extra options */
	sel_opts2[5].ch = -1;
	sel_opts1[4].ch = (ps_global->ops_under_apply) ? 'd' : -1;

	switch(q = radio_buttons(
			 (ps_global->ops_under_apply) ? sel_pmt1x : sel_pmt1,
				 q_line,0,sel_opts1,'c','x',0,help)){
	  case 'n' :			/* narrow selection */
	    mm_exclude_map = msgmap;
	    mn_init(&msgs, 0L);		/* note: msgs only used for its... */
	    mm_search_map  = msgs;	/* select array */

	  case 'b' :			/* broaden selection */
	    q = 0;
	    break;

	  case 'd':
	    mn_reset_cur(msgmap, old_msg);
	    apply_command(state, msgmap, q_line);
	    return;

	  case 'c' :			/* Un/Select Current */
	  case 'a' :			/* Unselect All */
	  case 'x' :			/* cancel */
	  default :
	    break;
	}
    }
    else{
	sel_opts2[4].ch = 'c';		/* enable extra options */
	sel_opts2[5].ch = 'a';
	mn_init(&msgs, 0L);		/* note: msgs only used for its... */
	mm_search_map  = msgs;		/* select array */
    }

    if(!q)
      q = radio_buttons(sel_pmt2, q_line, 0, sel_opts2, 'c', 'x', 0, help);

    switch(q){
      case 'x':				/* cancel */
	q_status_message(0,1,2,"\007Select command cancelled");
	mn_reset_cur(msgmap, old_msg);
	if(msgs && msgs != msgmap)
	  mn_give(&msgs);

	return;

      case 'c' :			/* select/unselect current */
	mn_reset_cur(msgmap, old_msg);
	if(msgs && msgs != msgmap)
	  mn_give(&msgs);

	i = mn_get_cur(msgmap);
	if(get_flag(state->mail_stream, msgmap, i, MN_TEMP)){ /* set?  unset */
	    set_flag(state->mail_stream, msgmap, i, MN_TEMP, 0);
	    if(hidden){
		set_flag(state->mail_stream, msgmap, i, MN_HIDE, 1);
		/*
		 * See if there's anything left to zoom on.  If so, 
		 * pick an adjacent one for highlighting, else make
		 * sure nothing is left hidden...
		 */
		if(any_flagged(state->mail_stream, msgmap, MN_TEMP)){
		    mn_inc_cur(state->mail_stream, msgmap);
		    if(mn_get_cur(msgmap) == old_msg)
		      mn_dec_cur(state->mail_stream, msgmap);
		}
		else{			/* clear all hidden flags */
		    for(i = 1L; i <= mn_get_total(msgmap); i++)
		      set_flag(state->mail_stream, msgmap, i, MN_HIDE, 0);
		}
	    }
	}
	else
	  set_flag(state->mail_stream, msgmap, i, MN_TEMP, 1);

	return;

      case 'a' :			/* select/unselect all */
	mn_reset_cur(msgmap, old_msg);
	if(msgs && msgs != msgmap)
	  mn_give(&msgs);

	old_msg = any_flagged(state->mail_stream, msgmap, MN_TEMP);
	diff    = (!old_msg) ? mn_get_total(msgmap) : 0L;

	for(i = 1L; i <= mn_get_total(msgmap); i++){
	    if(old_msg){		/* unmark 'em all */
		if(get_flag(state->mail_stream, msgmap, i, MN_TEMP)){
		    diff++;
		    set_flag(state->mail_stream, msgmap, i, MN_TEMP, 0);
		}
		else if(hidden)
		  set_flag(state->mail_stream, msgmap, i, MN_HIDE, 0);
	    }
	    else			/* mark 'em all */
	      set_flag(state->mail_stream, msgmap, i, MN_TEMP, 1);
	}

	q_status_message4(0,0,2,"%s%ld message%s %sselected",
			  old_msg ? "" : "All ", (void *) diff, 
			  plural(diff), old_msg ? "UN" : "");
	return;

      case 'n' :			/* Select by Number */
	rv = select_number(state->mail_stream, msgmap, old_msg);
	break;

      case 'd' :			/* Select by Date */
	rv = select_date(state->mail_stream, msgmap, old_msg);
	break;

      case 't' :			/* Text */
	rv = select_text(state->mail_stream, msgmap, old_msg);
	break;

      case 's' :			/* Status */
	rv = select_flagged(state->mail_stream, msgmap, old_msg);
	break;

      default :				/* no op */
	break;
    }

    /*
     * On the surface, you'd think building the selected array 
     * above and taking it apart down here is kind of dumb.  But it snot!
     * Since the flag indicating selectedness is in an unused elt bit,
     * we can't set/unset those bits in the mm_searched callback with
     * set_flag (which in turn calls) mail_elt.  The ol' c-client isn't
     * reentrant.  So, we build the array of what's to be selected above,
     * and then set the appropriate flags here...
     */
    if(!msgs)			/* replace global map with new one */
      msgs = msgmap;

    if(!rv){
	if(mm_search_count && mm_exclude_map && mm_exclude_map != msgs){
	    for(i = mn_first_cur(mm_exclude_map); i > 0L;
		i = mn_next_cur(mm_exclude_map)){
		/*
		 * if the message number is current in the "msgs" set,
		 * then it's still selected so don't unflag it...
		 */
		if(!mn_is_cur(msgs, i)){
		    set_flag(state->mail_stream,mm_exclude_map,i,MN_TEMP,0);

		    /*
		     * if others hidden, then flag the one we just unselected
		     * as hidden.  If we hid the current message, pick
		     * a new one...
		     */
		    if(hidden){
			set_flag(state->mail_stream, mm_exclude_map, i, 
				 MN_HIDE, 1);
			if(i == old_msg){
			    mn_inc_cur(state->mail_stream, msgmap);
			    if(mn_get_cur(msgmap) == old_msg)
			      mn_dec_cur(state->mail_stream, msgmap);

			    old_msg = mn_get_cur(msgmap);
			}
		    }
		}
	    }
	}

	for(i = mn_first_cur(msgs); i > 0L; i = mn_next_cur(msgs)){
	    if(!get_flag(state->mail_stream, msgmap, i, MN_TEMP)){
		set_flag(state->mail_stream, msgmap, i, MN_TEMP, 1);
		if(hidden)
		  set_flag(state->mail_stream, msgmap, i, MN_HIDE, 0);
	    }
	}
    }

    if(msgs && msgs != msgmap)
      mn_give(&msgs);

    mn_reset_cur(msgmap, old_msg);

    if(rv)				/* bad return value.. */
      return;				/* error already displayed */

    if(!mm_search_count)
      q_status_message(0,1,2,
		       "\007Apply failed!  No new messages selected.");
    else if(diff = (any_flagged(state->mail_stream, msgmap, MN_TEMP)-old_tot))
      q_status_message4(0,1,2,
		      "Apply matched %ld messages! %ld %s messages %sselected",
			(void *)mm_search_count,
			(void *)((diff > 0) ? diff : -diff),
			(diff > 0) ? "new" : "old",
			(diff > 0) ? "" : "de-");
    else
      q_status_message(0,1,2,"\007Only one message selected!");
}



/*----------------------------------------------------------------------
 Prompt the user for the command to perform on selected messages

   Args: state -- pointer pine's state variables
	 msgmmap -- message collection to operate on
	 q_line -- line on display to write prompts
   Returns: with the selected messages suitably commanded
            

  ----*/
void
apply_command(state, msgmap, q_line)
     struct pine *state;
     MSGNO_S     *msgmap;
     int	  q_line;
{
    int i = 8;
    HelpType   help = NO_HELP;

    if(F_ON(F_ENABLE_FLAG,state)){ /* flag? */
	sel_opts3[i].ch      = '*';
	sel_opts3[i].rval    = '*';
	sel_opts3[i].name    = "*";
	sel_opts3[i++].label = "Flag";
    }

    if(F_ON(F_ENABLE_PIPE,state)){ /* pipe? */
	sel_opts3[i].ch      = '|';
	sel_opts3[i].rval    = '|';
	sel_opts3[i].name    = "|";
	sel_opts3[i++].label = "Pipe";
    }

    sel_opts3[i].ch = -1;
    switch(radio_buttons(sel_pmt3,q_line,0,sel_opts3,0,'x',0,help)){
      case 'd' :			/* delete */
	cmd_delete(state, msgmap, 1);
	break;

      case 'u' :			/* undelete */
	cmd_undelete(state, msgmap, 1);
	break;

      case 'r' :			/* reply */
	cmd_reply(state, msgmap, 1);
	break;

      case 'f' :			/* Forward */
	cmd_forward(state, msgmap, 1);
	break;

      case 'y' :			/* prYnt */
	cmd_print(state, msgmap, 1);
	break;

      case 't' :			/* take address */
	cmd_take_addr(state, msgmap, 1);
	break;

      case 's' :			/* save */
	cmd_save(state, msgmap, q_line, 1);
	break;

      case 'e' :			/* export */
	cmd_export(state, msgmap, q_line, 1);
	break;

      case '|' :			/* pipe */
	cmd_pipe(state, msgmap, 1);
	break;

      case '*' :			/* flag */
	cmd_flag(state, msgmap, 1);
	break;
#ifdef	LATER
      case 'b' :			/* bounce */
	cmd_bounce(state, msgmap, 1);
	break;
#endif
      case 'x' :			/* cancel */
	q_status_message(0,1,2,"\007Apply command cancelled");
	break;

	default:
	break;
    }
}



/*----------------------------------------------------------------------
 Prompt the user for the type of sort he desires

   Args: none
   Returns: 0 if search OK (matching numbers selected by side effect)
            1 if there's a problem

  ----*/
int
select_number(stream, msgmap, msgno)
     MAILSTREAM *stream;
     MSGNO_S    *msgmap;
     long	 msgno;
{
    int r;
    long n1, n2;
    char number1[16], number2[16], numbers[80], *p, *t;

    numbers[0] = '\0';
    ps_global->mangled_footer = 1;
    while(1){
        r = optionally_enter(numbers, -3, 0, 79, 1, 0,
                             select_num, NULL, NO_HELP, 0);
        if(r == 3 || r == 4)
	  continue;

	for(t = p = numbers; *p ; p++)	/* strip whitespace */
	  if(!isspace(*p))
	    *t++ = *p;

	*t = '\0';

        if(r == 1 || numbers[0] == '\0'){
	    q_status_message(0,0,2,"\007Apply selection by number cancelled");
	    return(1);
        }
	else
	  break;
    }

    for(p = numbers; *p ; p++){
	t = number1;
	while(*p && isdigit(*p))
	  *t++ = *p++;

	*t = '\0';
	if((n1 = atol(number1)) < 1L || n1 > mn_get_total(msgmap)){
	    q_status_message1(0,1,2,"\007%ld out of message number range",
			      (void *)n2);
	    return(1);
	}

	t = number2;
	if(*p && *p == '-'){
	    while(*++p && isdigit(*p))
	      *t++ = *p;

	    *t = '\0';
	    if((n2 = atol(number2)) < 1L 
	       || n2 > mn_get_total(msgmap)){
		q_status_message1(0,1,2,"\007%ld out of message number range",
				  (void *)n2);
		return(1);
	    }

	    if(n2 <= n1){
		q_status_message(0,1,2,"\007Invalid message number range");
		break;
	    }

	    for(;n1 <= n2; n1++)
	      mm_searched(stream, mn_m2raw(msgmap, n1));
	}
	else
	  mm_searched(stream, mn_m2raw(msgmap, n1));

	if(*p == '\0')
	  break;
    }
    
    return(0);
}



/*----------------------------------------------------------------------
 Prompt the user for the type of sort he desires

   Args: none
   Returns: 0 if search OK (matching numbers selected by side effect)
            1 if there's a problem

  ----*/
int
select_date(stream, msgmap, msgno)
     MAILSTREAM *stream;
     MSGNO_S    *msgmap;
     long	 msgno;
{
    int r;
    char *drange, date[32], prompt[128];

    date[0] = '\0';
    r = radio_buttons(sel_date, -3, 0, sel_date_opt, 'o', 'x', 0, NO_HELP);

    if(r != 'x'){
	ps_global->mangled_footer = 1;
	drange = (r == 'b') ? "BEFORE" : (r == 's') ? "SINCE" : "ON";

	while(1){
	    sprintf(prompt,"Select messages dated %s (eg: 10-DEC-93): ",
		    drange);
	    r = optionally_enter(date,-3,0,31,1,0,prompt,NULL,NO_HELP,0);
	    if(r == 3 || r == 4)
	      continue;

	    removing_leading_white_space(date);
	    removing_trailing_white_space(date);
	    if(r == 1 || date[0] == '\0')
	      r = 'x';

	    break;
	}
    }

    if(r == 'x'){
	q_status_message(0,0,2,"\007Apply selection by date cancelled");
	return(1);
    }

    sprintf(prompt, "%s %s", drange, date);
    mail_search(stream, prompt);
    return(0);
}



/*----------------------------------------------------------------------
 Prompt the user for the type of sort he desires

   Args: none
   Returns: 0 if search OK (matching numbers selected by side effect)
            1 if there's a problem

  ----*/
int
select_text(stream, msgmap, msgno)
     MAILSTREAM *stream;
     MSGNO_S    *msgmap;
     long	 msgno;
{
    int       r;
    char     *sval = NULL, sstring[80], prompt[128];
    ESCKEY_S  ekey[3];
    ENVELOPE *env = NULL;

    ps_global->mangled_footer = 1;

    /*
     * prepare some friendly defaults...
     */
    ekey[1].ch   = -1;
    ekey[2].ch   = -1;
    switch(r = radio_buttons(sel_text,-3,0,sel_text_opt,'s','x',0,NO_HELP)){
      case 't' :			/* address fields, offer To or From */
      case 'f' :
      case 'c' :
	sval          = (r == 't') ? "TO" : (r == 'f') ? "FROM" : "CC";
	ekey[0].ch    = ctrl('T');
	ekey[0].name  = "^T";
	ekey[0].rval  = 10;
	ekey[0].label = "Cur To";
	ekey[1].ch    = ctrl('R');
	ekey[1].name  = "^R";
	ekey[1].rval  = 11;
	ekey[1].label = "Cur From";
	break;

      case 's' :
	sval          = "SUBJECT";
	ekey[0].ch    = ctrl('X');
	ekey[0].name  = "^X";
	ekey[0].rval  = 13;
	ekey[0].label = "Cur Subject";
	break;

      case 'a' :
	sval = "TEXT";			/* fall thru */
      default :
	ekey[0].ch = -1;
	break;
    }

    if(ekey[0].ch > -1 && msgno > 0L
       && !(env = mail_fetchstructure(stream, mn_m2raw(msgmap, msgno), NULL)))
      ekey[0].ch = -1;

    sstring[0] = '\0';
    while(r != 'x'){
	sprintf(prompt, "String in message %s to match : ", sval ? sval : "");
	switch(r=optionally_enter(sstring,-3,0,79,1,0,prompt,ekey,NO_HELP,0)){
	  case 3 :
	  case 4 :
	    continue;

	  case 10 :			/* To: default */
	    if(env && env->to && env->to->mailbox)
	      sprintf(sstring, "%.30s%s%.40s", env->to->mailbox,
		      env->to->host ? "@" : "",
		      env->to->host ? env->to->host : "");

	    continue;
	  case 11 :			/* From: default */
	    if(env && env->from && env->from->mailbox)
	      sprintf(sstring, "%.30s%s%.40s", env->from->mailbox,
		      env->from->host ? "@" : "",
		      env->from->host ? env->from->host : "");

	    continue;
	  case 12 :			/* Cc: default */
	    if(env && env->cc && env->cc->mailbox)
	      sprintf(sstring, "%.30s%s%.40s", env->cc->mailbox,
		      env->cc->host ? "@" : "",
		      env->cc->host ? env->cc->host : "");

	    continue;
	  case 13 :			/* Subject: default */
	    if(env && env->subject && env->subject[0])
	      sprintf(sstring, "%.70s", env->subject);

	    continue;
	  default :
	    removing_leading_white_space(sstring);
	    removing_trailing_white_space(sstring);
	    break;
	}

	if(r == 1 || sstring[0] == '\0')
	  r = 'x';

	break;
    }

    if(r == 'x'){
	q_status_message(0,0,2,"\007Apply selection text match cancelled");
	return(1);
    }

    sprintf(prompt, "%s %s%s%s", sval ? sval : "", 
	    (r != 'r' && strindex(sstring, ' ')) ? "\"" : "",
	    sstring,
	    (r != 'r' && strindex(sstring, ' ')) ? "\"" : "");
    mail_search(stream, prompt);
    return(0);
}



/*----------------------------------------------------------------------
 Prompt the user for the type of sort he desires

   Args: none
   Returns: 0 if search OK (matching numbers selected by side effect)
            1 if there's a problem

  ----*/
int
select_flagged(stream, msgmap, msgno)
     MAILSTREAM *stream;
     MSGNO_S    *msgmap;
     long	 msgno;
{
    int  s, not = 0;

    while(1){
	s = radio_buttons((not) ? sel_flag_not : sel_flag,
			  -3, 0, sel_flag_opt, 'i', 'x', 0, NO_HELP);
	if(s == 'x'){
	    q_status_message(0,0,2,"\007Apply flagged selection cancelled");
	    return(1);
	}
	else if(s == '!')
	  not = !not;
	else
	  break;
    }

    mail_search(stream,
		     (s == 'n') ? (not) ? "SEEN UNDELETED"
					: "UNSEEN UNDELETED UNANSWERED" :
			(s == 'd') ? (not) ? "UNDELETED"
					   : "DELETED" :
			   (s == 'a') ? (not) ? "SEEN UNANSWERED UNDELETED" 
					      : "ANSWERED UNDELETED" :
			      (not) ? "UNFLAGGED" : "FLAGGED");

    return(0);
}



/*----------------------------------------------------------------------
   Prompt the user for the type of sort he desires

Args: q1 -- Line to prompt on

  ----*/
void
select_sort(state, ql)
     struct pine *state;
     int ql;
{
    char      prompt[200], tmp[3], *p;
    int       s, i;
    int       deefault = 'a';
    HelpType  help;
    ESCKEY_S  sorts[10];

    /*----- String together the prompt ------*/
    tmp[1] = '\0';
    strcpy(prompt, "Choose type of sort, or Reverse current sort : ");
    for(i = 0; state->sort_types[i] != EndofList && i < 8; i++) {
	sorts[i].rval	   = i;
	p = sorts[i].label = sort_name(state->sort_types[i]);
	while(*(p+1) && islower(*p))
	  p++;

	sorts[i].ch   = tolower(tmp[0] = *p);
	sorts[i].name = cpystr(tmp);

        if(mn_get_sort(state->msgmap) == state->sort_types[i])
	  deefault = sorts[i].rval;
    }

    sorts[i].ch     = 'r';
    sorts[i].rval   = 'r';
    sorts[i].name   = cpystr("R");
    sorts[i].label  = "Reverse";
    sorts[++i].ch   = -1;
    help = h_select_sort;

    if((s = radio_buttons(prompt,ql,0,sorts,deefault,'x',0,help)) != 'x'){
	if(s == 'r'){
	    mn_set_revsort(state->msgmap, !mn_get_revsort(state->msgmap));
	}
	else
	  mn_set_sort(state->msgmap, state->sort_types[s]);
    }
    else
      Writechar('\007', 0);

    while(--i >= 0)
      fs_give((void **)&sorts[i].name);

    blank_keymenu(ps_global->ttyo->screen_rows - 2, 0);
}



ATTACH_S *
attachments(qline)
     int           qline;
{
    char      prompt[100], section[100];
    HelpType  help;
    int       r;
    ATTACH_S *a;
    
    for(a = ps_global->atmts; (a+1)->description != NULL; a++);

    sprintf(prompt, "Enter attachment number to view or save (%s - %s) : ",
            ps_global->atmts->number, a->number);
            
    section[0] = '\0';
    help       = NO_HELP;
    while(1) {
        r = optionally_enter(section, qline, 0, sizeof(section), 1, 0,
                             prompt, NULL, help, 0);
        if(r == 3) {
            help = NO_HELP;
            continue;
        }

        if(r == 1 || section[0] == '\0') {
            q_status_message(0, 0, 2, "\007Attachment cancelled");
            return(NULL);
        }
        removing_trailing_white_space(section);
        removing_leading_white_space(section);
        for(a = ps_global->atmts; a->description != NULL ; a++)
          if(strcmp(section, a->number) == 0)
            break;

        if(a->description == NULL) {
            q_status_message1(1, 2, 4,
             "\007No such attachment number \"%s\". Must be in displayed list",
                              section);
            display_message('x');
            sleep(3);
            continue;
        }

        if(r != 4) /* redraw */
          break; /* redraw */
    }

    return(a);
}


/*----------------------------------------------------------------------
  detach the given body part using the given encoding
  returns: NULL on success, error message otherwise
  ----*/
char *
detach(stream, msg_no, body, part_no, len, pc, aux_filters)
     MAILSTREAM *stream;		/* c-client stream to use         */
     long        msg_no;		/* message number to deal with	  */
     BODY       *body;			/* body pointer 		  */
     char       *part_no;		/* part number of message 	  */
     long       *len;			/* returns bytes read in this arg */
     gf_io_t     pc;			/* where to put it		  */
     filter_t   *aux_filters;		/* null terminated array of filts */
{
    unsigned long  length, rv;
    char          *status, *contents;
    gf_io_t        gc;
    SourceType     src = CharStar;
    static char    err_string[100];
#ifdef	DOS
    extern unsigned char  *xlate_to_codepage;
#endif

    err_string[0] = '\0';

#ifdef	DOS
    if(body->size.bytes > MAX_MSG_INCORE || !strcmp(stream->dtb->name,"nntp")){
	src      = FileStar;
	mailgets = dos_gets;
    }
    else
      mailgets = NULL;
#endif	/* DOS */

    /*
     * go grab the requested body part
     */
    contents = mail_fetchbody(stream, msg_no, part_no, &length);
    if(contents == NULL) {
#ifdef	DOS
        mailgets = NULL;
#endif
	sprintf(err_string, "Unable to access body part %s", part_no);
	if (len != (long *)NULL)
	    *len = 0;
	return(err_string);
    }

    rv = (length) ? length : 1;

    gf_filter_init();			/* prepare to filter it! */

    switch(body->encoding) {		/* handle decoding */
      case ENC7BIT:
      case ENC8BIT:
      case ENCBINARY:
        break;

      case ENCBASE64:
	gf_link_filter(gf_b64_binary);
        break;

      case ENCQUOTEDPRINTABLE:
	gf_link_filter(gf_qp_8bit);
        break;

      case ENCOTHER:
        break;
    }

    while(aux_filters && *aux_filters)	/* apply externally provided filters */
      gf_link_filter(*aux_filters++);

    /*
     * Following canonical model, after decoding convert newlines from
     * crlf to local convention.
     */
    if(body->type == TYPETEXT){
	gf_link_filter(gf_nvtnl_local);
#ifdef	DOS
	/*
	 * When detaching a text part AND it's US-ASCII OR it
	 * matches what the user's defined as our charset,
	 * translate it...
	 */
	if(mime_can_display(body->type, body->subtype, body->parameter)
	   && xlate_to_codepage){
	    gf_translate_opt(xlate_to_codepage, 256);
	    gf_link_filter(gf_translate);
	}
#endif
    }

#ifdef	LATER
    dprint(9, (debugfile, "Attachment lengths: %ld (decoded) %lud (encoded)\n",
               *decoded_len, length));
#endif

    gf_set_readc(&gc,
#ifdef	DOS
		 /*
		  * If we fetched this to a file, 
		  * make sure we set up the storage
		  * object's getchar function accordingly...
		  */
		 (src == FileStar) ? (char *)append_file :
#endif
		 contents,
		 length, src);

    if(status = gf_pipe(gc, pc)) {
	sprintf(err_string, "Formatting error: %s", status);
        rv = 0L;
    }

#ifdef	DOS
    /*
     * free up file descriptor, and return tmpfile opened by
     * dos_gets and returned via the global "append_file"...
     */
    if(src == FileStar){
	if(append_file)
	  fclose(append_file);

	append_file = NULL;
	mailgets    = NULL;
	mail_gc(stream, GC_TEXTS);
    }
#endif

    if (len != (long *)NULL)
      *len = rv;

    return((err_string[0] == '\0') ? NULL : err_string);
}


/*----------------------------------------------------------------------
  ----*/
void
save_attachment(qline, msgno, a)
     int       qline;
     long      msgno;
     ATTACH_S *a;
{
    char	filename[MAXPATH+1], full_filename[MAXPATH+1], *ill;
    HelpType	help;
    char       *l_string, prompt_buf[200];
    int         r, is_text;
    long        len;
    PARAMETER  *param;
    gf_io_t     pc;
    STORE_S    *store;
    char       *err;


    is_text = a->body->type == TYPETEXT;

    /*-------  Figure out suggested file name ----*/
    filename[0] = '\0';
    for(param = a->body->parameter; param; param = param->next)
      if(param->value && strucmp(param->attribute, "name") == 0){
	  strcpy(filename, param->value);
	  break;
      }

    dprint(9, (debugfile, "save_attachment(name: %s)\n", filename));

    /*---------- Prompt the user for the file name -------------*/
    help = NO_HELP;
    while(1) {
	sprintf(prompt_buf, "Copy attachment to file in %s directory: ",
		F_ON(F_USE_CURRENT_DIR, ps_global) ? "current" : "home");
	r = optionally_enter(filename, qline, 0, MAXPATH, 1, 0, prompt_buf,
			     NULL, help, 0);

        /*--- Help ----*/
        if(r == 3) {
            help = (help == NO_HELP) ? h_oe_export : NO_HELP;
            continue;
        }

        if(r == 1 || filename[0] == '\0') {
            q_status_message(0, 0, 2, "\007Save attachment cancelled");
            return;
        }

        if(r == 4)
          continue;

        /* check out and expand file name. give possible error messages */
        strcpy(full_filename, filename);
        removing_trailing_white_space(full_filename);
        removing_leading_white_space(full_filename);
        if((ill = filter_filename(filename)) != NULL) {
            q_status_message1(0, 1, 3, "\007%s in file name", ill);
            display_message('x');
            sleep(3);
            continue;
        }
#ifndef	DOS
        if(full_filename[0] == '~') {
            if(fnexpand(full_filename, sizeof(full_filename)) == NULL) {
                char *p = strindex(full_filename, '/');
                if(p != NULL)
                  *p = '\0';
                q_status_message1(1, 1, 3,
                    "\007Error expanding file name: \"%s\" unknown user",
                    full_filename);
                display_message('x');
                sleep(3);
                continue;
            }
        } else if(full_filename[0] != '/') {
#else
        if(full_filename[0] != '\\' && full_filename[1] != ':') {
#endif
	    if(F_ON(F_USE_CURRENT_DIR, ps_global))
              (void)strcpy(full_filename, filename);
	    else
              build_path(full_filename, ps_global->home_dir, filename);
        }

        break; /* Must have got an OK file name */
    }

    if(ps_global->restricted) {
        q_status_message(1, 2, 4, "\007Pine demo can't save attachments");
        return;
    }
     

    /*----------- Write the contents to the file -------------*/
    if(can_access(full_filename, ACCESS_EXISTS) == 0) {
        sprintf(prompt_buf, "File \"%s\" already exists. Overwrite it",
                full_filename);
        if(want_to(prompt_buf, 'n', 'n', NO_HELP, 0, 0) == 'n') {
            q_status_message(0, 1, 3, "\007Save of attachment cancelled");
            return;
        }

	unlink(full_filename);		/* so_get only appends! */
    }

    if((store = so_get(FileStar, full_filename, WRITE_ACCESS)) == NULL){
	q_status_message2(1, 3, 5, "\007Error opening destination %s: %s",
			  full_filename, error_description(errno));
	return;
    }

    gf_set_so_writec(&pc, store);
    err = detach(ps_global->mail_stream,msgno,a->body,a->number,&len,pc,NULL);
    if(!err){
        l_string = cpystr(byte_string(len));
        q_status_message7(0, 2, 4, "Part %s, %s%s written to \"%s\"%s%s%s",
                         a->number, 
                         is_text ?   comatose(a->body->size.lines) :
                                     l_string,
                         is_text ?   " lines" : "",
                         full_filename,
                         is_text || len == a->body->size.bytes ?
                                        "" : "(decoded from ",
                         is_text || len == a->body->size.bytes ?
                                        "" : byte_string(a->body->size.bytes),
                         is_text || len == a->body->size.bytes ?
                                        "" : ")");
        fs_give((void **)&l_string);
    }
    else{
      q_status_message2(1, 3, 5,"\007%s: Error writing attachment to \"%s\"",
                        err, full_filename);
    }

    so_give(&store);
}


/*----------------------------------------------------------------------

  ----*/        
int
display_attachment(msgno, a)
     long      msgno;
     ATTACH_S *a;
{
    char    *filename;
    STORE_S *store;
    gf_io_t  pc;
    filter_t aux_filter[2];
    char    *err;
#ifndef DOS
    char prefix[8];
#endif

    /*------- Display the attachment -------*/
    if(!a->can_display) {
        /*----- Can't display this type ------*/
        q_status_message3(1, 3, 5,
                 "\007Don't know how to display attachment format %s%s%s",
                          body_type_names(a->body->type),
                          a->body->subtype != NULL ? "/" : "",
                          a->body->subtype != NULL ? a->body->subtype :"");
        return(0);
    }
    
    if(a->body->type == TYPETEXT) {
	display_text_att(msgno, a);
	ps_global->mangled_screen = 1;
        return(0);
    }

        
    /*------ Write the image to a temporary file ------*/
#ifdef	DOS
    filename = temp_nam(NULL, "im");
#else
    sprintf(prefix, "img-%.3s", (a->body->subtype) ? a->body->subtype : "unk");
    filename = temp_nam(NULL, prefix);
#endif

    if((store = so_get(FileStar, filename, WRITE_ACCESS)) == NULL){
        q_status_message2(1, 3, 5,
                          "\007Error \"%s\", Can't write file %s",
                          error_description(errno), filename);
        return(0);
    }

    gf_set_so_writec(&pc, store);
    err = detach(ps_global->mail_stream,msgno,a->body,a->number,NULL,pc,NULL);
    if(err){
	q_status_message2(1, 3, 5,
		"\007%s: Error saving image to temp file %s", err, filename);
        return(0);
    }

    so_give(&store);

    /*----- Run the viewer process ----*/
    run_viewer(filename, a->body);
    fs_give((void **)&filename);
    return(0);
}

void
display_text_att(msgno, a)
    long      msgno;
    ATTACH_S *a;
{
    STORE_S        *store;
    gf_io_t         pc;
    SourceType	    src = CharStar;

    clear_index_cache_ent(msgno);

    /* BUG, should check this return code */
    (void)mail_fetchstructure(ps_global->mail_stream, msgno, NULL);

    /* initialize a storage object */
#ifdef	DOS
    if(a->body->size.bytes > MAX_MSG_INCORE
       || strcmp(ps_global->mail_stream->dtb->name, "nntp") == 0){
	src = FileStar;
    }else {
        src = CharStar;
    }
#endif

    store = so_get(src, NULL, EDIT_ACCESS);
    gf_set_so_writec(&pc, store);

    if(!ps_global->full_header) {

	(void) decode_text(a, msgno, pc, QStatus, 1);

    } else {
#ifdef	DOS
	/*
	 * This'll save us having to copy files around.
	 * (see mailview.c)
	 */
	if(src == FileStar){
	    append_file = (FILE *)so_text(store);
	    mailgets    = dos_gets;
	    (void)mail_fetchheader(ps_global->mail_stream, msgno);
	    (void)mail_fetchtext(ps_global->mail_stream, msgno);
	    append_file = NULL;
	    mailgets    = NULL;
	    mail_gc(ps_global->mail_stream, GC_TEXTS);
	}
	else
#endif
	{
	    so_puts(store, mail_fetchheader(ps_global->mail_stream,msgno));
	    so_puts(store, mail_fetchtext(ps_global->mail_stream,msgno));
	}
    }

    scrolltool(so_text(store), "ATTACHMENT TEXT", (int *)NULL,
	       AttachText, src, a);

    so_give(&store);	/* free resources associated with store */

}



/*----------------------------------------------------------------------
   Run xloadimage to display gif,pbm and other such files

Args: image_file -- The name of the file to pass to xloadimage

If xloadimage produces any output on the command line or the shell
produces output because it can't find or execute xloadimage the first
5 lines will be displayed on the status line one at a time.
 ----*/
void
run_viewer(image_file, body)
     char *image_file;
     BODY *body;
{
    char *cmd = NULL;

    if(cmd = mailcap_build_command(body, image_file)){
	exec_mailcap_cmd(cmd, image_file);
	fs_give((void **)&cmd);
    }
    else
      q_status_message1(0,1,4,"Cannot display %s attachment",
		     type_desc(body->type, body->subtype, body->parameter, 1));

    display_message('x');
}


/* This isn't quite ctime, because it doesn't have the \n */

char *
mcdate2ctime(m)
     MESSAGECACHE *m;
{
    static char date[30];

    sprintf(date, "Xxx %s %2d %02d:%02d:%02d %04d",
    month_abbrev(m->month), m->day, m->hours, m->minutes, m->seconds,
	    m->year + BASEYEAR);
    return(date);
}




/*
 * given the selection list, return a malloc'd string
 * containing the comma-delimited list...
 */
char *
build_sequence(msgmap, count)
     MSGNO_S *msgmap;
     long    *count;
{
    long  i, del_count = 0L;
    char *seq = NULL;

    tmp_20k_buf[0] = '\0';
    if(any_flagged(ps_global->mail_stream, msgmap, MN_TEMP)){
	if(!(i = (long)pseudo_selected("DELETE", msgmap, NULL))){
	    *count = -1;
	    return(NULL);
	}

	if(ps_global->ops_under_apply || i == 'y'){
	    for(i = 1L; i <= mn_get_total(msgmap); i++){
		if(get_flag(ps_global->mail_stream, msgmap, i, MN_TEMP)){
		    if(del_count++)
		      strcat(tmp_20k_buf, ",");

		    strcat(tmp_20k_buf, long2string(mn_m2raw(msgmap,i)));
		    clear_index_cache_ent(i);
		}
	    }

	    seq = cpystr(tmp_20k_buf);
	}
    }

    *count = del_count;
    return(seq);
}



/*
 * Temporary function to convert MN_TEMP flagged messages to 
 * 
 */
int
pseudo_selected(name, map, cur)
     char    *name;
     MSGNO_S *map;
     long    *cur;
{
    int  ch = 'y';
    char pmt[256];
    long num_flagged, i, later = 0L;

    if(cur)
      *cur = 0L;

    if(num_flagged = any_flagged(ps_global->mail_stream, map, MN_TEMP)){
	if(cur)
	  *cur = mn_m2raw(map, mn_get_cur(map)); /* fake selected array */

	switch(ch){
	  case 'y' :
	    for(i = 1L; cur && i <= mn_get_total(map); i++)
	      if(get_flag(ps_global->mail_stream, map, i, MN_TEMP)){
		  if(!later++){
		      mn_set_cur(map, i);
		  }
		  else{
		      mn_add_cur(map, i);
		  }
	      }

	    return('y');

	  case 'n' :
	    return('n');

	  case 'x' :
	    q_status_message1(0,0,2,"\007%s cancelled", name);
	    return(0);
	}
    }

    return(1);
}


/*
 * Get the user name from the mailbox portion of an address.
 *
 * Args: mailbox -- the mailbox portion of an address (lhs of address)
 *       target  -- a buffer to put the result in
 *       len     -- length of the target buffer
 *
 * Returns the left most portion up to the first '%', ':' or '@',
 * and to the right of any '!' (as if c-client would give us such a mailbox).
 * Returns NULL if it can't find a username to point to.
 */
char *
get_uname(mailbox, target, len)
char  *mailbox,
      *target;
int    len;
{
    int i, start, end;

    if(!mailbox || !*mailbox)
	return NULL;

    end = strlen(mailbox) - 1;
    for(start = end; mailbox[start] != '!' && start > -1; start--)
        if(strindex("%:@", mailbox[start]))
	    end = start - 1;

    start++;			/* compensate for either case above */

    for(i = start; i <= end && (i-start) < (len-1); i++) /* copy name */
        target[i - start] = isupper(mailbox[i]) 
		       ? mailbox[i] - 'A' + 'a' : mailbox[i];

    target[i - start] = '\0';	/* tie it off */

    if(*target)
	return(target);
    else
	return NULL;
}
