#if !defined(lint) && !defined(DOS)
static char rcsid[] = "$Id: other.c,v 4.40 1994/06/16 23:08:26 hubert Exp $";
#endif
/*----------------------------------------------------------------------

            T H E    P I N E    M A I L   S Y S T E M

   Laurence Lundblade and Mike Seibel
   Networks and Distributed Computing
   Computing and Communications
   University of Washington
   Administration Builiding, AG-44
   Seattle, Washington, 98195, USA
   Internet: lgl@CAC.Washington.EDU
             mikes@CAC.Washington.EDU

   Please address all bugs and comments to "pine-bugs@cac.washington.edu"

   Copyright 1989-1994  University of Washington

    Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee to the University of
   Washington is hereby granted, provided that the above copyright notice
   appears in all copies and that both the above copyright notice and this
   permission notice appear in supporting documentation, and that the name
   of the University of Washington not be used in advertising or publicity
   pertaining to distribution of the software without specific, written
   prior permission.  This software is made available "as is", and
   THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
   WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
   NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
   INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
   LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
   (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
   WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  
   Pine and Pico are trademarks of the University of Washington.
   No commercial use of these trademarks may be made without prior
   written permission of the University of Washington.

   Pine is in part based on The Elm Mail System:
    ***********************************************************************
    *  The Elm Mail System  -  Revision: 2.13                             *
    *                                                                     *
    * 			Copyright (c) 1986, 1987 Dave Taylor              *
    * 			Copyright (c) 1988, 1989 USENET Community Trust   *
    ***********************************************************************
 

  ----------------------------------------------------------------------*/

/*======================================================================
      other.c

      This implements the "setup" screen of miscellaneous commands such
  as keyboard lock, and disk usage

  ====*/

#include "headers.h"

#define HEADER_LINES 2
#define BOTTOM_LINES 3
#define	FIRST_DLINE	2		/* first screen line for display */

#define	R_SELD	'*'



/*
 * Information used to paint and maintain a line on the configuration screen
 */
typedef struct conf_line {
    char	     *varname,			/* alloc'd var name string   */
		     *value;			/* alloc'd var value string  */
    short	      valoffset;		/* offset from screen left   */
    struct variable  *var;			/* pointer to pinerc var     */
    short	      varmem;			/* value's index, if list    */
    int		      (*tool)();		/* tool to manipulate values */
    struct key_menu  *keymenu;			/* tool-specific  keymenu    */
    HelpType	      help;			/* variable's help text      */
    short	      unselectable;		/* not user selectable line  */
    struct conf_line *varnamep;			/* pointer to varname        */
    struct conf_line *next, *prev;
} CONF_S;


/*
 *
 */
typedef struct conf_screen {
    CONF_S  *current,
	    *top_line;
} OPT_SCREEN_S;


#define	next_confline(p)	((p) ? (p)->next : NULL)
#define	prev_confline(p)	((p) ? (p)->prev : NULL)
static OPT_SCREEN_S *opt_screen;


#ifdef ANSI
void	 draw_klocked_body(char *, char *);
int	 update_option_screen(struct pine *, CONF_S *, struct conf_screen *);
void	 option_screen_redrawer();
HelpType config_help(int, int);
int	 text_tool(struct pine *, int, CONF_S **, int);
int	 checkbox_tool(struct pine *, int, CONF_S **, int);
int	 radiobutton_tool(struct pine *, int, CONF_S **, int);
int	 yesno_tool(struct pine *, int, CONF_S **, int);
char	*pretty_value(struct variable *, int);
void	 toggle_feature_bit(struct pine *, int, CONF_S *);
CONF_S	*new_confline(CONF_S **);
void	 free_confline(CONF_S **);
CONF_S	*first_confline(CONF_S *);

#else
void	 draw_klocked_body();
int	 update_option_screen();
void	 option_screen_redrawer();
HelpType config_help();
int	 text_tool();
int	 checkbox_tool();
int	 radiobutton_tool();
int	 yesno_tool();
char	*pretty_value();
void	 toggle_feature_bit();
CONF_S	*new_confline();
void	 free_confline();
CONF_S	*first_confline();
#endif

static char *klockin, *klockame;

void
redraw_kl_body()
{
#ifndef NO_KEYBOARD_LOCK
    ClearScreen();

    set_titlebar("KEYBOARD LOCK", ps_global->context_current, 
		 ps_global->cur_folder, NULL, 1, FolderName, 0, 0);

    PutLine0(6,3 ,
       "You may lock this keyboard so that no one else can access your mail");
    PutLine0(8, 3 ,
       "while you are away.  The screen will be locked after entering the ");
    PutLine0(10, 3 ,
       "password to be used for unlocking the keyboard when you return.");
    fflush(stdout);
#endif
}


void
redraw_klocked_body()
{
#ifndef NO_KEYBOARD_LOCK
    ClearScreen();

    set_titlebar("KEYBOARD LOCK", ps_global->context_current, 
		 ps_global->cur_folder, NULL, 1, FolderName, 0, 0);

    PutLine2(6, 3, "This keyboard is locked by %s <%s>.",klockame, klockin);
    PutLine0(8, 3, "To unlock, enter password used to lock the keyboard.");
    fflush(stdout);
#endif
}


#ifndef NO_KEYBOARD_LOCK
/*----------------------------------------------------------------------
          Execute the lock keyboard command

    Args: None

  Result: keyboard is locked until user gives password
  ---*/

lock_keyboard()
{
    struct pine *ps = ps_global;
    char inpasswd[80], passwd[80];
    HelpType help = NO_HELP;
    SigType (*hold_quit)(int);

    passwd[0] = '\0';
    redraw_kl_body();
    ps->redrawer = redraw_kl_body;

    inpasswd[0] = '\0';
    while(1){			/* input pasword to use for locking */
        int rc;
        rc =  optionally_enter(inpasswd, -3, 0, 30, 0, 1,
			       "Enter password to LOCK keyboard : ", NULL,
                               help, 0);

	if(rc == 3) {
	    help = NO_HELP;		/* BUG: more help than from kl_body? */
	    continue;
        }
	else if(rc == 1 || inpasswd[0] == '\0'){
	    q_status_message(0, 0, 2, "\007Lock keyboard cancelled");
	    return(-1);
	}
	else if(rc != 4)
          break;
    }

    if(want_to("Really lock keyboard with entered password", 'y', 'n',
	       NO_HELP, 0, 0) != 'y'){
	q_status_message(0, 0, 2, "\007Lock keyboard cancelled");
	return(-1);
    }

    /* ignore ^\ */
    install_quit_handler();
    draw_klocked_body(ps->VAR_USER_ID ? ps->VAR_USER_ID : "<no-user>",
		  ps->VAR_PERSONAL_NAME ? ps->VAR_PERSONAL_NAME : "<no-name>");

    ps->redrawer = redraw_klocked_body;
    while(strcmp(inpasswd, passwd)){
	if(passwd[0]){
	    q_status_message(1,2,4,
		"\007Password to UNLOCK doesn't match password used to LOCK");
	    display_message('x');
	    sleep(3);
	}
        
        help = NO_HELP;
        while(1){
	    int rc;
	    rc =  optionally_enter(passwd,  -3, 0, 30, 0, 1, 
				   "Enter password to UNLOCK keyboard : ",NULL,
				   help, 1);
	    if(rc == 3) {
		help = help == NO_HELP ? h_oe_keylock : NO_HELP;
		continue;
	    }

	    if(rc != 4)
	      break;
        }
    }

    replace_quit_handler();

    q_status_message(0, 1,3,"Keyboard Unlocked");
    return(0);
}


void
draw_klocked_body(login, username)
    char *login, *username;
{
    klockin = login;
    klockame = username;
    redraw_klocked_body();
}
#endif /* !NO_KEYBOARD_LOCK */



static struct key config_text_keys[] = 
       {{"?","Help",0},	    {NULL,NULL, 0},       {"M","Main Menu",0},
	{"E","[Edit]",0},   {"P","Prev", 0},      {"N","Next", 0},
        {"-","PrevPage",0}, {"Spc","NextPage",0}, {"A","Add",0},
	{"D","Delete",0},   {NULL,NULL,0},        {NULL,NULL,0}};
static struct key_menu config_text_keymenu = {sizeof(config_text_keys)/(sizeof(config_text_keys[0])*12), 0, 0, 0, 0, 0, config_text_keys};

static struct key config_checkbox_keys[] = 
       {{"?","Help",0},	       {NULL,NULL, 0},       {"M","Main Menu",0},
	{"S","[Set/Unset]",0}, {"P","Prev", 0},      {"N","Next", 0},
        {"-","PrevPage",0},    {"Spc","NextPage",0}, {NULL,NULL,0},
	{NULL,NULL,0},         {NULL,NULL,0},        {NULL,NULL,0}};
static struct key_menu config_checkbox_keymenu = {sizeof(config_checkbox_keys)/(sizeof(config_checkbox_keys[0])*12), 0, 0, 0, 0, 0, config_checkbox_keys};

static struct key config_radiobutton_keys[] = 
       {{"?","Help",0},	       {NULL,NULL, 0},       {"M","Main Menu",0},
	{"S","[Select]",0},    {"P","Prev", 0},      {"N","Next", 0},
        {"-","PrevPage",0},    {"Spc","NextPage",0}, {NULL,NULL,0},
	{NULL,NULL,0},         {NULL,NULL,0},        {NULL,NULL,0}};
static struct key_menu config_radiobutton_keymenu = {sizeof(config_radiobutton_keys)/(sizeof(config_radiobutton_keys[0])*12), 0, 0, 0, 0, 0, config_radiobutton_keys};

static struct key config_yesno_keys[] = 
       {{"?","Help",0},	       {NULL,NULL, 0},       {"M","Main Menu",0},
	{"C","[Change]",0},    {"P","Prev", 0},      {"N","Next", 0},
        {"-","PrevPage",0},    {"Spc","NextPage",0}, {NULL,NULL,0},
	{NULL,NULL,0},         {NULL,NULL,0},        {NULL,NULL,0}};
static struct key_menu config_yesno_keymenu = {sizeof(config_yesno_keys)/(sizeof(config_yesno_keys[0])*12), 0, 0, 0, 0, 0, config_yesno_keys};


/*
 * test that variables must pass to make it into the menu...
 */
#define	VAR_INCLUDE(P,V) ((V)->is_user && (V)->is_used && !(V)->is_obsolete \
			  && (V) != &(P)->vars[V_INCOMING_FOLDERS]	    \
			  && (V) != &(P)->vars[V_PRINTER]		    \
			  && (V) != &(P)->vars[V_PERSONAL_PRINT_COMMAND]    \
			  && (V) != &(P)->vars[V_STANDARD_PRINTER]	    \
			  && (V) != &(P)->vars[V_LAST_VERS_USED])



/*----------------------------------------------------------------------
    Present pinerc data for manipulation

    Args: None

  Result: help edit certain pinerc fields.
  ---*/
void
option_screen(ps)
    struct pine *ps;
{
    char	  tmp[MAXPATH+1];
    int		  i, j, ch, orig_ch, done = 0, changes = 0, dline, longest = 0;
    struct	  key_menu  *km = NULL;
    struct	  variable  *vtmp;
    CONF_S	 *current = NULL, *ctmp = NULL;
    OPT_SCREEN_S  screen;
    NAMEVAL_S	 *f;

    screen.current = screen.top_line = NULL;

    /*
     * First, find longest variable name
     */
    for(vtmp = ps->vars; vtmp->name; vtmp++){
	if(!VAR_INCLUDE(ps, vtmp))
	  continue;

	if((i = strlen(vtmp->name)) > longest)
	  longest = i;
    }

    /*
     * Next, allocate and initialize config line list...
     */
    for(vtmp = ps->vars; vtmp->name; vtmp++){
	if(!VAR_INCLUDE(ps, vtmp))
	  continue;

	new_confline(&current)->var = vtmp;
	current->valoffset	    = longest + 3;
	current->keymenu	    = &config_text_keymenu;
	current->help		    = config_help(vtmp - ps->vars, 0);
	current->tool		    = text_tool;

	sprintf(tmp, "%-*s =", longest, vtmp->name);
	current->varname  = cpystr(tmp);
	current->varnamep = ctmp = current;
	if(vtmp == &ps->vars[V_FEATURE_LIST]){	/* special checkbox case */
	    current->unselectable = 1;
	    current->keymenu      = &config_checkbox_keymenu;
	    current->help	  = config_help(vtmp - ps->vars, 0);
	    current->tool	  = NULL;

	    /* put a nice delimiter before list */
	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_checkbox_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = checkbox_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("Set        Feature Name");

	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_checkbox_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = checkbox_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("---   ----------------------");

	    for(i = 0; f = feature_list(i); i++){
		if(f->value != F_OLD_GROWTH){	/* simpler with this one out */
		    new_confline(&current)->var = vtmp;
		    current->varnamep		= ctmp;
		    current->keymenu	        = &config_checkbox_keymenu;
		    current->help	        = config_help(vtmp-ps->vars,
							      f->value);
		    current->tool	        = checkbox_tool;
		    current->valoffset	        = 12;
		    current->varmem	        = i;
		    sprintf(tmp, "[%c]  %s", F_ON(f->value, ps) ? 'X' : ' ',
			    f->name);
		    current->value = cpystr(tmp);
		}
	    }
	}
	else if(vtmp == &ps->vars[V_SAVED_MSG_NAME_RULE]){ /* radio case */
	    current->unselectable = 1;
	    current->keymenu      = &config_radiobutton_keymenu;
	    current->help	  = config_help(vtmp - ps->vars, 0);
	    current->tool	  = NULL;

	    /* put a nice delimiter before list */
	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_radiobutton_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = radiobutton_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("Set       Rule Values");

	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_radiobutton_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = radiobutton_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("---   ----------------------");

	    for(i = 0; f = save_msg_rules(i); i++){
		new_confline(&current)->var = vtmp;
		current->varnamep	    = ctmp;
		current->keymenu	    = &config_radiobutton_keymenu;
		current->help		    = config_help(vtmp - ps->vars, 0);
		current->tool		    = radiobutton_tool;
		current->valoffset	    = 12;
		current->varmem		    = i;
		sprintf(tmp, "(%c)  %s",
			(ps->save_msg_rule == f->value) ? R_SELD : ' ',
			f->name);
		current->value = cpystr(tmp);
	    }
	}
	else if(vtmp == &ps->vars[V_FCC_RULE]){		/* radio case */
	    current->unselectable = 1;
	    current->keymenu      = &config_radiobutton_keymenu;
	    current->help	  = config_help(vtmp - ps->vars, 0);
	    current->tool	  = NULL;

	    /* put a nice delimiter before list */
	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_radiobutton_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = radiobutton_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("Set       Rule Values");

	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_radiobutton_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = radiobutton_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("---   ----------------------");

	    for(i = 0; f = fcc_rules(i); i++){
		new_confline(&current)->var = vtmp;
		current->varnamep	    = ctmp;
		current->keymenu	    = &config_radiobutton_keymenu;
		current->help		    = config_help(vtmp - ps->vars, 0);
		current->tool		    = radiobutton_tool;
		current->valoffset	    = 12;
		current->varmem		    = i;
		sprintf(tmp, "(%c)  %s",
			(ps->fcc_rule == f->value) ? R_SELD : ' ', f->name);
		current->value = cpystr(tmp);
	    }
	}
	else if(vtmp == &ps->vars[V_SORT_KEY]){ /* radio case */
	    current->unselectable = 1;
	    current->keymenu      = &config_radiobutton_keymenu;
	    current->help	  = config_help(vtmp - ps->vars, 0);
	    current->tool	  = NULL;

	    /* put a nice delimiter before list */
	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_radiobutton_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = radiobutton_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("Set       Sort Options");

	    new_confline(&current)->var = NULL;
	    current->varnamep		= ctmp;
	    current->keymenu	        = &config_radiobutton_keymenu;
	    current->help	        = NO_HELP;
	    current->tool	        = radiobutton_tool;
	    current->valoffset	        = 12;
	    current->unselectable       = 1;
	    current->value = cpystr("---   ----------------------");

	    for(j = 0; j < 2; j++){
		for(i = 0; ps->sort_types[i] != EndofList; i++){
		    if(strucmp(sort_name(i), "to") /* if implemented... */
		       && strucmp(sort_name(i), "cc")){
			new_confline(&current)->var = vtmp;
			current->varnamep  = ctmp;
			current->keymenu   = &config_radiobutton_keymenu;
			current->help	   = config_help(vtmp - ps->vars, 0);
			current->tool	   = radiobutton_tool;
			current->valoffset = 12;

			/*
			 * varmem == sort_type index (reverse doubles index)
			 */
			current->varmem = i + (j * EndofList);
			sprintf(tmp, "(%c)  %s%s",
				(ps->def_sort == i && ps->def_sort_rev == j)
				  ? R_SELD : ' ',
				(j) ? "Reverse " : "",
				sort_name(i));
			current->value = cpystr(tmp);
		    }
		}
	    }
	}
	else if(vtmp == &ps->vars[V_USE_ONLY_DOMAIN_NAME]){ /* radio case */
	    current->keymenu      = &config_yesno_keymenu;
	    current->help	  = config_help(vtmp - ps->vars, 0);
	    current->tool	  = yesno_tool;
	    if(vtmp->user_val.p && !strucmp(vtmp->user_val.p, "yes")
	       || (!vtmp->user_val.p && vtmp->current_val.p
		   && !strucmp(vtmp->current_val.p, "yes")))
	      current->value = cpystr("Yes");
	    else
	      current->value = cpystr("No");
	}
	else if(vtmp->is_list){
	    if(vtmp->user_val.l){
		for(i = 0; vtmp->user_val.l[i]; i++){
		    if(i)
		      (void)new_confline(&current);

		    current->var       = vtmp;
		    current->value     = pretty_value(vtmp, i);
		    current->valoffset = longest + 3;
		    current->keymenu   = &config_text_keymenu;
		    current->help      = config_help(vtmp - ps->vars, 0);
		    current->tool      = text_tool;
		    current->varmem    = i;
		    current->varnamep  = ctmp;
		}
	    }
	    else{
		current->varmem = 0;
		current->value  = pretty_value(vtmp, 0);
	    }
	}
	else
	  current->value = pretty_value(vtmp, 0);
    }

    current	       = first_confline(current);
    ps->mangled_screen = 1;
    ps->redrawer       = option_screen_redrawer;
    opt_screen	       = &screen;

    while(!done){
	if(ps->mangled_screen){
	    ps->mangled_header = 1;
	    ps->mangled_footer = 1;
	    ps->mangled_body   = 1;
	    ps->mangled_screen = 0;
	}

	/*----------- Check for new mail -----------*/
        if(new_mail(NULL, 0,ch==NO_OP_IDLE ? 0 : ch==NO_OP_COMMAND ?1 :2) >= 0)
          ps->mangled_header = 1;

	if(ps->mangled_header){
	    set_titlebar("CONFIGURATION MENU", ps->context_current, 
			 ps->cur_folder, ps->msgmap, 1, FolderName, 0, 0);
	    ps->mangled_header = 0;
	}

	/*
	 * Move past unselectable items...
	 */
	while(current->unselectable){	/* BUG: if first or last line...    */
	    if(ch == KEY_UP)		/*      unselectable, we're screwed */
	      current = prev_confline(current);
	    else if(ch == KEY_DOWN)
	      current = next_confline(current);
	}

	dline = update_option_screen(ps, current, &screen);

	/*---- This displays new mail notification, or errors ---*/
        display_message(ch);

        /*------ Read the command from the keyboard ----*/
	if(ps->mangled_footer || km != current->keymenu){
	    bitmap_t	 bitmap;

	    setbitmap(bitmap);
	    ps->mangled_footer = 0;
	    km                 = current->keymenu;
	    draw_keymenu(km, bitmap, ps->ttyo->screen_cols,-2, 0, FirstMenu,0);
	}

	MoveCursor(max(0, ps->ttyo->screen_rows - 3), 0);
	ch = orig_ch = read_command();

        if(ch <= 0xff && isupper(ch))
          ch = tolower(ch);

	switch(ch){
	  case 'm' :				/* exit options screen */
	    done++;
	    break;

	  case '?' :				/* help! */
	    if(current->help != NO_HELP){
		helper(current->help, "HELP FOR CONFIGURATION SCREEN", 0);
		ps->mangled_screen = 1;
	    }
	    else
	      q_status_message(0,0,3,"\007No help yet!");

	    break;

	  case 'n' :				/* next list element */
	  case '\t' :
	  case ctrl('F') :
	  case KEY_RIGHT :
	  case ctrl('N'):			/* down arrow */
	  case KEY_DOWN :
	    ch = KEY_DOWN;
	    if(ctmp = next_confline(current))
	      current = ctmp;

	    break;

	  case 'p' :				/* previous list element */
	  case ctrl('B') :
	  case KEY_LEFT :
	  case ctrl('P') :			/* up arrow */
	  case KEY_UP :
	    ch = KEY_UP;
	    if(ctmp = prev_confline(current))
	      current = ctmp;

	    break;

	  case '+' :				/* page forward */
	  case ' ' :
	  case ctrl('V') :
	    ch = KEY_DOWN;
	    while(dline++ < ps->ttyo->screen_rows - BOTTOM_LINES)
	      if(ctmp = next_confline(current))
		current = ctmp;
	      else
		break;

	    break;

	  case '-' :				/* page backward */
	  case ctrl('Y') :
	    ch = KEY_UP;
	    while(dline-- > FIRST_DLINE)
	      if(ctmp = prev_confline(current))
		current = ctmp;
	      else
		break;

	    while(++dline < ps->ttyo->screen_rows - BOTTOM_LINES)
	      if(ctmp = prev_confline(current))
		current = ctmp;
	      else
		break;

	    break;

	  case ctrl('L'):
          case KEY_RESIZE:
	    ClearScreen();
	    ps->mangled_screen = 1;
	    break;

	  default:
	    if(ps_global->restricted){
		q_status_message(1, 1, 3,
				 "Pine demo can't change options or settings");
	    }
	    else if(current->tool){
		if((i = (*current->tool)(ps, ch, &current, dline)) == 1){
		    changes = 1;
		    break;
		}
		else if(i == 0)
		  break;
	    }

	    bogus_command(orig_ch, F_ON(F_USE_FK, ps) ? "F1" : "?");

	  case NO_OP_IDLE:			/* simple timeout */
	  case NO_OP_COMMAND:
	    break;
	}
    }

    if(changes)
      write_pinerc(ps);				/* save any changes */

    for(current = first_confline(current); current;){	/* clean up */
	ctmp = current->next;
	free_confline(&current);
	current = ctmp;
    }

    ps->mangled_screen = 1;
    ClearScreen();
}


/*
 *
 */
HelpType
config_help(var, feature)
    int var, feature;
{
    switch(var){
      case V_FEATURE_LIST :
	switch(feature){
	  case F_ENABLE_FULL_HDR :
	    return(h_config_enable_full_hdr);
	  case F_ENABLE_PIPE :
	    return(h_config_enable_pipe);
	  case F_ENABLE_TAB_COMPLETE :
	    return(h_config_enable_tab_complete);
	  case F_QUIT_WO_CONFIRM :
	    return(h_config_quit_wo_confirm);
	  case F_ENABLE_JUMP :
	    return(h_config_enable_jump);
	  case F_ENABLE_ALT_ED :
	    return(h_config_enable_alt_ed);
	  case F_ENABLE_BOUNCE :
	    return(h_config_enable_bounce);
	  case F_ENABLE_AGG_OPS :
	    return(h_config_enable_agg_ops);
	  case F_ENABLE_FLAG :
	    return(h_config_enable_flag);
	  case F_ENABLE_ZOOM :
	    return(h_config_enable_zoom);
	  case F_CAN_SUSPEND :
	    return(h_config_can_suspend);
	  case F_EXPANDED_FOLDERS :
	    return(h_config_expanded_folders);
	  case F_USE_FK :
	    return(h_config_use_fk);
	  case F_INCLUDE_HEADER :
	    return(h_config_include_header);
	  case F_SIG_AT_BOTTOM :
	    return(h_config_sig_at_bottom);
	  case F_DEL_SKIPS_DEL :
	    return(h_config_del_skips_del);
	  case F_AUTO_EXPUNGE :
	    return(h_config_auto_expunge);
	  case F_AUTO_READ_MSGS :
	    return(h_config_auto_read_msgs);
	  case F_READ_IN_NEWSRC_ORDER :
	    return(h_config_read_in_newsrc_order);
	  case F_SELECT_WO_CONFIRM :
	    return(h_config_select_wo_confirm);
	  case F_USE_CURRENT_DIR :
	    return(h_config_use_current_dir);
	  case F_SAVE_DELETES :
	    return(h_config_save_deletes);
	  case F_SAVE_ADVANCES :
	    return(h_config_save_advances);
	  case F_FORCE_LOW_SPEED :
	    return(h_config_force_low_speed);
	  case F_ALT_ED_NOW :
	    return(h_config_alt_ed_now);
	  case F_SHOW_DELAY_CUE :
	    return(h_config_show_delay_cue);
	  case F_DISABLE_CONFIG_SCREEN :
	    return(h_config_disable_config_screen);
	  case F_DISABLE_PASSWORD_CMD :
	    return(h_config_disable_password_cmd);
	  case F_DISABLE_UPDATE_CMD :
	    return(h_config_disable_update_cmd);
	  case F_DISABLE_KBLOCK_CMD :
	    return(h_config_disable_kblock_cmd);
	  case F_STRICT_FROM_QUOTE :
	    return(h_config_quote_real_froms);
	  default :
	    return(NO_HELP);
        }

	break;

      case V_PERSONAL_NAME :
	return(h_config_pers_name);
      case V_USER_ID :
	return(h_config_user_id);
      case V_USER_DOMAIN :
	return(h_config_user_dom);
      case V_SMTP_SERVER :
	return(h_config_smtp_server);
      case V_NNTP_SERVER :
	return(h_config_nntp_server);
      case V_INBOX_PATH :
	return(h_config_inbox_path);
      case V_FOLDER_SPEC :
	return(h_config_folder_spec);
      case V_NEWS_SPEC :
	return(h_config_news_spec);
      case V_DEFAULT_FCC :
	return(h_config_default_fcc);
      case V_POSTPONED_FOLDER :
	return(h_config_postponed_folder);
      case V_MAIL_DIRECTORY :
	return(h_config_mail_directory);
      case V_READ_MESSAGE_FOLDER :
	return(h_config_read_message_folder);
      case V_SIGNATURE_FILE :
	return(h_config_signature_file);
      case V_ADDRESSBOOK :
	return(h_config_addressbook);
      case V_INIT_CMD_LIST :
	return(h_config_init_cmd_list);
      case V_COMP_HDRS :
	return(h_config_comp_hdrs);
      case V_CUSTOM_HDRS :
	return(h_config_custom_hdrs);
      case V_SAVED_MSG_NAME_RULE :
	return(h_config_saved_msg_name_rule);
      case V_FCC_RULE :
	return(h_config_fcc_rule);
      case V_SORT_KEY :
	return(h_config_sort_key);
      case V_CHAR_SET :
	return(h_config_char_set);
      case V_EDITOR :
	return(h_config_editor);
      case V_IMAGE_VIEWER :
	return(h_config_image_viewer);
      case V_USE_ONLY_DOMAIN_NAME :
	return(h_config_domain_name);
      case V_PRINTER :
      case V_LAST_TIME_PRUNE_QUESTION :
	return(h_config_prune_date);
#ifdef	DOS                       
      case V_NORM_FORE_COLOR :
      case V_NORM_BACK_COLOR :
      case V_REV_FORE_COLOR :
      case V_REV_BACK_COLOR :
#endif
      default :
	return(NO_HELP);
    }
}


/*
 * simple text variable handler
 *
 * note, things get a little envolved due to the
 *	 screen struct <--> variable mapping. (but, once its
 *       running it shouldn't need changing ;).
 * 
 * returns:  -1 on unrecognized cmd, 0 if no change, 1 if change
 */
int
text_tool(ps, cmd, cl, line)
    struct pine  *ps;
    int		  cmd;
    CONF_S      **cl;
    int		  line;
{
    char	     prompt[80], sval[MAXPATH+1], *tmp, **newval = NULL;
    int		     rv = 0, i;
    struct variable *vtmp;
    CONF_S	    *ctmp;

    switch(cmd){
      case 'a' :				/* add to list */
	if((*cl)->var->is_fixed){
	    q_status_message(0, 0, 3,
			     "\007Can't add to sys-admin defined value.");
	}
	else if(!(*cl)->var->is_list && (*cl)->var->user_val.p){
	    q_status_message(0, 0, 3,
			     "\007Only single value allowed.  Use \"Edit\".");
	}
	else{
	    sprintf(prompt, "Enter text to add to %.30s : ", (*cl)->var->name);
	    sval[0] = '\0';
	    ps->mangled_footer = 1;
	    while(1){
		i = optionally_enter(sval, -3, 0, MAXPATH, 1, 0, prompt,
				     NULL, NO_HELP, 0);
		if(i == 0){
		    rv = ps->mangled_body = 1;
		    removing_leading_white_space(sval);
		    removing_trailing_white_space(sval);
		    if((*cl)->var->is_list){
			if((*cl)->var->user_val.l){
			    int    i;
			    for(i = 0; (*cl)->var->user_val.l[i]; i++)
			      ;

			    fs_resize((void **)&(*cl)->var->user_val.l,
				      (i + 2) * sizeof(char *));
			    for(; i >= (*cl)->varmem; i--)
			      (*cl)->var->user_val.l[i+1] =
						     (*cl)->var->user_val.l[i];

			    tmp = (*cl)->value;
			    new_confline(cl);
			    (*cl)->value     = tmp;
			    (*cl)->var       = (*cl)->prev->var;
			    (*cl)->valoffset = (*cl)->prev->valoffset;
			    (*cl)->keymenu   = (*cl)->prev->keymenu;
			    (*cl)->help      = (*cl)->prev->help;
			    (*cl)->tool      = (*cl)->prev->tool;
			    (*cl)->varnamep  = (*cl)->prev->varnamep;
			    *cl		     = (*cl)->prev;
			    (*cl)->value     = NULL;

			    /* now fix up varmem values */
			    for(ctmp = (*cl)->varnamep, i = 0;
				(*cl)->var->user_val.l[i];
				ctmp = ctmp->next, i++)
			      ctmp->varmem = i;
			}
			else{
			    (*cl)->var->user_val.l
					 = (char **)fs_get(2 * sizeof(char *));
			    (*cl)->var->user_val.l[0] = NULL;
			    (*cl)->var->user_val.l[1] = NULL;
			}

			(*cl)->var->user_val.l[(*cl)->varmem] = cpystr(sval);
		    }
		    else{
			if((*cl)->var->user_val.p)
			  fs_give((void **)&(*cl)->var->user_val.p);

			(*cl)->var->user_val.p = cpystr(sval);
		    }

		    newval = &(*cl)->value;
		}
		else if(i == 1){
		    q_status_message(0,0,3,"\007Add cancelled");
		}
		else if(i == 3){		/* no help, yet */
		    continue;
		}
		else if(i == 4){		/* no redraw, yet */
		    continue;
		}
		
		break;
	    }
	}

	break;

      case 'd' :				/* delete from list */
	if((*cl)->var->is_fixed){
	    q_status_message(0, 0, 3,
			     "\007Can't delete sys-admin defined value.");
	}
	else if(((*cl)->var->is_list && !(*cl)->var->user_val.l)
		|| (!(*cl)->var->is_list && !(*cl)->var->user_val.p)){
	    q_status_message(0, 0, 3, "\007No set value to delete");
	}
	else{
	    tmp = NULL;
	    sprintf(prompt, "Really delete %s%.20s from %.30s ",
		    (*cl)->var->is_list ? "item " : "", 
		    (*cl)->var->is_list ? int2string((*cl)->varmem + 1)
					: (tmp = pretty_value((*cl)->var, 0)),
		    (*cl)->var->name);
	    if(tmp)
	      fs_give((void **)&tmp);

	    ps->mangled_footer = 1;
	    if(want_to(prompt, 'n', 'n', NO_HELP, 0, 1) == 'y'){
		rv = ps->mangled_body = 1;
		if((*cl)->var->is_list){
		    fs_give((void **)&(*cl)->var->user_val.l[(*cl)->varmem]);
		    if((*cl)->var->user_val.l[(*cl)->varmem + 1]){
			char **bufp = &(*cl)->var->user_val.l[(*cl)->varmem];
			while(*bufp = *(bufp+1))
			  bufp++;

			if(*cl == (*cl)->varnamep){	/* leading value */
			    if((*cl)->value)
			      fs_give((void **)&(*cl)->value);

			    ctmp = (*cl)->next;
			    (*cl)->value = ctmp->value;
			    ctmp->value  = NULL;
			}
			else{
			    ctmp = *cl;	/* blast the confline */
			    *cl = (*cl)->next;
			}

			free_confline(&ctmp);

			/* now fix up varmem values */
			for(ctmp = (*cl)->varnamep, i = 0;
			    (*cl)->var->user_val.l[i];
			    ctmp = ctmp->next, i++)
			  ctmp->varmem = i;
		    }
		    else if((*cl)->varmem){/* blasted last in list */
			ctmp = *cl;
			*cl = (*cl)->prev;
			free_confline(&ctmp);
		    }
		    else{			/* blasted last remaining */
			fs_give((void **)&(*cl)->var->user_val.l);
			newval = &(*cl)->value;
		    }
		}
		else{
		    fs_give((void **)&(*cl)->var->user_val.p);
		    newval = &(*cl)->value;
		}
	    }
	    else
	      q_status_message(0, 1, 3, "\007Value not deleted");
	}

	break;

      case ctrl('M') :
      case ctrl('J') :
      case 'e' :				/* edit list option */
	if((*cl)->var->is_fixed){
	    q_status_message(0, 0, 3,
			     "\007Can't edit sys-admin defined value.");
	}
	else if(((*cl)->var->is_list && !(*cl)->var->user_val.l)
		|| (!(*cl)->var->is_list && !(*cl)->var->user_val.p)){
	    q_status_message(0, 0, 3,
			     "\007No current value set.  Use \"Add\".");
	}
	else{
	    ps->mangled_footer = 1;
	    if((*cl)->var->is_list){
		sprintf(prompt, "Edit field %.30s list entry : ",
			(*cl)->var->name);
		sprintf(sval, "%s",
			(*cl)->var->user_val.l[(*cl)->varmem]
			  ? (*cl)->var->user_val.l[(*cl)->varmem] : "");
	    }
	    else{
		sprintf(prompt, "Edit field %.35s value : ",
			(*cl)->var->name);
		sprintf(sval, "%s", (*cl)->var->user_val.p
				     ? (*cl)->var->user_val.p : "");
	    }

	    ps->mangled_footer = 1;
	    while(1){
		i = optionally_enter(sval, -3, 0, MAXPATH, 1, 0, prompt,
				      NULL, NO_HELP, 0);
		if(i == 0){
		    removing_leading_white_space(sval);
		    removing_trailing_white_space(sval);
		    rv = ps->mangled_body = 1;
		    if((*cl)->var->is_list){
			if((*cl)->var->user_val.l[(*cl)->varmem])
			  fs_give((void **)&(*cl)->var->user_val.l[
							       (*cl)->varmem]);

			(*cl)->var->user_val.l[(*cl)->varmem] = cpystr(sval);
		    }
		    else{
			if((*cl)->var->user_val.p)
			  fs_give((void **)&(*cl)->var->user_val.p);

			if(sval[0])
			  (*cl)->var->user_val.p = cpystr(sval);
		    }

		    newval = &(*cl)->value;
						
		}
		else if(i == 1){
		    q_status_message(0,0,3,"\007Edit cancelled");
		}
		else if(i == 3){		/* no help, yet */
		    continue;
		}
		else if(i == 4){		/* no redraw, yet */
		    continue;
		}

		break;
	    }
	}

	break;

      default :
	rv = -1;
	break;
    }

    /*
     * At this point, if changes occurred, var->user_val.X is set.
     * So, fix the current_val, and handle special cases...
     *
     * NOTE: we don't worry about the "fixed variable" case here, because
     *       editing such vars should have been prevented above...
     */
    if(rv == 1){
	/*
	 * Because this field is additive, this code is kind of wacky...
	 */
	if((*cl)->var == &ps->vars[V_ADDRESSBOOK]){
	    if((*cl)->var->user_val.l && (*cl)->var->global_val.l
	       && (*cl)->var->global_val.l[0] && !(*cl)->var->global_val.l[1]
	       && !strcmp(DF_ADDRESSBOOK, (*cl)->var->global_val.l[0])){
		fs_give((void **)&(*cl)->var->global_val.l[0]);
		fs_give((void **)&(*cl)->var->global_val.l);
	    }
	    else if(!(*cl)->var->global_val.l
		    && !(*cl)->var->fixed_val.l
		    && !(*cl)->var->user_val.l
		    && !(*cl)->var->command_line_val.l)
	      (*cl)->var->global_val.l = parse_list(DF_ADDRESSBOOK, 1, NULL);
	}

	/*
	 * Now go and set the current_val based on user_val changes
	 * above.  Turn off command line settings...
	 */
	set_current_val((*cl)->var, FALSE, FALSE);

	/*
	 * Handle any special case variable or config setting here
	 * (resetting current_val where needed).
	 *
	 * "Special cases" are variables that are not used by pine
	 * on-the-fly, but are used, in turn, to set other config
	 * data or internal structures *or* are variables that when
	 * NULL are given internally defined defaults (in which case
	 * we've got to fix up var->current.val)...
	 */
	if((*cl)->var == &ps->vars[V_PERSONAL_NAME]){
	    if(!(*cl)->var->user_val.p && ps->ui.fullname){
		if((*cl)->var->current_val.p)
		  fs_give((void **)&(*cl)->var->current_val.p);

		(*cl)->var->current_val.p = cpystr(ps->ui.fullname);
	    }
	}
	else if((*cl)->var == &ps->vars[V_USER_DOMAIN]){
	    /*
	     * Reset various pointers pertaining to domain name and such...
	     */
	    init_hostname(ps);
	}
	else if((*cl)->var == &ps->vars[V_INBOX_PATH]){
	    /*
	     * fixup the inbox path based on global/default values...
	     */
	    init_inbox_mapping(ps->VAR_INBOX_PATH, ps->context_list);
	}
	else if((*cl)->var == &ps->vars[V_FOLDER_SPEC]
	   || (*cl)->var == &ps->vars[V_NEWS_SPEC]){
	    q_status_message(0, 0, 3,
	   "\007Folder List changes will take affect your next pine session.");
	}
	else if((*cl)->var == &ps->vars[V_ADDRESSBOOK]){
	    addrbook_reset();
	}
	else if((*cl)->var == &ps->vars[V_DEFAULT_FCC]){
	    init_save_defaults();
	}
	else if((*cl)->var == &ps->vars[V_INIT_CMD_LIST]){
	    q_status_message(0, 0, 3,
	    "\007Initial command changes will affect your next pine session.");
	}

	/*
	 * Delay setting the displayed value until "var.current_val" is set
	 * in case current val get's changed due to a special case above.
	 */
	if(newval){
	    if(*newval)
	      fs_give((void **)newval);

	    *newval = pretty_value((*cl)->var, (*cl)->varmem);
	}
    }

    return(rv);
}



/*
 * feature list manipulation tool
 * 
 * 
 * returns:  -1 on unrecognized cmd, 0 if no change, 1 if change
 */
int
checkbox_tool(ps, cmd, cl, line)
    struct pine  *ps;
    int		  cmd;
    CONF_S	**cl;
    int		  line;
{
    int  rv = 0;

    switch(cmd){
      case ctrl('M') :
      case ctrl('J') :
      case 's' :				/* set/unset feature */
	if((*cl)->var == &ps->vars[V_FEATURE_LIST]){
	    rv = 1;
	    toggle_feature_bit(ps, (*cl)->varmem, (*cl));
	}
	else
	  q_status_message(0, 0, 3,
			   "\007Programmer botch!  Unknown checkbox type.");

	break;

      default :
	rv = -1;
	break;
    }

    return(rv);
}


/*
 * simple radio-button style variable handler
 */
int
radiobutton_tool(ps, cmd, cl, line)
    struct pine  *ps;
    int	          cmd;
    CONF_S      **cl;
    int	          line;
{
    int	       rv = 0;
    CONF_S    *ctmp;

    switch(cmd){
      case ctrl('M') :
      case ctrl('J') :
      case 's' :				/* set/unset feature */
	/* hunt backwards, turning off old values */
	for(ctmp = *cl; ctmp && !ctmp->unselectable && !ctmp->varname;
	    ctmp = prev_confline(ctmp))
	  ctmp->value[1] = ' ';

	/* hunt forwards, turning off old values */
	for(ctmp = *cl; ctmp && !ctmp->varname; ctmp = next_confline(ctmp))
	  ctmp->value[1] = ' ';

	/* turn on current value */
	(*cl)->value[1] = R_SELD;

	if((*cl)->var == &ps->vars[V_SAVED_MSG_NAME_RULE]
	   || (*cl)->var == &ps->vars[V_FCC_RULE]){
	    NAMEVAL_S *rule;

	    if((*cl)->var == &ps->vars[V_SAVED_MSG_NAME_RULE]){
		rule		  = save_msg_rules((*cl)->varmem);
		ps->save_msg_rule = rule->value;
	    }
	    else{
		rule	     = fcc_rules((*cl)->varmem);
		ps->fcc_rule = rule->value;
	    }

	    if((*cl)->var->user_val.p)
	      fs_give((void **)&(*cl)->var->user_val.p);

	    (*cl)->var->user_val.p = cpystr(rule->name);

	    ps->mangled_body = 1;	/* BUG: redraw it all for now? */
	    rv = 1;
	}
	else if((*cl)->var == &ps->vars[V_SORT_KEY]){
	    ps->def_sort_rev  = (*cl)->varmem >= EndofList;
	    ps->def_sort      = (*cl)->varmem - (ps->def_sort_rev * EndofList);
	    if((*cl)->var->user_val.p)
	      fs_give((void **)&(*cl)->var->user_val.p);

	    sprintf(tmp_20k_buf, "%s%s%s", sort_name(ps->def_sort),
		    (ps->def_sort_rev) ? "/" : "",
		    (ps->def_sort_rev) ? "Reverse" : "");

	    (*cl)->var->user_val.p = cpystr(tmp_20k_buf);

	    ps->mangled_body = 1;	/* BUG: redraw it all for now? */
	    rv = 1;
	}
	else
	  q_status_message(0, 0, 3,
			   "\007Programmer botch!  Unknown checkbox type.");

	break;

      default :
	rv = -1;
	break;
    }

    return(rv);
}



/*
 * simple yes/no style variable handler
 */
int
yesno_tool(ps, cmd, cl, line)
    struct pine  *ps;
    int	          cmd;
    CONF_S      **cl;
    int	          line;
{
    int  rv = 0;

    switch(cmd){
      case ctrl('M') :
      case ctrl('J') :
      case 'c' :				/* toggle yes to no and back */
	rv = 1;
	if(!strucmp((*cl)->value, "no")){
	    fs_give((void **)&(*cl)->value);
	    (*cl)->value = cpystr("Yes");
	}
	else{
	    fs_give((void **)&(*cl)->value);
	    (*cl)->value = cpystr("No");
	}

	if((*cl)->var->user_val.p)
	  fs_give((void **)&(*cl)->var->user_val.p);

	(*cl)->var->user_val.p = cpystr((*cl)->value);

	if((*cl)->var == &ps->vars[V_USE_ONLY_DOMAIN_NAME]){
	    set_current_val((*cl)->var, FALSE, FALSE);
	    init_hostname(ps);
	}

	break;

      default :
	rv = -1;
	break;
    }

    return(rv);
}



/*
 * Manage display of the config/options menu body.
 */
int
update_option_screen(ps, current, screen)
    struct pine  *ps;
    CONF_S	 *current;
    OPT_SCREEN_S *screen;
{
    int		   dline, return_line = FIRST_DLINE;
    CONF_S	  *top_line, *ctmp;

    /* calculate top line of display */
    dline = 0;
    ctmp = top_line = first_confline(current);
    do
      if(((dline++)%(ps->ttyo->screen_rows-HEADER_LINES-BOTTOM_LINES)) == 0)
	top_line = ctmp;
    while(ctmp != current && (ctmp = next_confline(ctmp)));

    /* mangled body or new page, force redraw */
    if(ps->mangled_body || screen->top_line != top_line)
      screen->current = NULL;

    /* loop thru painting what's needed */
    for(dline = 0, ctmp = top_line;
	dline < ps->ttyo->screen_rows - BOTTOM_LINES - HEADER_LINES;
	dline++, ctmp = next_confline(ctmp)){

	/*
	 * only fall thru painting if something needs painting...
	 */
	if(!(!screen->current || ctmp == screen->current || ctmp == current
	     || ctmp == screen->current->varnamep
	     || ctmp == current->varnamep))
	  continue;

	MoveCursor(dline + FIRST_DLINE, 0);
	CleartoEOLN();

	if(ctmp && ctmp->varname){
	    if(ctmp == current || ctmp == current->varnamep){
		StartInverse();
		return_line = dline + FIRST_DLINE;
	    }

	    Write_to_screen(ctmp->varname);
	    if(ctmp == current || ctmp == current->varnamep)
	      EndInverse();
	}

	if(ctmp && ctmp->value){
	    char *p = tmp_20k_buf;
	    int   i, j;
	    if(ctmp == current){
		return_line = dline + FIRST_DLINE;
		StartInverse();
	    }

	    /*
	     * Copy the value to a temp buffer expanding tabs, and
	     * making sure not to write beyond screen right...
	     */
	    for(i = 0, j = ctmp->valoffset;
		ctmp->value[i] && j < ps->ttyo->screen_cols;
		i++){
		if(ctmp->value[i] == ctrl('I')){
		    do
		      *p++ = ' ';
		    while(j < ps_global->ttyo->screen_cols && ((++j)&0x07));
			  
		}
		else{
		    *p++ = ctmp->value[i];
		    j++;
		}
	    }

	    *p = '\0';
	    PutLine0(dline+FIRST_DLINE, ctmp->valoffset, tmp_20k_buf);

	    if(ctmp == current)
	      EndInverse();
	}
    }

    ps->mangled_body = 0;
    screen->top_line = top_line;
    screen->current  = current;
    return(return_line);
}



/*
 *
 */
void
option_screen_redrawer()
{
    bitmap_t	 bitmap;

    ClearScreen();

    set_titlebar("CONFIGURATION MENU", ps_global->context_current, 
		 ps_global->cur_folder, ps_global->msgmap, 1, FolderName,0,0);

    ps_global->mangled_body = 1;
    (void)update_option_screen(ps_global, opt_screen->current, opt_screen);

    setbitmap(bitmap);
    draw_keymenu(opt_screen->current->keymenu, bitmap,
		 ps_global->ttyo->screen_cols, -2, 0, FirstMenu, 0);
}



/*
 * pretty_value - given the variable and, if list, member, return an
 *                alloc'd string containing var's value...
 */
char *
pretty_value(var, member)
    struct variable *var;
    int		     member;
{
    char *rs, tmp[MAXPATH];

    if(var->is_list){
	rs = (var->user_val.l)
		 ? (*var->user_val.l[member])
		     ? var->user_val.l[member]
		     : "<Empty Value>" 
		 : "<No Value Set>";
    }
    else{
	if(!var->user_val.p){
	    sprintf(rs = tmp, "<No Value Set%s%s%s>", 
		    (var->current_val.p) ? ": using \"" : "",
		    (var->current_val.p) ? var->current_val.p : "",
		    (var->current_val.p) ? "\"" : "");
	}
	else
	  rs = (*var->user_val.p) ?  var->user_val.p : "<Empty Value>";
    }

    return(cpystr(rs));
}


/*
 * test_feature - runs thru a feature list, and returns:
 *                 1 if feature explicitly set and matches 'v'
 *                 0 if feature not explicitly set *or* doesn't match 'v'
 */
int
test_feature(l, f, g, v)
    char **l;
    char  *f;
    int    g, v;
{
    char *p;
    int   rv = 0, forced_off;

    for(; l && *l; l++){
	p = (forced_off = !struncmp(*l, "no-", 3)) ? *l + 3 : *l;
	if(!strucmp(p, f))
	  rv = (v == !forced_off);
	else if(g && !strucmp(p, "old-growth"))
	  rv = (v == forced_off);
    }

    return(rv);
}


void
clear_feature(l, f)
    char ***l;
    char   *f;
{
    char **list = l ? *l : NULL, newval[256];
    int    count = 0;

    for(; list && *list; list++, count++){
	if(f && !strucmp(((!struncmp(*list,"no-",3)) ? *list + 3 : *list), f)){
	    fs_give((void **)list);
	    f = NULL;
	}

	if(!f)					/* shift  */
	  *list = *(list + 1);
    }

    /*
     * this is helpful to keep the array from growing if a feature
     * get's set and unset repeatedly
     */
    if(!f)
      fs_resize((void **)l, count * sizeof(char *));
}


void
set_feature(l, f, v)
    char ***l;
    char   *f;
    int     v;
{
    char **list = l ? *l : NULL, newval[256];
    int    count = 0;

    sprintf(newval, "%s%s", v ? "" : "no-", f);
    for(; list && *list; list++, count++)
      if(!strucmp(((!struncmp(*list, "no-", 3)) ? *list + 3 : *list), f)){
	  fs_give((void **)list);		/* replace with new value */
	  *list = cpystr(newval);
	  return;
      }

    /*
     * if we got here, we didn't find it in the list, so grow the list
     * and add it..
     */
    fs_resize((void **)l, (count + 2) * sizeof(char *));
    (*l)[count]     = cpystr(newval);
    (*l)[count + 1] = NULL;
}


/*
 *
 */
void
toggle_feature_bit(ps, index, current)
    struct pine *ps;
    int		 index;
    CONF_S      *current;
{
    NAMEVAL_S  *f;
    char      **vp, *p;
    int		i, og;

    f  = feature_list(index);
    og = test_old_growth_bits(ps, f->value);

    /*
     * if this feature is in the fixed set, or old-growth is in the fixed
     * set and this feature is in the old-growth set, don't alter it...
     */
    for(vp = current->var->fixed_val.l; vp && *vp; vp++){
	p = (struncmp(*vp, "no-", 3)) ? *vp : *vp + 3;
	if(!strucmp(p, f->name) || (og && !strucmp(p, "old-growth"))){
	    q_status_message(0, 0, 3,
			     "\007Can't change value fixed by sys-admin.");
	    return;
	}
    }

    F_SET(f->value, ps, !F_ON(f->value, ps));	/* flip the bit */
    current->value[1] = F_ON(f->value, ps) ? 'X' : ' ';

    /*
     * fix up the user's feature list based on global and current
     * settings..
     *
     * Note, we only care if "old-growth" is set or not in as much as
     * we don't want to add redundant feature entries.  we won't add or 
     * remove "old-growth" in that the set it defines may change in the
     * future...
     */
    if(test_feature(current->var->global_val.l,f->name,og,F_ON(f->value,ps))
       || test_feature(current->var->user_val.l,f->name,og,!F_ON(f->value,ps)))
      clear_feature(&current->var->user_val.l, f->name);
    else
      set_feature(&current->var->user_val.l, f->name, F_ON(f->value, ps));

    /*
     * Handle any features that need special attention here...
     */
    if(f->value == F_STRICT_FROM_QUOTE)
      mail_parameters(NULL,SET_FROMWIDGET,(void *)(F_ON(f->value,ps) ? 0 : 1));

}


/*
 * new_confline - create new CONF_S zero it out, and insert it after current.
 *                NOTE current gets set to the new CONF_S too!
 */
CONF_S *
new_confline(current)
    CONF_S **current;
{
    CONF_S *p;

    p = (CONF_S *)fs_get(sizeof(CONF_S));
    memset((void *)p, 0, sizeof(CONF_S));
    if(current){
	if(*current){
	    p->next	     = (*current)->next;
	    (*current)->next = p;
	    p->prev	     = *current;
	    if(p->next)
	      p->next->prev = p;
	}

	*current = p;
    }

    return(p);
}


/*
 *
 */
void
free_confline(p)
    CONF_S **p;
{
    if(p){
	if((*p)->varname)
	  fs_give((void **)&(*p)->varname);

	if((*p)->value)
	  fs_give((void **)&(*p)->value);

	if((*p)->prev)
	  (*p)->prev->next = (*p)->next;

	if((*p)->next)
	  (*p)->next->prev = (*p)->prev;

	fs_give((void **)p);
    }
}


/*
 *
 */
CONF_S *
first_confline(p)
    CONF_S *p;
{
    while(p && p->prev)
      p = p->prev;

    return(p);
}
