$!
$! This command procedure re-creates the indexdemo.idx and indexdemo.sel
$! indexed files.
$ create idx.fdl
SYSTEM
	SOURCE                  VAX/VMS
FILE
	BEST_TRY_CONTIGUOUS     yes
	BUCKET_SIZE             9
	CLUSTER_SIZE            3
	CONTIGUOUS              no
	EXTENSION               50
	FILE_MONITORING         no
	GLOBAL_BUFFER_COUNT     0
	ORGANIZATION            indexed
	PROTECTION              (system:RWED, owner:RWED, group:RE, world:RE)

RECORD
	BLOCK_SPAN              yes
	CARRIAGE_CONTROL        carriage_return
	FORMAT                  fixed
	SIZE                    32

AREA 0
	BEST_TRY_CONTIGUOUS     yes
	BUCKET_SIZE             9
	EXTENSION               50

AREA 1
	BEST_TRY_CONTIGUOUS     yes
	BUCKET_SIZE             9
	EXTENSION               9

KEY 0
	CHANGES                 no
	DATA_KEY_COMPRESSION    yes
	DATA_RECORD_COMPRESSION no
	DATA_AREA               0
	DATA_FILL               100
	DUPLICATES              no
	INDEX_AREA              1
	INDEX_COMPRESSION       no
	INDEX_FILL              100
	LEVEL1_INDEX_AREA       1
	NAME                    ""
	NULL_KEY                no
	PROLOG                  3
	SEG0_LENGTH             26
	SEG0_POSITION           0
	TYPE                    string
$!
$ create sel.fdl
SYSTEM
	SOURCE                  VAX/VMS
FILE
	BEST_TRY_CONTIGUOUS     yes
	BUCKET_SIZE             3
	CLUSTER_SIZE            3
	CONTIGUOUS              no
	EXTENSION               9
	FILE_MONITORING         no
	GLOBAL_BUFFER_COUNT     0
	ORGANIZATION            indexed
	PROTECTION              (system:RWED, owner:RWED, group:RE, world:RE)

RECORD
	BLOCK_SPAN              yes
	CARRIAGE_CONTROL        carriage_return
	FORMAT                  variable
	SIZE                    250

AREA 0
	BEST_TRY_CONTIGUOUS     yes
	BUCKET_SIZE             3
	EXTENSION               9

AREA 1
	BEST_TRY_CONTIGUOUS     yes
	BUCKET_SIZE             3
	EXTENSION               3

KEY 0
	CHANGES                 no
	DATA_KEY_COMPRESSION    no
	DATA_RECORD_COMPRESSION no
	DATA_AREA               0
	DATA_FILL               100
	DUPLICATES              no
	INDEX_AREA              1
	INDEX_COMPRESSION       no
	INDEX_FILL              100
	LEVEL1_INDEX_AREA       1
	NAME                    ""
	NULL_KEY                no
	PROLOG                  3
	SEG0_LENGTH             6
	SEG0_POSITION           0
	TYPE                    string
$!
$ write sys$Output "Making selector file"
$ convert/fdl=sel.fdl sys$Input sys$disk:[]INDEXDEMO.SEL/statistics
0000010Configuration rules file	0www_root:[documents]configfile.html
0000020Host-based access control	0www_root:[documents]hostprot.html
0000030Sample Home Page	0www_root:[documents]index.html
0000040Index search demonstration	0www_root:[documents]indexdemo.html
0000050Clickable image demo (background)	0www_root:[documents]nagel23a-background.html
0000060Clickable image demo (erring)	0www_root:[documents]nagel23a-earring.html
0000070Clickable image demo (face)	0www_root:[documents]nagel23a-face.html
0000080Clickable image demo (hair)	0www_root:[documents]nagel23a-hair.html
0000090Clickable image demo	0www_root:[documents]nagel23a.html
0000100Writing scripts	0www_root:[documents]script_env.html
0000110Setting up scripts	0www_root:[documents]script_setup.html
0000120About Boolean Keyword Queries	0www_root:[documents]searchwords.html
0000130DECthreads server algorithm	0www_root:[documents]serveralgorithm.html
0000140Server&lt;-&gt;script DECnet protocol	0www_root:[documents]serverscriptprotocol.html
0000150Understanding Server Errors	0www_root:[documents]server_errors.html
0000160Fill out forms example	0www_root:[documents]testform.html
0000170User home page lookup	0www_root:[documents]userdir.html
0000180User-based access control	0www_root:[documents]userprot.html
0000190VMSHELP script example	0www_root:[documents]vmshelp.html
$!
$ write sys$Output "Making index file"
$ convert/fdl=idx.fdl sys$input sys$disk:[]INDEXDEMO.IDX/statistics
000000              000001000002
000000              000010000001
000000              000013000001
000000              000018000001
128                 000002000001
146                 000002000001
200                 000010000001
200                 000014000001
235                 000002000001
255                 000010000002
255                 000014000005
3rd                 000001000001
404                 000013000001
4094                000014000001
7bit                000001000001
8bit                000001000001
8bit                000013000001
ability             000018000002
abort               000013000003
absent              000011000001
absolute            000001000001
accept              000013000001
accept              000015000001
accepted            000012000001
accepted            000013000001
access              000001000006
access              000002000004
access              000003000001
access              000011000001
access              000013000002
access              000015000007
access              000017000001
access              000018000007
accesses            000001000002
accesses            000014000001
accesslog           000001000004
according           000010000001
according           000013000001
according           000014000001
account             000011000004
account             000016000001
acknowlegement      000013000001
acl                 000018000001
across              000011000001
action              000016000002
actions             000013000001
activates           000016000001
actual              000014000002
add                 000002000001
add                 000011000002
add                 000018000001
additional          000010000002
addres              000015000001
address             000001000013
address             000002000001
address             000003000002
address             000004000002
address             000005000002
address             000006000002
address             000007000002
address             000008000002
address             000009000002
address             000010000002
address             000011000002
address             000013000002
address             000014000004
address             000015000001
address             000016000004
address             000017000002
address             000018000002
address             000019000002
addresses           000001000001
addresses           000002000002
adds                000001000001
advanced            000011000002
advantage           000011000001
after               000010000003
after               000014000002
against             000001000005
against             000004000001
against             000015000001
algorithm           000013000003
alias               000011000001
all                 000001000001
all                 000004000002
all                 000010000002
all                 000014000001
all                 000018000001
allow               000014000001
allow               000015000002
allowed             000013000001
allows              000002000001
allows              000012000002
along               000018000001
alphabetic          000012000001
always              000014000002
anchor              000009000001
anchors             000001000001
anchors             000009000001
another             000001000002
another             000005000001
another             000009000002
another             000012000004
another             000014000001
anything            000005000001
anything            000009000001
appear              000001000001
appear              000014000001
append              000001000001
append              000014000001
appended            000014000001
appends             000010000001
appends             000014000001
applies             000018000001
apply               000001000001
apply               000013000001
appropriate         000015000001
area                000001000003
arg                 000001000002
arg                 000010000005
arg                 000013000001
argument            000001000005
argument            000010000008
argument            000013000001
argument            000014000003
argument            000019000001
arguments           000010000002
arguments           000013000001
argv                000010000003
associated          000004000001
assumed             000012000001
assuming            000014000001
asterik             000001000001
asterisk            000012000001
attempt             000013000002
attempting          000015000001
attempts            000001000001
auth                000001000002
authenticate        000018000001
authentication      000018000003
authenticator       000001000007
authenticator       000018000012
authorization       000018000002
authorize           000011000001
authorized          000015000001
automatically       000001000001
automatically       000010000001
available           000013000001
available           000015000002
available           000017000001
back                000010000001
backgound           000005000001
backgound           000009000001
background          000005000003
background          000009000002
bad                 000015000001
balancing           000011000001
base                000003000001
base                000013000002
based               000001000002
based               000002000003
based               000003000004
based               000013000001
based               000018000004
basic               000010000001
basic               000013000001
because             000013000001
before              000010000001
before              000014000003
beginning           000001000001
behavior            000003000001
being               000001000001
being               000014000002
believe             000003000001
belly               000016000004
belongs             000009000001
below               000001000001
below               000009000001
below               000015000001
best                000011000001
between             000012000001
between             000013000001
bewteen             000011000001
binary              000001000001
binary              000013000001
bind                000001000001
bit                 000014000001
blank               000010000002
blocks              000002000001
body                000001000002
body                000002000002
body                000003000002
body                000004000002
body                000005000001
body                000006000002
body                000007000002
body                000008000002
body                000009000002
body                000010000002
body                000011000002
body                000012000002
body                000013000002
body                000014000002
body                000015000002
body                000017000002
body                000018000002
body                000019000002
boolean             000012000003
both                000012000001
both                000018000001
bottom              000013000001
broad               000015000001
browsable           000001000001
browser             000001000001
browser             000014000001
browserrules        000001000003
browsing            000001000006
browsing            000003000001
buffer              000013000001
builtin             000001000001
builtin             000009000001
button              000012000001
button              000016000004
bypass              000001000001
bytes               000013000001
cache               000001000001
cache               000003000001
cache               000013000006
cache               000014000001
caching             000013000001
call                000001000001
calls               000001000001
capability          000013000001
capability          000015000001
carriage            000010000002
carriage            000014000002
case                000012000001
case                000013000001
case                000014000001
case                000015000001
categories          000015000001
cause               000014000001
cause               000015000001
caused              000003000001
caused              000014000001
caused              000015000002
causes              000001000001
cel                 000018000001
cgi                 000003000002
cgi                 000010000009
cgi                 000014000001
cgi                 000016000003
cgilib              000010000001
change              000009000001
changed             000015000002
character           000001000001
characters          000010000004
characters          000012000002
characters          000014000006
charles             000018000001
check               000011000001
check               000013000004
checkbox            000016000008
checked             000001000001
checks              000001000002
checks              000018000001
circle              000006000001
circle              000009000001
class               000001000002
clickable           000003000001
clickable           000005000002
clickable           000006000002
clickable           000007000002
clickable           000008000002
clickable           000009000002
client              000001000006
client              000002000002
client              000010000007
client              000012000002
client              000013000005
client              000014000009
client              000015000007
client              000018000001
clients             000001000003
clients             000012000001
close               000013000001
close               000014000002
cluster             000011000001
cmd                 000010000001
code                000001000003
code                000003000003
code                000011000002
code                000015000022
college             000005000001
college             000006000001
college             000007000001
college             000008000001
college             000009000001
college             000015000001
com                 000003000001
com                 000010000003
com                 000011000004
com                 000013000002
com                 000016000001
combined            000004000001
command             000001000003
command             000010000011
command             000011000003
command             000012000001
command             000013000001
command             000014000001
command             000019000001
commands            000001000003
commands            000010000006
commands            000014000004
comment             000001000006
comments            000001000001
comments            000002000001
comments            000013000001
common              000001000002
common              000010000002
common              000014000001
common              000015000002
communicates        000010000001
compare             000001000001
compatibility       000001000001
compatibilty        000001000001
complete            000010000001
complete            000013000001
computing           000005000001
computing           000006000001
computing           000007000001
computing           000008000001
computing           000009000001
computing           000015000001
concurrency         000001000001
conditional         000001000001
conf                000001000002
conf                000011000001
config              000001000002
configfile          000003000001
configfile          000010000001
configuration       000001000009
configuration       000002000002
configuration       000003000003
configuration       000010000002
configuration       000013000002
configuration       000015000003
configuration       000018000001
configurations      000001000001
configured          000015000002
configures          000001000001
configures          000013000001
conformance         000014000001
conformance         000015000001
connect             000015000002
connection          000010000002
connection          000013000003
connection          000014000005
connection          000015000001
connections         000001000002
connections         000013000001
connects            000014000001
consisting          000014000002
consists            000012000001
constant            000001000002
constructing        000014000001
contact             000015000002
contain             000002000001
contain             000012000001
containing          000001000001
contains            000001000002
contains            000012000001
contains            000015000002
contains            000018000001
content             000001000003
content             000010000002
content             000013000004
content             000014000001
contents            000001000001
contents            000013000002
contents            000015000001
continue            000001000001
continues           000013000001
control             000001000005
control             000002000003
control             000003000001
control             000010000003
control             000013000001
control             000014000003
control             000018000005
convenient          000010000001
convert             000001000001
convert             000013000003
convert             000014000001
converted           000014000001
converter           000001000009
converter           000013000001
copy                000001000002
copy                000011000001
copy                000014000001
correct             000003000001
correct             000015000001
correct             000018000001
corrective          000015000001
correctly           000011000001
correctly           000018000001
corresponding       000001000004
counter             000001000004
counters            000001000001
counts              000001000001
cover               000012000001
create              000011000001
create              000018000001
created             000001000002
created             000004000002
created             000011000001
created             000016000001
creates             000013000001
creates             000014000002
crlf                000010000003
crlf                000014000001
customize           000001000001
data                000001000014
data                000010000004
data                000013000001
data                000014000012
data                000015000002
data                000016000002
database            000011000001
database            000012000003
databases           000018000001
david               000003000001
david               000004000001
david               000010000001
david               000011000001
david               000013000001
david               000014000001
david               000017000001
david               000018000001
david               000019000001
dcl                 000001000002
dcl                 000003000003
dcl                 000010000004
dcl                 000014000002
dcl                 000016000002
debugging           000001000001
decnet              000001000003
decnet              000010000002
decnet              000011000005
decnet              000013000009
decnet              000014000010
decode              000010000004
decthreads          000003000002
decthreads          000010000001
decthreads          000011000001
decthreads          000013000001
deemed              000015000001
default             000001000014
default             000003000001
default             000010000001
default             000011000003
default             000014000002
define              000001000001
define              000002000001
define              000010000001
define              000011000006
defined             000001000001
defined             000010000001
defined             000011000001
defined             000013000002
defined             000014000001
defines             000001000001
defining            000001000001
defining            000011000001
definition          000001000001
definition          000006000001
definitions         000001000001
defintion           000009000001
defprot             000001000004
deleted             000015000001
delimited           000001000001
delimiter           000010000001
delimiting          000010000002
demo                000004000001
demo                000005000001
demo                000006000001
demo                000007000001
demo                000008000001
demo                000009000001
demonstrate         000005000001
demonstrate         000006000001
demonstrate         000007000001
demonstrate         000008000001
demonstrate         000009000001
demonstrate         000010000001
demonstrate         000018000001
demonstration       000004000001
demonstrations      000003000001
denoted             000001000001
depends             000013000001
described           000010000001
describes           000010000001
description         000013000001
description         000014000001
description         000015000002
desire              000011000001
detailed            000013000001
detected            000015000001
determine           000013000002
developed           000018000001
development         000013000001
device              000001000004
diagnose            000015000001
diagnositic         000015000001
diagnostic          000001000001
diagnostic          000015000001
dialog              000010000010
did                 000015000001
different           000001000003
different           000010000002
different           000018000002
dir                 000001000016
dir                 000011000002
diraccess           000001000005
direct              000001000001
direct              000013000002
directing           000001000001
directive           000001000001
directive           000011000001
directive           000018000001
directives          000001000004
directives          000002000001
directives          000018000001
directly            000001000001
directly            000010000002
directly            000014000001
directories         000001000001
directories         000002000001
directories         000017000001
directories         000018000002
directory           000001000026
directory           000003000001
directory           000004000002
directory           000009000001
directory           000010000002
directory           000011000007
directory           000013000009
directory           000014000001
directory           000015000001
directory           000017000003
disabled            000001000001
disabled            000011000002
disables            000001000003
disallow            000015000001
disk                000001000001
disk                000011000002
disk                000014000001
display             000017000001
displayed           000017000001
distribute          000011000001
distributed         000004000002
distribution        000003000001
distribution        000018000002
dmaprules           000001000002
dnetarg             000014000002
dnetarg2            000010000001
dnetarg2            000014000001
dnetbindir          000014000001
dnetcgi             000010000003
dnetcgi             000014000003
dnethdr             000014000001
dnethost            000014000001
dnetid              000014000001
dnetinput           000014000001
dnetinvcache        000014000001
dnetpath            000014000001
dnetraw             000010000001
dnetraw             000014000003
dnetrecmode         000010000002
dnetrecmode         000014000001
dnetrqurl           000014000001
dnettext            000010000003
dnettext            000014000002
dnetxlate           000014000001
dnslookup           000001000005
doc                 000014000001
document            000001000003
document            000004000002
document            000010000003
document            000011000001
document            000013000005
document            000014000001
document            000015000006
document            000019000001
documentation       000010000001
documents           000001000001
documents           000003000004
documents           000004000002
documents           000012000001
documents           000017000001
documents           000018000001
domain              000001000002
domains             000018000001
done                000010000002
done                000013000001
dot                 000001000001
drexel              000018000001
driver              000016000004
dump                000015000001
duphy4              000018000001
dynamic             000003000001
each                000001000004
each                000010000002
each                000012000001
each                000014000002
earing              000006000001
earing              000009000001
earring             000006000002
earring             000009000002
easier              000014000001
edit                000002000001
edit                000011000002
edit                000018000001
edu                 000003000002
edu                 000004000001
edu                 000010000001
edu                 000017000001
edu                 000018000001
edu                 000019000001
effecitively        000001000001
effect              000015000001
effectively         000001000001
effectively         000004000001
either              000001000004
either              000010000003
either              000011000002
either              000014000001
either              000015000001
either              000018000001
element             000010000001
enable              000001000001
enable              000002000001
enabled             000001000002
enabled             000015000002
enables             000001000005
encoded             000010000001
encoding            000001000004
encoding            000013000003
encryption          000018000001
end                 000010000001
end                 000014000003
endif               000010000001
ends                000001000002
eng                 000003000002
eng                 000017000001
eng                 000019000001
engine              000012000001
engineering         000005000001
engineering         000006000001
engineering         000007000001
engineering         000008000001
engineering         000009000001
engineering         000015000001
enters              000010000001
entire              000013000001
entire              000014000001
entries             000001000001
entry               000001000001
env                 000003000003
env                 000016000002
environment         000001000006
environment         000011000002
environment         000014000002
environments        000013000001
eqs                 000010000003
errant              000013000001
erring              000006000001
error               000001000002
error               000003000001
error               000010000001
error               000011000002
error               000013000001
error               000015000012
errors              000003000001
errors              000015000002
escape              000010000003
establish           000015000001
established         000014000001
event               000001000001
eventcount          000001000002
eventcounter        000001000002
example             000003000001
example             000010000001
example             000012000001
example             000015000002
example             000016000001
example             000019000001
except              000001000001
except              000014000001
exe                 000004000001
exe                 000010000001
exec                000001000008
exec                000009000001
exec                000010000002
exec                000013000001
executable          000010000001
executables         000011000001
execute             000011000002
execute             000013000001
execute             000014000001
executes            000011000001
executes            000013000001
executes            000014000001
execution           000009000001
execution           000010000002
execution           000011000002
execution           000014000003
exist               000001000001
existence           000001000001
existence           000013000001
existent            000015000001
exit                000001000001
exit                000010000002
exit                000013000001
exited              000011000001
explains            000010000001
explicitly          000010000002
expr                000012000003
expression          000012000003
expressions         000012000001
extract             000010000004
extract             000013000001
face                000007000004
face                000009000003
facility            000005000001
facility            000006000001
facility            000007000001
facility            000008000001
facility            000009000001
facility            000015000001
factor              000012000006
fail                000001000006
fail                000013000001
failed              000013000002
failed              000015000002
failing             000011000001
fails               000011000001
failure             000001000001
failure             000015000002
false               000018000002
fao                 000010000001
feature             000001000001
feature             000015000001
features            000011000003
field               000001000001
field               000014000004
fields              000001000001
fields              000018000001
file                000001000047
file                000002000004
file                000003000001
file                000010000003
file                000011000005
file                000012000001
file                000013000017
file                000014000006
file                000015000005
file                000017000001
file                000018000008
filename            000001000001
files               000001000007
files               000002000001
files               000003000001
files               000004000005
files               000013000001
files               000014000001
files               000018000003
fileserv            000004000001
fill                000003000001
fill                000016000002
final               000013000001
find                000001000001
find                000015000001
finding             000001000001
first               000010000002
first               000011000001
first               000013000002
first               000014000004
first               000018000001
fit                 000013000001
flagged             000014000002
follow              000010000001
follow              000014000002
followed            000010000002
followed            000012000003
following           000003000001
following           000010000001
following           000011000002
following           000012000001
following           000013000001
following           000014000002
fopen               000013000002
forced              000013000001
forcing             000014000001
form                000001000001
form                000011000001
form                000014000001
form                000016000010
format              000001000012
format              000003000001
format              000010000001
format              000011000002
format              000015000001
formatting          000014000001
forms               000003000001
forms               000016000002
fote                000012000001
found               000001000002
found               000011000001
found               000013000004
frequently          000015000001
full                000011000001
function            000001000001
function            000003000001
function            000013000004
function            000014000001
function            000015000001
functionality       000018000001
future              000001000001
future              000013000001
gateway             000003000001
gateway             000010000002
gateway             000014000001
gateway             000015000001
gatewaying          000015000002
general             000001000001
generate            000001000001
generate            000010000002
generated           000014000001
generated           000015000001
generates           000010000001
generating          000001000001
generic             000013000001
getmask             000002000001
getmask             000018000001
gets                000015000001
getstats            000001000001
gif                 000009000002
gives               000015000001
gopher              000004000001
goto                000010000004
granted             000001000001
granted             000013000001
greatly             000011000001
guest               000003000001
guide               000011000001
gzip                000001000001
hair                000008000004
hair                000009000003
handed              000016000002
handle              000010000001
handle              000013000001
handled             000001000001
handled             000004000001
handled             000010000001
handles             000001000001
handling            000009000001
hardest             000015000001
hasn                000001000002
head                000001000002
head                000002000002
head                000003000002
head                000004000002
head                000005000002
head                000006000002
head                000007000002
head                000008000002
head                000009000002
head                000010000002
head                000011000002
head                000012000002
head                000013000004
head                000014000002
head                000015000003
head                000017000002
head                000018000002
head                000019000002
header              000010000007
header              000013000002
header              000014000001
header              000015000001
header              000018000001
headers             000010000001
headers             000013000001
headers             000018000001
help                000003000002
help                000010000024
help                000012000001
help                000019000001
helpcmd             000010000002
helpgate            000003000001
highest             000001000001
histogram           000001000001
holds               000010000003
home                000003000001
home                000017000001
homed               000001000002
hoohoo              000010000001
hopefully           000011000001
host                000001000008
host                000002000003
host                000003000002
host                000011000001
host                000013000001
host                000014000004
host                000015000002
host                000018000001
hostclass           000001000002
hostmask            000001000002
hostname            000001000004
hostname            000011000001
hostprot            000001000006
hostprot            000002000001
hostprot            000003000002
hostprot            000018000001
hosts               000001000001
hosts               000002000002
how                 000001000003
how                 000003000001
how                 000010000001
href                000001000038
href                000003000019
href                000004000001
href                000009000002
href                000010000004
href                000011000001
href                000013000007
href                000015000001
href                000017000001
href                000018000002
href                000019000001
htbin               000001000005
htbin               000003000004
htbin               000009000001
htbin               000010000001
htbin               000011000002
htbin               000013000003
htbin               000014000003
htbin               000016000002
html                000001000003
html                000002000002
html                000003000015
html                000004000003
html                000005000002
html                000006000002
html                000007000002
html                000008000002
html                000009000002
html                000010000006
html                000011000003
html                000012000003
html                000013000004
html                000014000003
html                000015000002
html                000017000003
html                000018000003
html                000019000002
htmlx               000001000001
htmlx               000003000001
http                000001000003
http                000003000003
http                000010000008
http                000011000005
http                000013000005
http                000014000012
http                000015000005
http                000018000001
httpd               000004000001
httpd               000011000001
ident               000001000001
ident               000010000001
ident               000013000005
ident               000014000004
identifier          000014000001
idx                 000004000002
ignored             000001000001
image               000001000007
image               000005000001
image               000006000001
image               000007000001
image               000008000001
image               000009000004
image               000010000001
imagemap            000001000002
imagemap            000009000003
images              000003000001
images              000005000001
images              000006000001
images              000007000001
images              000008000001
images              000009000001
img                 000001000001
img                 000009000002
implemented         000018000001
implied             000001000001
implied             000014000002
improve             000011000001
inadvertantly       000015000001
include             000001000006
include             000010000005
include             000018000001
included            000003000001
included            000010000001
included            000013000001
included            000015000001
includes            000001000001
includes            000010000001
includes            000018000002
including           000014000001
incorrect           000003000001
increment           000001000001
incremented         000001000001
index               000001000002
index               000003000002
index               000004000006
index               000012000001
index               000013000001
index               000017000001
indexdemo           000003000001
indexdemo           000004000002
indexed             000012000001
indicate            000011000002
indicates           000012000001
indicating          000013000001
individual          000002000001
individual          000012000001
information         000001000001
information         000003000001
information         000010000001
information         000011000001
information         000015000001
inhibit             000013000001
init                000010000001
initialization      000001000001
inny                000016000002
input               000001000001
input               000010000001
input               000014000001
input               000016000018
insensitive         000012000001
instead             000001000004
instead             000009000001
intended            000015000002
interest            000001000001
interface           000001000002
interface           000010000002
interface           000014000001
internal            000001000001
internally          000001000001
internally          000010000001
internals           000003000001
internals           000013000001
interpret           000014000001
interprets          000010000001
introduction        000010000001
introduction        000014000001
introduction        000015000001
invalid             000011000001
invalid             000015000001
invalidate          000003000001
invalidate          000014000001
invcache            000003000001
invoke              000001000002
invoke              000013000002
invoked             000001000001
invoked             000014000001
invokes             000009000001
invokes             000010000001
invokes             000019000001
involves            000014000001
isindex             000004000001
isindex             000017000001
isindex             000019000001
ismap               000009000003
isn                 000011000001
items               000001000001
items               000010000001
items               000014000001
itself              000001000001
itself              000011000001
itself              000013000001
itself              000014000001
jones               000003000001
jones               000004000001
jones               000010000001
jones               000011000001
jones               000013000001
jones               000014000001
jones               000017000001
jones               000018000001
jones               000019000001
jonesd              000003000002
jonesd              000017000001
jonesd              000019000001
jump                000001000001
junk                000012000001
kcgl1               000003000002
kcgl1               000017000001
kcgl1               000019000001
keeps               000001000001
kept                000001000001
key                 000012000001
keyword             000001000003
keyword             000004000003
keyword             000010000005
keyword             000012000005
keywords            000004000001
keywords            000012000002
known               000001000001
known               000011000001
labels              000001000001
lane                000018000002
last                000010000001
last                000014000001
latest              000014000001
leading             000001000001
learn               000011000001
least               000001000001
length              000010000003
length              000012000001
length              000014000002
lets                000013000001
lets                000014000001
level               000001000006
level               000002000002
level               000018000004
levels              000001000001
lib                 000001000001
like                000001000001
like                000015000001
limits              000001000001
line                000001000004
line                000010000016
line                000013000001
line                000014000005
line                000015000001
lines               000001000001
lines               000010000004
lines               000013000001
lines               000014000001
lines               000015000001
link                000001000001
link                000003000001
link                000010000016
link                000014000005
link                000015000001
link                000017000001
link                000019000001
links               000009000001
list                000001000003
list                000002000001
list                000010000020
list                000013000001
listen              000001000003
listener            000013000001
listens             000013000001
load                000011000001
loaded              000001000001
local               000001000001
local               000011000001
local               000013000001
local               000014000001
localaddress        000001000004
locat               000010000001
locate              000015000001
locate              000018000001
locates             000010000001
location            000010000002
location            000014000001
locator             000015000001
log                 000001000009
log                 000011000005
logfile             000001000001
logging             000001000003
logical             000001000003
logical             000010000002
logical             000011000001
logical             000014000003
login               000011000003
login               000017000002
logrules            000001000002
long                000014000001
look                000011000001
lookup              000017000001
lookups             000001000001
machine             000011000002
machine             000013000001
machinery           000018000001
made                000001000001
made                000003000001
made                000014000001
made                000017000001
made                000019000001
mail                000003000002
mails               000016000001
mailto              000003000001
mailto              000016000002
mailto              000017000001
mailto              000019000001
main                000013000002
maintainer          000015000002
make                000010000001
make                000011000001
make                000013000002
make                000017000001
make                000018000001
makes               000001000001
makes               000013000001
makes               000014000001
making              000001000001
making              000013000001
making              000014000001
making              000015000001
malformed           000015000001
manage              000001000001
managed             000010000001
management          000001000001
many                000015000001
map                 000001000011
mapimage            000001000006
mapimage            000009000003
mapped              000001000001
mapped              000006000001
mapped              000007000001
mapped              000009000003
mapping             000001000005
maps                000001000001
mark                000015000001
marks               000014000001
mask                000001000004
maskgroup           000001000001
maskgroup           000002000001
maskgroup           000018000001
match               000001000004
match               000013000003
matched             000001000002
matched             000013000001
matches             000001000009
matches             000013000001
matching            000001000001
matching            000004000001
matching            000013000001
matching            000014000001
maximum             000014000001
maxlength           000016000004
meaning             000001000001
means               000011000003
measures            000015000001
memory              000013000001
menu                000012000001
merely              000018000001
message             000011000001
message             000013000002
message             000014000007
message             000015000003
messages            000003000001
messages            000010000002
messages            000011000002
messages            000014000001
messages            000015000002
method              000009000001
method              000010000004
method              000013000005
method              000014000002
method              000015000002
method              000016000002
methods             000015000001
mime                000001000001
miscellaneous       000001000002
miscrules           000001000002
missing             000001000001
missing             000013000001
mistyped            000015000001
mod                 000019000001
mode                000010000011
mode                000013000002
mode                000014000004
modes               000010000003
modified            000010000001
mosaic              000009000001
most                000011000001
most                000013000001
moved               000015000001
multi               000001000001
multiple            000001000001
multiple            000012000001
must                000001000011
must                000002000001
must                000004000001
must                000010000003
must                000011000003
must                000014000001
nagel23             000003000001
nagel23a            000001000001
nagel23a            000003000001
nagel23a            000009000004
name                000001000044
name                000005000001
name                000006000001
name                000007000001
name                000008000001
name                000009000004
name                000010000001
name                000011000002
name                000013000005
name                000014000002
name                000016000020
named               000013000001
named               000016000001
names               000001000002
ncsa                000010000001
nearsighted         000016000004
necessary           000010000001
need                000010000001
need                000011000001
needed              000010000001
needed              000011000001
needed              000014000001
needed              000018000001
needs               000012000001
negated             000001000002
negates             000001000001
nested              000001000001
net                 000010000012
net                 000013000001
netrules            000001000002
netserver           000011000004
netserver           000014000001
network             000001000004
network             000010000002
network             000011000001
network             000014000002
network             000015000001
networking          000011000001
new                 000001000001
new                 000013000001
newline             000014000001
nocache             000001000004
node                000001000012
node                000011000003
nodes               000011000001
non                 000001000002
non                 000015000001
none                000001000001
nonesuch            000015000001
note                000001000006
note                000010000004
note                000011000002
note                000013000002
note                000014000001
noted               000001000001
nothing             000013000001
null                000001000001
null                000010000001
null                000014000001
num                 000001000001
num                 000010000004
number              000001000002
number              000011000002
numeric             000001000003
numeric             000011000001
obj                 000001000003
object              000010000001
object              000011000009
object              000013000002
object              000014000001
object              000015000002
obsolete            000001000001
occur               000001000001
off                 000001000003
ohio                000003000003
ohio                000004000001
ohio                000005000001
ohio                000006000001
ohio                000007000001
ohio                000008000001
ohio                000009000001
ohio                000010000001
ohio                000011000001
ohio                000013000001
ohio                000014000001
ohio                000015000001
ohio                000017000002
ohio                000018000001
ohio                000019000002
once                000010000001
open                000010000002
open                000013000008
opened              000001000001
opened              000010000001
opens               000011000001
opens               000013000001
operating           000018000001
operation           000001000006
operation           000003000001
operation           000013000002
operation           000018000001
operators           000012000001
optimized           000001000001
option              000009000001
option              000016000004
option              000018000001
optional            000001000003
optionally          000012000003
oqobf               000003000001
order               000001000003
organizing          000003000001
oriented            000013000001
original            000001000002
originally          000018000001
other               000001000002
other               000009000001
other               000010000001
other               000011000002
other               000018000001
out                 000003000001
out                 000013000002
out                 000015000001
out                 000016000002
output              000010000018
output              000011000001
output              000014000003
outy                000016000002
overlap             000001000001
override            000001000001
overrides           000010000001
overriding          000001000001
overview            000003000001
own                 000001000001
own                 000003000001
own                 000011000001
own                 000017000001
owner               000015000001
page                000003000002
page                000012000001
page                000015000001
page                000017000002
pair                000014000001
pairs               000018000001
parameter           000001000001
parameter           000010000004
parameters          000010000001
parameters          000013000001
parse               000013000002
parse               000015000003
parsed              000014000004
parsed              000015000006
parses              000013000001
parsing             000013000001
part                000001000003
part                000010000001
particular          000001000001
particular          000010000001
particular          000017000001
partner             000011000001
pass                000001000006
passed              000010000001
password            000018000002
passwords           000018000001
path                000001000001
path                000009000001
path                000010000006
path                000014000003
percent             000010000005
perform             000001000002
perform             000017000001
perform             000018000001
performed           000014000001
performing          000019000001
performs            000013000001
performs            000019000001
periods             000001000001
permanent           000010000001
permanent           000011000003
permanent           000013000001
permits             000001000001
permitted           000002000001
pertinent           000018000001
phase               000010000012
phases              000010000001
phone               000016000004
physics             000018000001
place               000001000001
place               000011000004
placing             000013000001
placing             000017000001
plain               000014000001
please              000003000001
plus                000018000001
point               000001000001
polygon             000007000001
polygon             000008000001
polygon             000009000002
port                000001000013
port                000013000003
port                000014000002
portion             000001000001
portion             000010000001
portion             000013000001
portion             000014000002
portions            000009000001
possible            000015000001
post                000013000003
post                000014000002
post                000016000003
posts               000016000001
ppf                 000013000001
pre                 000003000001
pre                 000010000004
pre                 000011000002
pre                 000012000002
precedence          000001000001
prefaced            000015000001
prefix              000001000003
prefix              000010000001
prefixed            000001000004
prepended           000010000001
preproc             000003000001
presenation         000013000001
presence            000001000001
present             000001000006
present             000013000002
presentation        000001000008
presentation        000009000001
presentation        000013000001
presents            000001000002
press               000012000001
previous            000001000001
previous            000013000001
primary             000013000001
prior               000014000001
privilege           000015000001
probably            000011000001
problems            000003000001
procedure           000010000002
procedure           000011000002
procedure           000013000001
procedure           000014000001
procedures          000011000001
process             000001000002
process             000010000001
process             000011000002
process             000013000001
process             000014000006
process             000015000001
process             000018000001
processed           000001000001
processed           000013000001
processes           000001000001
processes           000004000001
processes           000011000002
processes           000014000002
processing          000001000002
processing          000013000002
processing          000014000001
processor           000003000001
produce             000015000001
program             000001000001
program             000004000001
program             000010000002
program             000013000001
program             000015000002
program             000016000001
programs            000001000001
prohibit            000001000001
protect             000001000008
protect             000002000001
protect             000018000002
protected           000001000002
protected           000003000001
protected           000015000001
protected           000018000002
protection          000001000009
protection          000002000002
protection          000015000001
protection          000018000007
protocol            000010000005
protocol            000011000001
protocol            000013000003
protocol            000014000006
protocol            000015000002
protrules           000001000002
provide             000003000002
provide             000014000001
provide             000018000001
provided            000010000001
provided            000011000001
proxies             000011000001
proxy               000011000003
public              000015000001
public              000017000001
punt                000013000005
purpose             000018000001
purposes            000003000001
quality             000001000002
queries             000010000001
queries             000012000001
query               000012000006
query               000013000001
question            000015000003
quite               000014000001
rather              000011000002
rather              000014000001
rather              000015000001
raw                 000010000013
raw                 000014000002
reached             000012000001
read                000001000003
read                000010000003
read                000011000001
read                000013000001
read                000014000006
read                000015000001
readable            000011000001
readable            000014000001
reading             000010000001
reading             000014000002
reads               000001000002
reads               000013000003
reasons             000011000001
receive             000001000001
received            000013000001
received            000015000002
recieves            000014000001
reckless            000016000004
record              000001000001
record              000010000002
record              000014000004
records             000001000002
redirect            000001000007
redirect            000010000001
redirect            000014000001
redirecting         000001000001
redirects           000001000002
reduced             000014000001
redundant           000001000001
referred            000014000001
region              000005000002
region              000006000002
region              000007000002
region              000008000002
region              000009000005
region              000015000003
regular             000001000001
relay               000014000001
relaying            000015000001
releases            000001000001
remains             000010000001
remote              000001000002
remote              000014000002
remote              000015000001
remotely            000011000001
repeated            000013000001
replace             000001000001
report              000001000001
reports             000001000001
representation      000001000001
representing        000014000001
request             000001000002
request             000010000002
request             000013000014
request             000014000011
request             000015000019
request             000018000003
requested           000001000001
requested           000013000003
requested           000015000001
requesting          000002000001
requests            000001000004
requests            000014000012
required            000011000001
required            000015000001
reset               000016000004
reside              000010000001
residing            000013000001
resource            000015000001
resources           000001000001
responding          000014000001
response            000010000003
response            000011000001
response            000014000004
response            000015000006
response            000016000001
response            000018000001
responses           000010000001
responsible         000014000001
restrict            000001000001
restrict            000002000001
restrict            000015000001
restrict            000018000002
result              000001000006
result              000014000001
results             000010000001
retrieval           000013000003
retrieve            000013000001
retrieve            000015000001
retrieved           000013000001
retrieved           000017000001
return              000001000001
return              000012000001
return              000013000001
returned            000010000002
returned            000018000001
returning           000001000001
returning           000010000001
returns             000010000001
returns             000018000002
rev                 000003000001
rev                 000017000001
rev                 000019000001
rewrite             000001000002
right               000001000001
right               000011000001
right               000016000002
righthanded         000016000002
root                000001000002
root                000003000004
root                000004000001
root                000010000001
root                000013000001
root                000018000002
routine             000001000003
routine             000010000001
routine             000013000003
routines            000010000001
rtn                 000001000002
rule                000001000065
rule                000010000002
rule                000013000005
rule                000014000003
rule                000018000001
ruled               000015000001
rules               000001000032
rules               000002000001
rules               000011000001
rules               000013000003
rules               000014000001
rules               000018000003
run                 000001000003
run                 000011000001
running             000014000001
runs                000010000002
same                000001000005
same                000010000001
same                000014000001
sample              000003000001
sample              000018000002
save                000013000002
saved               000001000002
saved               000013000001
scheme              000001000001
scheme              000013000001
sci                 000004000001
screen              000001000001
script              000001000023
script              000003000006
script              000004000002
script              000009000003
script              000010000018
script              000011000011
script              000013000006
script              000014000008
script              000016000002
script              000019000002
scriptlib           000010000001
scripts             000003000002
scripts             000010000005
scripts             000011000005
scripts             000013000001
scripts             000014000001
scriptserver        000010000001
scriptserver        000014000021
search              000001000014
search              000003000001
search              000004000003
search              000010000008
search              000012000004
search              000013000006
search              000014000002
search              000015000002
search              000017000002
search              000019000002
searched            000001000001
searches            000004000001
searches            000012000001
searches            000013000001
searching           000004000002
section             000001000001
sections            000012000001
security            000011000001
sel                 000004000002
select              000001000001
select              000016000004
selected            000016000002
selective           000001000002
send                000003000001
send                000010000003
send                000013000005
send                000014000012
send                000018000001
senddoc             000013000003
sending             000010000001
sending             000014000002
sends               000001000001
sends               000014000001
sends               000015000002
sends               000018000001
sense               000001000001
sensible            000015000001
sent                000001000001
sent                000010000006
sent                000014000014
separate            000001000001
separate            000011000001
separated           000014000001
separately          000004000002
sepcified           000001000001
sequentially        000001000001
server              000001000027
server              000002000001
server              000003000012
server              000004000001
server              000009000001
server              000010000010
server              000011000019
server              000013000011
server              000014000031
server              000015000027
server              000018000005
serveralgorithm     000003000001
servers             000001000001
servers             000011000001
servers             000015000001
serverscriptprotocol000010000001
serverscriptprotocol000011000001
serverscriptprotocol000013000001
serves              000001000001
serviing            000001000001
session             000014000001
sets                000001000003
setting             000011000003
setup               000001000007
setup               000002000002
setup               000003000001
setup               000011000003
setup               000018000005
several             000011000001
sfx                 000001000001
shall               000014000001
should              000011000001
should              000012000001
should              000018000001
show                000011000001
show                000016000001
side                000003000001
signed              000014000001
simple              000010000001
simple              000011000001
simpler             000001000001
since               000001000001
since               000010000001
single              000001000001
single              000014000002
site                000015000001
situations          000010000001
size                000016000004
skipping            000001000001
slash               000001000003
slash               000013000001
solely              000014000002
source              000002000001
spaces              000014000001
spec                000001000003
special             000001000002
special             000003000001
special             000004000003
special             000009000001
special             000013000002
specific            000001000001
specification       000001000001
specification       000010000001
specification       000015000003
specified           000001000011
specified           000010000001
specified           000012000001
specified           000013000002
specified           000014000001
specified           000015000004
specifies           000001000003
specify             000001000003
specify             000002000003
specify             000018000002
specifying          000001000001
specifying          000018000001
src                 000009000002
standard            000001000001
start               000013000001
start               000018000001
started             000001000003
starts              000013000001
startup             000001000003
startup             000011000003
state               000003000003
state               000004000001
state               000005000001
state               000006000001
state               000007000001
state               000008000001
state               000009000001
state               000010000001
state               000011000001
state               000013000001
state               000014000001
state               000015000001
state               000017000002
state               000018000001
state               000019000002
statement           000001000001
status              000010000005
status              000013000003
status              000014000001
step                000011000001
step                000013000001
steps               000011000001
steps               000013000001
still               000014000001
stream              000014000001
string              000001000002
string              000010000002
string              000011000005
string              000012000001
string              000014000007
string              000017000001
string              000019000001
strings             000001000001
strong              000001000078
structure           000001000001
style               000010000001
sub                 000001000004
sub                 000013000002
sub                 000018000001
subdirectory        000017000001
subfunction         000001000001
subfunction         000013000004
subfunction         000014000001
submit              000012000001
submit              000016000004
submited            000016000001
subsequent          000001000001
subsequent          000014000002
subsystem           000015000002
success             000001000001
successful          000013000001
successfully        000015000007
successully         000015000001
suffix              000001000012
suffix              000013000003
suffixed            000004000001
superceded          000001000001
supervisor          000010000001
supplied            000001000001
support             000003000001
support             000015000001
supported           000001000002
supported           000015000001
supposed            000010000001
symbol              000001000003
symbols             000010000002
symbols             000016000002
syntax              000015000001
sys                 000010000003
sys                 000013000001
sys                 000017000001
system              000011000001
system              000016000002
systems             000018000001
sysuaf              000011000001
sysuaf              000018000001
table               000001000001
tag                 000014000001
tags                000001000001
tailor              000012000001
take                000001000002
take                000011000001
take                000018000001
target              000011000001
task                000001000003
task                000010000001
task                000011000009
task                000013000005
tcp                 000001000001
tcp                 000011000001
tcp                 000013000001
tcp                 000014000001
template            000001000019
template            000018000001
temporary           000013000001
term                000012000006
test                000001000001
tested              000013000001
testform            000003000001
testing             000001000001
testing             000013000001
tests               000001000001
text                000001000004
text                000009000001
text                000010000009
text                000012000001
text                000013000002
text                000014000003
text                000016000006
therefore           000004000001
things              000015000001
thread              000013000004
tilda               000001000001
time                000011000001
time                000013000001
title               000001000002
title               000002000002
title               000003000002
title               000004000002
title               000005000002
title               000006000002
title               000007000002
title               000008000002
title               000009000002
title               000010000002
title               000011000002
title               000012000002
title               000013000002
title               000014000002
title               000015000002
title               000016000002
title               000017000002
title               000018000002
title               000019000002
token               000012000004
tokenized           000001000002
trace               000001000008
tracefile           000001000002
tracelevel          000001000002
transfer            000001000001
transformations     000014000001
translate           000009000001
translate           000014000001
translated          000001000001
translated          000010000003
translated          000013000001
translated          000014000002
translation         000001000007
translation         000018000001
translations        000010000001
transrules          000001000002
treated             000013000001
tree                000001000001
triggered           000010000001
triggered           000013000001
triggering          000001000001
triggers            000014000001
triggers            000018000001
trim                000010000001
troubleshooting     000011000001
true                000018000001
truncated           000010000001
truncated           000014000004
try                 000011000001
txt                 000015000001
type                000001000009
type                000010000003
type                000013000004
type                000014000001
type                000015000002
type                000016000018
types               000013000001
types               000018000001
uiuc                000010000001
unable              000015000002
under               000011000001
understanding       000003000001
understanding       000015000001
understands         000018000001
unescaped           000001000001
unfamiliar          000011000001
unfortunately       000015000001
uniform             000015000001
university          000003000001
university          000004000001
university          000010000001
university          000011000001
university          000013000001
university          000014000001
university          000017000001
university          000018000001
university          000019000001
unix                000001000004
unix                000011000001
unless              000010000002
unless              000013000001
until               000010000001
upper               000014000001
url                 000001000009
url                 000010000001
url                 000013000008
url                 000014000009
url                 000015000006
url                 000018000002
urls                000001000001
urls                000013000001
urls                000014000001
urls                000015000001
useful              000003000001
userdir             000001000005
usermap             000001000004
username            000001000002
username            000011000001
username            000017000001
username            000018000004
usernames           000001000001
userprot            000003000002
users               000015000001
usually             000014000001
usually             000015000003
utility             000011000001
valid               000011000001
valid               000015000001
validate            000001000002
validates           000018000001
value               000014000001
value               000016000004
values              000001000002
variable            000001000005
variable            000010000001
variable            000011000002
variable            000014000002
verify              000003000001
version             000010000003
version             000014000001
vertices            000007000001
vertices            000009000001
via                 000001000001
via                 000010000003
via                 000018000001
viewing             000012000001
virtual             000001000001
vms                 000001000005
vms                 000003000002
vms                 000011000002
vms                 000012000001
vms                 000019000001
vmshelp             000003000002
vmshelp             000010000002
vmshelp             000019000001
vmsindex            000004000001
vmsindex            000012000001
wants               000011000001
web                 000001000002
web                 000017000001
welcome             000001000007
welcome             000013000003
well                000001000001
well                000013000001
wfeb                000004000001
whatever            000011000001
wide                000017000001
wilcards            000002000001
wildcard            000001000001
window              000014000001
wish                000011000001
wishes              000014000001
without             000001000001
words               000012000001
work                000001000003
work                000011000002
workarounds         000015000001
working             000003000001
world               000017000001
would               000001000001
would               000011000001
wreckless           000016000004
write               000003000001
write               000010000010
writes              000010000001
writing             000010000003
wrong               000015000001
wwexec              000013000001
www                 000001000004
www                 000003000014
www                 000004000002
www                 000009000003
www                 000010000002
www                 000011000001
www                 000013000003
www                 000014000001
www                 000015000001
www                 000017000004
www                 000018000003
wwwexec             000001000003
wwwexec             000009000001
wwwexec             000010000003
wwwexec             000011000008
wwwexec             000013000006
wwwexec             000014000002
xxx                 000001000006
xxx                 000013000001
zero                000011000001
zero                000014000001
$ write sys$output "Done"
