/******************************************************************************


                       VMS - IRC - Client   part ANALYZE

 Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
                       CMU/tek, UCX, Wollongong or Multinet TCP/IP

 Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG

 Modified for IRC 2.7 by GrayElf, paul@coombs.anu.edu.au

 ******************************************************************************/

#include <stdio.h>
#include <string.h>
#include <strdef.h>
#include "header.h"
#include "numeric.h"
#include "environment.h"
#include "misc.h"
     
extern qio_send(),putbold(),putchunk(),c$cks(),c$dsc(),stricmp(),
       create_status();
extern time_t last_command;
bool notify_request;

/******************************************************************************/

char *nstrip(char *string)
{
int nicklen;

    nicklen = strcspn(string,"!");
    string[nicklen] = '\0';
    return string;
}

char *hstrip(char *string)
{
int nicklen;

    nicklen = strcspn(string,"!");
    return &string[++nicklen];
}

/******************************************************************************/

mark_notify(char *nicks)
{
int i, cnt, flag;
char *ilp,*p[50],ol1[512],ol2[512],ol3[512];
NotifyStruct *tmp;

    strcpy(ol1,"Currently present:");
    strcpy(ol2,"Signon detected for:");
    strcpy(ol3,"Signoff detected for:");

	ilp=nicks;
	for(i=0;i<50;i++) p[i]=""; i=0;
	while (*ilp && (i<50)) {
	    p[i]=ilp;
	    tillspace(ilp);
	    if (*ilp) *ilp++ ='\0';
	    i++;
	}

        for(i=0; i < 50; i++) {
	if (notify_array[i] != NULL)
	    for(cnt = 0, flag = 0; cnt < 50; cnt++) {
		if (!stricmp(notify_array[i],p[cnt])) {
		    flag = 1;
		    strcpy(notify_array[i],p[cnt]);
		}
	    }

	tmp = queue_find(notify_list,&notify_array[i],0);
	if (tmp == NULL) break;
	if (strcmp(tmp->nick,notify_array[i]))
	    strcpy(tmp->nick,notify_array[i]);
	if (tmp->flag == -1) {
	    if (flag == 1) {
		strcat(ol1," ");
		strcat(ol1,&notify_array[i]); }
	    tmp->flag = flag;
	    }
        else if (tmp->flag == 0 && flag == 1) {
	    strcat(ol2," ");
	    strcat(ol2,&notify_array[i]);
	    tmp->flag = flag;
	    }
        else if (tmp->flag == 1 && flag == 0) {
	    strcat(ol3," ");
	    strcat(ol3,&notify_array[i]);
	    tmp->flag = flag;
	    }
    }
    if (strcmp(ol1,"Currently present:")) putchunk(ol1,TRUE);
    if (strcmp(ol2,"Signon detected for:")) putchunk(ol2,TRUE);
    if (strcmp(ol3,"Signoff detected for:")) putchunk(ol3,TRUE);
}


/******************************************************************************/

void create_channel(name)
char *name;
{
char tmp[256];
int i,l,m;

    strcpy(&channel[channels++].name,name);
#ifdef DEBUG
    sprintf(tmp,"DEBUG: create_channel(%s)",name);
    printf("%s\n",tmp);
#endif
}

/******************************************************************************/

void join(chan)
char *chan;
{
CHANNEL tmpchan;
int i=0;

#ifdef DEBUG
    char tmp[256];
    sprintf(tmp,"DEBUG: join(): %s",chan); printf("%s\n",tmp);
    while(i<channels && strcmp(&channel[i].name,chan)) {
	sprintf(tmp,"DEBUG: join(): channel %s",&channel[i].name);
	printf("%s\n",tmp);
	i++; }
    if(strcmp(&channel[i].name,chan)) {
	sprintf(tmp,"DEBUG: join(): Could not find channel %s",chan);
	printf("%s\n",tmp); }
#else
    while(strcmp(&channel[i].name,chan)) i++;    
#endif
    tmpchan=channel[i];
    while(i--) channel[i+1]=channel[i];
    channel[0]=tmpchan;
}

/******************************************************************************/

void leave_channel(chan)
char *chan;
{
char tmp[256];
int i=0;

    channels--;
#ifdef DEBUG
    sprintf(tmp,"DEBUG: leave_channel(): %s",chan); printf("%s\n",tmp);
    while(i<channels && stricmp(&channel[i].name,chan)) {
	sprintf(tmp,"DEBUG: leave_channel(): channel %s",&channel[i].name);
	printf("%s\n",tmp);
	i++; }
    if(stricmp(&channel[i].name,chan)) {
	sprintf(tmp,"DEBUG: leave_channel(): Could not find channel %s",chan);
	printf("%s\n",tmp); }
#else
    while(stricmp(channel[i].name,chan)) i++;    
#endif
    while(i<channels) { channel[i]=channel[i+1]; i++; }
}

/******************************************************************************/

bool on_channel(chan)
char *chan;
{
int i=channels;

    while(strcmp(&channel[i].name,chan)&&i--);
    return(i>=0);
}

/******************************************************************************/

void flush_windows(param)
int param;
{

    msg_refresh();
}

/******************************************************************************/

WINDOW *chan2win(chan)
CHANNEL *chan;
{
int i=0;

/*  while(strcmp(channel[i].name,chan)) i++;    */
    return(dispwindow);  
}

/******************************************************************************/

WINDOW *nrmwin()
{
int i=0;

/*  while(*channel[i].name=='#') i++;    */
    return(dispwindow);  
}

/******************************************************************************/

analyze_ctcp(char *nick,char *ctcp)
{
char ol[MAXNETLEN],*host,tmp[256],*name = &tmp,*user,*txt = &tmp;
bool flag = 1;
time_t idle;

    ctcp[strlen(ctcp)-1] = '\0';
    if (!strcmp(ctcp,"\001VERSION")) {
	sprintf(ol, "NOTICE %s :\001VERSION VMS IRC Client %s\001\n",nick,VMSVERSION);
    }
    else if (!strncmp(ctcp,"\001ACTION",7)) {
	sprintf(ol, "*** Action: %s %s",nick, &ctcp[8]);
	putchunk(ol,TRUE); flag = 0;
    }
    else if (!strcmp(ctcp,"\001FUCK_YOU")) {
	sprintf(ol, "NOTICE %s :\001FUCK_YOU No you dipshit.. FUCK YOU!!@#\001\n", nick);
    }
    else if (!strcmp(ctcp,"\001CLIENTINFO")) {
	sprintf(ol, "NOTICE %s :\001CLIENTINFO ACTION CLIENTINFO ECHO ERRMSG FINGER PING TIME USERINFO VERSION\001\n",nick);
    }
    else if ((!strncmp(ctcp,"\001ERRMSG",7)) || (!strncmp(ctcp,"\001ECHO",5)) ||
	     (!strncmp(ctcp,"\001PING",5))) {
	sprintf(ol, "NOTICE %s :%s\001\n",nick,ctcp);
    }
    else if (!strcmp(ctcp,"\001USERINFO")) {
	sprintf(ol, "NOTICE %s :\001USERINFO Huh? Who wants to know?\001\n", nick);
    }
    else if (!strcmp(ctcp,"\001TIME")) {
	idle = time(0); txt = ctime(&idle); txt[24] = '\0';
	sprintf(ol, "NOTICE %s :\001TIME %s\001\n", nick,txt);
    }
    else if (!strcmp(ctcp,"\001FINGER")) {
#ifdef MULTINET
	host = getenv("MULTINET_HOST_NAME");
#elif UCX
	host = getenv("UCX$INET_HOST");
#elif CMU
	host = getenv("INTERNET_HOST_NAME");
#else
	host = 0;
#endif
	user = getenv("USER"); strcpy(name,get_uaf_entry());
	idle = time(0) - last_command;
	if (host)
	    sprintf(ol,"NOTICE %s :\001FINGER %s (%s@%s) Idle %d seconds\001\n",
		nick,name,user,host,idle);
	else
	    sprintf(ol,"NOTICE %s :\001FINGER %s (%s) Idle %d seconds\001\n",
		nick,name,user,idle);
    }
    else return;
    if (flag) qio_send(ol);
}

/******************************************************************************/

char *analyze_time()
{
char tim[]="17-NOV-1858 00:00:00.00",t[20];
int tim_len;

    if (away_flag) {
	c$cks(sys$asctim(&tim_len,c$dsc(tim),NIL,NIL)); tim[17]='\0';
	sprintf(t,"[%s] ",&tim[12]);
    } else t[0]='\0';
    return(t);
}

/******************************************************************************/

analyze_privmsg(nickname)
char *nickname;
{
char t[256]="\0",ol[256];
int i=0,j;

    i=0;
    while (strcmp(nickname,prvrec[i]) && i<PRIVREC && *prvrec[i]) i++;
    if (PRIVREC==i) {
	for (j=1;j<PRIVREC;j++) strcpy(prvrec[j-1],prvrec[j]);
	strcpy(prvrec[PRIVREC-1],nickname);
    } else if (!*prvrec[i]) strcpy(prvrec[i],nickname);
    else {
	while (*prvrec[i] && i<PRIVREC) { 
	    if (i+1<PRIVREC) strcpy(prvrec[i],prvrec[i+1]); i++; }
	strcpy(prvrec[i-1],nickname);
    }
    if (dbopt&0x80) for (i=0;i<PRIVREC;i++) {
	sprintf(ol,"*** PrivmsgRecall #%2d: %s",i,prvrec[i]);
	putbold(ol,FALSE); }
}

/******************************************************************************/

char *analyze_mode(mode,flag)
char *mode;
bool flag;
{
char t[256]="\0",x[20];
bool fl[20];
int i;

  if (flag) {
    for (i=0;i<20;i++) fl[i]=TRUE;
    while (*mode) {
      switch (*mode) {
        case '+': if (fl[0]) { strcat(t,"to ");              fl[0]=FALSE; } break;
        case '-': if (fl[1]) { strcat(t,"removing ");        fl[1]=FALSE; } break;
        case 'p': if (fl[2]) { strcat(t,"private,");         fl[2]=FALSE; } break;
        case 's': if (fl[3]) { strcat(t,"secret,");          fl[3]=FALSE; } break;
        case 'a': if (fl[4]) { strcat(t,"anonymous,");       fl[4]=FALSE; } break;
        case 'l': if (fl[5]) { strcat(t,"limited channel,"); fl[5]=FALSE; } break;
        case 'm': if (fl[6]) { strcat(t,"moderated,");       fl[6]=FALSE; } break;
        case 't': if (fl[7]) { strcat(t,"topic limit,");     fl[7]=FALSE; } break;
        case 'i': if (fl[8]) { strcat(t,"invite only,");     fl[8]=FALSE; } break;
        case 'n': if (fl[9]) { strcat(t,"no privmsg,");      fl[9]=FALSE; } break;
        case 'o': if (fl[10]) { strcat(t,"channel oper,");   fl[10]=FALSE; } break;
        case 'b': if (fl[11]) { strcat(t,"banning,");        fl[11]=FALSE; } break;
        default:  sprintf(x,"Unknown '%c',",*mode); strcat(t,x);
      }
    mode++;
    }
  }
  else {
    for (i=0;i<20;i++) fl[i]=TRUE;
    while (*mode) {
      switch (*mode) {
        case '+': if (fl[0]) { strcat(t,"to ");              fl[0]=FALSE; } break;
        case '-': if (fl[1]) { strcat(t,"removing ");        fl[1]=FALSE; } break;
        case 'o': if (fl[2]) { strcat(t,"operator,");        fl[2]=FALSE; } break;
        case 's': if (fl[3]) { strcat(t,"server msgs,");     fl[3]=FALSE; } break;
        case 'w': if (fl[4]) { strcat(t,"wallops,");         fl[4]=FALSE; } break;
        case 'i': if (fl[5]) { strcat(t,"invisible,");       fl[5]=FALSE; } break;
        default:  sprintf(x,"Unknown '%c',",*mode); strcat(t,x);
      }
    mode++;
    }
  }
  if (!strcmp(t,"to ") || *t == '\0') strcpy(t,"to nothing,");
  if (*t) t[strlen(t)-1]='\0';
  return(t);
}

/******************************************************************************/

analyzeout(char *il)
{
char *ilp,*olp,ol[MAXNETLEN],flag,*para,*para2,*p[MAXPARA],p0[256],p6[256],
     *tmp,t[MAXNETLEN],t2[256],atim[20],notify_nicks[50];
char tim[]="00:00:00.00";
int i,cnt,num;
bool wall_flag;
quadw curtim,pingtim,sendtim;
long status;

    if (dbopt&1) { sprintf(ol,"DEBUG: [server]%s",il); putchunk(ol,FALSE); }

    ilp=il;
    for(i=0;i<=MAXPARA;i++) p[i]="";
    flag=(*ilp==':'); i=0; if (flag) ilp++;
    while (*ilp && (i<=MAXPARA)) {
	if (*ilp==':' || (i==3 && !strcmp(p[0],"NAMREPLY")) ||
	  (i==2 && !strcmp(p[0],"LINREPLY"))) {
	    if (*ilp==':') ilp++; p[i]=ilp; i=MAXPARA+1;
	} else { p[i]=ilp; tillspace(ilp); if (*ilp) *ilp++ ='\0'; i++; }
    }

    if (dbopt&2) {
	sprintf(ol,"DEBUG: [parsed]%s|%s|%s|%s|%s|%s|%s|%s|%s|%s|%s",
          p[0],p[1],p[2],p[3],p[4],p[5],p[6],p[7],p[8],p[9],p[10]);
	putchunk(ol,FALSE);
    }

/*----------------------------------------------------------------------------*/

    num=atoi(p[1]);
    if (flag && num>0) {
	switch(num) {
	    case RPL_WELCOME:
	    case RPL_YOURHOST:
	    case RPL_CREATED: sprintf(ol,"*** %s",p[3]); putchunk(ol,FALSE);
		break;
	    case RPL_MYINFO:
		sprintf(ol,"*** Your host is %s, running version %s",p[3],p[4]);
		putchunk(ol,FALSE); break;
	    case RPL_TRACELINK:
		sprintf(ol,"*** Link %s<%s> ==> %s",p[0],p[4],p[5]);
		putchunk(ol,FALSE); break;
	    case RPL_TRACECONNECTING:
	    case RPL_TRACEHANDSHAKE:
      	    case RPL_TRACEUNKNOWN:
	    case RPL_TRACEOPERATOR:
	    case RPL_TRACEUSER:
      	    case RPL_TRACESERVICE:
		sprintf(ol,"*** %s Class[%2s] ==> %s",p[3],p[4],p[5]);
		putchunk(ol,FALSE); break;
      	    case RPL_TRACESERVER:
		sprintf(ol,"*** %s Class[%2s] ==> %s %s %s",p[3],p[4],p[7],
		  p[5],p[6]);
		putchunk(ol,FALSE); break;
	    case RPL_TRACECLASS:
		sprintf(ol,"*** %s %6s Entries linked %s",p[3],p[4],p[5]);
		putchunk(ol,FALSE); break;
      	    case RPL_STATSLINKINFO:
		if (strlen(p[3]) > 19) p[3][20]='\0';
		if (strlen(p[9]) > 19) p[9][20]='\0';
		sprintf(ol,"%20s %3s %7s %9s %7s %8s %s",p[3],p[4],p[5],
		  p[6],p[7],p[8],p[9]);
		putchunk(ol,FALSE); break;
	    case RPL_STATSCOMMANDS:
		sprintf(ol,"*** Command %8s: %10s %12s %12s",p[3],p[4],
		  p[5],p[6],p[7]);
		putchunk(ol,FALSE); break;
	    case RPL_STATSCLINE:
      	    case RPL_STATSNLINE:
      	    case RPL_STATSILINE:
      	    case RPL_STATSKLINE:
	    case RPL_STATSQLINE:
	    case RPL_STATSYLINE:
      	    case RPL_STATSLLINE:
      	    case RPL_STATSOLINE:
      	    case RPL_STATSHLINE:
		sprintf(ol,"STATS: %s %s %s %s %s %s %s %s",p[3],p[4],p[5],
		  p[6],p[7],p[8],p[9],p[10]);
		putchunk(ol,FALSE); break;
	    case RPL_STATSUPTIME: sprintf(ol,"%s: %s",p[0],p[3]);
		putchunk(ol,FALSE); break;
	    case RPL_ENDOFSTATS:
		break;
	    case RPL_UMODEIS:
		sprintf(ol,"*** Your user mode is set %s",analyze_mode(p[3],0));
		putchunk(ol,FALSE); break;
	    case RPL_SERVICEINFO:
		sprintf(ol,"*** Service %s (%s)",p[3],p[2]);
		putchunk(ol,FALSE); break;
      	    case RPL_ENDOFSERVICES:
		break;
	    case RPL_LUSERME:
	    case RPL_LUSERCLIENT: sprintf(ol,"*** %s",p[3]); putchunk(ol,FALSE);
		break;
	    case RPL_LUSERUNKNOWN:
	    case RPL_LUSEROP: sprintf(ol,"*** There are %s %s",p[3],p[4]);
		putchunk(ol,FALSE); break;
	    case RPL_LUSERCHANNELS:
		sprintf(ol,"*** There have been %s %s",p[3],p[4]);
		putchunk(ol,FALSE); break;
	    case RPL_ADMINME:
	    case RPL_ADMINLOC1:
	    case RPL_ADMINLOC2:
	    case RPL_ADMINEMAIL:
		sprintf(ol,"*** %s",p[3]); putchunk(ol,FALSE);
		break;
	    case RPL_TRACELOG:
		sprintf(ol,"*** %s %s",p[0],p[3]); putchunk(ol,TRUE);
	    case RPL_NONE: break;
      	    case RPL_AWAY:
		if(!*p[4]) p[4]="No message (strange)";
		sprintf(ol,"*** %s is away: \042%s\042",p[3],p[4]);
        	putchunk(ol,FALSE); break;
	    case RPL_USERHOST:
		tmp = p[3];
		if (*tmp) {
		    while (*tmp != "+") tmp++;
		    *--tmp = '\0'; *++tmp = '\0';
		    sprintf(ol,"*** %s is %s",p[3],++tmp);
		    putchunk(ol,TRUE);
		} break;
	    case RPL_UNAWAY:
	    case RPL_NOWAWAY:
		sprintf(ol,"*** %s",p[3]); putchunk(ol,TRUE); break;
      	    case RPL_WHOISUSER:
		sprintf(ol,"*** %s is %s@%s (%s)",p[3],p[4],p[5],p[7]);
		putchunk(ol,FALSE); break;
	    case RPL_WHOISSERVER:
		if (*p[3]=='*' && *p[4]=='*')
		    sprintf(ol,"*** On IRC via unknown server (server name removed by gateway)");
		else if (*p[5])
		    sprintf(ol,"*** On IRC via server %s (%s)",p[4],p[5]);
		else
		    sprintf(ol,"*** On IRC via server %s (%s)",p[3],p[4]);
        		putchunk(ol,FALSE); break;
	    case RPL_WHOISOPERATOR:
		sprintf(ol,"*** %s has a connection to the twilight zone",p[3]);
		putchunk(ol,FALSE); break;
	    case RPL_WHOWASUSER:
		if (*p[6]=='*') p[6]="*PRIVATE*";
		if (*p[6]=='+') { strcpy(p6,p[6]); strcat(p[6]=p6,"+"); }
		if (*p[6]=='#') { strcpy(p6,p[6]); strcat(p[6]=p6,"#"); }
		sprintf(ol,"*** %s was %s@%s (%s) on channel %s",p[3],p[4],
		  p[5],p[7],p[6]);
		putchunk(ol,FALSE); break;
      	    case RPL_WHOISIDLE:
		sscanf(p[4],"%d",&cnt); i = cnt/60; num = cnt%60;
		sprintf(ol,"*** %s has been idle for %d minutes and %d seconds",
			p[3],i,num);
		putchunk(ol,FALSE); break;
	    case RPL_ENDOFWHO:
		whoop=0; break;
	    case RPL_WHOISCHANNELS:
		sprintf(ol,"*** %s is on channels %s",p[3],p[4]);
		putchunk(ol,FALSE); break;
	    case RPL_WHOISCHANOP:
		sprintf(ol,"*** %s has been touched by magic forces",p[3]);
		putchunk(ol,FALSE); break;
	    case RPL_LISTSTART:
		putchunk("***    Channel: Users  Topic",FALSE); break;
      	    case RPL_LIST:
		if (p[3][0]=='*') p[6]="   Private:";
		else {
		    strcpy(p[6]=p6,p[3]);
		    if (strlen(p[6])>10) { p[6][10]='*'; p[6][11]='\0'; }
		    else strcat(p[6],":");
		}
		sprintf(ol,"*** %11s %5s  %s",p[6],p[4],p[5]);
        		putchunk(ol,FALSE); break;
	    case RPL_LISTEND:
		break;
	    case RPL_CHANNELMODEIS:
		sprintf(ol,"*** Mode is set %s %s%s%s",analyze_mode(p[4]),*p[5]?"(max.users ":"",p[5],*p[5]?")":"");
		putchunk(ol,FALSE); break;
	    case RPL_NOTOPIC:
		if ((!*srvnam || !strcmp(p[0],srvnam)) &&
		  (strcmp(p[3],"Bad Craziness")))
		putchunk("*** No Topic is set.",TRUE);
		break;
	    case RPL_TOPIC:
		if (!*srvnam || !strcmp(p[0],srvnam) || dbopt&0x10) {
		    if (*p[4])
			sprintf(ol,"*** Topic on channel %s is %s",p[3],p[4]);
		    else
			sprintf(ol,"*** Topic is %s",p[3]);
		    putchunk(ol,TRUE);
		} break;
	    case RPL_INVITING:
		sprintf(ol,"*** Inviting user %s into channel %s",p[3],p[4]);
		putchunk(ol,TRUE); break;
	    case RPL_SUMMONING:
		sprintf(ol,"*** %s %s",p[3],p[4]); putchunk(ol,TRUE); break;
	    case RPL_VERSION:
		sprintf(ol,"*** Server %s runs IRC version %s",p[4],p[3]);
		putchunk(ol,FALSE); break;
	    case RPL_WHOREPLY:        /* ===WHO,WHOOP,WHOP,WHOX=== */
		if (!strcmp(p[3],"Channel") && !strcmp(p[4],"User")) {
		    strcpy(t,"Channel  Nickname  S  User@Host         ");
		    switch(whoop) {
			case 0: sprintf(ol,"%sName",t); break;
			case 1: sprintf(ol,"%sName (Operators only)",t); break;
			case 2: sprintf(ol,"%sServer",t); break;
			case 3: sprintf(ol,"%sName (pattern=%s)",t,whoinp); break;
            		case 4: sprintf(ol,"%sName (exclude=%s)",t,whoinp); break;
			case 5: sprintf(ol,"%sName (Sleeping users only)",t); break;
		    }
		    putchunk(ol,FALSE);
		} else {
		    switch(*p[3]) {
			case '0': if (strcmp(p[3],"0")) {
			    strcpy(p[0]=p0,p[3]);
			    if (strlen(p[0])>7) { p[0][7]='*'; p[0][8]='\0'; }
			    else strcat(p[0],":");
			    break; }
			case '*': p[0]="Private:"; break;
			default:  strcpy(p[0]=p0,p[3]);
			    if (strlen(p[0])>7) { p[0][7]='*'; p[0][8]='\0'; }
			    else strcat(p[0],":\0");
		    }
		    switch(whoop) {
			case 0: sprintf(ol,"%8s %-10s%-4s%s@%s (%s)",p[0],p[7],p[8],p[4],p[5],p[9]);
			    putchunk(ol,FALSE); break;
			case 1: sprintf(ol,"%8s %-10s%-4s%s@%s (%s)",p[0],p[7],p[8],p[4],p[5],p[9]);
			    if ((p[8][1]==whoinp[0] || p[8][1]==whoinp[1] ||
			      p[8][2]==whoinp[0] || p[8][2]==whoinp[1]) && p[8][1])
				putchunk(ol,FALSE); break;
			case 2: sprintf(ol,"%8s %-10s%-4s%s@%s (%s)",p[0],p[7],p[8],p[4],p[5],p[6]);
			    putchunk(ol,FALSE); break;
			case 3: sprintf(ol,"%8s %-10s%-4s%s@%s (%s)",p[0],p[7],p[8],p[4],p[5],p[9]);
			    tmp = &t;
			    sprintf(tmp,"%s %s",ol,p[6]);
			    if (strimw(&whoinp,tmp)) putchunk(ol,FALSE);
			    c$cks(1); break;
			case 4: sprintf(ol,"%8s %-10s%-4s%s@%s (%s)",p[0],p[7],p[8],p[4],p[5],p[9]);
			    tmp = &t;
			    sprintf(tmp,"%s %s",ol,p[6]);
			    if (!strimw(&whoinp,tmp)) putchunk(ol,FALSE);
			    c$cks(1); break;
			case 5: sprintf(ol,"%8s %-10s%-4s%s@%s (%s)",p[0],p[7],p[8],p[4],p[5],p[9]);
			    if (*p[8]=='G') putchunk(ol,FALSE); break;
		    }
		} break;
	    case RPL_KILLDONE:
		if (!*srvnam || !strcmp(p[0],srvnam) || dbopt&0x10) {
		    sprintf(ol,"*** Kill: May the soul of %s rest in peace...",p[3]);
		    putchunk(ol,TRUE);
		} break;
	    case RPL_CLOSING:
	    case RPL_CLOSEEND:
		sprintf(ol,"*** %s %s",p[3],p[4]); putchunk(ol,TRUE); break;
	    case RPL_LINKS:
		sprintf(ol,"*** Server: %s (%s)",p[3],p[4]);
		putchunk(ol,FALSE); break;
	    case RPL_NAMREPLY:
		if (*p[3]=='*') p[6]="Private:";
		else {
		    strcpy(p[6]=p6,p[4]);
		    if (strlen(p[6])>7) { p[6][7]='*'; p[6][8]='\0'; }
		    else strcat(p[6],":");
		}
		sprintf(ol,"%8s %s",p[6],p[5]);
		putchunk(ol,FALSE); break;
      	    case RPL_ENDOFLINKS:
		break;
	    case RPL_ENDOFNAMES:
		break;
	    case RPL_INFOSTART:
	    case RPL_INFO:
	    case RPL_ENDOFINFO:
	    case RPL_MOTDSTART:
	    case RPL_ENDOFMOTD:
		sprintf(ol,"*** %s",p[3]); putchunk(ol,FALSE); break;
	    case RPL_MOTD:
		sprintf(ol,"*** Motd: %s",p[3]);
		putchunk(ol,FALSE); break;
	    case RPL_YOUREOPER:
		your_priv=TRUE;
		sprintf(ol,"*** Good afternoon, %s. I am a VAX 9440VP running VMS 6.0-1",p[2]);
		putchunk(ol,TRUE); break;
	    case RPL_REHASHING:
		putchunk("*** Re-reading irc.conf - file... Hope it works nice now...",FALSE); break;
	    case RPL_TIME:
		sprintf(ol,"*** Time on host %s is %s",p[3],p[4]);
		putchunk(ol,FALSE); break;
	    case RPL_USERSSTART:
	    case RPL_USERS:
	    case RPL_ENDOFUSERS:
	    case RPL_NOUSERS:
		sprintf(ol,"*** %s",p[3]); putchunk(ol,TRUE); break;
	    case ERR_NOSUCHNICK:
		sprintf(ol,"*** Error: No such nickname (%s)",p[3]);
		putchunk(ol,FALSE); break;
	    case ERR_NOSUCHSERVER:
		sprintf(ol,"*** Error: No such server (%s)",p[3]);
		putchunk(ol,FALSE); break;
	    case ERR_NOSUCHCHANNEL:
		if (stricmp(p[3],my_nick)) {
		    sprintf(ol,"*** Error: No such channel (%s)",p[3]);
		    putchunk(ol,FALSE); }
		break;
	    case ERR_CANNOTSENDTOCHAN:
		putchunk("*** Error: Sending to that channel is forbidden from heathens.",FALSE); break;
	    case ERR_NORECIPIENT:
		putchunk("*** Error: Message had no recipient.",FALSE); break;
	    case ERR_NOTEXTTOSEND:
		putchunk("*** Error: No text to send, so empty message not sent.",FALSE); break;
	    case ERR_UNKNOWNCOMMAND:
		sprintf(ol,"*** Error [%s]: Unknown command (%s)",p[0],p[3]); putchunk(ol,FALSE);
		break;
	    case ERR_NOMOTD: putchunk(p[3],TRUE); break;
	    case ERR_NONICKNAMEGIVEN:
		strncpy(my_nick,p[2],MAXNICKLEN-1); my_nick[MAXNICKLEN-1]='\0';
		create_status();
		putchunk("*** Error: No nickname given. Please choose one.",FALSE); break;
	    case ERR_ERRONEUSNICKNAME:
		strncpy(my_nick,p[2],MAXNICKLEN-1); my_nick[MAXNICKLEN-1]='\0'; create_status();
		putchunk("*** Error: Some special characters cannot be used in nicknames.",FALSE); break;
	    case ERR_NICKNAMEINUSE:
		strncpy(my_nick,p[2],MAXNICKLEN-1); my_nick[MAXNICKLEN-1]='\0'; create_status();
		sprintf(ol,"*** Error: Nickname (%s) is already in use. Please choose another.",p[3]);
		putchunk(ol,FALSE); break;
	    case ERR_USERNOTINCHANNEL:
		if (!*srvnam || !strcmp(p[0],srvnam) || dbopt&0x10)
		putchunk("*** Error: You have not joined a channel!",FALSE); break;
	    case ERR_NOTONCHANNEL:
		sprintf(ol,"*** Error: %s",p[4]);
		putchunk(ol,FALSE); break;
	    case ERR_SUMMONDISABLED:
	    case ERR_USERSDISABLED: putchunk(p[3],TRUE); break;
	    case ERR_NOTREGISTERED:
		putchunk("*** Error: You haven't registered yourself yet. Missing NICK,USER ?",FALSE); break;
	    case ERR_NEEDMOREPARAMS:
		sprintf(ol,"*** Error: %s",*p[3]?p[3]:"The command needs more paramters...");
		putchunk(ol,FALSE); break;
	    case ERR_ALREADYREGISTRED:
		putchunk("*** Error: You're already registered... Do you have any identity problems?",FALSE); break;
	    case ERR_NOPERMFORHOST:
		putchunk("*** Error: Your host isn't among the privileged. You've lost...",FALSE); break;
	    case ERR_PASSWDMISMATCH:
		putchunk("*** Error: Only real wizards do know the spells to open the gates of paradise!",FALSE); break;
	    case ERR_YOUREBANNEDCREEP:
		putchunk("*** You're banned from IRC... No chance!",TRUE); break;
	    case ERR_YOUWILLBEBANNED:
		sprintf(ol,"*** Warning: You will be banned in %d minutes! *hehe*",atoi(p[3]));
		putchunk(ol,TRUE); break;
	    case ERR_CHANNELISFULL:
		sprintf(ol,"*** Error: Sorry... Channel %s is full.",p[3]);
		putchunk(ol,FALSE); break;
	    case ERR_UNKNOWNMODE:
		sprintf(ol,"*** Error: %s is unknown mode char to me... What do you want ?",p[3]);
		putchunk(ol,FALSE); break;
	    case ERR_INVITEONLYCHAN:
		putchunk("*** Error: Magic locks open only with an invitation key...",FALSE); break;
	    case ERR_NOPRIVILEGES:
		sprintf(ol,"*** Error: %s",*p[3]?p[3]:"Only few and chosen are granted privileges. You're not one!");
		putchunk(ol,FALSE); break;
	    case ERR_NOOPERHOST:
		putchunk("*** Error: Only few of mere mortals may try to enter twilight zone...",FALSE); break;
	    case 318:
		break;
	    case 303:
		if (notify_request) {
		    notify_request = FALSE;
		    mark_notify(p[3]);
		    return;
		}
	    default:
		sprintf(ol,"*** Numeric message: (%d) %s %s %s %s %s %s %s",num,p[3],p[4],p[5],p[7],p[6],p[8],p[9]);
		putchunk(ol,TRUE);
	}
	if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }
    } else

  /*--------------------------------------------------------------------------*/

    if (!strcmp(p[0],"ERROR") && !flag) {         /* === ERROR === */
	sprintf(ol,"*** Server error message: %s",p[1]);
	putchunk(ol,FALSE);
	if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }
    } else
    if (!strcmp(p[0],"NOTICE") && !flag) {        /* === NOTICE === */
	if (notice_flag && !strncmp(p[2],"*** Notice -- Received KILL",27)) {
	    para=p[2]+40; tmp=t; para2=t2;
	    while (*para!=' ' && *para!=':' && *para!='.') *tmp++ = *para++;
	    *tmp++ =' '; while (*para && *para!='(') para++;
	    para--; if (*para==' ') para--;
	    while (*para!='!' && *para!=' ') para--; para++;
	    while (*para && *para!='(') {
		if (*para!=' ') *para2++ = *para; para++; }
	    while (*para) *tmp++ = *para++; *tmp='\0'; *para2='\0';
	    sprintf(ol,"*** Kill message from %s for %s",t2,t);
		putchunk(ol,FALSE);
	} else putchunk(p[2],FALSE);
	if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }
    } else
	if (!strcmp(p[0],"PING") && !flag) {          /* === PING === */
	sprintf(ol,"PONG %s\n\0",p[1]);
	qio_send(ol);
    } else
    if (!strcmp(p[0],"PONG")) {                   /* === PONG === */
	sprintf(ol,"*** %s answered your PING message for %s",p[1],p[2]);
	putchunk(ol,FALSE);
    } else {

  /*--------------------------------------------------------------------------*/

	if (ignore_max) {
	    ignore_flag=FALSE; wall_flag=FALSE;
	    for(cnt=0; cnt<ignore_max && !ignore_flag;cnt++) {
		if (strimw(ignore_ptr[cnt],p[0]))
		    ignore_flag = TRUE;
		else ignore_flag = !(stricmp(nstrip(p[0]),ignore_ptr[cnt]) &&
		    stricmp(hstrip(p[0]),ignore_ptr[cnt]));
		if (dbopt&0x20)
		    printf("\n[IgnoreFlags] p:%s, c:%s, cnt:%d flg:%d",p[0],ignore_ptr[cnt],cnt,ignore_flag);
	    }
	} else { ignore_flag=FALSE; wall_flag=FALSE; }
	strcpy(atim,analyze_time());

	if ((!strcmp(p[1],"JOIN") && flag)) {       /* === JOIN [2.6] === */
	    if (strcmp(p[2],"0")) {
		if (!strncmp(p[0],my_nick,strlen(my_nick))) {
		    if (on_channel(p[2])) {
			join(p[2]); flush_windows(0); }
		    else {
			create_channel(p[2]); join(p[2]); flush_windows(1);}
		    create_status();
		}
		if (tmp=strchr(p[0],'!')) {
		    if (strlen(tmp)) { *tmp = '\0'; tmp++; }
		} else tmp = &p[0][strlen(p[0])-1]; 
		sprintf(ol,"%s*** Change: %s (%s) has joined channel %s",atim,p[0],tmp,p[2]);
		putchunk(ol,TRUE); }
	    else {
	    sprintf(ol,"%s*** Change: %s has left this Channel",atim,nstrip(p[0]));
	    putchunk(ol,TRUE);
	    if (!strcmp(p[0],my_nick)) { strcpy(my_chan,"0"); create_status(); }
	    }
	    if (signalmode&6) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"INVITE") && flag) {       /* === INVITE === */
	    sprintf(ol,"%s*** %s invites you to channel %s%s%s",atim,nstrip(p[0]),*p[3]=='+'?"'":"",*p[3]=='+'?p[3]+1:p[3],*p[3]=='+'?"'":"");
	    putchunk(ol,TRUE);
	    if (signalmode) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"KICK") && flag) {         /* === KICK [2.5] === */
	    if (!strcmp(p[3],my_nick)) { leave_channel(p[2]); create_status(); }
	    sprintf(ol,"%s*** %s was kicked out off the channel by %s (%s)",atim,nstrip(p[3]),nstrip(p[0]),p[4]);
	    putchunk(ol,TRUE);
	    if (signalmode&6) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"KILL") && flag) {         /* === KILL === */
	    sprintf(ol,"%s*** %s was killed by %s",atim,nstrip(p[2]),nstrip(p[0]));
	    putchunk(ol,TRUE);
	    if (signalmode&6) { printf("\007\007"); wrefresh(inpwin); }
	    rundown(1);
	} else
	if (!strcmp(p[1],"MODE") && flag) {         /* === MODE [2.5] === */
	    if (strcmp(p[2],my_nick)) {
		sprintf(ol,"*** %s modified the channel mode %s %s%s%s",nstrip(p[0]),analyze_mode(p[3],TRUE),*p[4]?"'":"",p[4],*p[4]?"'":""); }
	    else {
		sprintf(ol,"*** You have modified your user mode %s",analyze_mode(p[3],FALSE)); }
	    putchunk(ol,TRUE);
	    if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"NICK") && flag) {         /* === NICK === */
	    sprintf(ol,"%s*** Change: %s is now known as %s",atim,nstrip(p[0]),p[2]);
	    putchunk(ol,TRUE);
	    if (signalmode&6) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"PRIVMSG") && flag) {	/* === PRIVMSG === */
	    if (*p[3] == '\001' && *p[2] != '$' && (*p[2] != '#' ||
	      on_channel(p[2])))
		analyze_ctcp(nstrip(p[0]),p[3]);
	    else if (*p[3] == '\001') {}
	    else if ((p[2][0] == '+') || (p[2][0] == '#') || (p[2][0] == '&') || (p[2][0] == '$')) {
		if (signalmode&2) { printf("\007\007"); wrefresh(inpwin); }
		if (!stricmp(my_chan,p[2]))
		    { sprintf(ol,"%s(%s) %s",atim,(nstrip(p[0])),p[3]);
		    putchunk(ol,TRUE); }  
		else
		    { sprintf(ol,"%s%s(%s) %s",atim,p[2],(nstrip(p[0])),p[3]);
		    putchunk(ol,TRUE); }
	    } else if (ignore_flag) {
		sprintf(ol,"NOTICE %s :%s is ignoring you.\r\n\0",
		  nstrip(p[0]),my_nick);
		qio_send(ol); }
	    else {
		if (signalmode&1) { printf("\007\007"); wrefresh(inpwin); }
		for(cnt=0;cnt<query_max;cnt++)
		    if (!stricmp((nstrip(p[0])),query_ptr[cnt])) break;
		sprintf(ol,cnt<query_max?"%s|%s| %s":"%s*%s* %s",atim,
		  (nstrip(p[0])),p[3]);
		analyze_privmsg(nstrip(p[0]));
		putchunk(ol,TRUE);
	    }
	} else
	if (!strcmp(p[1],"NOTICE") && flag) {	/* === NOTICE === */
	    if ((p[3][0]=='\001')) {
		if (!strncmp(p[3],"\001ERRMSG PING RELAY",18)) {
/*	            t2[] = "17-NOV-1858 00:00:00.00"; */
		    sys$gettim(&curtim);
		    tmp = &p[3][19]; tmp[23] = '\0';
		    status = sys$bintim(c$dsc(tmp),&sendtim);
		    status = lib$sub_times(&curtim,&sendtim, &pingtim);
		    status = sys$asctim(&i,c$dsc(tim),&pingtim,1);
		    sprintf(ol,"*** CTCP PING time to %s is %s", nstrip(p[0]),
		      tim);
		}
		else {
		    tmp = &p[3][1]; tillspace(p[3]);
		    p[3][0] = '\0'; p[3]++; p[3][strlen(p[3])-1] = '\0';
		    sprintf(ol, "*** CTCP %s reply from %s: %s", tmp,
		      nstrip(p[0]), p[3]);
		}
	    }
	    else if (notice_flag && !strncmp(p[3],"*** Notice -- Received KILL",27))
	    {
		para=p[3]+40; tmp=t; para2=t2;
		while (*para!=' ' && *para!=':' && *para!='.') *tmp++ = *para++;
		*tmp++ =' '; while (*para && *para!='(') para++;
		para--; if (*para==' ') para--;
		while (*para!='!' && *para!=' ') para--; para++;
		while (*para && *para!='(') {
		    if (*para!=' ') *para2++ = *para; para++; }
		while (*para) *tmp++ = *para++; *tmp='\0'; *para2='\0';
		sprintf(ol,"*** Kill message from %s for %s",t2,t);
	    }
	    else sprintf(ol,"%s-%s- %s",atim,(nstrip(p[0])),p[3]);
	    putchunk(ol,TRUE);
	} else
	if (!strcmp(p[1],"PART") && flag) {         /* === PART [2.6] === */
	    if (!strcmp((nstrip(p[0])),my_nick)) {
		leave_channel(p[2]); flush_windows(0);
		create_status();
	    }
	    sprintf(ol,"%s*** Change: %s has left Channel %s",atim,
	      nstrip(p[0]),p[2]);
	    putchunk(ol,TRUE);
	    if (signalmode&6) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"TOPIC") && flag) {        /* === TOPIC === */
	    if (*p[3])
		sprintf(ol,"%s*** %s changed the topic on channel %s to %s",
		  atim,nstrip(p[0]),p[2],p[3]);
	    else
		sprintf(ol,"%s*** %s changed the topic to %s",atim,
		  nstrip(p[0]),p[2]);
	    putchunk(ol,TRUE);
	    if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"QUIT") && flag) {         /* === QUIT === */
	    if (*p[2]) sprintf(ol,"%s*** Signoff: %s (%s)",atim,nstrip(p[0]),
	      p[2]);
	    else sprintf(ol,"%s*** Signoff: %s",atim,nstrip(p[0]));
	    putchunk(ol,TRUE);
	    if (signalmode&6) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"WALL") && flag) {         /* === WALL === */
	    if (wall_flag) ignore_flag=TRUE;
	    sprintf(ol,"%s#%s# %s",atim,p[0],p[2]);
	    putchunk(ol,TRUE);
	    if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }
	} else
	if (!strcmp(p[1],"WALLOPS") && flag) {      /* === WALLOPS [2.4] === */
	    if (wall_flag) ignore_flag=TRUE;
	    sprintf(ol,"%s!%s! %s",atim,nstrip(p[0]),p[2]);
	    putchunk(ol,TRUE);
	    if (signalmode&4) { printf("\007\007"); wrefresh(inpwin); }

	} else if (*il) { sprintf(ol,"Message: %s",il); putchunk(ol,TRUE); }
    }
}
/******************************************************************************/
