/******************************************************************************

                       VMS - IRC - Client   part ASYNC

 Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
                       CMU/tek, UCX, Wollongong or Multinet TCP/IP

 Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG

 Modified for IRC 2.7 by GrayElf, paul@coombs.anu.edu.au

 ******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <iodef.h>
#include <ssdef.h>
#include <msgdef.h>
#include "header.h"
#include "environment.h"
#include "misc.h"

extern analyzeout(),c$cks(),c$dsc(),putbold(),putchunk(),putwin(),qio_send(),
       recall_move(),recall_output(),rundown(),strincmp(),create_status(),
       msg_refresh(),notify_request;

extern time_t last_command;

extern do_noecho(),do_default(),do_big(),do_cls(),do_oper(),do_ctcp(),
       do_cmdch(),do_debug(),do_enter(),do_errlog(),do_privmsg(),do_dcl(),
       do_help(),do_ignore(),do_join(),do_loadfont(),do_log(),do_quit(),
       do_chunk(),do_msg(),do_nokill(),do_query(),do_quote(),do_clock(),
       do_type(),do_leave(),do_who(),do_script(),do_fkey(),do_recall(),
       do_nobold(),do_flags(),do_nick(),do_brdcst(),do_cd(),do_showesc(),
       do_time(),do_flush(),do_comment(),do_copyright(),do_alias(),do_kill(),
       do_server(),do_srvinfo(),do_mode(),do_spawn(),do_away(),do_topic(),
       do_signal(),do_redirect(),do_status(),do_inpscroll(),do_notify(),
       do_squit();

       
globaldef struct Message msgtab[] = {

  {"admin",     do_noecho,0,1,     "ADMIN [server]            Show administrative info"},
  {"alias",	do_alias,0,0,      "ALIAS                     Alias a command"},
  {"authors",   do_copyright,0,0,  "AUTHORS                   Displays copyright message"},
  {"away",      do_away,1,1,       "AWAY [text]               [Re]Set away message"},
  {"big",       do_big,0,0,        "BIG <*|nick> <text>       Send message in big letters"},
  {"bold",      do_nobold,0,0,     "BOLD                      Toggle bold text display"},
  {"broadcast", do_brdcst,0,0,     "BROADCAST                 Toggle broadcast window"},
  {"bye",       do_quit,0,1,       "BYE                       Exit IRC"},
  {"channel",   do_join,0,0,       "CHANNEL <channel>         Enter channel"},
  {"cd",        do_cd,0,0,         "CD [directory|?]          Change working directory"},
  {"cls",       do_cls,0,0,        "CLS                       Clear screen"},
  {"clock",     do_clock,1,0,      "CLOCK                     Display/Remove clock (what else ?)"},
  {"cmdch",     do_cmdch,0,0,      "CMDCH                     Change command character"},
  {"connect",   do_default,0,1,    "CONNECT <server> <port>   Add link to remote server (+)"},
  {"comment",   do_comment,0,0,    "COMMENT [text]            Comment on screen/in logfile"},
  {"ctcp",	do_ctcp,0,1,	   "CTCP <nick> <query>	      Client To Client Protocol"},
  {"date",      do_time,1,1,       "DATE [server]             Show local time for server"},
  {"dcl",       do_dcl,0,0,        "DCL [command]             Send DCL command"},
  {"debug",     do_debug,0,0,NIL},
  {"die",       do_default,0,0,    "DIE                       Shutdown own server"},
  {"enter",     do_enter,0,0,      "ENTER <channel> [text]    Enter channel and print text"},
  {"errlog",    do_errlog,0,0,     "ERRLOG                    Enable/disable error logging"},
  {"error",     do_default,0,1,    "ERROR [text]              Send error message to server"},
  {"exit",      do_quit,0,1,       "EXIT                      Exit IRC"},
  {"fkey",      do_fkey,0,0,       "FKEY <Key|?> [text]       Define function key"},
  {NIL,         NIL,0,0,           "                          [Keypad 0..9, GOLD a..z]"},
  {"flags",     do_flags,0,0,      "FLAGS                     Show client settings"},
  {"flush",     do_flush,0,0,      "FLUSH                     Flush incoming messages"},
  {"grph",      do_privmsg,1,1,    "GRPH <nick> <text>        Private message"},
  {"help",      do_help,0,0,       "HELP                      Surprise!"},
  {"here",      do_away,2,1,       "HERE                      Reset away message"},
  {"invite",    do_default,0,1,    "INVITE <nick> [channel]   Invite someone to a channel"},
  {"info",      do_noecho,0,1,     "INFO                      Inventor's info"},
  {"inpscroll", do_inpscroll,0,0,NIL},
  {"ignore",    do_ignore,0,0,     "IGNORE [nick|WALL|?]      Ignore someones messages"},
  {"join",      do_join,0,0,       "JOIN <channel>            Enter channel"},
  {"kick",      do_mode,1,0,       "KICK <nick>               Kick somebody from channel"},
  {"kill",      do_kill,0,0,       "KILL <nick>               Kill someone (+)"},
  {"list",      do_default,0,1,    "LIST                      List channel topics"},
  {"leave",     do_leave,0,0,      "LEAVE [time|?]            Set alarm clock"},
  {"links",     do_default,0,1,    "LINKS [server]            List connected servers"},
  {"loadfont",  do_loadfont,0,0,   "LOADFONT <file>           Load a BIG font"},
  {"log",       do_log,0,0,        "LOG [RECALL] [filename]   Start/stop logfile"},
  {"lusers",    do_noecho,0,1,     "LUSERS                    Summarize user info"},
  {"m",         do_privmsg,3,1,    "M <nick> <text>           Private message"},
  {"me",	do_ctcp,1,1,	   "ME <action>               Sends a ctcp action"},
  {"mirror",    do_chunk,2,1,      "MIRROR <*|nick> <text>    Send mirrored text"},
  {"mode",      do_mode,2,0,       "MODE [chan|?] [param]     Set mode of named chan"},
  {"motd",      do_noecho,0,1,     "MOTD [server]             Show motto of the day"},
  {"msg",       do_privmsg,3,1,    "MSG <nick> <text>         Private message"},
  {"names",     do_noecho,0,1,     "NAMES                     Show users' nicknames"},
  {"nick",      do_nick,0,1,       "NICK <newnick>            Change your nickname"},
  {"nokill",    do_nokill,0,0,     "NOKILL                    Suppress full kill messages"},
  {"note",	do_default,0,1,    "NOTE                      Use NOTE, no help available"},
  {"notice",    do_privmsg,2,1,    "NOTICE <nick> <text>      Private message"},
  {"notify",	do_notify,1,0,     "NOTIFY [+|-<nick>]        Add/remove users from NOTIFY list"},
  {"oper",      do_oper,0,1,       "OPER <name> <pass>        Become operator"},
  {"oops",      do_redirect,2,0,   "OOPS <nick> [text]        Redirect message and excuse"},
  {"part",      do_join,1,1,       "PART <channel>            Leave a channel"},
  {NIL,         NIL,0,0,           "(*) PASS <server.pwd>     Enter server password"},
  {"ping",      do_ctcp,2,1,       "PING <nick>               Check time for a CTCP reply"},
  {"privmsg",   do_privmsg,3,1,    "PRIVMSG <nick> <text>     Private message"},
  {"query",     do_query,0,0,      "QUERY [nick(s)|?] [text]  Set prefix for private messages"},
  {"quit",      do_quit,0,1,       "QUIT                      Exit IRC"},
  {"quote",     do_quote,0,1,      "QUOTE <string>            Pass string directly to server"},
  {"recall",    do_recall,0,0,     "RECALL [DCL|MSG]          Recall message to input line"},
  {"redirect",  do_redirect,1,0,   "REDIRECT <nick>           Redirect message"},
  {"rehash",    do_default,0,1,    "REHASH                    Reconfigure server (+)"},
  {"remirror",  do_recall,2,0,     "REMIRROR                  Show recent messages mirrored"},
  {"rerot13",   do_recall,1,0,     "REROT13                   Show recent messages rot13'ed"},
  {"restart",   do_default,0,0,    "RESTART                   Restart server"},
  {"rot13",     do_chunk,1,1,      "ROT13 <*|nick> <text>     Send message rot13'ed"},
  {"stats",     do_default,0,1,    "STATS [mode] [server]     Show server statistics"},
  {NIL,         NIL,0,0,           "                          [M: cmds, L: links, C: config]"},
  {"say",       do_msg,0,1,        "SAY <text>                Send message"},
  {"script",    do_script,0,0,     "SCRIPT <filename>         Execute scriptfile"},
  {"server",    do_server,0,0,     "SERVER <server> [port]    Connect to another server"},
  {"showesc",   do_showesc,0,0,    "SHOWESC                   Display/Interpret escape chars"},
  {"signal",    do_signal,0,0,     "SIGNAL [<mode>|?]         Signal messages"},
  {NIL,         NIL,0,0,           "                          [NONE|PRIV|MSG|MOD|ALL]"},
  {"spawn",     do_spawn,0,0,      "SPAWN                     Shell escape"},
  {"squit",     do_squit,0,0,      "SQUIT <server>            Remove link to server (+)"},
  {"srvinfo",   do_srvinfo,0,0,    "SRVINFO [server]          Give information about server"},
  {"status",    do_status,0,0,     "STATUS                    Toggle status line display"},
  {"summon",    do_default,0,1,    "SUMMON <usr>@<server>     Invite user to IRC"},
  {"time",      do_time,2,1,       "TIME [server]             Show local time for server"},
  {"topic",     do_topic,0,1,    "TOPIC [topic]             Set/Show topic of channel"},
  {"trace",     do_default,0,1,    "TRACE [server]            Show active links (+)"},
  {"type",      do_type,0,0,       "TYPE <*|nick> <file>      Send file as messages"},
  {"users",     do_default,0,1,    "USERS [server]            Show interactive users on server"},
  {"version",   do_default,0,1,    "VERSION [server]          Show version of server"},
  {"voice",     do_privmsg,4,1,    "VOICE <nick> <text>       Private message"},
  {"who",       do_who,0,1,        "WHO [*|channel]           Show users on channel"},
  {"wall",      do_default,0,1,    "WALL <text>               Send message to everybody (+)"},
  {"wallops",   do_default,0,1,    "WALLOPS <text>            Send message to all op's [2.4]"},
  {"whoaway",   do_who,5,1,        "WHOAWAY [*|channel]       Show all people who are sleeping"},
  {"whois",     do_default,0,1,    "WHOIS <nick>              Detailed user information"},
  {"whoop",     do_who,1,1,        "WHOOP [@|*|#] [*|channel] Show operators/ChanOp's"},
  {"whop",      do_who,3,1,        "WHOP <pattern> [*|chan.]  Show users with pattern selection"},
  {"whox",      do_who,4,1,        "WHOX <pattern> [*|chan.]  Show users with pattern exclusion"},
  {"whosrv",    do_who,2,1,        "WHOSRV [*|channel]        Show users with servers"},
  {"whowas",    do_default,0,1,    "WHOWAS <nick>             Show user who's gone [2.4]"},
  {"xtra",      do_privmsg,5,1,    "XTRA <nick> <text>        Private message"}
};

int HiddenCmd=4,
    AllCmd=sizeof(msgtab)/sizeof(struct Message);

/******************************************************************************/

win_refresh()
{
    wrefresh(brdcstwin); msg_refresh();
    if (status_line) wrefresh(statwin);
    if (clockwin) wrefresh(clockwin);
    if (dclwin) wrefresh(dclwin);
    if (tmpwin) wrefresh(tmpwin);
    wrefresh(inpwin);
}

/******************************************************************************/

showinpline(i,linlen,flag,curs)
char *i;
int linlen,flag,curs;
{
int start,cnt,co;
char *tmp,t[MAXCOLS+10],t2[MAXCOLS],*tp,*tmp2;

    co=(clockwin?COLS-6:COLS);
    if (flag!=1) {
    	start=curs-scrcurs;
	if (scrcurs<9 && curs>8)
	    { scrcurs=8+inpscroll;     start=curs-8-inpscroll; }
	if (scrcurs>co-10 && curs<linlen-9)
	    { scrcurs=co-9-inpscroll;  start=curs-co+9+inpscroll; }
	if (scrcurs>co-10 && curs>=linlen-9 && linlen>co && curs!=linlen)
	    { scrcurs=co-linlen+curs;  start=linlen-co; }
	if (scrcurs==co && curs==linlen)
	    { scrcurs=co-inpscroll;    start=linlen-co+inpscroll; flag=1; }
    } else {
	if (linlen<co) { scrcurs=linlen; start=0; }
	else { scrcurs=co-1; start=linlen-co+1; }
    }
    tmp=t; cnt=0; tp=i; i+=start;
    if (start && inpscroll==1) { *tmp++ = '\253'; i++; cnt++; }
    while (*i && cnt<co-1) { *tmp++ = *i++; cnt++; }
    if (cnt==co-1 && start+co<linlen && inpscroll==1) *tmp++ = '\273';
    else if (*i) *tmp++ = *i;

    *tmp++ =' '; *tmp='\0';
    tmp=tp; whilespace(tmp);
    strcpy(t2,tp); tmp2=t2; whilespace(tmp2); tillspace(tmp2); *tmp2='\0';
    if (!strincmp(t2,(cmdch[0]?cmdch:&cmdch[1]),
                min(strlen(&cmdch[1])+(cmdch[0]?1:0),strlen(t2)))
      && t2[(cmdch[0]?1:0)]) {
	tillspace(tmp);
	if (tmp<tp+start) tmp=t; else tmp+=t-tp-start;
	while (*tmp) *tmp++ =' ';
    }
    if (flag==1) { wmove(inpwin,0,0); wclrtoeol(inpwin); }
    if (flag!=2) {
	mvwaddstr(inpwin,0,0,t); wmove(inpwin,0,scrcurs); wrefresh(inpwin); }
}

/******************************************************************************/

testinpline(ilp)
char *ilp;
{
char *cmdp,cmd[MAXINPLEN],i[512],j[MAXINPLEN],*ptr;
int msg;
AliasStruct *tmp;

if (strlen(ilp) && *ilp != '\r' && *ilp != '\n') {
    last_command = time(0);
    if (ctrl_flag) {
	ptr=ilp;
	while(*ptr) {
	    if (*ptr=='^' && *(ptr+1)) {
		if (*(ptr+1)!='^') *ptr=upcase(*(ptr+1))-64;
		ptr++; cmdp=ptr;
		while (*(cmdp+1)) { *cmdp = *(cmdp+1); cmdp++; }
		*cmdp='\0';
	    } else ptr++;
	}
    }

    if ((cmdch[0] && *ilp==cmdch[0]) || (!cmdch[0])) {
	if (alias_list) {
	    ptr = &j; strcpy(ptr,ilp); tillspace(ptr); *ptr++ = '\0';
	    tmp = list_find(alias_list,&j[1],0);
	    if (tmp) {
		strcpy(i,tmp->equiv); tillspace(ilp);
		if (*ilp) strcat(i,ilp);
	    }
	    else if (!cmdch[0]) strcpy(i,&ilp[0]);
	    else strcpy(i,&ilp[1]);
	}
	else if (!cmdch[0]) strcpy(i,&ilp[0]);
	else strcpy(i,&ilp[1]);
    }
    else if (cmdch[0] && *ilp)
	sprintf(i,"SAY %s",ilp);
    ilp=i;

    cmdp=cmd; whilespace(ilp);
    if (*ilp) {
	while (*ilp!=' ' && *ilp)
	    if (islower(*ilp)) *cmdp++ = toupper(*ilp++);
	    else *cmdp++ = *ilp++;
    }
    *cmdp='\0'; whilespace(ilp);

    whoop = 0;
    if (cmd[0]) {
	for(msg=0;msg<AllCmd;msg++)
	    if (msgtab[msg].command)
		if (!strincmp(cmd,msgtab[msg].command,strlen(cmd))) {
		    j[0]=cmdch[0];
		    sprintf(&j[1],"%s %s",msgtab[msg].command,ilp);
		    (*msgtab[msg].funct)(msgtab[msg].varpar,ilp,j);
		    return(msgtab[msg].returncode);
		}
	sprintf(i,"*** Unknown Client command '%s'. For special commands try QUOTE.",cmd);
	putchunk(i,FALSE);
    }
    return(0);
}
}

/******************************************************************************/

kbd_escmode1(inpchar)
char inpchar;
{
char *tp;
int i;

    switch (inpchar) {
	case '0': case '1': case '2': case '3': case '4':
	case '5': case '6': case '7': case '8': case '9':
	    tp=fkey[inpchar-'0']; fkey_pos= fkey_mode[inpchar-'0']&1;
	    if (fkey_mode[inpchar-'0']&2) {
		inpx=0; crsr=inpx; inpline[inpx]='\0';
		showinpline(inpline,inpx,1,crsr);
	    }
	    while (*tp && inpx<MAXINPLEN) {
		if (crsr<inpx) {
		    i=inpx; while (i>=crsr) { inpline[i+1]=inpline[i]; i--; }
		    inpline[crsr]= *tp++; inpx++; crsr++; scrcurs++;
		} else {
		    inpline[inpx++]= *tp++; crsr++; scrcurs++;
		    inpline[inpx]='\0';
		}
		showinpline(inpline,inpx,2,crsr);
	    }
	    showinpline(inpline,inpx,0,crsr);
	    escflag=0; break;
	case 'D': case 'd':
	    do_flags(); escflag=0; break;
	case 'O':
	    escflag=3; break;
	case '[':
	    escflag=2; break;
	default: escflag=0;
    }
}

/******************************************************************************/

kbd_escmode2(inpchar)
char inpchar;
{
    switch (inpchar) {
	case '2':
	    escflag=4; break;
	case 'A':
	    if (ringminus(histptrt,MAXHIST)!=histptr && 
	      *histbuf[ringminus(histptrt,MAXHIST)]) {
		histptrt=ringminus(histptrt,MAXHIST);
		memcpy(inpline,histbuf[histptrt],MAXINPLEN);
		inpx=strlen(inpline); crsr=inpx;
		showinpline(inpline,inpx,1,crsr);
	    }
	    escflag=0; break;
	case 'B':
	    if (histptrt!=histptr && ringplus(histptrt,MAXHIST)!=histptr) {
		histptrt=ringplus(histptrt,MAXHIST);
		memcpy(inpline,histbuf[histptrt],MAXINPLEN);
	    } else { inpline[0]='\0'; histptrt=histptr; }
	    inpx=strlen(inpline); crsr=inpx;
	    showinpline(inpline,inpx,1,crsr);
	    escflag=0; break;
	case 'C':
	    if (crsr!=inpx) {
		crsr++; scrcurs++;
		showinpline(inpline,inpx,0,crsr);
	    }
	    escflag=0; break;
	case 'D':
	    if (crsr!=0) { crsr--; scrcurs--; showinpline(inpline,inpx,0,crsr); }
	    escflag=0; break;
	default: escflag=0;
    }
}

/******************************************************************************/

kbd_escmode3(inpchar)
char inpchar;
{
char *tp;
int i;

    switch (inpchar) {
	case 'P':
	    escflag=7; break;
	case 'p': case 'q': case 'r': case 's': case 't':
	case 'u': case 'v': case 'w': case 'x': case 'y':
	    tp=fkey[inpchar-'p']; fkey_pos= fkey_mode[inpchar-'p']&1;
	    if (fkey_mode[inpchar-'p']&2) {
		inpx=0; crsr=inpx; inpline[inpx]='\0';
		showinpline(inpline,inpx,1,crsr);
	    }
	    while (*tp && inpx<MAXINPLEN) {
		if (crsr<inpx) {
		    i=inpx;
		    while (i>=crsr) { inpline[i+1]=inpline[i]; i--; }
		    inpline[crsr]= *tp++; inpx++; crsr++; scrcurs++;
		} else {
		    inpline[inpx++]= *tp++; crsr++; scrcurs++; inpline[inpx]='\0';
		}
		showinpline(inpline,inpx,2,crsr);
	    }
	    showinpline(inpline,inpx,0,crsr);
	    escflag=0; break;
	default: escflag=0;
    }
}

/******************************************************************************/

kbd_escmode4(inpchar)
char inpchar;
{
    switch (inpchar) {
	case '8':
	    escflag=5; break;
	case '9':
	    escflag=6; break;
	default: escflag=0;
    }
}

/******************************************************************************/

kbd_escmode5(inpchar)
char inpchar;
{
    if (inpchar=='~') do_help();
    escflag=0;
}

/******************************************************************************/

kbd_escmode6(inpchar)
char inpchar;
{
    if (inpchar=='~') do_flags();
    escflag=0;
}

/******************************************************************************/

kbd_escmode7(inpchar)
char inpchar;
{
char *tp;
int i;

    if (inpchar>='0' && inpchar <='9') {
	tp=prvrec[inpchar-'0'];
	while (*tp && inpx<MAXINPLEN) {
	    if (crsr<inpx) {
		i=inpx;
		while (i>=crsr) { inpline[i+1]=inpline[i]; i--; }
		inpline[crsr]= *tp++; inpx++; crsr++; scrcurs++;
	    } else {
		inpline[inpx++]= *tp++; crsr++; scrcurs++; inpline[inpx]='\0';
	    }
	    showinpline(inpline,inpx,2,crsr);
	}
	showinpline(inpline,inpx,0,crsr);
    } else if  ((inpchar>='a' && inpchar<='z') || (inpchar>='A' && inpchar<='Z')) {
	tp=fkey[locase(inpchar)-'a'+10]; fkey_pos= fkey_mode[locase(inpchar)-'a'+10]&1;
	if (fkey_mode[locase(inpchar)-'a'+10]&2) {
	    inpx=0; crsr=inpx; inpline[inpx]='\0';
	    showinpline(inpline,inpx,1,crsr);
	}
	while (*tp && inpx<MAXINPLEN) {
	    if (crsr<inpx) {
		i=inpx;
		while (i>=crsr) { inpline[i+1]=inpline[i]; i--; }
		inpline[crsr]= *tp++; inpx++; crsr++; scrcurs++;
	    } else {
		inpline[inpx++]= *tp++; crsr++; scrcurs++; inpline[inpx]='\0';
	    }
	    showinpline(inpline,inpx,2,crsr);
	}
	showinpline(inpline,inpx,0,crsr);
    }
    escflag=0;
}

/******************************************************************************/

kbd_normal(inpchar)
char inpchar;
{
int i;
char txt[512];

    switch (inpchar) {
	case 27:
	    escflag=1; break;
	case 155:
	    escflag=2; break;
	case '@'-64:
	    escflag=7; break;
	case ('U'-64):
	case ('X'-64):
	    crsr=inpx=0; inpline[0]='\0'; showinpline(inpline,inpx,1,crsr);
	    break;
	case ('F'-64):
	    inpline[crsr]='\0'; crsr=inpx=strlen(inpline);
	    showinpline(inpline,inpx,1,crsr); break;
	case ('N'-64):
	    if (inpx>0 && !isspace(inpline[crsr])) {
		while (crsr>0 && !isspace(inpline[crsr-1])) {
		    i=crsr; while (i!=inpx) { inpline[i-1]=inpline[i]; i++; }
		    crsr--; scrcurs--; inpx--; inpline[inpx]='\0';
		    showinpline(inpline,inpx,0,crsr);
		}
		while (crsr<inpx && !isspace(inpline[crsr])) {
		    i=crsr+1; while (i!=inpx) { inpline[i-1]=inpline[i]; i++; }
		    inpx--; inpline[inpx]='\0';
		    showinpline(inpline,inpx,0,crsr);
		}
		while (crsr<inpx && isspace(inpline[crsr])) {
		    i=crsr+1; while (i!=inpx) { inpline[i-1]=inpline[i]; i++; }
		    inpx--; inpline[inpx]='\0';
		    showinpline(inpline,inpx,0,crsr);
		}
	    }
	    break;
	case ('J'-64):
	    if (crsr>0 && !isspace(inpline[crsr-1])) {
		scrcurs--; crsr--; showinpline(inpline,inpx,2,crsr);
		while (crsr>0 && !isspace(inpline[crsr])) {
		    scrcurs--; crsr--; showinpline(inpline,inpx,2,crsr); }
	    }
	    while (crsr>0 && isspace(inpline[crsr-1])) {
		scrcurs--; crsr--; showinpline(inpline,inpx,2,crsr); }
	    showinpline(inpline,inpx,0,crsr);
	    break;
	case ('K'-64):
	    while (crsr<inpx && isspace(inpline[crsr])) {
		scrcurs++; crsr++; showinpline(inpline,inpx,2,crsr); }
	    while (crsr<inpx && !isspace(inpline[crsr])) {
		scrcurs++; crsr++; showinpline(inpline,inpx,2,crsr); }
	    showinpline(inpline,inpx,0,crsr);
	    break;
	case ('H'-64):
	    if (inpx) { crsr=0; scrcurs=0; showinpline(inpline,inpx,0,crsr); }
	    break;
	case ('E'-64):
	    if (inpx) {
		crsr=inpx;
		if (!clockwin) scrcurs=(inpx<COLS-1?inpx:COLS-1);
		else scrcurs=(inpx<COLS-7?inpx:COLS-7);
		showinpline(inpline,inpx,0,crsr);
	    }
	    break;
	case ('L'-64):
	case ('W'-64):
	    delwin(newwin(LINES,COLS,0,0));
	    win_refresh();
	    break;
	case ('T'-64):
	case ('Y'-64):
	case ('C'-64):
	    break;
	case (']'-64):
	    do_recall(0,"msg"); break;
	case ('\\'-64):
	    do_flush(); wrefresh(inpwin); break;
	case ('R'-64):
	    do_keypad_help(); break;
	case ('B'-64):
	    do_brdcst(); break;
	case ('D'-64):
	    if (dcl_pid) do_dcl(0,""); break;
	case ('V'-64):
	    ctrl_flag = !ctrl_flag; break;
	case ('Z'-64):
	    rundown(0);
	case ('A'-64):
	    edit_mode=1-edit_mode;
	    create_status();
	    break;
	case 127:
	    if (inpx && crsr) {
		i=crsr;
		while (i!=inpx) { inpline[i-1]=inpline[i]; i++; }
		crsr--; scrcurs--; inpx--; inpline[inpx]='\0';
		showinpline(inpline,inpx,0,crsr);
	    }
	    break;
	case 13:
	    inpline[inpx]='\0';
	    if (strcmp(histbuf[histptr?(histptr-1):(MAXHIST-1)],inpline)) {
		if (*inpline) {
		    memcpy(histbuf[histptr],inpline,MAXINPLEN);
		    histptr=ringplus(histptr,MAXHIST);
		}
	    }
	    histptrt=histptr;
	    if (testinpline(inpline)) {
		inpline[inpx++]=13; inpline[inpx++]=10; inpline[inpx]='\0';
		qio_send(inpline);
	    }
	    if (dbopt&4) { sprintf(txt,"DEBUG: [input] |%s|",inpline);
		putchunk(txt,FALSE); }
	    crsr=inpx=scrcurs=0; inpline[0]='\0';
	    wmove(inpwin,0,0); wclrtoeol(inpwin); wrefresh(inpwin);
	    break;
	default:
	    if ((inpx||inpchar!=' ')&&(inpx<MAXINPLEN||(edit_mode &&
	      crsr<MAXINPLEN))) {
		if (edit_mode) {
		    if (crsr<inpx) { inpline[crsr]=inpchar; crsr++; scrcurs++; }
		    else { inpline[inpx++]=inpchar; crsr++; scrcurs++; inpline[inpx]='\0'; }
		} else {
		    if (crsr<inpx) {
			i=inpx;
			while (i>=crsr) { inpline[i+1]=inpline[i]; i--; }
			inpline[crsr]=inpchar; inpx++; crsr++; scrcurs++;
		    } else { inpline[inpx++]=inpchar; crsr++; scrcurs++;
			inpline[inpx]='\0'; }
		}
		showinpline(inpline,inpx,0,crsr);
	    }
    }
}

/******************************************************************************/

kbd_rec_esc1(inpchar)
char inpchar;
{
    escflag=(inpchar=='[')?2:0;
}

/******************************************************************************/

kbd_rec_esc2(inpchar)
char inpchar;
{
    switch (inpchar) {
	case 'A':
	    recall_move(-1); escflag=0; break;
	case 'B':
	    recall_move(1); escflag=0; break;
	case '4':
	    escflag=3; break;
	case '5':
	    escflag=4; break;
	case '6':
	    escflag=5; break;
	default: escflag=0;
    }
}

/******************************************************************************/

kbd_rec_esc3(inpchar)
char inpchar;
{
    if (inpchar=='~') { recall_start=recall_num; recall_move(0); }
    escflag=0;
}

/******************************************************************************/

kbd_rec_esc4(inpchar)
char inpchar;
{
    if (inpchar=='~') recall_move(-(LINES>>1)+1);
    escflag=0;
}

/******************************************************************************/

kbd_rec_esc5(inpchar)
char inpchar;
{
    if (inpchar=='~') recall_move((LINES>>1)-1);
    escflag=0;
}

/******************************************************************************/

kbd_recall(inpchar)
char inpchar;
{
int i,j;

    switch (inpchar) {
	case 27:
	    escflag=1; break;
	case 155:
	    escflag=2; break;
	case ('T'-64):
	case ('Y'-64):
	case ('C'-64):
	    break;
	case ('R'-64):
	    do_keypad_help(); break;
	case ('B'-64):
	    do_brdcst(); break;
	case ('L'-64):
	case ('W'-64):
	    delwin(newwin(LINES,COLS,0,0));
	    win_refresh();
	    break;
	case ('Z'-64):
	    recall_mode=FALSE; recall_start= -1;
	    delwin(tmpwin); tmpwin=NIL;
	    win_refresh();
	    break;
    case 'P': case 'p':
	recall_move(-(LINES>>1)+1); break;
    case 'L': case 'l':
	recall_move((LINES>>1)-1); break;
    case 13:
	recall_mode=FALSE;
	delwin(tmpwin); tmpwin=NIL;
	win_refresh();
	i=(recall_start!= -1&&recall_start<recall_num)?recall_start:recall_num;
	j=(recall_start<recall_num)?recall_num:recall_start;
	recall_output(i,j);
	wrefresh(inpwin);
	recall_start= -1;
	break;
    case ' ':
	recall_output(recall_num,recall_num);
	break;
    case 'S': case 's':
	recall_start=recall_num;
	recall_move(0);
	break;
    default:
	escflag=0;
    }
}

/******************************************************************************/

kbd_ast()
{
unsigned short *i_o_size;

    i_o_size=iosb;
    if (!tmpwin && !*(i_o_size+1) && inpchar==26)
	{ sprintf(inpline,"Leaving"); do_quit(0,inpline); }
    c$cks(*i_o_size);
    if (recall_mode) {
	if (t2win && inpchar!='W'-64) {
	    delwin(t2win); msg_refresh(); wrefresh(tmpwin); wrefresh(inpwin);
	    if (status_line) { touchwin(statwin); wrefresh(statwin); }
	    t2win=NIL;
	}
	else switch (escflag) {
	    case 1: kbd_rec_esc1(inpchar); break;
	    case 2: kbd_rec_esc2(inpchar); break;
	    case 3: kbd_rec_esc3(inpchar); break;
	    case 4: kbd_rec_esc4(inpchar); break;
	    case 5: kbd_rec_esc5(inpchar); break;
	    default: kbd_recall(inpchar);
	}
    } else {
	if (tmpwin && inpchar!='W'-64)
	    if (help_num) do_help();
	    else if (fkey_pos) do_fkey(0,"?");
	    else { delwin(tmpwin); msg_refresh(); wrefresh(inpwin);
		if (status_line) { touchwin(statwin); wrefresh(statwin); }
		tmpwin=NIL;
	    }
	    else switch(escflag) {
		case 1: kbd_escmode1(inpchar); break;
		case 2: kbd_escmode2(inpchar); break;
		case 3: kbd_escmode3(inpchar); break;
		case 4: kbd_escmode4(inpchar); break;
		case 5: kbd_escmode5(inpchar); break;
		case 6: kbd_escmode6(inpchar); break;
		case 7: kbd_escmode7(inpchar); break;
		default: kbd_normal(inpchar);
	    }
	    if (fkey_pos==1) { fkey_pos=0; kbd_normal(13); }
    }
    if (!kbd_fin)
	c$cks(sys$qio(0,chan,IO$_READVBLK+IO$M_NOFILTR+IO$M_NOECHO,iosb,
	    kbd_ast,0,&inpchar,1,0,0,0,0));
    else kbd_fin=0;
}

/******************************************************************************/

leave_ast()
{
quadw interval_time;

    wsetattr(dispwindow,_BLINK);
    putbold("***** RING! You set a leave time! *****\007",FALSE);
    wclrattr(dispwindow,_BLINK);
    wrefresh(inpwin);
    c$cks(sys$bintim(c$dsc(INTERVAL),&interval_time));
    c$cks(lib$add_times(&leave_time,&interval_time,&leave_time));
    c$cks(sys$setimr(NIL,&leave_time,leave_ast,&leave_id,NIL));
}

/******************************************************************************/

notify_ast()
{
NotifyStruct *tmp,*start;
int cnt=0;
char ol[512];
quadw interval_time;

    if (notify_request) return;
    strcpy(ol,"ison");
    for(tmp = notify_list->first; cnt < 50; cnt++) {
	if (!tmp) break;
	strcat(ol," ");
	strcat(ol,tmp->nick);
	strcpy(notify_array[cnt],tmp->nick);
	if (num_notify > 50) {
	    dequeue(notify_list,tmp->nick);
	    enqueue(notify_list,tmp);
	    tmp = notify_list->first; }
	else tmp = tmp->next;
    }
    strcat(ol,"\r\n\0");
    notify_request = TRUE;
    qio_send(ol);
    c$cks(sys$bintim(c$dsc(NOTIFYINTERVAL),&interval_time));
    c$cks(lib$add_times(&notify_time,&interval_time,&notify_time));
    c$cks(sys$setimr(NIL,&notify_time,notify_ast,&notify_id,NIL));
}
		
/******************************************************************************/

clock_ast()
{
quadw interval_time;
char tim[]="17-NOV-1858 00:00:00.00";
int tim_len;

    c$cks(sys$asctim(&tim_len,c$dsc(tim),&clock_time,NIL)); tim[17]='\0';
    if (status_line) {
	mvwaddstr(statwin,0,COLS-5,&tim[12]); wrefresh(statwin);
	wrefresh(inpwin);
    } else {
	mvwaddstr(clockwin,0,0,&tim[12]); wrefresh(clockwin); wrefresh(inpwin);
    }
    c$cks(sys$bintim(c$dsc(CLOCKINTERVAL),&interval_time));
    c$cks(lib$add_times(&clock_time,&interval_time,&clock_time));
    c$cks(sys$setimr(NIL,&clock_time,clock_ast,&clock_id,NIL));
}

/******************************************************************************/

dcl_ast()
{
    if (dcl_mode=(dcl_out_iosb[0]!=SS$_ENDOFFILE)) c$cks(dcl_out_iosb[0]);
    dcloutbuf[dcl_out_iosb[1]]='\0';
    putwin(dclwin,dcl_size,COLS,dcloutbuf,TRUE,FALSE);
    if (!*dcloutbuf) strcpy(dcloutbuf," ");
    strcpy(dclbuf[dclptr],dcloutbuf); dclptr=ringplus(dclptr,MAXDCLMSG);
    wrefresh(inpwin);
    c$cks(sys$qio(0,dcl_chan_out,IO$_READVBLK,dcl_out_iosb,
                dcl_ast,0,dcloutbuf,MAXNETLEN-1,0,0,0,0));
}

/******************************************************************************/

brdcst_ast()
{
char text[256],*ptr,*b;

    if (brdcstbuf[0]==MSG$_TRMBRDCST) {
	brdcst_flag=TRUE;
	brdcstbuf[mbx_iosb[1]]='\0';
	touchwin(brdcstwin);
	if (tmpwin) { touchwin(tmpwin); wrefresh(tmpwin); }

	strcpy(text,&brdcstbuf[brdcstbuf[22]==13?24:22]); ptr=text;
	while (*ptr) {
	    b=ptr; while (*ptr && *ptr!=13) ptr++;
	    if (*ptr==13) *ptr++ ='\0';
	    putwin(brdcstwin,BRDCSTWINHEIGHT,COLS,b,TRUE,FALSE);
	    if (*ptr==10) ptr++;
	}
	wrefresh(inpwin);
	brdcstbuf[0]='\0';
    }
    c$cks(sys$qio(0,mbx_chan,IO$_READVBLK,mbx_iosb,brdcst_ast,0,
        brdcstbuf,MAXBRDCSTLEN,0,0,0,0));
}

/******************************************************************************/

net_ast()
{
unsigned short *i_o_size;
char *cp,*il=outl;
int bsize=MAXNETLEN-1;
quadw now;

    i_o_size=read_iosb;
    c$cks(*i_o_size);
    nr_pos[*(i_o_size+1)]='\0';

    c$cks(sys$gettim(&now));
    if (flush_mode && (now.l2-net_time.l2>0 || now.l1-net_time.l1>NETINTERVAL))
	flush_mode=FALSE;
    net_time=now;

    cp=il;
    while (cp) {
	if (cp = strchr(il,'\n')) *cp='\0';
	if ((cp) && (*(cp-1)=='\r')) *(cp-1)='\0';
	if (cp) { cp++; analyzeout(il); il=cp; }
    }
    wrefresh(inpwin);
    cp=outl;
    while (*cp++ = *il++) --bsize;
    nr_pos=cp-1;
    c$cks(sys$qio(0,net_chan,IO$_READVBLK,read_iosb,net_ast,0,
                  nr_pos,bsize,0,0,0,0));
}

/******************************************************************************/
