/******************************************************************************

                       VMS - IRC - Client   part COMMAND

 Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
                       CMU/tek, UCX, Wollongong or Multinet TCP/IP

 Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG

 Modified for IRC 2.7 by GrayElf, paul@coombs.anu.edu.au

 ******************************************************************************/

#include <stdio.h>
#include <descrip.h>
#include <string.h>
#include <ctype.h>
#include <iodef.h>
#include "header.h"
#include "environment.h"

extern kbd_ast(),dcl_ast(),leave_ast(),clock_ast(),c$cks(),c$dsc(),putbold(),
       putchunk(),putwin(),qio_send(),quadcmp(),rundown(),stricmp(),strincmp(),
       testinpline(),win_refresh(),create_status(),msg_refresh(),msg_touch(),
       notify_ast();
extern char  *reverse(),*rot13();

/******************************************************************************/

do_alias(int dummy,char *ptr)
{
char	*alias,ol[256];
AliasStruct *tmp;

    if (!*ptr) {
	if (alias_list) {
	    putchunk("*** Aliases:",TRUE);
	    for(tmp=alias_list; tmp; tmp = tmp->next) {
		sprintf(ol,"*** %10s %s",tmp->alias,tmp->equiv);
		putchunk(ol,TRUE); }
	}
	else putchunk("*** No aliases",TRUE);
    }
    else {
	alias = ptr; tillspace(ptr);
	if (!*ptr) {
	    if (*alias == '-') {
		*alias++ = '\0';
		tmp = list_remove(&alias_list,alias);
		if (tmp) {
		    sprintf(ol,"*** Alias %s removed",tmp->alias);
		    new_free(tmp->alias); new_free(tmp->equiv); new_free(tmp); }
		else sprintf(ol,"*** No such alias %s",alias);
		putchunk(ol,TRUE);
	    }
	    else if (alias_list) {
		putchunk("*** Aliases:",TRUE);
		for(tmp=alias_list; tmp; tmp = tmp->next) {
		    if (!strincmp(tmp->alias,alias,strlen(alias))) {
			sprintf(ol,"*** %10s %s",tmp->alias,tmp->equiv);
			putchunk(ol,TRUE);
		    }
		}
	    }
	    else putchunk("*** No aliases",TRUE);
	}
	else {
	    *ptr++ = '\0';
	    if (alias_list) tmp = list_remove(&alias_list,alias);
	    else tmp = NULL;
	    if (tmp) {
		strcpy(tmp->equiv,ptr);
		list_insert(&alias_list,tmp); }
	    else {
		tmp = (AliasStruct *) malloc(sizeof(AliasStruct));
		tmp->next = NULL;
		tmp->alias = (AliasStruct *) malloc(strlen(alias)+2);
		tmp->equiv = (AliasStruct *) malloc(strlen(ptr)+2);
		strcpy(tmp->alias,alias); strcpy(tmp->equiv,ptr);
		list_insert(&alias_list,tmp);
	    }
	    sprintf(ol,"*** Alias %s added",tmp->alias); putchunk(ol,TRUE);
	}
    }
}	    

/******************************************************************************/

do_away(num,ptr)
int num;
char *ptr;
{
  char ol[256];

  if (num==1) { sprintf(ol,"away %s",ptr); putbold(ol); away_flag= *ptr; }
  if (num==2) { putbold("here",FALSE); away_flag=FALSE; }
  sprintf(inpline,"AWAY :%s",ptr); inpx=strlen(inpline);
  create_status();
}

/******************************************************************************/

do_big(dummy,ptr,line)
int dummy;
char *ptr,*line;
{
  char mode,*tp,*txtp,txt[256],txt2[256],big[MAXFONTHEIGHT][256];
  int cnt;
  bool flag;

  if (font_mode) {
    tp=ptr; mode=(*ptr=='*');
    tillspace(ptr); txtp=ptr; whilespace(ptr);
    for(cnt=0;cnt<fontheight;cnt++) *big[cnt]='\0';
    while(*ptr) {
      flag=FALSE;
      for (cnt=0;cnt<fontheight;cnt++) flag|=font[*ptr][cnt][0];
      for (cnt=0;cnt<fontheight;cnt++) {
        if (*big[cnt]) strcat(big[cnt]," ");
        strcat(big[cnt],font[flag?*ptr:toupper(*ptr)][cnt]);
      }
      ptr++;
    }
    if (strlen(big[0])>70)
      putchunk("*** Error: BIG text (probably) too long...",FALSE);
    else {
      putbold(cmdch[0]?line:&line[1],TRUE);
      *txtp='\0';
      for(cnt=0;cnt<fontheight;cnt++) {
        if (mode) {
          sprintf(txt2,"%s",big[cnt]);
          do_msg(0,txt2); inpline[inpx++]=13; inpline[inpx++]=10; inpline[inpx]=0;
          qio_send(inpline);
        } else {
          sprintf(txt2,"-> *%s* %s",tp,big[cnt]);
          sprintf(txt,"PRIVMSG %s :%s\r\n",tp,*big[cnt]?big[cnt]:" ");
          putchunk(txt2,TRUE); qio_send(txt);
        }
      }
    }
  } else putchunk("*** Error: No font loaded...",FALSE);
}

/******************************************************************************/

do_brdcst()
{
  if(!brdcst_flag) {
    touchwin(brdcstwin); wrefresh(brdcstwin);
  } else {
    msg_touch();
    if (status_line)           { touchwin(statwin); wrefresh(statwin); }
    if (dclwin && dcl_visible) { touchwin(dclwin); wrefresh(dclwin); }
    if (recall_mode)           { touchwin(tmpwin); wrefresh(tmpwin); }
    msg_refresh();
  }
  wrefresh(inpwin);
  brdcst_flag= !brdcst_flag;
}

/******************************************************************************/

do_cd(num,ptr)
int num;
char *ptr;
{
  char *disk,tmp[512],dir[256];
  int dir_len;
  $DESCRIPTOR(dirdesc,dir);

  if (*ptr && *ptr!='?')
    if(chdir(ptr)) {
      putchunk("*** Error: The specified directory does not exist.",FALSE);
    } else {
      c$cks(sys$setddir(0,&dir_len,&dirdesc));
      disk=getenv("SYS$DISK");
      sprintf(dirpath,"%s%s",disk,dir);
      disk=dirpath; while(*disk) { *disk=locase(*disk); disk++; }
      sprintf(tmp,"*** Changed WorkingDIR to %s",dirpath); putchunk(tmp,FALSE);
    }
  else { sprintf(tmp,"*** Actual WorkingDIR is %s",dirpath); putchunk(tmp,FALSE); }
}

/******************************************************************************/

do_chunk(flag,ptr,line)
int flag;
char *ptr,*line;
{
  char *tp,mode;

  tp=ptr; mode=(*ptr=='*');
  tillspace(ptr); if (*ptr) *ptr++ ='\0'; whilespace(ptr);
  if (mode) tp=ptr;
  if (flag==1) rot13(ptr);
  if (flag==2) reverse(ptr);
  putbold(cmdch[0]?line:&line[1],TRUE);
  if (mode) sprintf(inpline,"PRIVMSG %s :%s",my_chan,*tp?tp:" ");
  else sprintf(inpline,"PRIVMSG %s :%s",tp,*ptr?ptr:" ");
  inpx=strlen(inpline);
}

/******************************************************************************/

do_clock(num)
int num;
{
  char tim[]="17-NOV-1858 00:00:00.00";
  int tim_len;

  if (num==0 && status_line) {
    if (clock_mode) {
      clock_mode=2;
      if (clockwin) {
        delwin(clockwin); clockwin=NIL;
        delwin(inpwin); inpwin=newwin(1,COLS,LINES-1,0);
      }
    } else {
      c$cks(sys$gettim(&clock_time));
      c$cks(sys$asctim(&tim_len,c$dsc(tim),&clock_time,NIL));
      strcpy(&tim[18],"00.00");
      c$cks(sys$bintim(c$dsc(tim),&clock_time));
      c$cks(sys$setimr(NIL,&clock_time,clock_ast,&clock_id,NIL));
      clock_mode=1;
    }
  } else {
    if (clock_mode) {
      if (status_line) {
        clock_mode=3-clock_mode;
      } else {
        if (clock_mode==1) {
          if (clockwin) {
            delwin(clockwin); clockwin=NIL;
            delwin(inpwin); inpwin=newwin(1,COLS,LINES-1,0);
          }
          c$cks(sys$cantim(&clock_id,NIL));
          clock_mode=0;
        } else {
          delwin(inpwin); inpwin=newwin(1,COLS-6,LINES-1,0);
          clockwin=newwin(1,5,LINES-1,COLS-5);
          wclear(clockwin); if (bold_flag) wsetattr(clockwin,_BOLD);
          wrefresh(clockwin);
          clock_mode=1;
        }
      }
    } else {
      clock_mode=1;
      delwin(inpwin); inpwin=newwin(1,COLS-6,LINES-1,0);
      clockwin=newwin(1,5,LINES-1,COLS-5);
      wclear(clockwin); if (bold_flag) wsetattr(clockwin,_BOLD);
      wrefresh(clockwin);
      c$cks(sys$gettim(&clock_time));
      c$cks(sys$asctim(&tim_len,c$dsc(tim),&clock_time,NIL));
      strcpy(&tim[18],"00.00");
      c$cks(sys$bintim(c$dsc(tim),&clock_time));
      c$cks(sys$setimr(NIL,&clock_time,clock_ast,&clock_id,NIL));
    }
  }
  if (bold_flag) wsetattr(inpwin,_BOLD);
  wclear(inpwin); wrefresh(inpwin);
}

/******************************************************************************/

do_cls()
{
  int i;

  wclear(dispwindow);
  msg_refresh();
}

/******************************************************************************/

do_cmdch(dummy,ptr)
int dummy;
char *ptr;
{
  char line[256],*tp;
  int i;

  if (*ptr!=cmdch[0])
    for(i=0;i<MAXHIST;i++)
      if (histbuf[i][0])
        if (*ptr)
          if (cmdch[0]) {
            if (histbuf[i][0]==cmdch[0]) histbuf[i][0]= *ptr; }
          else
            if (!strincmp("ms",histbuf[i],2)) {
              tp=histbuf[i]; tillspace(tp); whilespace(tp);
              strcpy(line,tp); strcpy(histbuf[i],line); }
            else {
              line[0]= *ptr;
              strcpy(&line[1],histbuf[i]); strcpy(histbuf[i],line); }
        else
          if (histbuf[i][0]==cmdch[0]) {
            strcpy(line,&histbuf[i][1]); strcpy(histbuf[i],line); }
          else {
            sprintf(line,"msg %s",histbuf[i]); strcpy(histbuf[i],line); }

  cmdch[0]= *ptr;
  if (cmdch[0]) sprintf(line,"*** Command character set to %c",cmdch[0]);
  else
    sprintf(line,"*** Command character reset. Enter messages with PRIVMSG <channel> <text>");
  putchunk(line,FALSE);
  create_status();
}

/******************************************************************************/

do_comment(dummy,ptr)
int dummy;
char *ptr;
{
  char tmp[256];

  if (*ptr) sprintf(tmp,"*** Comment: %s",ptr);
  else sprintf(tmp,"*** Comment");
  putchunk(tmp,TRUE);
}

/******************************************************************************/

do_ctcp(int flag,char *ptr)
{
char ol[512],*nick,*query,*tmp = &ol,tim[]="17-NOV-1858 00:00:00.00";
int i;
quadw curtim;

switch (flag)
    {
    case 0:
	nick = ptr; tillspace(ptr); ptr[0] = '\0';
       	query = tmp = ++ptr; tillspace(ptr);
	if (strlen(ptr)) { ptr[0] = '\0'; ptr++; }
	while(*tmp) { *tmp = toupper(*tmp); tmp++; }
	putchunk(inpline,TRUE);
	if (*ptr)
	    sprintf(inpline,"PRIVMSG %s :\001%s %s\001",nick,
			query,ptr);
	else
	    sprintf(inpline,"PRIVMSG %s :\001%s\001",nick,query);
	break;
    case 1:
	sprintf(tmp,"* %s %s",my_nick,ptr); putchunk(tmp, TRUE);
	if (query_max) {
	    tmp[0]='\0';
	    for(i=0;i<query_max;i++) {
		if (i) strcat(tmp,",");
		strcat(tmp,query_ptr[i]); }
	    sprintf(inpline,"PRIVMSG %s :\001ACTION %s\001",tmp,ptr);
	} else {
	    sprintf(inpline,"PRIVMSG %s :\001ACTION %s\001",my_chan,ptr);
	}
	break;
    case 2:
	nick = ptr;
	c$cks(sys$asctim(&i,c$dsc(tim),NIL,NIL));
	sprintf(inpline,"PRIVMSG %s :\001ERRMSG PING RELAY %s\001",nick,tim);
	break;
    }
    inpx=strlen(inpline);
}

/******************************************************************************/

do_dcl(dummy,ptr)
int dummy;
char *ptr;
{
  long flags=0x29L;           /* nocontrol(5),nokeypad(3),nowait(0) */
  char txt[256],txt2[256];

  if (!dclwin)
    if (LINES<8)
      putchunk("*** My, whadda cute little window we have here. Sorry, no DCL for dwarves...",FALSE);
    else {
      dclwin=newwin(dcl_size=(LINES>>1),COLS,0,0);
      wsetattr(dclwin,_REVERSE); wclear(dclwin); wmove(dclwin,0,0);
      dcl_visible=TRUE; brdcst_flag=FALSE;
    }
  if (*ptr) {
    if (!dcl_mode) {
      if (!dcl_mbx) {
        c$cks(sys$crembx(0,&dcl_chan_in,MAXNETLEN-1,0,0xff00L,0,c$dsc("DCLMBXIN")));
        c$cks(sys$crembx(0,&dcl_chan_out,MAXNETLEN-1,0,0xff00L,0,c$dsc("DCLMBXOUT")));
      }
      c$cks(lib$spawn(c$dsc("SET NOON"),c$dsc("DCLMBXIN"),c$dsc("DCLMBXOUT"),&flags,0,&dcl_pid,0,0,0,0,0,0));
      dcl_mode=TRUE;
      if (!dcl_mbx) {
        c$cks(sys$qio(0,dcl_chan_out,IO$_READVBLK,dcl_out_iosb,dcl_ast,0,
                      dcloutbuf,MAXNETLEN-1,0,0,0,0));
        dcl_mbx=TRUE;
      }
    }
    if (!dcl_visible) {
      msg_touch(); touchwin(dclwin); if (status_line) touchwin(statwin);
      dcl_visible=TRUE; brdcst_flag=FALSE;
    }
    if (!stricmp(ptr,"^")) strcpy(txt2," ");
    else { sprintf(txt,"$ %s",ptr); putwin(dclwin,dcl_size,COLS,txt,TRUE,FALSE);
           strcpy(txt2,ptr); }
    strcpy(dclbuf[dclptr],txt); dclptr=ringplus(dclptr,MAXDCLMSG);
    c$cks(sys$qiow(0,dcl_chan_in,IO$_WRITEVBLK,dcl_in_iosb,0,0,txt2,
                   strlen(txt2),0,0,0,0));
    c$cks(dcl_in_iosb[0]);
  } else
    if (!dcl_visible) {
      msg_touch(); touchwin(dclwin); wrefresh(dclwin);
      if (status_line) touchwin(statwin);
      dcl_visible=TRUE; brdcst_flag=FALSE;
    } else {
      touchwin(brdcstwin); msg_touch(); msg_refresh();
      if (status_line) { touchwin(statwin); wrefresh(statwin); }
      if (brdcst_flag) { touchwin(brdcstwin); wrefresh(brdcstwin); }
      dcl_visible=FALSE;
    }
  wrefresh(inpwin);
}

/******************************************************************************/

do_debug(dummy,ptr)
int dummy;
char *ptr;
{
  char ol[256];

  if (*ptr=='?') {
    putchunk("DEBUG - Internal online debugging *oerks*",FALSE);
    putchunk("DEBUG bit 0 - Incoming server messages, echo all given commands",FALSE);
    putchunk("DEBUG bit 1 - Pre-parsed messages (p[0]..p[7])",FALSE);
    putchunk("DEBUG bit 2 - echo input line, $qio to network/server",FALSE);
    putchunk("DEBUG bit 3 - font load status, script commands",FALSE);
    putchunk("DEBUG bit 4 - External error message handling",FALSE);
    putchunk("DEBUG bit 5 - Ignore flags, leave timer",FALSE);
    putchunk("DEBUG bit 6 - ",FALSE);
    putchunk("DEBUG bit 7 - PrivmsgRecall buffer",FALSE);
    sprintf(ol,"DEBUG - Actual value is %02x",(unsigned char) dbopt);
    putchunk(ol,FALSE);
  } else {
    if (*ptr) dbopt=atoi(ptr); else dbopt=0;
    if (!dbopt) putchunk("*** Disabled debugging mode (Wow, you've found the bug)",FALSE);
    else putchunk("*** Enabled debugging mode (urgs, you enter the problem area)",FALSE);
  }
}

/******************************************************************************/

do_default(num,dummy,line)
int num;
char *dummy,*line;
{
  strcpy(inpline,&line[1]); inpx=strlen(inpline);
  putbold(cmdch[0]?line:&line[1],FALSE);
}

/******************************************************************************/

do_enter(dummy,ptr,line)
int dummy;
char *ptr,*line;
{
  char *txtp,txt[256],tmp[256];

  txtp=txt; copyspace(ptr,txtp); whilespace(ptr);
  putbold(cmdch[0]?line:&line[1],TRUE);
  sprintf(tmp,"JOIN %s\r\n\0",txt);
  qio_send(tmp);
  if (*ptr) {
    sprintf(tmp,"PRIVMSG %s :%s\r\n",txt,ptr);
    strcpy(txtp,ptr); }
  else {
    strcpy(txtp,":appears in a cloud of orange smoke on this channel...\007");
    sprintf(tmp,"PRIVMSG %s\r\n",txt); }
  qio_send(tmp);
  sprintf(tmp,"> %s",txtp); putbold(tmp,TRUE);
}

/******************************************************************************/

do_errlog()
{
  errlog_flag = !errlog_flag;
  if (errlog_flag) putchunk("*** Disabled error message logging",TRUE);
  else putchunk("*** Enabled error message logging",TRUE);
}

/******************************************************************************/

do_fkey(dummy,ptr,line)
int dummy;
char *ptr,*line;
{
  char *tp=ptr,txt[256],mode;
  int cnt;

  if (*ptr || fkey_pos)
    if (*ptr=='?' || fkey_pos) {
      if (COLS<70 || LINES<13)
        putchunk("*** My, whadda cute little window we have here. Sorry, no FKEY info for hobbits.",FALSE);
      else {
        if (!fkey_pos) {
          tmpwin=newwin(13,70,(LINES-13)>>1,(COLS-70)>>1);
          wsetattr(tmpwin,bold_flag?_REVERSE|_BOLD:_REVERSE);
        }
        if (inpchar!=26) {
          wclear(tmpwin); wmove(tmpwin,0,0);
          for(cnt=fkey_pos;cnt<fkey_pos+13 && cnt<36;cnt++) {
            mode=fkey_mode[cnt]?fkey_mode[cnt]+'0':' ';
            if (cnt<10) wprintw(tmpwin,*fkey[cnt]?" KP %d   %c'%s'\n":" KP %d   %c(none)\n",cnt,mode,fkey[cnt]);
            else wprintw(tmpwin,*fkey[cnt]?" GOLD %c %c'%s'\n":" GOLD %c %c(none)\n",cnt-10+'a',mode,fkey[cnt]);
          }
          if (fkey_pos==26) {
            wprintw(tmpwin," Special features: FKEY <key> [!<mode|!>]<text>\n");
            wprintw(tmpwin," Bit 0: Automatic command execution (added <CR>) on fkey\n");
            wprintw(tmpwin," Bit 1: Delete line before insertion of fkey text\n");
          }
          wrefresh(tmpwin); wrefresh(inpwin);
        } else { delwin(tmpwin); msg_refresh(); wrefresh(inpwin); tmpwin=NIL; }
        fkey_pos=(fkey_pos==26 || inpchar==26)?0:fkey_pos+13;
      }
    } else if ((isdigit(*ptr) || isalpha(*ptr)) && (ptr[1]==' ' || !(ptr[1])))
      if (ptr[1]) {
        do tp++; while(*tp==' ');
        if (*tp=='!' && (('0'<= *(tp+1) && *(tp+1)<='3') || *(tp+1)=='!')) {
          tp++;
          if (*tp!='!') { fkey_mode[locase(*ptr)-(isdigit(*ptr)?'0':'a'-10)]= *tp-'0'; tp++; }
        }
        strcpy(fkey[locase(*ptr)-(isdigit(*ptr)?'0':'a'-10)],tp);
        sprintf(txt,"*** Fkey %c set to '%s'",locase(*ptr),tp); putchunk(txt,FALSE);
      } else {
        *fkey[locase(*ptr)-(isdigit(*ptr)?'0':'a'-10)]='\0';
        fkey_mode[locase(*ptr)-(isdigit(*ptr)?'0':'a'-10)]=0;
        sprintf(txt,"*** Fkey %c disabled",locase(*ptr)); putchunk(txt,FALSE);
      }
    else putchunk("*** Error: Incorrect definition of a Fkey",FALSE);
  else putchunk("*** Error: No Fkey modified",FALSE);
}

/******************************************************************************/

do_flush()
{
  putchunk("*** Flushing incoming text...",FALSE);
  flush_mode=TRUE;
}

/******************************************************************************/

do_ignore(dummy,ptr)
int dummy;
char *ptr;
{
  char *txtp,txt[256];
  int cnt;

  if (*ptr=='?')
    if (ignore_max) {
      strcpy(txt,"*** Ignore is ");
      for(cnt=0;cnt<ignore_max;cnt++) {
        if (cnt) strcat(txt,",");
        strcat(txt,ignore_ptr[cnt]); }
    } else sprintf(txt,"*** No ignore is set.");
  else if (*ptr) {
    strcpy(txtp=ignore,ptr);
    sprintf(txt,"*** Ignore set to %s",ignore);
/*    ignore_max=0; */
    ignore_ptr[ignore_max++]=txtp;
    while(*++txtp) {
      if (*txtp==',' || *txtp==' ') {
        *txtp='\0'; ignore_ptr[ignore_max++]= ++txtp; }
    }
  } else {
    ignore_max=0; sprintf(txt,"*** Ignore is reset..."); }
  putchunk(txt,FALSE);
}

/******************************************************************************/

do_inpscroll(dummy,ptr)
int dummy;
char *ptr;
{
  int cnt;

  if (*ptr) cnt=atoi(ptr);
  else cnt=1;
  if (cnt<=0 || cnt>80) putchunk("*** Error: Value for INPSCROLL not allowed. Value should be [1..80]",FALSE);
  else inpscroll=cnt;
}

/******************************************************************************/

do_join(flag,ptr)
int flag;
char *ptr;
{
	char pre,*tmp;

/*	pre=(*ptr!='0' && atoi(ptr)==0 && *ptr!='+')?' ':' ';
	sprintf(tmp,"%c%s",pre,ptr); */
	if (flag==0)
		{
		if (on_channel(ptr)) join(ptr);
		else {
		    sprintf(inpline,"JOIN %s\r\n",ptr);
		    qio_send(inpline); }
		}
	else if (flag==1) { sprintf(inpline,"PART %s",ptr);
	    inpx=strlen(inpline); }
	if (status_line) create_status();
}

/******************************************************************************/

do_kill(int dummy, char *ptr)
{
char *tmp, ol[512];

    tmp = ptr;
    tillspace(ptr);
    if (strlen(ptr)) {
	*ptr = '\0'; ptr++;
	sprintf(&ol,"KILL %s :%s\r\n", tmp, ptr);
	qio_send(&ol);
    }
    else putchunk("*** Reason required for /KILL.",FALSE);
}

/******************************************************************************/

do_leave(dummy,ptr)
int dummy;
char *ptr;
{
  char txt[256],tim[]="17-NOV-1858 00:00:00.00";
  int tim_len;
  quadw new_time,now_time;

  if (*ptr!='?') {
    if (!(*ptr)) {
      if (leave_time.l2 || leave_time.l1) c$cks(sys$cantim(&leave_id,NIL));
      leave_time.l2=0; leave_time.l1=0;
    } else
      if (!(sys$bintim(c$dsc(ptr),&new_time) & 1))
        putchunk("*** Sorry, there is something wrong...",FALSE);
      else {
        if (leave_time.l2 || leave_time.l1) c$cks(sys$cantim(&leave_id,NIL));
        c$cks(sys$gettim(&now_time));
        if (new_time.l2<0) c$cks(lib$add_times(&now_time,&new_time,&new_time));
        if (quadcmp(&new_time,&now_time)<0)
          putchunk("*** Sorry, you can't specify a time before now!",FALSE);
        else {
          leave_time=new_time;
          c$cks(sys$setimr(NIL,&leave_time,leave_ast,&leave_id,NIL));
        }
      }
  }
  if (leave_time.l2 || leave_time.l1) {
    c$cks(sys$asctim(&tim_len,c$dsc(tim),&leave_time,NIL));
    sprintf(txt,"*** Leave time is set to %s",tim);
  }
  else sprintf(txt,"*** No leave time set...");
  putchunk(txt,FALSE);
  if (dbopt&0x20) { sprintf(txt,"DEBUG: [leave]%08X %08X",leave_time.l2,leave_time.l1); putchunk(txt,FALSE); }
}

/******************************************************************************/

do_loadfont(dummy,ptr)
int dummy;
char *ptr;
{
  char buffer[256],*pnt,*end,tmp[256],t[256];
  unsigned char c;
  int cnt,maxlen;
  FILE *fontfile;

  strcpy(tmp,ptr);
  if (!(fontfile=fopen(tmp,"r"))) {
    sprintf(tmp,"%s.fnt",ptr);
    if (!(fontfile=fopen(tmp,"r"))) {
      putchunk("*** Loadfont: Cannot open fontfile",FALSE);
      return; }
  }
  if (!fgets(buffer,sizeof(buffer),fontfile)) {
    putchunk("*** Loadfont: Unexpected end of file",FALSE); return; }
  if (*(pnt=buffer+strlen(buffer)-1)=='\n') *pnt='\0';
  if ((fontheight=atoi(buffer))>MAXFONTHEIGHT) {
    putchunk("*** Loadfont: Fontheight too large",FALSE); return; }
  if (!fgets(buffer,sizeof(buffer),fontfile)) {
    putchunk("*** Loadfont: Unexpected end of file",FALSE); return; }
  if (*(pnt=buffer+strlen(buffer)-1)=='\n') *pnt='\0';
  if ((fontwidth=atoi(buffer))>MAXFONTWIDTH) {
    putchunk("*** Loadfont: Fontwidth too large",FALSE); return; }
  font_mode=FALSE;
  for(c=0;c<255;c++) for(cnt=0;cnt<fontheight;font[c][cnt++][0]='\0');
  while (fgets(buffer,sizeof(buffer),fontfile)) {
    if (*(pnt=buffer+strlen(buffer)-1)=='\n') *pnt='\0';
    if (dbopt&8) { sprintf(t,"DEBUG: [font] %s",buffer); putchunk(t,FALSE); }
    if (strlen(buffer)!=1) {
       putchunk("Loadfont: Single character expected",FALSE); return; }
    c= *buffer; maxlen=0;
    for (cnt=0;cnt<fontheight;cnt++) {
      if (!fgets(buffer,sizeof(buffer),fontfile)) {
        putchunk("*** Loadfont: Unexpected end of file",FALSE); return; }
      if (*(pnt=buffer+strlen(buffer)-1)=='\n') *pnt='\0';
      if (strlen(buffer)>fontwidth) {
        putchunk("*** Loadfont: Character width too large",FALSE); return; }
      maxlen=max(maxlen,strlen(buffer));
      strcpy(font[c][cnt],buffer);
    }
    for (cnt=0;cnt<fontheight;cnt++)
      if (strlen(font[c][cnt])<maxlen) {
        *(end= &font[c][cnt][maxlen])='\0';
        for (pnt=font[c][cnt]+strlen(font[c][cnt]);pnt<end;*pnt++ =' '); }
  }
  fclose(fontfile);
  font_mode=TRUE;
  sprintf(t,"*** Fontfile '%s' loaded...",tmp); putchunk(t,FALSE);
  strcpy(fontnam,tmp);
  if (dbopt&8)
    for (c='A';c<='Z';c++) { sprintf(t,"DEBUG: %c",c); putchunk(t,FALSE);
      for (cnt=0;cnt<fontheight;cnt++) { sprintf(t,"DEBUG: [font] |%s|",font[c][cnt]); putchunk(t,FALSE); }
    }
}

/******************************************************************************/

do_log(dummy,ptr)
int dummy;
char *ptr;
{
  char txt[256],*tmp,*t;
  bool rec_mode=FALSE;
  int cnt;
  long tloc;

  t=ptr; if (*t) {
    tmp=txt; copyspace(t,tmp);
    if (!strincmp(txt,"recall",strlen(txt)) && *t) rec_mode=TRUE;
    if (rec_mode) { ptr=t; whilespace(ptr); }
  }
  time(&tloc);
  if (*ptr)
    if (logfile) putchunk("*** Error: Logfile is already open.",FALSE);
    else if (!(logfile=fopen(ptr,"a")))
        putchunk("*** Error: Cannot open Logfile!",FALSE);
      else {
        if (ftell(logfile)) sprintf(txt,"*** Appending to logfile %s at %s",ptr,ctime(&tloc));
        else sprintf(txt,"*** Logfile %s opened at %s",ptr,ctime(&tloc));
        txt[strlen(txt)-1]='\0'; putchunk(txt,TRUE);
        strcpy(lfilename,ptr);
        if (rec_mode) {
          cnt=savptr;
          if (!*savbuf[savptr]) while(!*savbuf[cnt]) cnt=ringplus(cnt,MAXSAVMSG);
          else { fprintf(logfile,"%s\n",savbuf[cnt]); cnt=ringplus(cnt,MAXSAVMSG); }
          while (cnt!=savptr) { fprintf(logfile,"%s\n",savbuf[cnt]); cnt=ringplus(cnt,MAXSAVMSG); }
          fprintf(logfile,"*** End of history buffer recall, normal input follows\n");
        }
      }
  else if (logfile) {
    lfilename[0]='\0';
    sprintf(txt,"*** Logfile closed at %s",ctime(&tloc));
    putchunk(txt,TRUE); fclose(logfile); logfile=NULL;
  } else putchunk("*** Error: No Logfile opened. What do you want ?",FALSE);
}

/******************************************************************************/

do_msg(dummy,ptr)
int dummy;
char *ptr;
{
  char txt[512],tmp[512];
  int cnt;

  if (query_max) {
    sprintf(txt,"==> %s",ptr); putbold(txt,TRUE);
    txt[0]='\0';
    for(cnt=0;cnt<query_max;cnt++) {
      if (cnt) strcat(txt,",");
      strcat(txt,query_ptr[cnt]); }
    sprintf(lastmsg,"%s %s",txt,ptr);
    sprintf(inpline,"PRIVMSG %s :%s",txt,*ptr?ptr:" "); inpx=strlen(inpline);
  } else {
    sprintf(tmp,"> %s",ptr); putbold(tmp,TRUE);
    sprintf(lastmsg,"* %s",ptr);
    sprintf(inpline,"PRIVMSG %s :%s",my_chan,ptr); inpx=strlen(inpline);
  }
}

/******************************************************************************/

do_query(dummy,ptr)
int dummy;
char *ptr;
{
  char *txtp,txt[256];
  int cnt;

  if (*ptr=='?')
    if (query_max) {
      strcpy(txt,"*** Query is ");
      for(cnt=0;cnt<query_max;cnt++) {
        if (cnt) strcat(txt,",");
        strcat(txt,query_ptr[cnt]); }
    } else sprintf(txt,"*** No query is set.");
  else if (*ptr) {
    txtp=query; copyspace(ptr,txtp); txtp=query; whilespace(ptr);
    sprintf(txt,"*** Query set to %s",query);
    query_max=0;
    query_ptr[query_max++]=txtp;
    while(*++txtp) {
      if (*txtp==',') {
        *txtp='\0'; query_ptr[query_max++]= ++txtp; }
    }
    if (*ptr) {
      do_msg(0,ptr); inpline[inpx++]=13; inpline[inpx++]=10; inpline[inpx]=0;
      qio_send(inpline);
    }
  } else {
    query_max=0; sprintf(txt,"*** Query is reset..."); }
  putchunk(txt,TRUE);
  create_status();
}

/******************************************************************************/

do_topic(int dummy, char *ptr)
{
char *chan;

    if (*ptr == '#') {
	chan = ptr;
	tillspace(ptr);
	if (strlen(ptr)) { *ptr = '\0'; ptr++; }
	if (*ptr) sprintf(inpline,"TOPIC %s :%s", chan, ptr);
	else sprintf(inpline,"TOPIC %s", chan);
    }
    else if (*ptr) {
	sprintf(inpline,"TOPIC %s :%s", my_chan, ptr);
    }
    else sprintf(inpline,"TOPIC %s", my_chan);
    inpx = strlen(inpline);
}

/******************************************************************************/

do_type(dummy,ptr)
int dummy;
char *ptr;
{
  char *tp,txt[256],tmp[256],tmp2[256];
  int mode;
  FILE *typefile;

  tp=ptr; mode=(*ptr=='*');
  tillspace(ptr); if (*ptr) *ptr++ ='\0'; whilespace(ptr);
  if (*ptr) {
    strcpy(tmp,ptr); 
    if (!(typefile=fopen(tmp,"r"))) {
      sprintf(tmp,"%s.lis",ptr);
      if (!(typefile=fopen(tmp,"r"))) {
        sprintf(txt,"*** Error: Cannot type %s",ptr); putchunk(txt,FALSE);
        return; }
    }
    sprintf(txt,"***** Typing file %s *****",tmp); putchunk(txt,TRUE);
    while (fgets(txt,sizeof(txt),typefile)) {
      if (*(ptr=txt+strlen(txt)-1)=='\n') *ptr='\0';
      if (mode) { 
        strcpy(tmp2,txt);
        do_msg(0,tmp2); inpline[inpx++]=13; inpline[inpx++]=10; inpline[inpx]=0;
        qio_send(inpline);
      } else {
        sprintf(tmp2,"-> *%s* %s",tp,txt);
        sprintf(tmp,"PRIVMSG %s :%s\r\n",tp,*txt?txt:" ");
        putchunk(tmp2,TRUE); qio_send(tmp);
      }
    }
    fclose(typefile);
  }
  else putchunk("*** Error: No filename given. Please specify.",FALSE);
}

/******************************************************************************/

do_mode(flag,ptr)
int flag;
char *ptr;
{
char ol[256],com[20],p[256],*p1,*p2;
  bool chantype;

    if (*ptr=='?') {
    	if (COLS<55 || LINES<15)
	    putchunk("*** Huh? What a small window... Sorry, no mode info for hobbits...",FALSE);
	else {
	    tmpwin=newwin(15,55,(LINES-13)>>1,(COLS-55)>>1);
      	    wsetattr(tmpwin,bold_flag?_REVERSE|_BOLD:_REVERSE);
      	    wclear(tmpwin); wmove(tmpwin,0,0);
      	    wprintw(tmpwin," MODE info for VMS IRC Client %s\n\n",VMSVERSION);
	    wprintw(tmpwin," +|- add|remove modes on named channels\n");
      	    wprintw(tmpwin," p   private mode\n");
      	    wprintw(tmpwin," s   secret mode (invisible channel)\n");
      	    wprintw(tmpwin," a   anonymous mode [users are invisible]\n");
      	    wprintw(tmpwin," t   topic limit (Set only by ChanOp)\n");
      	    wprintw(tmpwin," m   moderated channel (ChanOp-MSGs only)\n");
      	    wprintw(tmpwin," i   INVITE only channel\n");
      	    wprintw(tmpwin," n   no PRIVMSGs on this channel\n");
	    wprintw(tmpwin," l   limited channel <max. of users>\n");
	    wsetattr(tmpwin,_UNDERLINE);
      	    wprintw(tmpwin," o   add/remove channel operator <nick>%s\n",spc);
      	    wclrattr(tmpwin,_UNDERLINE);
      	    wprintw(tmpwin," PRIVMSG +channel  Message to all on channel\n");
	    wprintw(tmpwin," PRIVMSG #host     Message to all on host\n");
	    wprintw(tmpwin," PRIVMSG $server   Message to all on server\n");
	    wrefresh(tmpwin); wrefresh(inpwin);
    	}
    } else {
    	chantype=(atoi(my_chan)==0 && *my_chan!='0');
	switch (flag) {
      	    case 1: strcpy(com,"kick");
		if (*ptr == '+' || *ptr == '#' || *ptr == '&')
		    { sprintf(ol,"%s %s",com,ptr); }
		else { sprintf(ol,"%s %s %s",com,my_chan,ptr); }
		p1 = &ol; tillspace(p1); p1++;
		tillspace(p1); p1++; tillspace(p1);
		if (strlen(p1)) {
		    *p1 = '\0'; p1++; sprintf(p,"%s :%s",&ol,p1); }
		else strcpy(p,ol);
		break;
      	    case 2: strcpy(com,"mode");
		p1=ol; copyspace(ptr,p1); whilespace(ptr); p2=ptr;
		if ((!*p2 && (*ol=='-' || *ol=='+')) ||
		  (*p2 && *p2!='-' && *p2!='+'))
		    sprintf(p,"%s %s %s %s",com,my_chan,ol,p2);
		else
		    sprintf(p,"%s %s %s",com,ol,p2);
		break;
	    default: ;
    	}
    	if (cmdch[0]) sprintf(ol,"%c%s",cmdch[0],p); else strcpy(ol,p);
    	putbold(ol,TRUE); strcat(p,"\n\r\0"); qio_send(p);
    }
}

/******************************************************************************/

do_nobold()
{
  bold_flag = !bold_flag;
  if (bold_flag) {
    putchunk("*** Enabled BOLD text output",FALSE); wsetattr(inpwin,_BOLD);
    if (clockwin) { wsetattr(clockwin,_BOLD); wrefresh(clockwin); }
  } else {
    putchunk("*** Disabled BOLD text output",FALSE); wclrattr(inpwin,_BOLD);
    if (clockwin) { wclrattr(clockwin,_BOLD); wrefresh(clockwin); }
  }
}

/******************************************************************************/

do_noecho(num,dummy,line)
int num;
char *dummy,*line;
{
  strcpy(inpline,&line[1]); inpx=strlen(inpline);
  if (dbopt&1) putbold(cmdch[0]?line:&line[1],FALSE);
}

/******************************************************************************/

do_nokill()
{
  notice_flag = !notice_flag;
  if (notice_flag) putchunk("*** Disabled full KILL messages",FALSE);
  else putchunk("*** Enabled full KILL messages",FALSE);
}

/******************************************************************************/

do_nick(num,ptr,line)
int num;
char *ptr,*line;
{
  char *p,*n;
  int i=0;

  p=ptr; n=my_nick;
  while (i++<MAXNICKLEN && *p && *p!=' ') *n++ = *p++;
  *n='\0';
  do_default(num,ptr,line);
  create_status();
}

/******************************************************************************/

/*
 * notify: a few handy routines to notify you when people enter and leave irc
 *
 * Written By Michael Sandrof
 * Copyright(c) 1990
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT
 *
 * Revamped by lynX - Dec '91
 * Ported to VMS, and modified by GrayElf - April '92
 */

do_notify(dummy, nick)
int dummy;
char *nick;
{
char ol[256], tim[]="17-NOV-1858 00:00:00.00";
int tim_len;                        

NotifyStruct *new;
int no_nicks = 1, ptr;

/*    while (nick = next_arg(args, &args)) { */
while (*nick) {
	no_nicks = 0;
	if (ptr = strcspn(nick, ",")) {
		if (ptr == strlen(nick)) nick[ptr] = (char) NULL;
		else nick[ptr++] = (char) NULL;
	}
	if (*nick == '-') {
		nick++; ptr--;
		if (*nick) {
			if (new = (NotifyStruct *)
			   dequeue(notify_list, nick)) {
				new_free(new->nick);
				new_free(&new);
				sprintf(ol,"*** %s removed from notification list", nick);
				putchunk(ol,FALSE);
				num_notify = num_notify - 1;
			} else {
				sprintf(ol,"*** %s is not on the notification list", nick);
				putchunk(ol,FALSE); }
		} else
			show_notify_list(0);
	} else {
		if (*nick == '+') {
			nick++; ptr--; }
		if (*nick) {
			if (strcspn(nick, "*") != strlen(nick))
				putchunk("*** Wildcards not allowed in NOTIFY nicknames!");
			else if (new = (NotifyStruct *) dequeue(notify_list, nick)) {
				new_free(new->nick);
				new_free(&new);
				num_notify = num_notify - 1;
			}
			new = (NotifyStruct *) malloc(sizeof(NotifyStruct));
			new->next = (NotifyStruct *)NULL;
			new->nick = (NotifyStruct *) malloc(strlen(nick)+2);
			strcpy(new->nick, nick);
			new->flag = -1;
			enqueue(notify_list, new);
			sprintf(ol,"*** %s added to the notification list", new->nick);
			putchunk(ol,FALSE);
			num_notify = num_notify + 1;
		} else
			show_notify_list(0);
	}
	nick = &nick[ptr];
}
if (no_nicks)
	show_notify_list(1);
if (num_notify) {
	c$cks(sys$cantim(&notify_id,NIL));
	c$cks(sys$gettim(&notify_time));
	c$cks(sys$asctim(&tim_len,c$dsc(tim),&notify_time,NIL));
/*	strcpy(&tim[18],"00.00"); */
	c$cks(sys$bintim(c$dsc(tim),&notify_time));
	c$cks(sys$setimr(NIL,&notify_time,notify_ast,&notify_id,NIL));
	}
else
	c$cks(sys$cantim(&notify_id,NIL));
}

show_notify_list(all)
int all;
{
    NotifyStruct *tmp;
    char list1[512],list2[512],ol[512];

    strcpy(list1, "\0"); strcpy(list2, "\0");
    for (tmp = notify_list->first; tmp; tmp = tmp->next) {
	if (tmp->flag == 1) {
		strcat(list1, " ");
		strcat(list1, tmp->nick);
	}
	if (all && tmp->flag == 0) {
		    strcat(list2, " ");
		    strcat(list2, tmp->nick);
	}
    }
    if (*list1) {
	sprintf(ol,"*** Currently present:%s", list1); putchunk(ol,FALSE);
    new_free(&list1);
    }
    if (*list2) {
	sprintf(ol,"*** Currently absent:%s", list2); putchunk(ol,FALSE);
    new_free(&list1);
    }
}

/******************************************************************************/

do_oper(num,dummy,line)
int num;
char *dummy,*line;
{
  if (!your_priv) strcpy(oppwd,dummy);
  strcpy(inpline,&line[1]); inpx=strlen(inpline);
  if (histptr) histptr--; else histptr=MAXHIST-1;
  histptrt=histptr;
}

/******************************************************************************/

do_privmsg(flag,ptr)
int flag;
char *ptr;
{
  char *tp,txt[512],line[20];

  tp=ptr; tillspace(ptr); if (*ptr) *ptr++ ='\0'; whilespace(ptr);
  switch (flag) {
    case 1: strcpy(line,"PRIVMSG");    break;
    case 2: strcpy(line,"NOTICE");  break;
    case 3: strcpy(line,"PRIVMSG"); break;
    case 4: strcpy(line,"PRIVMSG");   break;
    case 5: strcpy(line,"PRIVMSG");    break;
  }
  sprintf(inpline,"%s %s :%s",line,tp,*ptr?ptr:" "); inpx=strlen(inpline);
  if (flag == 2) { sprintf(txt,"-> -%s- %s",tp,ptr); putbold(txt,TRUE); }
  else { sprintf(txt,"-> *%s* %s",tp,ptr); putbold(txt,TRUE); }
  sprintf(lastmsg,"%s %s",tp,ptr);
}

/******************************************************************************/

do_quit(int dummy, char *ptr)
{
  char line[20];

  anti_kill=0;
  if (*ptr)
    sprintf(&line,"quit :%s",ptr);
  else
    sprintf(&line,"quit Leaving");
  putbold(&line,FALSE); strcat(&line,"\r\n\0");
  qio_send(&line);
  rundown(0);
}

/******************************************************************************/

do_quote(dummy,ptr,line)
int dummy;
char *ptr,*line;
{
  putbold(cmdch[0]?line:&line[1],TRUE);
  strcpy(inpline,ptr);inpx=strlen(inpline);
}

/******************************************************************************/

do_redirect(opt,ptr)
int opt;
char *ptr;
{
  char line[512],msg[512],txt[256],txt2[256],otxt[256],*lptr,*lnick,*txtp;

  if (*ptr) {
    if (*lastmsg) {
      lptr=lastmsg; lnick=txt; copyspace(lptr,lnick); whilespace(lptr);

      txtp=txt2; copyspace(ptr,txtp); whilespace(ptr);
      if (opt==2) {
        if (!*ptr) { strcpy(otxt,"Oops, please ignore..."); ptr=otxt; }
        if (!strcmp(txt,"*")) {
          sprintf(line,"PRIVMSG %s :%s\r\n",my_chan,ptr);
          sprintf(msg,"> %s",ptr);
        } else {
          sprintf(line,"PRIVMSG %s :%s\r\n",txt,ptr);
          sprintf(msg,"-> *%s* %s",txt,ptr);
        }
        putchunk(msg,TRUE); qio_send(line); 
      }
      if (!strcmp(txt2,"*")) {
        sprintf(line,"PRIVMSG %s :%s\r\n",my_chan,lptr);
        sprintf(msg,"> %s",lptr);
      } else {
        sprintf(line,"PRIVMSG %s :%s\r\n",txt2,lptr);
        sprintf(msg,"-> *%s* %s",txt2,lptr);
      }
      putbold(msg,TRUE); qio_send(line);
    } else putchunk("*** Sorry, you have no message to redirect...",FALSE);
  } else putchunk("*** Missing nickname for command REDIRECT.",FALSE);
}

/******************************************************************************/

do_script(dummy,ptr)
int dummy;
char *ptr;
{
  char *tp,txt[MAXINPLEN],tmp[256];
  FILE *scriptfile;

  if (*ptr) {
    strcpy(tmp,ptr);
    if (!(scriptfile=fopen(tmp,"r"))) {
      sprintf(tmp,"%s.irc",ptr);
      if (!(scriptfile=fopen(tmp,"r"))) {
        sprintf(txt,"*** Error: Cannot execute %s",ptr); putchunk(txt,FALSE);
        return; }
    }
    sprintf(txt,"***** Executing file %s *****",tmp); putchunk(txt,FALSE);
    while (fgets(txt,sizeof(txt),scriptfile)) {
      if (*(tp=txt+strlen(txt)-1)=='\n') *tp='\0';
      if (strlen(txt) && txt[0]!=';')
        if (testinpline(txt)) {
          if (dbopt&8) { sprintf(txt,"DEBUG: [script] |%s|",inpline); putchunk(txt,FALSE); }
          inpline[inpx++]=13; inpline[inpx++]=10; inpline[inpx]=0;
          qio_send(inpline);
        }
    }
    fclose(scriptfile);
    sprintf(txt,"***** Finished scriptfile %s *****",tmp); putchunk(txt,FALSE);
    inpline[0]='\0'; inpx=0;
  }
  else putchunk("*** Error: No filename given. Please specify.",FALSE);
}

/******************************************************************************/

do_server(dummy,ptr)
int dummy;
char *ptr;
{
  char *txtp,txt[256],ol[256];

  txtp=txt; copyspace(ptr,txtp); whilespace(ptr);
  if (!*txt) {
    sprintf(ol,"%s",server);
    putchunk(ol,FALSE); 
    return; }
#ifdef MULTINET
  else if (!atoi(txt)) {
    sprintf(ol,"Sorry, only IP adresses work at this stage.");
    putchunk(ol,FALSE);
    return; }
#endif
  else {
    strcpy(server,txt); if (*ptr) srvport=atoi(ptr);
    anti_kill|=2; your_priv=FALSE; oppwd[0]='\0'; avenger=FALSE;
    rundown(1); }
}

/******************************************************************************/

do_showesc()
{
  showesc_flag = !showesc_flag;
  ctrl_flag = showesc_flag;
  if (showesc_flag) putchunk("*** Enabled display of escape characters",FALSE);
  else putchunk("*** Enabled interpretation of escape characters",FALSE);
}

/******************************************************************************/

do_signal(dummy,ptr)
int dummy;
char *ptr;
{
  char txt[80],ol[256];

  if (!strcmp(ptr,"?")) {
    txt[0]='\0';
    if (signalmode&1) strcat(txt,"private,");
    if (signalmode&2) strcat(txt,"public,");
    if (signalmode&4) strcat(txt,"modification,");
    if (signalmode==0) strcpy(txt,"no,");
    if (signalmode==7) strcpy(txt,"all,");
    txt[strlen(txt)-1]='\0';
    sprintf(ol,"*** Message signals are enabled for %s messages.",txt);
    putchunk(ol,FALSE);
  } else
  if (!stricmp(ptr,"none")) {
    signalmode=0; putchunk("*** All message signals disabled.",FALSE);
  } else
  if (!stricmp(ptr,"priv")) {
    signalmode|=1; putchunk("*** Message signals enabled for private messages.",FALSE);
  } else
  if (!stricmp(ptr,"msg")) {
    signalmode|=2; putchunk("*** Message signals enabled for public messages.",FALSE);
  } else
  if (!stricmp(ptr,"mod")) {
    signalmode|=4; putchunk("*** Message signals enabled for modification messages.",FALSE);
  } else
  if (!stricmp(ptr,"all")) {
    signalmode=7; putchunk("*** All message signals enabled.",FALSE);
  } else
  putchunk("*** Unknown command qualifier for SIGNAL specified.",FALSE);
}

/******************************************************************************/

do_spawn()
{
  struct dsc$descriptor cdsc;
  struct dsc$descriptor *cdscp;
  int i;
  long substatus;

  printf("\n-----------------------------------\n");
  printf("Reenter IRC with the command LOGOUT\n");
  printf("-----------------------------------\n");
  sys$cancel(mbx_chan);
  sys$cancel(chan);
  c$cks(sys$qiow(0,chan,IO$_SETMODE,iosb,0,0,oldmode,sizeof(oldmode),0,0,0,0));
  sys$dassgn(chan);
  cdscp=0; kbd_fin=1;
  lib$spawn(cdscp,0,0,0,0,0,&substatus,0,0,0);
  i=MAXBRDCSTLEN; c$cks(lib$asn_wth_mbx(c$dsc("TT:"),&i,&i,&chan,&mbx_chan));
  c$cks(sys$qiow(0,chan,IO$_SETMODE,iosb,0,0,newmode,sizeof(newmode),0,0,0,0));
  delwin(newwin(LINES,COLS,0,0));
  win_refresh();
  c$cks(sys$qio(0,chan,IO$_READVBLK+IO$M_NOFILTR+IO$M_NOECHO,iosb,kbd_ast,0,
        &inpchar,1,0,0,0,0));
}

/******************************************************************************/

do_squit(int dummy, char *ptr)
{
char *tmp,ol[512];

    tmp = ptr;
    tillspace(ptr);
    if (strlen(ptr)) {
	*ptr = '\0'; ptr++;
	sprintf(&ol,"SQUIT %s :%s\r\n", tmp, ptr);
	qio_send(&ol);
    }
    else putchunk("*** Reason required for /SQUIT.",FALSE);
}

/******************************************************************************/

do_srvinfo(dummy,ptr)
int dummy;
char *ptr;
{
  char txt[256];

  sprintf(txt,"VERSION %s\r\n",ptr); qio_send(txt);
  sprintf(txt,"TIME %s\r\n",ptr); qio_send(txt);
  sprintf(txt,"ADMIN %s\r\n",ptr); qio_send(txt);
  sprintf(txt,"MOTD %s\r\n",ptr); qio_send(txt);
}

/******************************************************************************/

do_status()
{
  char txt[256];
  extern do_clock();

  status_line= !status_line;
  if (status_line) {
    scroll(msgwin);
    statwin=newwin(1,COLS,LINES-2,0); wsetattr(statwin,_REVERSE); wclear(statwin);
    msg_refresh();
    create_status();
    do_clock(0);
  } else {
    mvwaddstr(msgwin,LINES-2,0,"*** Statusline removed again.");
    delwin(statwin);
    msg_refresh();
    do_clock(0);
  }
}

/******************************************************************************/

do_time(flag,ptr)
int flag;
char *ptr;
{
  char line[256];

  line[0]=cmdch[0];
  if (flag==1) sprintf(&line[1],"date %s",ptr);
  if (flag==2) sprintf(&line[1],"time %s",ptr);
  sprintf(inpline,"time %s",ptr); inpx=strlen(inpline);
  putbold(cmdch[0]?line:&line[1],TRUE);
}

/******************************************************************************/

do_who(flag,ptr,line)
int flag;
char *ptr,*line;
{
  char *tp;

  if (flag == 0 && (!strcmp(ptr,"*"))) strcpy(ptr,my_chan);
  else if (flag==1) switch (*ptr) {
    case '@': strcpy(whoinp,"@ "); ptr++; whilespace(ptr); break;
    case '*': strcpy(whoinp,"* "); ptr++; whilespace(ptr); break;
    case '#': strcpy(whoinp,"*@"); ptr++; whilespace(ptr); break;
    default:  strcpy(whoinp,"* "); if (*ptr) ptr++; whilespace(ptr);
  }
  else if (flag==3 || flag==4) {
    tp=whoinp; copyspace(ptr,tp);
  }
  sprintf(inpline,"WHO %s",ptr); inpx=strlen(inpline);
  whoop = flag;
}

/******************************************************************************/
