/******************************************************************************

                       VMS - IRC - Client   HEADER file

 Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
                       CMU/tek, UCX, Wollongong or Multinet TCP/IP

 Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG

 Modified for IRC 2.7 by GrayElf, paul@coombs.anu.edu.au

 ******************************************************************************/

#define __VMS_CURSES
#include curses
#include time

#ifdef CMU
#define TRANSPORT "CMU-tek"
#endif
#ifdef WIN
#define TRANSPORT "Wollongong"
#endif
#ifdef UCX
#define TRANSPORT "UCX"
#endif
#ifdef PSC
#define TRANSPORT "TCPware"
#endif
#ifdef MULTINET
#undef TRANSPORT
#define TRANSPORT "Multinet"
#endif

#undef	STATUS				/* Status line on by default */
#define UAI$_OWNER	12		/* Needed part of <uaidef.h> */

#define MAXFONTHEIGHT 10		/* Maximum height for font characters */
#define MAXFONTWIDTH 7			/* Maximum width of a font character */
#define MAXHIST 20			/* Size of the history buffer */
#define MAXPARA 15			/* Maximum # of param's from server */
#define MAXNICKLEN 10			/* Maximum length of a nickname */
#define PRIVREC 10			/* Buffersize for PRIVMSG nicknames */
#define MAXINPLEN 238			/* Size of input line buffer */
#define MAXNETLEN 1024			/* Size of buffer for net read */
#define MAXBRDCSTLEN 256		/* Maximum size of broadcasts */
#define BRDCSTWINHEIGHT 4		/* Height of broadcast window */
#define MAXCOLS 250			/* Max. column # of the terminal */
#define MINCOLS 80			/* Min. column # of the terminal*/
#define MINLINES 6			/* Min. line # of the terminal */
#define MAXSAVMSG 200			/* Size of message recall buffer */
#define MAXDCLMSG 50			/* Size of DCL recall buffer */
#define CLOCKINTERVAL "0 00:01:00.00"	/* Timer interval used for the CLOCK */
#define INTERVAL "0 00:01:00.00"	/* Timer interval used for LEAVE */
#define NOTIFYINTERVAL "0 00:01:00.00"	/* Timer interval used for NOTIFY */
#define NETINTERVAL 30000000		/* Timer interval of FLUSH (100ns) */
#define RECONNECTDELAY 2		/* Network shutdown timeout delay */
#define MAXCHANNELS 16			/* Maximum Multichannels allowed */
#define MAXCHNUSR 256			/* Maximum users on a channel */

/******************************************************************************/

#ifndef NULL
#define NULL 0
#endif
#ifdef NODCL
#undef NODCL
#undef MAXDCLMSG
#define MAXDCLMSG 5
#endif

#ifdef NOMEM
#undef NOMEM
#undef MAXDCLMSG
#undef MAXSAVMSG
#define MAXDCLMSG 5
#define MAXSAVMSG 20
#endif

#ifdef MAXBUF
#undef MAXSAVMSG
#define MAXSAVMSG MAXBUF
#endif

#ifdef HIST
#undef MAXHIST
#define MAXHIST HIST
#endif

/******************************************************************************/

typedef char fonttyp[256][MAXFONTHEIGHT][MAXFONTWIDTH+1];
#ifndef bool
typedef char bool;
#endif
typedef struct { unsigned long l1; long l2; } quadw;
typedef struct {
/*  WINDOW *window; */
  char name[256];
  int lines,start;
  struct { char name[MAXNICKLEN]; bool chanop; } user[MAXCHNUSR];
} CHANNEL;

/* NotifyQ: the structure for the notify stuff */
typedef struct notify_stru {
    struct notify_stru *next;	/* pointer to next notify person */
    char *nick;			/* nickname of person to notify about */
    int flag;			/* 1=person on irc, 0=person not on irc */
}	NotifyStruct;

typedef struct notify_lis {
    struct NotifyStruct *first;
    struct NotifyStruct *last;
}	NotifyList;

NotifyList *notify_list;

typedef struct alias_struct {
    struct alias_struct *next;
    char *alias;
    char *equiv;
}	AliasStruct;

AliasStruct *alias_list;

struct Message {
  char *command;
  int (* funct)();
  int varpar;
  int returncode;
  char *helptext;
};

/******************************************************************************/

globalref struct Message msgtab[];
globalref char spc[],spcchars[],trmchars[];

extern unsigned short chan,net_chan,dcl_chan_in,dcl_chan_out,mbx_chan;
extern unsigned short dcl_in_iosb[4],dcl_out_iosb[4],mbx_iosb[4];
extern unsigned int   iosb[2],read_iosb[2],oldmode[3],newmode[3];
extern char persname[80],my_nick[MAXNICKLEN],server[80],
	    lfilename[160],fontnam[160],dirpath[160],inpline[256],inpchar,
	    cmdch[],oppwd[256],histbuf[MAXHIST][256],fkey[36][256],
	    savbuf[MAXSAVMSG][MAXNETLEN],recbuf[MAXSAVMSG+1][MAXNETLEN],
	    outl[MAXNETLEN],*nr_pos,dcloutbuf[MAXNETLEN],*dcl_pos,
	    brdcstbuf[MAXBRDCSTLEN],query[256],*query_ptr[32],ignore[256],
	    *ignore_ptr[32],srvnam[80],script[160],whoinp[80],
	    whoop,dbopt,signalmode,lastmsg[256],notify_array[50][10],
	    prvrec[PRIVREC][MAXNICKLEN+1],dclbuf[MAXDCLMSG][MAXNETLEN];
extern bool anti_kill,kbd_fin,edit_mode,away_flag,status_line,
	    notice_flag,errlog_flag,your_priv,ctrl_flag,showesc_flag,
	    ignore_flag,font_mode,flush_mode,avenger,clock_mode,dcl_mode,
	    dcl_mbx,brdcst_flag,recall_mode,bold_flag,dcl_visible;
extern int inpx,crsr,scrcurs,escflag,histptr,histptrt,savptr,dclptr,srvport,
	   fontheight,fontwidth,dcl_size,recpos[MAXSAVMSG+1],fkey_mode[36],
	   net_chan_tcp,query_max,ignore_max,userlen,help_num,recall_num,
	   recall_start,fkey_pos,inpscroll,channels,HiddenCmd,AllCmd,
           num_notify;
extern long leave_id,clock_id,dcl_pid,notify_id;
extern quadw leave_time,clock_time,net_time,notify_time;
extern FILE *logfile;
extern fonttyp font;
extern CHANNEL channel[MAXCHANNELS];
extern WINDOW *dispwindow,*inpwin,*clockwin,*brdcstwin,*tmpwin,*dclwin,*t2win,
	      *statwin;
extern time_t last_command;

/******************************************************************************/

#define NIL		((void *) 0)
#define min(a,b)	((a)<(b)?(a):(b))
#define max(a,b)	((a)>(b)?(a):(b))
#define upcase(c)	(islower(c)?toupper(c):(c))
#define locase(c)	(isupper(c)?tolower(c):(c))
#ifndef isspace
#define isspace(c)	(strchr(spcchars,(c))!=0)
#endif
#define isterminator(c)	(strchr(trmchars,(c))!=0)
#define ringplus(a,b)	(((a)<(b)-1)?(a)+1:0)
#define ringminus(a,b)	((a)?(a)-1:(b)-1)
#define tillspace(a)	while (*(a)!=' ' && *(a)) *(a)++;
#define whilespace(a)	while (*(a)==' ') *(a)++;
#define copyspace(a,b)	while (*(a)!=' ' && *(a)) *(b)++ = *(a)++; *(b)='\0';
#define WORKLINES	(LINES-(status_line?2:1))

/******************************************************************************/

#define msgwin  dispwindow
#define my_chan channel[0].name
