/******************************************************************************

                       VMS - IRC - Client   version 1.7.6

 Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
                       CMU/tek, UCX, Wollongong or Multinet TCP/IP

 Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG

 Modified for IRC 2.7 by GrayElf, paul@coombs.anu.edu.au

 You may freely distribute this software provided that the above copyright
 notice remains unchanged in all copies. You are free to make your own changes
 to the code but only unmodified copies may be redistributed.

 E-Mail contact for bug-reports: paul@coombs.anu.edu.au

 ******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <descrip.h>
#include <string.h>
#include <iodef.h>
#include <ssdef.h>
#include <ttdef.h>
#include <tt2def.h>
#include <dvidef.h>
#ifdef WIN
#include <types.h>
#include <socket.h>
#include <netdb.h>
#include <in.h>
#include <vms/inetiodef.h>
#define MAXDNAME 256
/* #include <arpa/nameser.h> */
#include <resolv.h>
struct hostent *dest_host;
struct sockaddr_in data_socket = {0};
#endif
#ifdef MULTINET
extern noshare int h_errno;
#endif
#ifdef UCX
#include <netdb.h>
#include <in.h>
#include <inet.h>
#include <ucx$inetdef.h>
#include "ucxdef.h"
struct hostent *dest_host;
#endif
#ifdef PSC
#include <tcpip_root:types.h>
#include <tcpip_root:socket.h>
#include <tcpip_root:in.h>
#include <tcpip_root:inet.h>
struct hostent *dest_host;
struct sockaddr_in data_socket = {0};
struct descriptor {long int len;
                   char    *adr;} ecb_desc, hn_desc;
struct itemlist {short int param_id;
                 long  int param_val;} ecb[2];
long int host_addr;
#endif
#include "header.h"
#include "environment.h"

/*----------------------------------------------------------------------------*/

extern net_ast(),kbd_ast(),brdcst_ast(),msg_refresh();

/*----------------------------------------------------------------------------*/

globaldef char spcchars[]=" .,:;()[]{}<>", trmchars[]=" ?!.,;:-",
	       spc[]="                                                        ";
unsigned short chan,net_chan,dcl_chan_in,dcl_chan_out,mbx_chan;
unsigned short dcl_in_iosb[4],dcl_out_iosb[4],mbx_iosb[4];
unsigned int   iosb[2],read_iosb[2],
               oldmode[3],newmode[3];
char persname[80],my_nick[MAXNICKLEN],server[80],
     lfilename[160]="\0",fontnam[160]="\0",dirpath[160],
     inpline[256],inpchar='\0',cmdch[]="/OPER",oppwd[256]="\0",
     histbuf[MAXHIST][256],fkey[36][256],dclbuf[MAXDCLMSG][MAXNETLEN],
     savbuf[MAXSAVMSG][MAXNETLEN],recbuf[MAXSAVMSG+1][MAXNETLEN],
     outl[MAXNETLEN],*nr_pos=outl,dcloutbuf[MAXNETLEN],*dcl_pos=dcloutbuf,
     brdcstbuf[MAXBRDCSTLEN],
     query[256],*query_ptr[32],ignore[256],*ignore_ptr[32],
     prvrec[PRIVREC][MAXNICKLEN+1],
     srvnam[80]="\0",script[160],whoinp[80],whoop,dbopt='\0',signalmode='\0',
     killer[MAXNICKLEN]="\0",lastmsg[256]="\0",notify_array[50][10];
bool anti_kill=0,kbd_fin=0,edit_mode=0,
     notice_flag=TRUE,errlog_flag=FALSE,your_priv=FALSE,ctrl_flag=FALSE,
     showesc_flag=TRUE,away_flag=FALSE,status_line=FALSE,
     ignore_flag=FALSE,font_mode=FALSE,flush_mode=FALSE,avenger=FALSE,
     clock_mode=FALSE,dcl_mode=FALSE,dcl_mbx=FALSE,brdcst_flag=FALSE,
     recall_mode=FALSE,bold_flag=FALSE,dcl_visible;
int inpx=0,crsr,scrcurs,escflag,histptr=0,histptrt=0,savptr=0,dclptr=0,
    srvport,fontheight,fontwidth,dcl_size,recpos[MAXSAVMSG+1],fkey_mode[36],
    net_chan_tcp=0,query_max=0,ignore_max=0,userlen=80,help_num=0,
    recall_num=0,recall_start= -1,fkey_pos=0,inpscroll=65,windows,num_notify,
    channels;
time_t  last_command;
long    notify_id,leave_id,clock_id,dcl_pid=0;
quadw   notify_time={0,0},leave_time={0,0},clock_time={0,0},net_time={0,0};
FILE    *logfile=NULL;
fonttyp font;
CHANNEL channel[MAXCHANNELS];
WINDOW  *inpwin,*brdcstwin,*statwin,*dispwindow,
        *clockwin=NIL,*tmpwin=NIL,*dclwin=NIL,*t2win=NIL;

/******************************************************************************/

dump(adr,len)
char *adr;
int len;
{
  int cnt;
  char tmp[256],hex[16];

  while(len>0) {
    tmp[0]='\0';
    for(cnt=16;cnt && len--;cnt--) {
      sprintf(hex,cnt==8?"%02x-":"%02x ",(unsigned char)*adr++);
      strcat(tmp,hex); }
    putbold(tmp,FALSE);
  }
}

/******************************************************************************/

int stricmp(src1,src2)
char *src1,*src2;
{
  while(*src1) {
    if (!(*src2)) return(upcase(*src1));
    if (upcase(*src1)!=upcase(*src2))
      return(upcase(*src1)-upcase(*src2));
    src1++; src2++;
  }
  return(-upcase(*src2));
}

/******************************************************************************/

int strincmp(src1,src2,cnt)
char *src1,*src2;
int cnt;
{
  while(*src1 && cnt--) {
    if (!*src2) return(upcase(*src1));
    if (upcase(*src1) != upcase(*src2))
      return(upcase(*src1)-upcase(*src2));
    src1++; src2++;
  }
  return(cnt?-upcase(*src2):0);
}

/******************************************************************************/

int quadcmp(tim1,tim2)
quadw *tim1,*tim2;
{
  if (tim1->l2==tim2->l2) return(tim1->l1-tim2->l1);
  else return(tim1->l2-tim2->l2);
}

/******************************************************************************/

int *c$_tmphead = (int *) 0;

int *c$alloc_tmp(size)
int size;
{
  int *tmp;

  tmp=malloc(size+4); *tmp=c$_tmphead; c$_tmphead=tmp;
  return(c$_tmphead+1);
}

/******************************************************************************/

c$dsc(c$_str)
char *c$_str;
{
  struct dsc$descriptor *c$_tmpdesc;

  c$_tmpdesc = c$alloc_tmp(8);
  c$_tmpdesc->dsc$w_length = strlen(c$_str);
  c$_tmpdesc->dsc$b_dtype  = DSC$K_DTYPE_T;
  c$_tmpdesc->dsc$b_class  = DSC$K_CLASS_S;
  c$_tmpdesc->dsc$a_pointer= c$_str;
  return(c$_tmpdesc);
}

/******************************************************************************/

c$cks(c$_status)
int c$_status;
{
  int *c$_tmp;

  if (!(c$_status&1) && c$_status!=0)
    if (c$_status==SS$_ABORT || c$_status==SS$_VCCLOSED) rundown(0);
#ifdef UCX
    else if (c$_status==SS$_LINKEXIT || c$_status==SS$_LINKDISCON) rundown(0);
#endif
    else if (c$_status == 33200) {
       printf("Connection terminated by server.");
       rundown(0); }
    else { printf("\nError #%d\n",c$_status); lib$stop(c$_status); }
  while (c$_tmphead) {
    c$_tmp= *c$_tmphead; free(c$_tmphead); c$_tmphead=c$_tmp;
  }
  return(c$_status);
}

/******************************************************************************/

qio_send(text)
char *text;
{
  char tmp[MAXNETLEN];
  unsigned short *i_o_size;
  extern putchunk();

  if (dbopt&4) { sprintf(tmp,"DEBUG: [$qio] |%s|",text); putchunk(tmp,FALSE); }
  strcpy(tmp,text);
  i_o_size=iosb;
#if CMU || WIN || PSC
  c$cks(sys$qiow(0,net_chan,IO$_WRITEVBLK,iosb,0,0,tmp,strlen(tmp),0,net_chan_tcp,0,0));
#endif
#ifdef UCX
  c$cks(sys$qiow(3,net_chan,IO$_WRITEVBLK,iosb,0,0,tmp,strlen(tmp),0,0,0,0));
#endif
  c$cks(*i_o_size);
}

/******************************************************************************/

putwin(win,lines,col,txt,flag,flag2)
WINDOW *win;
int lines,col;
char *txt;
bool flag,flag2;
{
  int len=strlen(txt);
  char tmp[256];

  if (!len) { scroll(win); if (flag) wrefresh(win); }
  while (len>col) {
    memcpy(tmp,txt,col); tmp[col]='\0';
    scroll(win); mvwaddstr(win,lines-1,0,tmp); if (flag) wrefresh(win);
    txt+=col; len-=col;
  }
  if (len) {
    if (!flag2) scroll(win);
    mvwaddstr(win,lines-1,0,txt);
    if (flag2) scroll(win);
    if (flag) wrefresh(win);
  }
}

/******************************************************************************/

putparse(il)
unsigned char *il;
{
	unsigned char ol[256],*ilp,l[MAXNETLEN],*lp;
	int i,pos;
	ilp=il; lp=l;

	while (*ilp)
		if (showesc_flag && (*ilp<32 || (*ilp>127 && *ilp<160))) {
			*lp++ = '^'; *lp++ = (*ilp++)+64;
		} else *lp++ = *ilp++;
	*lp='\0';

	ilp=l;
	while (*ilp)
		{
		i=0; pos=0; lp=ilp;
		while (i<COLS && *lp)
			{
			if (isterminator(*lp)) pos=i+1;
			lp++; i++;
			}
		if (!pos) pos=COLS;
		if (!*lp) pos=strlen(ilp);
		memcpy(ol,ilp,pos); ol[pos]='\0';
		if (status_line)
			putwin(dispwindow,WORKLINES+1,COLS,ol,FALSE,status_line);
		else putwin(dispwindow,WORKLINES,COLS,ol,FALSE,status_line);
/*		if (!status_line) scroll(msgwin);
		mvwaddstr(msgwin,LINES-2,0,ol);
		if (status_line) scroll(msgwin); */
		msg_refresh(); ilp+=pos;
		}
}

/******************************************************************************/

putchunk(il,flag)
char *il;
bool flag;
{
  char ol[256],*ilp,l[MAXNETLEN],*lp;
  int i,pos;

  if (logfile && (flag || !errlog_flag))
    fprintf(logfile,(ignore_flag?"[ignored]%s\n":"%s\n"),il);

  if (!ignore_flag && !flush_mode) {
    strcpy(savbuf[savptr],il); savptr=ringplus(savptr,MAXSAVMSG);

    putparse(il);
  }
  ignore_flag=FALSE;
}

/******************************************************************************/

putbold(il,flag)
char *il;
bool flag;
{
  if (bold_flag) wsetattr(msgwin,_BOLD);
  putchunk(il,flag);
  if (bold_flag) wclrattr(msgwin,_BOLD);
}

/******************************************************************************/

void new_free(ptr)
char **ptr;
{
    if (*ptr) {
	free(ptr);
	*ptr = '\0';
    }
}

/*
 * sindex: much like index(), but it looks for a match of any character in
 * the group, and returns that position.  If the first character is a ^, then
 * this will match the first occurence not in that group. If the first
 * character is a !, it will not match characters escaped with '\'
 */
char *sindex(string, group)
char *string,
    *group;
{
    char *ptr;
    int escapes;

    if (*group=='!')
    {
	group++;
	escapes=1;
    }
    else
	escapes=0;
    if ((string == (char *)NULL) || (group == (char *)NULL))
	return ((char *)NULL);
    if (*group == '^') {
	group++;
	for (; *string; string++) {
	    for (ptr = group; *ptr; ptr++) {
		if (*ptr == *string)
		    break;
	    }
	    if (*ptr == (char)NULL)
		return (string);
	}
    } else {
	for (; *string; string++) {
	    if (escapes && *string=='\\')
	    {
		if (*(++string)==(char)NULL)
			break;
		else
			continue;
	    }
	    for (ptr = group; *ptr; ptr++) {
		if (*ptr == *string)
		    return (string);
	    }
	}
    }
    return ((char *)NULL);
}

char *next_arg(str, new_ptr)
char *str,
   **new_ptr;
{
    char *ptr, *empty_string;

    if (ptr = sindex(str, "^ ")) {
	if (str = sindex(ptr, " "))
	    *(str++) = (char)NULL;
	else
	    str = empty_string;
    } else
	str = empty_string;
    if (new_ptr)
	*new_ptr = str;
    return (ptr);
}

/******************************************************************************/

char *get_uaf_entry()
{
  char uaf_owner[40],loc_username[13],t[40],*usrptr;
  int i,pos;

  struct item_list {
    short bl,ic; char *ba; short *rl;
  } getuai_itmlist[] = {
      { sizeof(uaf_owner), UAI$_OWNER, &uaf_owner[0], 0},{ 0, 0, 0, 0} };

  usrptr=getenv("USER"); strcpy(loc_username,usrptr);
  for (i=strlen(loc_username);i<12;++i) loc_username[i]=' ';
  loc_username[i]='\0';
  c$cks(sys$getuai(0,0,c$dsc(loc_username),getuai_itmlist,0,0,0));
  pos=1; if (uaf_owner[pos]=='|') pos+=3;
  while(uaf_owner[pos]==' ') pos++;
  uaf_owner[uaf_owner[0]+1]='\0';
  sprintf(t,"%s",&uaf_owner[pos]);
  return(t);
}

/******************************************************************************/

rundown(num)
int num;
{
  int i;
  long tloc;
  char txt[256],*ptr;

#if CMU || WIN
  sys$cancel(net_chan);
  sys$qiow(0,net_chan,IO$_DELETE,0,0,0,0,0,0,0,0,0); sys$dassgn(net_chan);
#endif
#ifdef PSC
  sys$qiow(0,net_chan,IO$_SETMODE|IO$M_CTRL|IO$M_SHUTDOWN,iosb,0,0,0,0,0,0,0,0);
  sys$dassgn(net_chan);
#endif
#ifdef UCX
  if (num == 0) {
    sys$qiow(3,net_chan,IO$_DEACCESS|IO$M_SHUTDOWN,iosb,0,0,0,0,0,INET$C_DSC_ALL,0,0);
    sys$qiow(3,net_chan,IO$_DEACCESS,iosb,0,0,0,0,0,0,0,0);
    sys$dassgn(net_chan);
  }
#endif
  if (num == 0) {
    sys$cancel(mbx_chan);
    sys$cancel(chan);
    sys$qiow(0,chan,IO$_SETMODE,iosb,0,0,oldmode,sizeof(oldmode),0,0,0,0);
    sys$dassgn(chan);
    if (leave_time.l2 || leave_time.l1) sys$cantim(&leave_id,NIL);
    if (clock_mode) sys$cantim(&clock_id,NIL);
    if (logfile) {
      time(&tloc);
      sprintf(txt,"*** Logfile closed at %s",ctime(&tloc)); putchunk(txt,TRUE);
      fclose(logfile); }
    delwin(brdcstwin);
    if (clockwin) delwin(clockwin);
    if (dclwin) delwin(dclwin);
    msg_refresh(); 
    if (status_line) wrefresh(statwin);
    wclear(inpwin); wrefresh(inpwin);
    if (dcl_mode) c$cks(sys$delprc(&dcl_pid,0));
    ptr=getenv("PATH"); strcpy(txt,ptr);
    chdir(txt);
    sys$exit(1);
  } else {
    sleep(RECONNECTDELAY);
    nr_pos=outl; for(i=0;i<MAXNETLEN;i++) outl[i]='\0';
    startnet(persname,my_nick,server,srvport,my_chan);
  }
}

/******************************************************************************/

startnet(persname,nick,server,srvport,chan_name)
char *persname,*nick,*server;
int srvport;
char *chan_name;
{
  char tmpline[256],*usrptr;
  short *ioptr=iosb;
  int i;
  unsigned long ip;
#ifdef UCX
  struct sockaddr local_host = prototype_sockaddr;
  struct sockaddr remote_host = prototype_sockaddr;
#endif

  strcpy(tmpline,server);

/*----------------------------------------------------------------------------*/
#ifdef CMU
  net_chan_tcp=1;
  c$cks(sys$assign(c$dsc("IP:"),&net_chan,0,0));
  c$cks(sys$qiow(0,net_chan,IO$_CREATE,iosb,0,0,tmpline,srvport,0,1,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) sys$exit(iosb[1]);
    else sys$exit(*ioptr);
  }
#endif
/*----------------------------------------------------------------------------*/
#ifdef WIN
  c$cks(sys$assign(c$dsc("INET:"),&net_chan,0,0));
  c$cks(sys$qiow(0,net_chan,IO$_SOCKET,iosb,0,0,AF_INET,SOCK_STREAM,0,0,0,0));
  if (isdigit(tmpline[0])) {
    data_socket.sin_addr.s_addr=inet_addr(tmpline);
  } else {
    if ((dest_host=gethostbyname(server))==NULL) {
      printf("\045IRC-F-HOST, Host %s not defined by TCP\n",tmpline); sys$exit(1); }
    data_socket.sin_addr.s_addr= *((unsigned long *)(dest_host->h_addr));
  }
  data_socket.sin_family=AF_INET;
  data_socket.sin_port=htons(srvport);
  c$cks(sys$qiow(0,net_chan,IO$_CONNECT,iosb,0,0,&data_socket,sizeof(data_socket),0,0,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) exit(iosb[1]);
    else exit(*ioptr);
  }
#endif
/*----------------------------------------------------------------------------*/
#ifdef PSC
  c$cks(sys$assign(c$dsc("TCP0:"),&net_chan,0,0));
  hn_desc.adr=tmpline;
  hn_desc.len=strlen(tmpline);
  if (hns_lookuphost(&hn_desc,&host_addr)!=SS$_NORMAL) {
    printf("\045IRC-F-HOST, Host %s not defined by TCP\n",tmpline);
    sys$exit(1);
  }
  ecb[0].param_id =2;           ecb[1].param_id =3;
  ecb[0].param_val=host_addr;   ecb[1].param_val=srvport;
  ecb_desc.len= sizeof(ecb);
  ecb_desc.adr= &ecb;
  c$cks(sys$qiow(0,net_chan,IO$_SETMODE|IO$M_CTRL|IO$M_STARTUP,iosb,0,0,0,&ecb_desc,0,0,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) sys$exit(iosb[1]);
    else sys$exit(*ioptr);
  }
#endif
/*----------------------------------------------------------------------------*/
#ifdef UCX
  sck_parm[0]=INET$C_TCP;
  sck_parm[1]=INET_PROTYP$C_STREAM;

  lhst_adrs.lgth= sizeof(local_host);
  lhst_adrs.hst=  &local_host;
  lhst_il3.lgth=  sizeof(local_host);
  lhst_il3.hst=   &local_host;
  lhst_il3.retlth=sizeof(local_host);
  lsck_adrs.lgth=     16;
  lsck_adrs.rmt_adrs= &local_hostaddr;
  lsck_adrs.retlth=   &l_retlen;

  rhst_adrs.lgth= sizeof(remote_host);
  rhst_adrs.hst=  &remote_host;
  rsck_adrs.lgth=     16;
  rsck_adrs.rmt_adrs= &remote_hostaddr;
  rsck_adrs.retlth=   &r_retlen;

  local_host.inet_family=INET$C_AF_INET;
  local_host.inet_port=0;
  local_host.adrs[0]=0; local_host.adrs[2]=0;
  local_host.adrs[1]=0; local_host.adrs[3]=0;

  remote_host.inet_family=INET$C_AF_INET;
  remote_host.inet_port=htons(srvport);

  if (isdigit(tmpline[0])) {
    ip=inet_addr(tmpline);
    for (i=0;i<4;i++) { remote_host.adrs[i]=ip&0xff; ip>>=8; }
  } else {
    if ((dest_host=gethostbyname(tmpline))==NULL) {
      printf("\045IRC-F-HOST, Host %s not defined by TCP\n",tmpline); sys$exit(1); }
    ip= *((unsigned long *)(dest_host->h_addr));
    for (i=0;i<4;i++) { remote_host.adrs[i]=ip&0xff; ip>>=8; }
  }

  c$cks(sys$assign(c$dsc("BG:"),&net_chan,0,0));
  c$cks(sys$qiow(3,net_chan,IO$_SETMODE,iosb,0,0,&sck_parm,0x01000000|SOCKOPT$M_REUSEADDR,&lhst_adrs,0,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) sys$exit(iosb[1]);
    else sys$exit(*ioptr);
  }
  c$cks(sys$qiow(3,net_chan,IO$_SENSEMODE,iosb,0,0,0,0,&lsck_adrs,0,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) sys$exit(iosb[1]);
    else sys$exit(*ioptr);
  }
  c$cks(sys$qiow(3,net_chan,IO$_ACCESS,iosb,0,0,0,0,&rhst_adrs,0,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) sys$exit(iosb[1]);
    else sys$exit(*ioptr);
  }
  c$cks(sys$qiow(3,net_chan,IO$_SENSEMODE,iosb,0,0,0,0,0,&rsck_adrs,0,0));
  if (!(*ioptr & 1)) {
    if (*ioptr==SS$_ABORT) sys$exit(iosb[1]);
    else sys$exit(*ioptr);
  }
#endif
/*----------------------------------------------------------------------------*/

  if (inpchar) { putchunk(" ",TRUE); putchunk(" ",TRUE); putchunk(" ",TRUE); }
  else {
    sprintf(tmpline,"*** Local VMS IRC Client version %s",VMSVERSION); putchunk(tmpline,TRUE);
    sprintf(tmpline,"*** This Client was last modified %s %s",__DATE__,__TIME__); putchunk(tmpline,TRUE);
  }
  wrefresh(inpwin);
  usrptr=getenv("USER");
  sprintf(tmpline,"USER %s x y :<%s>\r\n",usrptr,persname); qio_send(tmpline);
  if (nick[0]) { sprintf(tmpline,"NICK %s\r\n",nick); qio_send(tmpline); }
  if (*oppwd && your_priv && anti_kill&1) { sprintf(tmpline,"OPER %s\n",oppwd); qio_send(tmpline);
  } else { oppwd[0]='\0'; your_priv=FALSE; }
  if (avenger && your_priv) { sprintf(tmpline,"KILL %s *reKILL*\n",nstrip(killer)); qio_send(tmpline); }
  if (strcmp(chan_name,"0")) {
    i = channels - 2;
    while (i+1) {
	sprintf(tmpline,"JOIN %s\n",channel[i].name);
	qio_send(tmpline); i--; }
  }
  killer[0]='\0'; away_flag=FALSE;
  srvnam[0]='\0';

  c$cks(sys$gettim(&net_time));
  c$cks(sys$qio(0,net_chan,IO$_READVBLK,read_iosb,net_ast,0,
        outl,MAXNETLEN-1,0,0,0,0));
}

/******************************************************************************/

main(argc,argv)
int argc;
char *argv[];
{
  char *c,tmpline[256],*userptr,*nickptr,*servptr,*scriptptr,*portptr,iport[40],
       usr[40];
  short *ioptr=iosb;
  int i,lin,col,dev,error,
      nicklen=sizeof(my_nick),servlen=sizeof(server),scriptlen=sizeof(script),
      portlen=sizeof(iport);
  FILE *srvfile;

#ifdef DEBUG
  dbopt=0xff;
#endif

  alias_list = NULL;
  notify_list = malloc(sizeof(NotifyList));
  notify_list->first = NULL; notify_list->last = NULL;
  c=getenv("PATH"); sprintf(dirpath,"%s",c);
  for (i=0;i<MAXHIST;i++) *histbuf[i]='\0';
  for (i=0;i<MAXSAVMSG;i++) *savbuf[i]='\0';
  for (i=0;i<PRIVREC;i++) *prvrec[i]='\0';
  for (i=0;i<35;i++) { *fkey[i]='\0'; fkey_mode[i]=0; }
  strcpy(dclbuf[0],"DCLbuffer is empty, you do not have any DCL subprocess.");

  /*--------------------------------------------------------------------------*/

  i=MAXBRDCSTLEN; c$cks(lib$asn_wth_mbx(c$dsc("TT:"),&i,&i,&chan,&mbx_chan));
  i=DVI$_TT_PAGE; c$cks(lib$getdvi(&i,&chan,0,&lin,0,0));
  i=DVI$_DEVBUFSIZ; c$cks(lib$getdvi(&i,&chan,0,&col,0,0));
  i=DVI$_DEVTYPE;  c$cks(lib$getdvi(&i,&chan,0,&dev,0,0));
  if (lin<MINLINES || col<MINCOLS || col>MAXCOLS || dev==0) {
    sys$cancel(mbx_chan); sys$cancel(chan); sys$dassgn(chan);
    if (dev==0) printf("This client does not support unknown terminal types!\n");
    else if (col>MAXCOLS) printf("Wow! Your terminal is really large, but too large for IRC...\n");
    else printf("Your terminal is really too small for IRC!\n");
    sys$exit(1);
  }

  /*--------------------------------------------------------------------------*/

  if (argc>1) nickptr=argv[1];
  else if (getenv("IRCNICK")) nickptr=getenv("IRCNICK");
  else nickptr=getenv("USER");
  if (nickptr) { strncpy(my_nick,nickptr,nicklen); my_nick[nicklen-1]='\0'; }
  else my_nick[0]='\0';
  if (argc>2) servptr=argv[2]; else servptr=getenv("IRCSERVER");
  if (servptr) { strncpy(server,servptr,servlen); server[servlen-1]='\0'; }
  else if ((servptr=getenv("IRCSRVLIS")) || !(access("SYS$LOGIN:IRCSRV.DAT",0)))
    server[0]='\0';
  else if (strlen(DEFSERVER)) strcpy(server,DEFSERVER);
  else {
    printf("You have not specified an IRC server. To do this, simply edit\n");
    printf("your LOGIN.COM to include the command line, or type it in\n");
    printf("each time you login before using IRC:\n\n");
    printf("$ DEFINE IRCSERVER %c<server>%c\n\n",34,34);
    printf("If you do not know the server closest to you, please ftp the\n");
    printf("READ.ME text file from the same place as this program, and check\n");
    printf("the brief list of servers in there. Once on IRC, ask an IRC\n");
    printf("Operator which is the closest server for you.\n");
    exit(0); 
  }
  if (argc>3) portptr=argv[3]; else portptr=getenv("IRCPORT");
  if (portptr) { strncpy(iport,portptr,portlen); iport[portlen-1]='\0'; }
  else strcpy(iport,DEFPORT);
  srvport=atoi(iport);
  if (scriptptr=getenv("IRCLOGIN")) {
    strncpy(script,scriptptr,scriptlen); script[scriptlen-1]='\0'; }
  else if (!access("SYS$LOGIN:LOGIN.IRC",0))
    sprintf(script,"SYS$LOGIN:LOGIN.IRC");
  else script[0]='\0';
  if (userptr=getenv("IRCNAME")) {
    strncpy(persname,userptr,userlen); persname[userlen-1]='\0'; }
  else {
    strcpy(usr,get_uaf_entry());
    printf("\n\n\nInternet Relay Chat - VMS Client %s\n",VMSVERSION);
    printf("===================\n\n");
    printf("Use DEFINE IRCNAME \042Your real name\042 to predefine this...\n\n");
    printf("Personal name? [%s] ",usr);
    c$cks(sys$qiow(0,chan,IO$_READVBLK,iosb,0,0,persname,80,0,0,0,0));
    c$cks(*ioptr);
    persname[*(ioptr+1)]='\0';
    if (!*persname) strcpy(persname,usr);
    c$cks(lib$set_logical(c$dsc("IRCNAME"),c$dsc(persname),0,0,0));
  }

  /*--------------------------------------------------------------------------*/

  initscr();
  brdcstwin=newwin(BRDCSTWINHEIGHT,COLS,0,0); wsetattr(brdcstwin,_REVERSE); wclear(brdcstwin);
  windows=0; create_channel("0");
  dispwindow=newwin(WORKLINES,COLS,0,0);
  wclear(dispwindow); wrefresh(dispwindow);
  inpwin=newwin(1,COLS,LINES-1,0); wclear(inpwin);
  if (bold_flag) wsetattr(inpwin,_BOLD);
#ifdef STATUS
  do_status();
#endif

  c$cks(sys$qiow(0,chan,IO$_SENSEMODE,iosb,0,0,oldmode,sizeof(oldmode),0,0,0,0));
  newmode[0]=oldmode[0];
  newmode[1]=oldmode[1] | TT$M_NOBRDCST;
  newmode[2]=oldmode[2] | TT2$M_BRDCSTMBX;
  c$cks(sys$qiow(0,chan,IO$_SETMODE,iosb,0,0,newmode,sizeof(newmode),0,0,0,0));

  /*--------------------------------------------------------------------------*/

  if ((*server != NULL) && !(srvfile=getenv("IRCSRVLIS")))
  startnet(persname,my_nick,server,srvport,"0");

  c$cks(sys$qio(0,chan,IO$_READVBLK+IO$M_NOFILTR+IO$M_NOECHO,iosb,kbd_ast,0,
        &inpchar,1,0,0,0,0));
  c$cks(sys$qio(0,mbx_chan,IO$_READVBLK,mbx_iosb,brdcst_ast,0,
        brdcstbuf,MAXBRDCSTLEN,0,0,0,0));

  sys$setast(0);
  if (script[0]) { do_script(0,script); script[0]='\0'; }
  sys$setast(1);
  sys$hiber();
}

/******************************************************************************/
