$!******************************************************************************
$!
$!                       VMS - IRC - Client   DCL MAKE file
$!
$! Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
$!                       CMU/tek, UCX, Wollongong or Multinet TCP/IP
$!
$! Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG
$!
$!******************************************************************************
$!
$!
$ IF P1 .NES. "?" THEN GOTO NoHelp
$ TYPE sys$input

Supported TCP/IP-Implementations
-CMU tek TCP/IP			-Multinet TCP/IP
-UCX (DEC)			-Process Software (TCPware)
-Wollongong TCP/IP

Parameter 'P1' for MAKE:
?       This HELP-page
%       Do not delete object-files after compilation
*	Compile IRC with debugging on (keep object files)

CC/DEF=(<P1>)
 NODCL		Compile with small DCL recallbuffer
 NOMEM		Compile IRC for small memory contents (without Recallbuffer)
 DEBUG		Compile with IRC internal debugging on
 MAXBUF=<num>   Compile with special size of Recallbuffer
 HIST=<num>	Compile with special size of command history buffer

$ EXIT
$NoHelp:
$!------------------------------------------------------------------------------
$ Message = F$ENVIRONMENT("MESSAGE")
$ SET MESSAGE/NOTEXT/NOSEVERITY/NOIDENTIFICATION/NOFACILITY
$ cmu := "***"
$ win := "***"
$ ucx := "***"
$ psc := "***"
$ keep := "YES"
$ cmu = F$GETDVI("IP0:","DEVNAM")
$ win = F$GETDVI("INET0:","DEVNAM")
$ ucx = F$GETDVI("BG0:","DEVNAM")
$ psc = F$GETDVI("TCP0:","DEVNAM")
$ multinet = F$LENGTH(F$TRNLNM("MULTINET_ROOT","LNM$SYSTEM"))
$ SET MESSAGE'Message'
$!------------------------------------------------------------------------------
$ Transport="***"
$ IF cmu .NES. "***" THEN Transport="CMU"
$ IF win .NES. "***" THEN Transport="WIN"
$ IF ucx .NES. "***" THEN Transport="UCX"
$ IF psc .NES. "***" THEN Transport="PSC"
$ IF multinet .EQ. 0 THEN GOTO NoMultinet
$   DEFINE/NOLOG VAXC$INCLUDE multinet_root:[multinet.include],sys$library
$   DEFINE/NOLOG VMS multinet_root:[multinet.include.vms]
$   DEFINE/NOLOG ARPA multinet_root:[multinet.include.arpa]
$   Transport=Transport+",MULTINET"
$   IF (ucx .EQS. "***") .OR. (win .EQS. "***") THEN GOTO NoMultinet
$Nochmal:
$   INQUIRE/NOPUNCT flag "You use Multinet TCP/IP with which Transport ? [WIN/UCX]"
$   IF (flag .NES. "WIN") .AND. (flag .NES. "UCX") THEN GOTO Nochmal
$   IF (FLAG .EQS. "WIN") THEN UCX := "***"
$   IF (FLAG .EQS. "UCX") THEN WIN := "***"
$   Transport="''flag',MULTINET"
$NoMultinet:
$ IF (Transport .EQS. "***")! .OR. ((Transport.NES."CMU").AND.(P1.EQS."MINI"))
$ THEN
$   TYPE sys$input

You do not have CMU, UCX, Wollongong, Process Software or Multinet TCP/UP...

So there is no IRC available!

$   EXIT 8308
$ ELSE
$   IF multinet .EQ. 0
$   THEN
$     DEFINE/NOLOG VAXC$INCLUDE twg$tcp:[netdist.include],sys$library
$     DEFINE/NOLOG VMS twg$tcp:[netdist.include.vms]
$     DEFINE/NOLOG ARPA twg$tcp:[netdist.include.arpa]
$   ENDIF
$   WRITE sys$output "Creating IRC for ''Transport' TCP/IP ..."
$ ENDIF
$ Exe="IRC.EXE"
$!------------------------------------------------------------------------------
$ IF P1 .NES. "*" THEN GOTO NoStar
$   WRITE sys$output "Compiling debugger version of IRC ..."
$   Keep="YES"
$   IF P2 .EQS. ""
$   THEN
$!     P1="DEBUG"
$     P1=""
$   ELSE
$!     P1="DEBUG,"+P2
$     P1=+P2
$   ENDIF
$   Qual1="/NOOPT/DEBUG"
$   Qual2="/DEBUG/TRACE"
$   Exe="I.EXE"
$NoStar:
$!------------------------------------------------------------------------------
$ IF P1 .NES. "%" THEN GOTO NoPercent
$   P1=P2
$   Keep="YES"
$NoPercent:
$ IF P1 .NES. "" THEN P1 = "/DEF=(''P1',''Transport')"
$ IF P1 .EQS. "" THEN P1 = "/DEF=(''Transport')"
$!------------------------------------------------------------------------------
$ WRITE sys$output "Compiling all five parts of IRC [''P1']"
$ CALL CompileIt ANALYZE 'P1' 'Qual1'
$ CALL CompileIt ASYNC   'P1' 'Qual1'
$ CALL CompileIt COMMAND 'P1' 'Qual1'
$ CALL CompileIt IRC     'P1' 'Qual1'
$ CALL CompileIt MISC    'P1' 'Qual1'
$ CALL CompileIt RECALL  'P1' 'Qual1'
$ DEFINE/NOLOG lnk$library sys$library:vaxccurse
$!------------------------------------------------------------------------------
$! sys$library:neterror is optional (only for error message texts)
$!------------------------------------------------------------------------------
$ WRITE sys$output "Linking ''Exe' ..."
$ LFile := ""
$ IF F$SEARCH("sys$library:neterror.obj") .NES. "" THEN -
			LFile := ",sys$library:neterror.obj"
$!------------------------------------------------------------------------------
$ IF ucx .EQS. "***" THEN GOTO NoUCX
$ IF multinet .EQ. 0
$ THEN
$ LINK/EXE='Exe''Qual2' irc.obj,async.obj,analyze.obj, misc.obj, -
					command.obj,recall.obj'LFile', -
					sys$input/OPT
sys$library:vaxcrtl/SHARE,sys$library:ucx$ipc/LIBRARY
$ ELSE
$ LINK/EXE='Exe''Qual2' irc.obj,async.obj,analyze.obj, misc.obj, -
					command.obj,recall.obj'LFile', -
					sys$input/OPT
sys$library:vaxcrtl/SHARE,sys$library:ucx$ipc/LIBRARY,multinet:multinet_socket_library/SHARE
$ ENDIF
$ GOTO LinkReady
$!------------------------------------------------------------------------------
$NoUCX:
$ IF psc .EQS. "***" THEN GOTO NoPSC
$ LINK/EXE='Exe''Qual2' irc.obj,async.obj,analyze.obj, misc.obj, -
					command.obj,recall.obj'LFile', -
					sys$input/OPT
sys$library:vaxcrtl/SHARE,tcpip_root:socklib/LIBRARY
$ GOTO LinkReady
$!------------------------------------------------------------------------------
$NoPSC:
$ IF win .EQS. "***" THEN GOTO NoWIN
$ IF multinet .GT. 0 THEN GOTO NoWIN
$ LINK/EXE='Exe''Qual2' irc.obj,async.obj,analyze.obj, misc.obj, -
					command.obj,recall.obj'LFile', -
					sys$input/OPT
sys$library:vaxcrtl/SHARE,twg$tcp:[netdist.lib]twglib/LIBRARY
$ GOTO LinkReady
$!------------------------------------------------------------------------------
$NoWIN:
$ IF multinet .EQ. 0
$ THEN
$ LINK/EXE='Exe''Qual2' irc.obj,async.obj,analyze.obj, misc.obj, -
					command.obj,recall.obj'LFile', -
					sys$input/OPT
sys$library:vaxcrtl/SHARE
$ ELSE
$ LINK/EXE='Exe''Qual2' irc.obj,async.obj,analyze.obj, misc.obj, -
					command.obj,recall.obj'LFile', -
					sys$input/OPT
sys$library:vaxcrtl/SHARE,multinet:multinet_socket_library/SHARE
$ ENDIF
$!------------------------------------------------------------------------------
$LinkReady:
$ PURGE/NOLOG 'Exe'
$ PURGE/NOLOG environment.h
$ IF Keep .NES. "YES"
$ THEN
$   DELETE/NOCONF *.obj;*
$ ELSE
$   PURGE/NOLOG *.obj
$ ENDIF
$ EXIT
$!
$!
$!
$!------------------------------------------------------------------------------
$! CALL CompileIt <File> <Definitions> <Debug-Qualifier>
$!------------------------------------------------------------------------------
$CompileIt:
$ SUBROUTINE
$   Source = F$CVTIME(F$FILE_ATTR("''P1'.C","CDT"))
$   IF F$SEARCH("''P1'.OBJ") .EQS. "" THEN GOTO DoObject
$   Object = F$CVTIME(F$FILE_ATTR("''P1'.OBJ","CDT"))
$   Header = F$CVTIME(F$FILE_ATTR("HEADER.H","CDT"))
$   IF Source .LTS. Header THEN GOTO DoObject1
$   IF Source .LTS. Object THEN GOTO NoObject
$   GOTO DoObject
$DoObject1:
$   COPY/NOCONF/NOLOG 'P1'.c 'P1'.c
$   PURGE/NOLOG 'P1'.c
$DoObject:
$   WRITE sys$output "...compiling ''P1'"
$   CC/NODEBUG'P3' 'P1'.C 'P2
$   GOTO EndSub
$NoObject:
$   WRITE sys$output "...allready uptodate ''P1'"
$EndSub:
$ EXIT
$ ENDSUBROUTINE
