/* Miscelaneous functions */

#include <stdio.h>
#include <strdef.h>
#include "header.h"
#include "misc.h"
#include "environment.h"

static int total_explicit;

/* strimw: Case-insensative wildcard matching.
 *
 * Parameters:
 *	str1 is a pointer to the string (possibly) with wildcards.
 *	str2 is a pointer to a string to be compared to str1.
 *
 * Returned: 1 if str2 matches str1
 *           0 otherwise
 */
bool strimw(char *str1, char *str2)
{
char *ptr1, *ptr2;
bool retval;

    ptr1 = malloc(strlen(str1)+1);
    ptr2 = malloc(strlen(str2)+1);
    strcpy(ptr1,str1); strcpy (ptr2,str2);
    str$upcase(c$dsc(ptr1),c$dsc(str1));
    str$upcase(c$dsc(ptr2),c$dsc(str2));
    if (str$match_wild(c$dsc(ptr2),c$dsc(ptr1)) == STR$_MATCH)
	retval = 1;
    else retval = 0;
    free(ptr1); free(ptr2);
    return(retval);
}

/*
 * list_insert: Insert a new element into a list.
 *
 * Parameters: "list" which is a pointer to a list.. "new"
 * which is a pre-allocated element to be added to the list.  
 */
void list_insert(list, new)
List **list;
List *new;
{
    if (*list != NULL)
	{
	new->next = *list;
	*list = new;
	}
    else
	{
	*list = new;
	new->next = NULL;
	}
}


/*
 * list_find: This looks up the given name in the given list.  List and
 * name are as described above.  If wild is true, each name in the list is
 * used as a wild card expression to match name... otherwise, normal matching
 * is done 
 */
List *list_find(list, name, wild)
List *list;
char *name;
int wild;
{
    List *tmp;
    int best_match, current_match;

    best_match=0;
    if (wild) {
	List *match = (List *)NULL;

	for (tmp = list; tmp; tmp = tmp->next) {
	    if ((current_match=wild_match(tmp->name, name))>best_match)
	    {
		match = tmp;
		best_match=current_match;
	    }
	}
	return (match);
    } else {
	for (tmp = list; tmp; tmp = tmp->next) {
	    if (stricmp(tmp->name, name) == 0)
		return (tmp);
	}
    }
    return ((List *)NULL);
}

/*
 * list_remove: this removes the given name from the given list (again as
 * described above).  If found, it is removed from the list and returned
 * (memory is not deallocated).  If not found, null is returned. 
 */
List *list_remove(list, name)
List **list;
char *name;
{
    List *tmp, *prev;

    for (tmp = *list, prev = *list; tmp; tmp = tmp->next) {
	if (stricmp(tmp->name, name) == 0) {
	    prev->next = tmp->next;
	    if ((tmp == *list) && (tmp->next == NULL)) *list = NULL;
	    else if (tmp == *list) *list = tmp->next;
	    return (tmp);
	    }
	prev = tmp;
    }
    return ((List *)NULL);
}

/*
 * list_lookup: this routine just consolidates list_remove and
 * list_find.  I did this cause it fit better with some alread existing
 * code 
 */
List *list_lookup(list, name, wild, delete)
List *list;
char *name;
int wild;
int delete;
{
    List *tmp;

    if (delete)
	tmp = list_remove(list, name);
    else
	tmp = list_find(list, name, wild);
    return (tmp);
}

/*
 * parse_it: parse the next valid expression from the given string.  Because
 * we have terrible trivial expressions (either a series of characters or an
 * asterisk) this is a damn easy thing to do.  If a wild card is found, the
 * function value is null, otherwise, it is the next series of characters to
 * be matched.  An asterisk preceeded by a backslash is considered quoted and
 * treated as a character rather than an asterisk 
 */
static char *parse_it(str, space)
char *str;
char *space;
{
    char *ptr,
        *start;

    if (*str == '*') {
	strcpy(str, str + 1);
	return ((char *)NULL);
    }
    ptr = space;
    start = str;
    *space = (char)NULL;
    while (*str) {
	if (*str == '\\')
	    str++;
	else if (*str == '*')
	    break;
	total_explicit++;
	*(ptr++) = *(str++);
    }
    *ptr = (char)NULL;
    strcpy(start, str);
    return (space);
}
    
/*
 * wild_match: matches the expression 'match' which may contain wildcards,
 * with the str.  Returns 1 on match, 0 otherwise 
 */
int old_wild_match(match, str)
char *match,
    *str;
{
    char *ptr,
        *match_str = (char *)NULL,
        *space;
    int len;

    if ((match == (char *)NULL) || (str == (char *)NULL))
	return (0);
    space = (char *) malloc(strlen(match) + 1);	/* never need more than
    match_str = (char *) malloc(strlen(match) + 1);	* this */
    strcpy(match_str, match);
    while (strlen(match_str)) {
	if (ptr = parse_it(match_str, space)) {
	    len = strlen(ptr);
	    if (strncmp(ptr, str, len)) {
		new_free(&space);
		new_free(&match_str);
		return (0);
	    }
	    str += len;
	} else {
	    while ((ptr = parse_it(match_str, space)) == (char *)NULL);
	    if ((len = strlen(ptr)) == 0) {
		new_free(&space);
		new_free(&match_str);
		return (1);
	    }
	    while (1) {
		if (strncmp(ptr, str, len) == 0) {
		    if (old_wild_match(match_str, str + len)) {
			new_free(&match_str);
			new_free(&space);
			return (1);
		    }
		    str++;
		} else {
		    if (*(str++) == (char)NULL) {
			new_free(&match_str);
			new_free(&space);
			return (0);
		    }
		}
	    }
	}
    }
/* No path exists to these statements... says my optimizer...*/
    new_free(&match_str);
    new_free(&space);
    if (strlen(str))
	return (0);
    else
	return (1);
}

/* This version of wild_match returns 1 + the  count  of characters
 * explicitly matched if a match occurs. That way we can look for
 * the best match in a list
 */
int wild_match(match, str)
{
    total_explicit=0;
    if (old_wild_match(match, str))
	return total_explicit+1;
    else
	return 0;
}

/*
 * enqueue: Insert a new element into a queue.
 *
 * Parameters: "queue" which is a pointer to a structure containing
 * pointers to the first and last entries in the queue. "new"
 * which is a pre-allocated element to be added to the queue.  
 */
void enqueue(queue, new)
Queue *queue;
QElt *new;
{
    QElt *tmp;

    tmp = queue->last;
    if (tmp != NULL)
	{
	tmp->next = new;
	queue->last = new;
	new->next = NULL;
	}
    else
	{
	queue->last = new;
	queue->first = new;
	new->next = NULL;
	}
}


/*
 * queue_find: This looks up the given name in the given queue. Queue and
 * name are as described above.  If wild is true, each name in the queue is
 * used as a wild card expression to match name... otherwise, normal matching
 * is done 
 */
QElt *queue_find(queue, name, wild)
Queue *queue;
char *name;
int wild;
{
    QElt *tmp;
    int best_match, current_match;

    best_match=0;
    if (wild) {
	QElt *match = (QElt *)NULL;

	for (tmp = queue->first; tmp; tmp = tmp->next) {
	    if ((current_match=wild_match(tmp->name, name))>best_match)
	    {
		match = tmp;
		best_match=current_match;
	    }
	}
	return (match);
    } else {
	for (tmp = queue->first; tmp; tmp = tmp->next) {
	    if (stricmp(tmp->name, name) == 0)
		return (tmp);
	}
    }
    return ((QElt *)NULL);
}

/*
 * dequeue: this removes the given name from the given queue (again as
 * described above).  If found, it is removed from the queue and returned
 * (memory is not deallocated).  If not found, null is returned. 
 */
QElt *dequeue(queue, name)
Queue *queue;
char *name;
{
    QElt *tmp, *prev;

    for (tmp = queue->first, prev = NULL; tmp; tmp = tmp->next) {
	if (stricmp(tmp->name, name) == 0) {
	    if (tmp == queue->first) queue->first = tmp->next;
	    else prev->next = tmp->next;
	    if (tmp == queue->last) queue->last = prev;
	    return (tmp);
	    }
	prev = tmp;
    }
    return ((QElt *)NULL);
}
