/******************************************************************************

                       VMS - IRC - Client   part RECALL

 Internet Relay Chat - Client for VAX/VMS V5.x with VT-Terminals using
                       CMU/tek, UCX, Wollongong or Multinet TCP/IP

 Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG

 Modified for IRC 2.7 by GrayElf, paul@coombs.anu.edu.au

 ******************************************************************************/

#include <stdio.h>
#include <string.h>
#include "header.h"
#include "environment.h"

extern putchunk(),putwin(),qio_send(),stricmp(),c$dsc(),c$cks(),win_refresh();

/******************************************************************************/

msg_refresh()
{
  int i;

/*  for(i=0;i<channels;i++) wrefresh(channel[i].window); */
  wrefresh(dispwindow);
}

/******************************************************************************/

msg_touch()
{
  int i;

  for(i=0;i<channels;i++) touchwin(dispwindow);
}

/******************************************************************************/

create_status()
{
  int count,txtlen;
  char txt1[256],txt2[256],*p,*copy;

  if(status_line) {
    sprintf(txt1," VMS IRC %-10s(%s) %c%s %-10s",VMSVERSION,edit_mode?"OWR":"INS"
               ,cmdch[0]?cmdch[0]:' ',away_flag?"AWAY":"HELP",my_nick);
    txtlen=COLS-strlen(txt1)-5;
    if (query_max) {
      strcpy(txt2,"==>");
      for(count=0;count<query_max;count++)
        if (strlen(txt2)+strlen(query_ptr[count])+1<txtlen) {
          if (count) strcat(txt2,",");
          strcat(txt2,query_ptr[count]);
        } else if (count+1==query_max) strcat(txt2,"...");
      strcat(txt1,txt2);
    } else {
      strcpy(txt2,"Channel ");
      p=channel[0].name; copy=strchr(txt2,'\0');
      while (*p && p-channel[0].name<txtlen-9) *copy++ = *p++;
      if (*p) *(copy-1) ='*';
      *copy='\0';
      if (!strcmp(channel[0].name,"0")) strcpy(txt2,"Nowhere Channel");
      strcat(txt1,txt2);
    }
    strcat(txt1,spc); txt1[COLS-5]='\0';
    wmove(statwin,0,0); wprintw(statwin,txt1);
    wrefresh(statwin); wrefresh(inpwin);
  }
}

/******************************************************************************/

char *reverse(src)
char *src;
{
  char *p=src,*q=src+strlen(src);
  while (p<q) {char h= *p; *p++ = *--q; *q=h; }
  return(src);
}

/******************************************************************************/

char *rot13(src)
char *src;
{
  char *p=src;
  while (*p) {
    *p = ('a' <= *p && *p <= 'm') || ('A' <= *p && *p <= 'M') ? *p+13 :
         ('n' <= *p && *p <= 'z') || ('N' <= *p && *p <= 'Z') ? *p-13 : *p;
    p++; }
  return(src);
}

/******************************************************************************/

recall_display(start,size,flag)
int start,size,flag;
{
  char *ilp,cmd[MAXNETLEN];
  int cnt,i,j,anf,end;

  anf=(recall_num>recall_start && recall_start!= -1)?recall_start:recall_num;
  end=(recall_num>recall_start)?recall_num:recall_start;
  cnt=0; while (recpos[cnt+1]<=start) cnt++;
  i=0;
  if (recpos[cnt]<start) {
    strcpy(ilp=cmd,recbuf[cnt]);
    if (flag==1) rot13(ilp);
    if (flag==2) reverse(ilp);
    ilp+=COLS*(i=start-recpos[cnt++]);
    if ((anf<recpos[cnt] || end<recpos[cnt]) && !flag) wsetattr(tmpwin,_UNDERLINE);
    putwin(tmpwin,size,COLS,ilp,FALSE,FALSE); wclrattr(tmpwin,_UNDERLINE);
  }
  while (i<size && *recbuf[cnt]) {
    strcpy(ilp=cmd,recbuf[cnt++]);
    if (flag==1) rot13(ilp);
    if (flag==2) reverse(ilp);
    j=i; i+=(strlen(ilp)+COLS-1)/COLS;
    if (i>size) *(ilp+(size-j)*COLS)='\0';
    if (anf<=recpos[cnt-1] && recpos[cnt-1]<=end && !flag) wsetattr(tmpwin,_UNDERLINE);
    putwin(tmpwin,LINES>>1,COLS,ilp,FALSE,FALSE); wclrattr(tmpwin,_UNDERLINE);
  }
  wrefresh(tmpwin); wrefresh(inpwin);
}

/******************************************************************************/

recall_move(delta)
int delta;
{
  int i,anf;

  i=0; while (*recbuf[i]) i++;
  recall_num+=delta;
  if (recall_num<0) recall_num=0;
  else if (recall_num>recpos[i]-1) recall_num=recpos[i-1];
  else {
    anf=1; while (recpos[anf]<=recall_num) anf++;
    recall_num=recpos[(anf!=i && delta>0 && recall_num!=recpos[anf-1])?anf:anf-1];
  }
  if (recpos[i]<=(LINES>>1)) { anf=0; wclear(tmpwin); }
  else if (recall_num<=(LINES>>2)) anf=0;
  else if (recpos[i]-recall_num<=(LINES>>2)) anf=recpos[i]-(LINES>>1);
  else anf=recall_num-(LINES>>2);
  recall_display(anf,LINES>>1,0);
}

/******************************************************************************/

recall_output(start,finish)
int start,finish;
{
  int i;
  char ol[MAXNETLEN],t[80],*ptr,ibuf[MAXINPLEN];
  bool flag=TRUE;

  strcpy(ibuf,inpline);
  i=0; while (start!=recpos[i]) i++;
  while (flag) {
    ptr=recbuf[i];
    while (strlen(ptr)) {
      if (strlen(ptr)>70) { strncpy(t,ptr,70); t[70]='\0'; ptr+=70; }
      else { strcpy(t,ptr); ptr+=strlen(ptr); }
      do_msg(0,t); inpline[inpx++]=13; inpline[inpx++]=10; inpline[inpx]=0;
      qio_send(inpline);
    }
    i++; if (finish==recpos[i-1]) flag=FALSE;
  }
  strcpy(inpline,ibuf); inpx=strlen(inpline);
}

/******************************************************************************/

do_recall(flag,ptr)
int flag;
char *ptr;
{
  int cnt,i,size,mode;

  mode=0;
  if (*ptr && !flag) {
    if (!stricmp(ptr,"msg")) mode=1;
    if (!stricmp(ptr,"dcl")) mode=2;
  } else mode=1;

  if (LINES<8 || mode==0) {
    if (LINES<8)
      putchunk("*** Huh? This window is to small for RECALL/REDRAW channels...",FALSE);
    else
      putchunk("*** Error: Wrong parameter for RECALL given...",FALSE);
   } else {
    for (i=0;i<(mode==1?MAXSAVMSG:MAXDCLMSG);i++) recpos[i]=0;
    if (mode==1) {
      i=0; cnt=savptr; while(!*savbuf[cnt]) cnt=ringplus(cnt,MAXSAVMSG);
      strcpy(recbuf[i++],savbuf[cnt]); cnt=ringplus(cnt,MAXSAVMSG);
      while (cnt!=savptr) {
        strcpy(recbuf[i],savbuf[cnt]);
        recpos[i]=recpos[i-1]+(strlen(recbuf[i-1])+COLS-1)/COLS;
        i++; cnt=ringplus(cnt,MAXSAVMSG);
      }
    } else {
      i=0; cnt=dclptr; while(!*dclbuf[cnt]) cnt=ringplus(cnt,MAXDCLMSG);
      strcpy(recbuf[i++],dclbuf[cnt]); cnt=ringplus(cnt,MAXDCLMSG);
      while (cnt!=dclptr) {
        strcpy(recbuf[i],dclbuf[cnt]);
        recpos[i]=recpos[i-1]+(strlen(recbuf[i-1])+COLS-1)/COLS;
        i++; cnt=ringplus(cnt,MAXDCLMSG);
      }
    }

    recbuf[i][0]='\0'; recpos[i]=recpos[i-1]+(strlen(recbuf[i-1])+COLS-1)/COLS;
    recall_num=recpos[i-1]; size=(LINES>>1);
    tmpwin=newwin(LINES>>1,COLS,0,0); wsetattr(tmpwin,_REVERSE); wclear(tmpwin);
    recall_display(recpos[i]-size,size,flag);
    recall_mode= !flag;
  }
}

/******************************************************************************/

do_keypad_help()
{
  if (COLS<(recall_mode?52:59) || LINES<(recall_mode?12:15))
    putchunk("*** My, whadda cute little window we have here. Sorry, no HELP for dwarves...",FALSE);
  else {
    if (recall_mode) {
      t2win=newwin(12,52,(LINES-11)>>1,(COLS-52)>>1);
      wsetattr(t2win,bold_flag?_REVERSE|_BOLD:_REVERSE);
      wclear(t2win); wmove(t2win,0,0);
      wprintw(t2win," RECALL Help for VMS IRC Client %s\n\n",VMSVERSION);
      wprintw(t2win," PrevScr or P  Move to the previous page\n");
      wprintw(t2win," NextScr or L  Move to the next page\n");
      wprintw(t2win," Crsr Up/Down  Move one line up/down\n");
      wprintw(t2win," Select or S   Select buffer for pasting\n");
      wprintw(t2win," SPACE         Send actual line to channel\n");
      wprintw(t2win," Return        Send selected buffer and exit RECALL\n");
      wprintw(t2win," Ctrl-Z        Exit RECALL without pasting\n");
      wprintw(t2win," Ctrl-L,Ctrl-W Redraw screen\n");
      wprintw(t2win," Ctrl-R        Recall help\n");
      wprintw(t2win," Ctrl-B        Toggle broadcast window\n");
      wrefresh(t2win); wrefresh(inpwin);
    } else {
      tmpwin=newwin(15,59,(LINES-15)>>1,(COLS-59)>>1);
      wsetattr(tmpwin,bold_flag?_REVERSE|_BOLD:_REVERSE);
      wclear(tmpwin); wmove(tmpwin,0,0);
      wprintw(tmpwin," Keypad HELP for VMS IRC Client %s\n\n",VMSVERSION);
      wprintw(tmpwin," Ctrl-L Redraw screen       |    Ctrl-B Broadcast window\n");
      wprintw(tmpwin," Ctrl-W Redraw screen       |    Ctrl-D DCL window\n");
      wprintw(tmpwin," Ctrl-X Delete line         |    Ctrl-] Recall window\n");
      wprintw(tmpwin," Ctrl-U Delete line         |    Ctrl-R Keypad help window\n");
      wprintw(tmpwin," Ctrl-H Beginning of line   |      HELP Command help\n");
      wprintw(tmpwin," Ctrl-E End of line         |        DO Setup information\n");
      wprintw(tmpwin," Ctrl-K 1 word right        |     ESC D Setup information\n");
      wprintw(tmpwin," Ctrl-J 1 word left         |   KP 0..9 Defined FKey\n");
      wprintw(tmpwin," Ctrl-N Delete word         |  ESC 0..9 Defined FKey\n");
      wprintw(tmpwin," Ctrl-F Erase to EOLN       | GOLD a..z Defined FKey\n");
      wprintw(tmpwin," Ctrl-A Toggle edit mode    | GOLD 0..9 Last PRIVMSG nicks\n");
      wprintw(tmpwin," Ctrl-V Toggle CtrlKey mode |\n");
      wprintw(tmpwin," Ctrl-\\ Flush messages      |         GOLD = Ctrl-@ or PF1\n");
      wrefresh(tmpwin); wrefresh(inpwin);
    }
  }
}

/******************************************************************************/

do_help()
{
  int cnt,height,needed;

  needed=AllCmd-HiddenCmd;
  height=LINES<needed+8?LINES-4:needed+4;
  if (!help_num)
    if (COLS<63 || LINES<10)
      putchunk("*** My, whadda cute little window we have here. Sorry, no HELP for dwarves...",FALSE);
    else {
      tmpwin=newwin(height,63,(LINES-height)>>1,(COLS-63)>>1);
      wsetattr(tmpwin,bold_flag?_REVERSE|_BOLD:_REVERSE);
    }
  if (help_num<AllCmd && inpchar!=26) {
    wclear(tmpwin); wmove(tmpwin,0,0);
    wprintw(tmpwin,"  HELP for VMS IRC Client %s\n\n",VMSVERSION);
    for(cnt=height-2;cnt>0;cnt--) {
      while(!(msgtab[help_num].helptext)) help_num++;
      wprintw(tmpwin,"  %s\n",msgtab[help_num].helptext);
      if (++help_num>=AllCmd) break;
    }
  }
  if (inpchar!=26 && help_num>=AllCmd) {
    wmove(tmpwin,height-2,0);
    wprintw(tmpwin,"  (*) These commands are only available with QUOTE <command>\n");
    wprintw(tmpwin,"  +   Not yet implemented commands... *sorry*");
  }
  if (help_num>=AllCmd) help_num=0;
  if (inpchar==26) {
    delwin(tmpwin); help_num=0; msg_refresh(); tmpwin=NIL;
    if (brdcst_flag) wrefresh(brdcstwin);
    if (clockwin) wrefresh(clockwin);
    if (status_line) wrefresh(statwin);
  } else wrefresh(tmpwin);
  wrefresh(inpwin);
}

/******************************************************************************/

do_flags()
{
  char s[80],tmp[80],tmp2[80],tmp3[20],cmd[10],
       tim[]="17-NOV-1858 00:00:00.00";
  int tim_len,num;

  if (dbopt)      sprintf(s,"DBG $%02x,",(unsigned char) dbopt); else s[0]='\0';
  if (anti_kill)   strcat(s,"Reconnect,");
  if (avenger)     strcat(s,"ReKill,");
  if (away_flag)   strcat(s,"Away,");
  if (signalmode)  strcat(s,"Signal,");
  if (flush_mode)  strcat(s,"Flush,");
  if (query_max)   strcat(s,"Query,");
  if (ignore_max)  strcat(s,"Ignore,");
  if (status_line) strcat(s,"StatLine,");
  if (*s) s[strlen(s)-1]='\0';
  if (COLS<60 || LINES<(*s?15:14))
    putchunk("*** My, whadda cute little window you have. Sorry this client isn't for gnomes.",FALSE);
  else {
    if (leave_time.l2 || leave_time.l1) { c$cks(sys$asctim(&tim_len,c$dsc(tim),&leave_time,NIL)); strcpy(tmp,tim);
    } else strcpy(tmp,"(none)");
    if (*cmdch)  sprintf(cmd,"'%c'",cmdch[0]); else strcpy(cmd,"(none)");
    if (dcl_pid) sprintf(tmp2,"%08X",dcl_pid); else strcpy(tmp2,"(none)");
    num=atoi(channel[0].name);
    if (num==0 && !strcmp(channel[0].name,"0")) strcpy(tmp3,"entry");
    else if (num>=1 && num<=999)                strcpy(tmp3,"public");
    else if (num>=1000)                         strcpy(tmp3,"hidden");
    else if (num<0)                             strcpy(tmp3,"secret");
    else                                        strcpy(tmp3,"named");
    tmpwin=newwin(*s?15:14,60,(LINES-(*s?15:14))>>1,(COLS-60)>>1);
    wsetattr(tmpwin,bold_flag?_REVERSE|_BOLD:_REVERSE);
    wclear(tmpwin); wmove(tmpwin,0,0);
    wprintw(tmpwin," VAX/VMS IRC Client version %s\n\n",VMSVERSION);
    wprintw(tmpwin," Server:   %s (%d)\n",server,srvport);
    wprintw(tmpwin," Nickname: %s\n",*my_nick?my_nick:"(none)");
    wprintw(tmpwin," Channel:  %s [%s channel]\n",channel[0].name,tmp3);
    wsetattr(tmpwin,_UNDERLINE);
    wprintw(tmpwin," Username: %s%s\n",*persname?persname:"(none)",spc);
    wclrattr(tmpwin,_UNDERLINE);
    wprintw(tmpwin," Commandchar:   %-12s ErrMsg's for Log:  %s\n",cmd,errlog_flag?"ignore":"write");
    wprintw(tmpwin," Edit mode:     %-12s ControlKey Input:  %s\n",edit_mode?"overwrite":"insert",ctrl_flag?"'^' <chr>":"direct");
    wprintw(tmpwin," Message mode:  %-12s Visible CtrlCodes: %s\n",bold_flag?"bold":"normal",showesc_flag?"display":"interpret");
    wsetattr(tmpwin,_UNDERLINE);
    wprintw(tmpwin," Kill messages: %-12s Subprocess:        %s%s\n",your_priv?(notice_flag?"short":"full"):"none",tmp2,spc);
    wclrattr(tmpwin,_UNDERLINE);
    wprintw(tmpwin," WorkingDIR: %s\n",dirpath);
    wprintw(tmpwin," BIG font:   %s\n",*fontnam?fontnam:"(none)");
    wprintw(tmpwin," Logfile:    %s\n",*lfilename?lfilename:"(none)");
    wprintw(tmpwin," Alarmclock: %s\n",tmp);
    if (*s) wprintw(tmpwin," %s\n",s);
    wrefresh(tmpwin); wrefresh(inpwin);
  }
}

/******************************************************************************/

do_copyright()
{
  char tmp[256];

  putchunk("***",FALSE);
  sprintf(tmp,"*** This is the VAX/VMS IRC Client version v%s using %s TCP/IP",VMSVERSION,TRANSPORT); putchunk(tmp,FALSE);
  sprintf(tmp,"*** This Client was last modified %s %s",__DATE__,__TIME__); putchunk(tmp,FALSE);
  putchunk("***",FALSE);
  putchunk("*** Copyright 1990 by Very Mad Students, University of Karlsruhe, FRG",FALSE);
  putchunk("*** You may freely distribute this software provided that this copyright",FALSE);
  putchunk("*** notice remains unchanged in all copies.",FALSE);
  putchunk("***",FALSE);
  putchunk("*** This IRC Client was programmed by",FALSE);
  putchunk("*** GrayElf   Paul Williams      paul@coombs.anu.edu.au",FALSE);
  putchunk("*** Uranus    Bernd Onasch       ONASCH@ira.uka.de",FALSE);
  putchunk("*** Andy      Andreas Ley        S_LEY@irav1.ira.uka.de",FALSE);
  putchunk("*** Mike      Michael Pall       S_PALL@irav1.ira.uka.de",FALSE);
  putchunk("***",FALSE);
  putchunk("*** Thanks to all those who helped with bug reports and suggestions.",FALSE);
  putchunk("***",FALSE);
  putchunk("*** Look out for new versions of the famous VMS IRC Client...",FALSE);
  putchunk("***",FALSE);
}

/******************************************************************************/
