.TH xephem 1X
.SH Name
xephem \- an interactive astronomical ephemeris for X
.SH Syntax
\fBxephem\fP
.SH Description
.na
.nh
.PP
.B Xephem
version 2.6
is an interactive astronomical ephemeris program for X Windows systems. 
It computes heliocentric, geocentric and topocentric information for celestial
objects. Xephem has built-in support for all planets; the moons of Jupiter,
Saturn and Earth and Mars' central meridian longitude. Xephem supports objects
in heliocentric or Earth orbit given the appropriate elements. Sample databases
of over 16000 objects are included in the release kit. Xephem generates data in
configurable tabular forms and in several detailed graphical formats.  Xephem
can plot and list all data fields and can be programmed to search for arbitrary
circumstances. Xephem can serve as the control point for automated telescopes
and can connect to auxiliary database servers in real-time via named streams
pipes.
.SH Getting Started
.PP
Xephem contains extensive context-sensitive on-line help. Virtually none of
that help is duplicated here so go ahead and run xephem to learn more. In
order for xephem to find this help text the resource `XEphem.HELPFILE' must
be set to the path name of the xephem.hlp file.

When you first run xephem you may hear a beep. This means xephem has added a
message to the message box menu. This menu is not shown by default. Whether the
message box is displayed may be toggled by using the
.I Messages
entry in the File pulldown menu off the Main menu.
Whether xephem beeps when it adds a message may be toggled using the
.I Message Bell
option in the Preferences pulldown menu.
.SH Quick Menu Tour
.PP
The
.I Help
pulldown at the top right of the main menu provides access to several
categories of assistance applicable to the overall operation of
.B xephem.
Those unfamiliar with
.B xephem
might begin by reading the 
.I Introduction
help section first and reading the additional help information in the
order in which it is listed in the pulldown.

If little or no help appears to be available, the resource XEphem.HELPFILE
is not set properly. It should point to the xephem.hlp file.

The
.I Main menu
of
.B xephem
provides control and display of three basic services: observing circumstances,
looping, and access to additional displays.

Observing circumstances includes location, time and atmospheric conditions
(used for the refraction model). Looping refers to the ability to set up
.B xephem
so that it automatically increments time at a desired step size and rate.

Additional displays provide all of the tabular and graphical information
available, and always refer to the circumstances defined in the main menu.
These additional displays are activated from the 
.I Views
pulldown.

.B Xephem
has information about the Solar system built in and can be accessed without the
need to access an external database. 
.B Xephem
can read files of additional objects into memory as well. Database files
are read in using the
.I Data Base
button in the
.I Objects
pulldown or via the DBFIFO fifo (see the Help for the Data Base menu for more
details on formats and the fifo). All of the information about each object in
memory may be inspected and manipulated in detail and assigned to so-called
`user defined objects' X and Y using the
.I ObjX/Y
button in the same pulldown.

All of the data that 
.B xephem
presents in numeric form may be written to a file and later plotted; written
to a file as a tabular listing; or used to formulate an arbitrary
mathematical expression that may be solved for a maximum, minimum or zero.
These facilities are accessed from the
.I Control
pulldown.

Several options related to performance and display formatting may be controlled
from the
.I Preferences
pulldown.

The
.I Files
pulldown in the main menu allows one to reset the main menu from the initial
resource settings; toggle whether the general messages menu is displayed; and
quit the program.
.SH Resources
.PP
Xephem has many resources, some of which you will soon want to tune to your
taste and circumstances; many others may be left unchanged. Look through the
XEphem.ad distribution for full details. If no resources are available
xephem contains internal fallback resources that are suitable for a
black-and-white X terminal.

Of course, in addition to all the custom resources, xephem supports
the usual Xt command line arguments such as -display, -xrm, -synchronous, -fg
and -bg.

The application class of xephem is XEphem.

A list of widgets in xephem would be enormous. If you really want such
a list, build xephem for X11R5 and use the editres feature. The necessary
code is in xephem.c surrounded by #ifdef WANT_EDITRES.
.SH Time zones
.PP
If __STDC__ was defined by the compiler when xephem was compiled and at runtime
the gmtime() ANSI C function returns non-NULL, then xephem will attempt to
support time zone control. The time zone name and offset is obtained from the
operating system whenever the "Now" option is used from the various Main menu
time fields or resources or at each time step if Auto Time Zone mode is in
effect. Otherwise, xephem never attempts to automatically change the
time zone name or offset. In any case, the time zone offset and name may always
be set manually at any time from the Main menu, or they may be initialized from
the XEphem.TZName and XEphem.TZone resources, respectively.
.SH Files and Fifos
.PP
Xephem can use and create several files and communicate via several fifos. The
following table lists the name of the defining resource, the default value and
a short description of each. Full details for each may be found in the
appropriate run-time Help available from within xephem. The initial default
settings define everything to be in the current directory. Many file names may
begin with tilde (~) to refer to the user's HOME directory.
.na
.nf

X Resource Name                 Default         Usage
---------------                 -------         -----
XEphem*List*Filename.value      ephem.lst       Listing file
XEphem*Plot*Filename.value      ephem.plt       Plot file
XEphem.DBFIFO                   xephem_db_fifo  auto database input
XEphem.DBdirectory		.		database directory
XEphem.DBinitialFiles:		basic.edb	db files auto loaded
XEphem.DBpattern		*.edb		datebase file pattern
XEphem.HELPFILE                 xephem.hlp      Help text
XEphem.SITESFILE                xephem_sites    Earth view sites
XEphem.SKYINFIFO                xephem_in_fifo  Sky View aim input
XEphem.SKYLOCFIFO               xephem_loc_fifo Sky View Button2 report
XEphem.SKYOUTFIFO               xephem_out_fifo Sky View re-aim output
.SH Author
.PP
Elwood Downey, ecdowney@noao.edu. Although they graciously provide me with
email and other services, neither I nor xephem are associated in any way with
the National Optical Astronomical Observatory.
.SH References
.PP
.B Ephem
is the ancestor of xephem. It is suitable for "dumb" 24x80 character displays,
including VMS and DOS as well as UNIX.
The latest version may be found on iraf.noao.edu in contrib/xephem.
.PP
.B Xephem
is maintained on iraf.noao.edu in contrib/xephem. Source code, the SAO catalog
and several sample executables are available.
.PP
The online Help entry
.I on Credits
lists some of the texts, individuals and organizations that have contributed to
xephem.
.PP
The xephem distribution kit includes an awk script to convert from NASA
"2-line" earth satellite format to the form required by the xephem database.
This script is called
.I nasa2edb.awk
and should be available wherever you find xephem. Also included is a sample
script to convert the comet postings from John Jost to xephem format,
jost2edb.nawk. Encke2edb.nawk is one which converts the elements found on
http://encke.jpl.nasa.gov.
