$! Analyze Map on Alpha Architecture
$!
$ SAY := "WRITE_ SYS$OUTPUT"
$ IF P2 .EQS. "QUIET" THEN SAY := "!"
$ 
$ IF F$SEARCH("''P1'") .NES. "" THEN GOTO DOIT
$ TYPE_/NOPAGE SYS$INPUT:
  USAGE: ANALYZE_MAP <file> [opt]
         where  <file> should be an existing File
                [opt]  = 'quiet' suppresses any Messages
$ EXIT
$
$ DOIT:
$
$ NAME = F$PARSE(P1,,,"DEVICE")+F$PARSE(P1,,,"DIRECTORY")+F$PARSE(P1,,,"NAME")
$ SAY ""
$ SAY "[1m  Analyze_Map[m  Version 1.1 (Johannes Plass)"
$ SAY "  searching ''P1' for shared Read/Write Data"
$ SEARCH_/NOHIGH/WINDOW=(0,0) 'P1' "NOPIC,OVR,REL,GBL,  SHR,NOEXE,  WRT,NOVEC"/OUT='NAME.PSECT_TMP
$
$ OPEN_/READ IN 'NAME.PSECT_TMP
$ OPEN_/WRITE OUTA 'NAME.UNIVERSAL_PSECT_Alpha
$ OPEN_/WRITE OUTB 'NAME.PSECT_Alpha
$
$ WRITE_ OUTA "!"
$ WRITE_ OUTA "! ### PSECT Symbol Vectors for ''P1'"
$ WRITE_ OUTA "!" 
$ WRITE_ OUTB "!"
$ WRITE_ OUTB "! ### PSECT Attr for ''P1'"
$ WRITE_ OUTB "!" 
$ LAST = ""
$ LOOP_PSECT:
$    READ_/END=EOF_PSECT IN REC
$    J = F$LOCATE(" ",REC)
$    S = F$EXTRACT(0,J,REC)
$    IF S .EQS. LAST THEN GOTO LOOP_PSECT
$    WRITE_ OUTA "symbol_vector = (" +  S + " = PSECT)"
$    WRITE_ OUTB "psect_attr    =  " +  S + " , NOSHR"
$    LAST = S
$    GOTO LOOP_PSECT
$
$ EOF_PSECT:
$    CLOSE_ IN
$    CLOSE_ OUTA 
$    CLOSE_ OUTB 
$    DELETE_/NOLOG/NOCONFIRM 'NAME.PSECT_TMP;*
$
$ SAY "  searching ''P1' for Universal Functions"
$ SEARCH_/NOHIGH/WINDOW=(0,0) 'P1' " R-"/OUT='NAME.UNIVERSAL_TMP
$
$ OPEN_/READ IN 'NAME.UNIVERSAL_TMP
$ OPEN_/WRITE OUT 'NAME.UNIVERSAL_Alpha
$ WRITE_ OUT "!"
$ WRITE_ OUT "! ### UNIVERSAL Declarations for ''P1'"
$ WRITE_ OUT "!" 
$
$ LOOP_UNIVERSAL:
$    READ_/END=EOF_UNIVERSAL IN REC
$    J = F$LOCATE(" R-",REC)
$    S = "symbol_vector = ("+F$EXTRACT(J+3,F$length(rec),REC)+"	= PROCEDURE)"
$    WRITE_ OUT S
$    GOTO LOOP_UNIVERSAL
$
$ EOF_UNIVERSAL:
$    CLOSE_ IN
$    CLOSE_ OUT
$    DELETE_/NOLOG/NOCONFIRM 'NAME.UNIVERSAL_TMP;*
$
$ SAY ""
$ EXIT_ 
