/*
 * options.c
 * Copyright (C) 1995  Johannes Plass
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes-Gutenberg University, Mainz, Germany
 * Internet: plass@dipmza.physik.uni-mainz.de
*/

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/

#include "config.h"

#include <stdio.h>

/*
#define MESSAGES
#define MESSAGE_NO_ESC
*/
#include "message.h"

#ifdef VMS
#   include <X11_DIRECTORY/IntrinsicP.h>
#   include <X11_DIRECTORY/StringDefs.h>
#   include <XAW_DIRECTORY/Box.h>
#   include <XAW_DIRECTORY/Command.h>
#   if defined(USE_XAW3D) && defined(USE_FORM3D)
#      ifdef _FORM3D_LOCAL_
#         include "Form3d.h"
#      else
#         include <XAW_DIRECTORY/Form3d.h>
#      endif
#   else
#      include <XAW_DIRECTORY/Form.h>
#   endif
#   include <XAW_DIRECTORY/Label.h>
#   include <XAW_DIRECTORY/Toggle.h>
#   include <XAW_DIRECTORY/AsciiText.h>
#   include <X11_DIRECTORY/Shell.h>
#   ifdef _LAYOUT_LOCAL_
#      include "Layout.h"
#   else
#      include <XAW_DIRECTORY/Layout.h>
#   endif
#   define unlink remove
#else
#   include <X11/IntrinsicP.h>
#   include <X11/StringDefs.h>
#   include <X11/Xaw/Box.h>
#   include <X11/Xaw/Command.h>
#   if defined(USE_XAW3D) && defined(USE_FORM3D)
#      ifdef _FORM3D_LOCAL_
#         include "Form3d.h"
#      else
#         include <X11/Xaw/Form3d.h>
#      endif
#   else
#      include <X11/Xaw/Form.h>
#   endif
#   include <X11/Xaw/Label.h>
#   include <X11/Xaw/Toggle.h>
#   include <X11/Xaw/AsciiText.h>
#   include <X11/Shell.h>
#endif

#include "popup.h"

#ifndef max
#   define max(a, b)    ((a) > (b) ? (a) : (b))
#endif

/*### Application dependencies ##############################################*/

#define  OPTIONS_TOPLEVEL 	toplevel	/* the Apllication Shell   */
#define  OPTIONS_APPLIC_CONTEXT app_con		/* the Apllication Context */
#define  OPTIONS_POPUP_NAME	"optionPopup"
#define  OPTIONS_POPUP		optionpopup
#include "gv.h"
#include "options.h"
#include "note.h"
#include "texttr.h"

#define MESSAGE_STRING_LEN 512
#define MAX_RECORD_LENGTH 512
#define MAX_OPTIONS 10

static Widget   optionLayout;
static Widget   doneButton, cancelButton, saveButton;
static Widget   confirmPrintToggle;
static Widget   print_command, scratch_dir,default_save_dir;
static Bool	optionPopupCreated = False;
static Bool	optionPopupVisible = False;

/*###############################################################################
   SaveOptionsToFile(argn,argi,argfi,argi)
   Modify the resource file according to a given array of options.
   Some care is taken to respect the appearance of the resource file.
      argn: number of options to be saved
      argi: argn strings identifying the resources to be modified
      argv: the values given to the resources argi
###############################################################################*/

#   define END_OF_RECORD "\n"

static void
SaveOptionsToFile(argn,argi,argv)
   int  argn;
   char argi[MAX_OPTIONS][MAX_RECORD_LENGTH];
   char argv[MAX_OPTIONS][MAX_RECORD_LENGTH];
{
   FILE *tempfile;
   FILE *infile;
   char line[MAX_RECORD_LENGTH];
   char tempfilename[GV_MAX_FILENAME_LENGTH];
   int  i;
   char *comm, *res;
   char errorMessage[MESSAGE_STRING_LEN];

   BEGINMESSAGE(SaveOptionsToFile)
   if (argn == 0) {INFMESSAGE(nothing to do) return;}
   else --argn;

   if (!gv_user_defaults_file) {
      sprintf(errorMessage,"Save aborted: \nUndefined destination file.");
      NotePopupShowMessage(errorMessage);
      INFMESSAGE(undefined destination file)
      ENDMESSAGE(SaveOptionsToFile)
      return;
   }
   INFSMESSAGE(trying to write to,gv_user_defaults_file)

   infile=fopen(gv_user_defaults_file,"r"); 
#  ifdef VMS
      if ((res=strchr(gv_user_defaults_file,';'))) { *res='\0'; }
      sprintf(tempfilename,"%s%s",gv_user_defaults_file,"_TMP;");
      strcat(gv_user_defaults_file,";");
#  else
      tmpnam(tempfilename);
#  endif
   INFSMESSAGE(using temporary file,tempfilename)
   
   if (!tempfilename || !(tempfile = fopen(tempfilename,"w"))) {
      sprintf(errorMessage,"Save aborted: \nCannot create temporary file");
      NotePopupShowMessage(errorMessage);
      INFMESSAGE(cannot create temporary file)
      ENDMESSAGE(SaveOptionsToFile)
      fclose(infile);
      return;
   }

   if (infile) {
      while (fgets(line,MAX_RECORD_LENGTH,infile)) {
         i=0;
         while (i <= argn) {
            if (res=strstr(line,argi[i])) {
               comm=strchr(line,'!');
               if (!comm) comm=res;
               if (comm-res >= 0) {  
                  INFSMESSAGE(found:,line)
                  res=strchr(res,':');
                  while ((*(++res) == ' ') || (*res == '\t'));     
                  *res = '\0';
                  strcat(line,argv[i]);
                  INFSMESSAGE(replaced by:,line)
                  strcat(line,END_OF_RECORD);
                  while (i<argn) {
                     strcpy(argi[i],argi[i+1]);
                     strcpy(argv[i],argv[i+1]);
                     ++i;
                  }
                  --argn;
               }
               else i=argn+1;
            }
            else ++i;
         }
         fputs(line,tempfile);
      }
      fclose(infile);
   }

   if (argn>=0) fputs(END_OF_RECORD,tempfile);
   while (argn >= 0) {
      strcat(argi[argn]," ");
      strcat(argi[argn],argv[argn]);   
      strcat(argi[argn],END_OF_RECORD);
      fputs(argi[argn],tempfile);
      INFSMESSAGE(added to resource file:,argi[argn])
      --argn;
   }
   fclose(tempfile);

   if (rename(tempfilename,gv_user_defaults_file)) {
      sprintf(errorMessage,"Save aborted: \nCannot rename temporary '%s'\n to '%s'",tempfilename,gv_user_defaults_file);
      NotePopupShowMessage(errorMessage);
      unlink(tempfilename);
      INFMESSAGE(Cannot rename temporary file)
      ENDMESSAGE(SaveOptionsToFile)
      return;
   }

   ENDMESSAGE(SaveOptionsToFile)
}

/*###############################################################################
   getText
   get the current contents of a text field
###############################################################################*/

static char *getText(w)
   Widget       w;
{
   Arg          args[2];
   Cardinal     n;
   String       value;

   BEGINMESSAGE(getText)
   n = 0;
   XtSetArg(args[n], XtNstring, &value);  n++;
   XtGetValues(w, args, n);
   ENDMESSAGE(getText)
   return value;
}   

/*###############################################################################
   getToggle
   set the current state of a toggle button
###############################################################################*/

static Boolean getToggle(w)
   Widget       w;
{
   Arg          args[2];
   Cardinal     n;
   Boolean      value;

   BEGINMESSAGE(getToggle)
   n = 0;
   XtSetArg(args[n], XtNstate, &value);  n++;
   XtGetValues(w, args, n);   
   ENDMESSAGE(getToggle)
   return value;
} 

/*###############################################################################
   toggleNotify
   toggle notify callback
###############################################################################*/

static void toggleNotify(w, client_data, call_data)
   Widget               w;
   XtPointer    client_data, call_data;
{
   BEGINMESSAGE(toggleNotify)
   ENDMESSAGE(toggleNotify)
}

/*###############################################################################
   setToggle
   set the state of a toggle button explicitly
###############################################################################*/

static void setToggle(w, value)
   Widget       w;
   Boolean      value;
{
   Arg          args[2];
   Cardinal     n;

   BEGINMESSAGE(setToggle)
   n = 0;
   XtSetArg(args[n], XtNstate, value);  n++;
   XtSetValues(w, args, n);
   ENDMESSAGE(setToggle)
}

/*###############################################################################
   setText
   set the contents of a text field to a string
###############################################################################*/

static void setText(w, value)
   Widget       w;
   String       value;
{
   Arg          args[2];
   Cardinal     n;

   BEGINMESSAGE(setText)
   n = 0;
   XtSetArg(args[n], XtNstring, value);  n++;
   XtSetValues(w, args, n);
   ENDMESSAGE(setText)
}

/*###############################################################################
   setOptionsAtEntry
###############################################################################*/

static void setOptionsAtEntry()
{
   BEGINMESSAGE(setOptionsAtEntry)

   setToggle(confirmPrintToggle, app_res.confirm_print);
   XtCallActionProc(confirmPrintToggle, "notify", NULL, NULL, 0);  

   SMESSAGE(app_res.print_command)
   setText(print_command, app_res.print_command);
   SMESSAGE(app_res.scratch_dir)
   setText(scratch_dir,  app_res.scratch_dir);
   SMESSAGE(app_res.default_save_dir)
   setText(default_save_dir,  app_res.default_save_dir);

   ENDMESSAGE(setOptionsAtEntry)
}

/*###############################################################################
   changeOptionsAtExit
###############################################################################*/

#define OPTION_LENGTH 255

static void changeOptionsAtExit()
{
   char    *value, *str;
   static Boolean s_print_command = False;
   static Boolean s_scratch_dir =   False;
   static Boolean s_default_save_dir = False;

   app_res.confirm_print       = getToggle(confirmPrintToggle);

   value = getText(print_command);
   str = XtNewString(value);
   if   (s_print_command == True) {INFMESSAGE(freeing) XtFree(app_res.print_command);} 
   else  s_print_command =  True;
   app_res.print_command =  str;

   value = getText(scratch_dir);
   str = XtNewString(value);
   if   (s_scratch_dir == True) {INFMESSAGE(freeing) XtFree(app_res.scratch_dir);} 
   else  s_scratch_dir =  True;
   app_res.scratch_dir =  str;

   value = getText(default_save_dir);
   str = XtNewString(value);
   if   (s_default_save_dir == True) {INFMESSAGE(freeing) XtFree(app_res.default_save_dir);} 
   else  s_default_save_dir =  True;
   app_res.default_save_dir =  str;

}

/*###############################################################################
   cb_popupOptionPopup
###############################################################################*/

void cb_popupOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(popupOptionPopup)
   if (!optionPopupCreated) makeOptionPopup();
   if (!optionPopupVisible) {
      setOptionsAtEntry();
      positionPopup(optionpopup,2,OPTIONS_TOPLEVEL,50,50, 1,1);
      XtPopup(optionpopup, XtGrabNone);
      optionPopupVisible=True;
   }
   ENDMESSAGE(popupOptionPopup)
}      

/*###############################################################################
   cb_saveOptionPopup
   Note: the resources MUST be terminated by ':'
###############################################################################*/

static
void cb_saveOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   int 		argn = 0;
   char		argi[5][MAX_RECORD_LENGTH];
   char		argv[5][MAX_RECORD_LENGTH];

   BEGINMESSAGE(cb_saveOptionPopup)

   if (!optionPopupVisible) {
      INFMESSAGE(option popup not up)
      ENDMESSAGE(cb_saveOptionPopup)
      return;
   }

   sprintf(argi[argn],"%s.printCommand:",gv_name);      
   strcpy(argv[argn],getText(print_command));       ++argn;

   sprintf(argi[argn],"%s.scratchDir:",gv_name);      
   strcpy(argv[argn],getText(scratch_dir));         ++argn;
   
   sprintf(argi[argn],"%s.defaultSaveDir:",gv_name);      
   strcpy(argv[argn],getText(default_save_dir));         ++argn;

   sprintf(argi[argn],"%s.confirmPrint:",gv_name);      
   if (getToggle(confirmPrintToggle))  strcpy(argv[argn],"True");
   else strcpy(argv[argn],"False");                   ++argn;

   SaveOptionsToFile(argn,argi,argv);

   ENDMESSAGE(cb_saveOptionPopup)
}

/*###############################################################################
   cb_popdownOptionPopup
###############################################################################*/

void cb_popdownOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(cb_popdownOptionPopup)
   if (optionPopupVisible) {
      cb_popdownNotePopup((Widget)NULL,(XtPointer)NULL,NULL);
      XtPopdown(optionpopup);
      optionPopupVisible=False;
   }
   ENDMESSAGE(cb_popdownOptionPopup)
}

/*###############################################################################
   cb_doneOptionPopup
###############################################################################*/

void cb_doneOptionPopup(w, client_data, call_data)
   Widget	w;
   XtPointer	client_data, call_data;
{
   BEGINMESSAGE(doneOptionPopup)
   if (optionPopupVisible) {
      cb_popdownOptionPopup((Widget)NULL,(XtPointer)NULL,NULL);
      changeOptionsAtExit();
   }
   ENDMESSAGE(doneOptionPopup)
}

/*###############################################################################
   action_handleOptionPopup
###############################################################################*/

void 
action_handleOptionPopup(top, event, params, num_params)
    Widget top;
    XEvent *event;
    String *params;
    Cardinal *num_params;
{
    BEGINMESSAGE(action_handleOptionPopup)
    if (!params) {
       INFMESSAGE(no parameters)
       ENDMESSAGE(action_handleOptionPopup)
       return;
    }
    if (!(strcmp(params[0],"popup"))) {
       cb_popupOptionPopup((Widget)NULL,(XtPointer)NULL,NULL);
    } else
    if (!(strcmp(params[0],"popdown"))) {
       cb_popdownOptionPopup((Widget)NULL,(XtPointer)NULL,NULL);
    } else
    if (!(strcmp(params[0],"done"))) {
       cb_doneOptionPopup((Widget)NULL,(XtPointer)NULL,NULL);
    } else
    if (!(strcmp(params[0],"save"))) {
       cb_saveOptionPopup((Widget)NULL,(XtPointer)NULL,NULL);
    }
    ENDMESSAGE(action_handleOptionPopup)
}

/*###############################################################################
   createToggleL
   create a label/toggle widget pair
###############################################################################*/

static Widget createToggleL(name, parent)
   char         *name;
   Widget       parent;
{
   char         tempName[50];
   Widget       theToggle, theLabel;
   Widget       theBox;
   Arg          args[10];
   Cardinal n;

   INFMESSAGE(executing createToggleL)

            strcpy(tempName, name);
            strcat(tempName,"Toggle");
            n = 0;
   theToggle = XtCreateManagedWidget(tempName, toggleWidgetClass,parent, args, n);
            XtAddCallback(theToggle, XtNcallback, toggleNotify, (XtPointer)name);

            strcpy(tempName, name);
            strcat(tempName, "Label");
            n = 0;
   theLabel = XtCreateManagedWidget(tempName, labelWidgetClass,parent, args, n);

   return theToggle;
}

/*###############################################################################
   createTextFieldL
   create a labelled single-line text field widget pair
###############################################################################*/

static Widget createTextFieldL(name, parent)
   char         *name;
   Widget       parent;
{
   char         tempName[50];
   char         tempName3d[50];
   Widget       theForm, theText3d, theText, theLabel; 
   Arg          args[20];
   Cardinal     n;
   Dimension    w, h;

   INFMESSAGE(executing createTextFieldL)   
          strcpy(tempName, name);
          strcat(tempName, "Label");
          n = 0;
          XtSetArg(args[n], XtNresize, False);				n++;
   theLabel = XtCreateManagedWidget(tempName, labelWidgetClass,parent, args, n);

          strcpy(tempName, name);
          strcat(tempName, "Text3d");
          n=0;

#   if defined(USE_XAW3D) && defined(USE_FORM3D)
       theText3d = XtCreateManagedWidget(tempName, form3dWidgetClass,parent, args, n);
#   else
       theText3d = XtCreateManagedWidget(tempName, formWidgetClass,parent, args, n);
#   endif
          								n=0;
          XtSetArg(args[n], XtNfromVert, NULL);				n++;
          XtSetArg(args[n], XtNfromHoriz, NULL);			n++;
          XtSetArg(args[n], XtNtop,    XawChainTop);			n++;
          XtSetArg(args[n], XtNbottom, XawChainBottom);			n++;
          XtSetArg(args[n], XtNleft,   XawChainLeft);			n++;
          XtSetArg(args[n], XtNright,  XawChainRight);			n++;
          XtSetArg(args[n], XtNtype, XawAsciiString);			n++;
          XtSetArg(args[n], XtNuseStringInPlace, False);		n++;
          XtSetArg(args[n], XtNscrollHorizontal, XawtextScrollNever);	n++;
          XtSetArg(args[n], XtNscrollVertical, XawtextScrollNever);	n++;
          XtSetArg(args[n], XtNdisplayCaret, False);			n++;
          XtSetArg(args[n], XtNeditType, XawtextEdit);			n++;
          XtSetArg(args[n], XtNresizable, True);			n++;
          XtSetArg(args[n], XtNresize, XawtextResizeWidth);		n++;
   theText = XtCreateManagedWidget(name, asciiTextWidgetClass,theText3d, args, n);
          XtOverrideTranslations(theText,XtParseTranslationTable(OneLineTextTr));

   return theText;
}

/*###############################################################################
   makeOptionPopup
###############################################################################*/

void makeOptionPopup()
{
   Arg          args[10];
   Cardinal     n;
   Dimension	minw,minh;

   BEGINMESSAGE(makeOptionPopup)

   if (optionPopupCreated) {INFMESSAGE(popup exists) ENDMESSAGE(makeOptionPopup) }

        						n=0;
        XtSetArg(args[n], XtNallowShellResize, True);	n++;           
   OPTIONS_POPUP = XtCreatePopupShell(OPTIONS_POPUP_NAME,transientShellWidgetClass,OPTIONS_TOPLEVEL, args, n);

         						n=0;
        XtSetArg(args[n], XtNresizeWidth, True);	n++;
        XtSetArg(args[n], XtNresizeHeight, True);	n++;
        XtSetArg(args[n], XtNconditionedResize, False);	n++;
        XtSetArg(args[n], XtNmaximumWidth, 0);	 	n++;
        XtSetArg(args[n], XtNmaximumHeight,0);	 	n++;
   optionLayout = XtCreateManagedWidget("optionLayout",layoutWidgetClass,OPTIONS_POPUP,args,n);

   confirmPrintToggle = createToggleL("confirmPrint", optionLayout);

        						n=0;
   doneButton = XtCreateManagedWidget("done", commandWidgetClass,optionLayout, args, n);
         XtAddCallback(doneButton, XtNcallback, cb_doneOptionPopup,NULL); 
   saveButton = XtCreateManagedWidget("save", commandWidgetClass,optionLayout, args, n);
         XtAddCallback(saveButton, XtNcallback, cb_saveOptionPopup,NULL);
   cancelButton = XtCreateManagedWidget("cancel", commandWidgetClass,optionLayout, args, n);
         XtAddCallback(cancelButton, XtNcallback, cb_popdownOptionPopup, NULL);
 
   print_command    = createTextFieldL("printCommand", optionLayout);
   scratch_dir      = createTextFieldL("scratchDir",   optionLayout);
   default_save_dir = createTextFieldL("saveDir",      optionLayout);
   setOptionsAtEntry();
   XtRealizeWidget(OPTIONS_POPUP);

   LayoutWidgetGetNaturalSize((LayoutWidget)optionLayout,&minw,&minh);
   IIMESSAGE(minw,minh)
                                          n=0;
   XtSetArg(args[n], XtNminWidth, minw);  ++n;
   XtSetArg(args[n], XtNminHeight, minh); ++n;
   XtSetArg(args[n], XtNmaxWidth, XtUnspecifiedShellInt);  ++n;
   XtSetArg(args[n], XtNmaxHeight, minh); ++n;
   XtSetValues(OPTIONS_POPUP, args, n);

                                       n=0;
   XtSetArg(args[n], XtNwidth, minw+50);  ++n;
   XtSetValues(optionLayout, args, n);

   XSetWMProtocols(XtDisplay(OPTIONS_POPUP),XtWindow(OPTIONS_POPUP),&wm_delete_window,1);
   optionPopupCreated = True;  
                                
   ENDMESSAGE(makeOptionPopup)
}
