/*
 * vms_dir.c
 * Copyright (C) 1995  Johannes Plass
 *   Author: Johannes Plass
 *           Department of Physics
 *           Johannes-Gutenberg University, Mainz, Germany
 * Internet: plass@dipmza.physik.uni-mainz.de
*/

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
*/ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unixlib.h>
#include <rmsdef.h>
#include <descrip.h>
#include <lib$routines.h>
#include "vms_dirent.h"

/*
#define MESSAGES
#define MESSAGE_NO_ESC
*/
#include "message.h"

#define	NOWILD		0x00000001
#define MULTIPLE	0x00000002

static unsigned long context = 0;

/*#################################################################
   create_descriptor
#################################################################*/

static struct dsc$descriptor_s *create_descriptor ( name )
char *name;
{
   struct dsc$descriptor_s *retdescrip;

   BEGINMESSAGE(create_descriptor)
   retdescrip = (struct dsc$descriptor_s *)calloc(1, sizeof(struct dsc$descriptor_s));

   if (retdescrip == NULL) return ((struct dsc$descriptor_s *)NULL);

   retdescrip->dsc$b_dtype	= DSC$K_DTYPE_T;
   retdescrip->dsc$b_class	= DSC$K_CLASS_S;
   retdescrip->dsc$w_length	= strlen(name);
   retdescrip->dsc$a_pointer	= name;

   ENDMESSAGE(create_descriptor)
   return (retdescrip);
}

/*#################################################################
   Check_Directory
#################################################################*/

static int 
Check_Directory(path)
   char	*path;
{
   char *cp;
   char dirfile[MAXNAMLEN+15];
   FILE *fp;
   int valid = 0;

   BEGINMESSAGE(Check_Directory)
   SMESSAGE(path);

   if (strlen(path) >= MAXNAMLEN) {
      INFMESSAGE(path exceeds maximum length) ENDMESSAGE(Check_Directory)
      return(valid);
   }
   strcpy(dirfile,path);

   cp = strrchr(dirfile,'.');
   if (cp) {
      *cp = ']';
      cp = strrchr(dirfile, ']');
      *cp = '\0';
      strcat(cp, ".DIR");
      valid = 1;
      SMESSAGE(dirfile)
   }
   else {
      char *dl, *dr;
      dr = strrchr(dirfile, ']');
      dl = strchr(dirfile, '[');
      if ((dl) && (dr)) {
         char tmp[MAXNAMLEN+15];
         *dr = '\0';
         strcpy(tmp,dl+1); *dl='\0';
         strcat(dirfile, "[000000]");
         strcat(dirfile, tmp);
         strcat(dirfile, ".DIR");
         valid = 1;
         SMESSAGE(dirfile)
      }
   }
   if (valid) {
      fp = fopen(dirfile, "r");
      if (!fp) {INFMESSAGE(directory does not exist) valid = 0; }
      else {INFMESSAGE(directory exists) fclose(fp); valid = 1; }
   }
   else {INFMESSAGE(invalid directory specification) valid = 0; }
   ENDMESSAGE(Check_Directory)
   return (valid);
}

/*#################################################################
   opendir
#################################################################*/

DIR *opendir( dirname )
char *dirname;
{
   DIR *retdir;
   struct dsc$descriptor_s filedescriptor;
   char *filepathname;
   char path[MAXNAMLEN];

   BEGINMESSAGE(opendir)
   retdir = (DIR *) calloc(1, sizeof(DIR));
   if (retdir == NULL) { INFMESSAGE(cannot calloc) ENDMESSAGE(opendir) return ((DIR *)NULL); }

   strcpy(path,dirname);
   if (!strcmp(path,".")) getwd(path);
   SMESSAGE(path)

   if (!Check_Directory(path)) {INFMESSAGE(cannot open) ENDMESSAGE(opendir) return ((DIR *)NULL); }

   filepathname = (char *)calloc(MAXNAMLEN+1, sizeof(char));

   strcpy(filepathname, path);
   strcat(filepathname, "*.*.*");

   retdir->dd_fd = (unsigned long) create_descriptor(filepathname);
   retdir->dd_loc = 0;
   retdir->dd_size = strlen(filepathname);
   retdir->dd_bsize = 0;
   retdir->dd_off = 0;
   retdir->dd_buf = filepathname;

   INFSMESSAGE(valid:,path)
   ENDMESSAGE(opendir)
   return (retdir);
}

/*#################################################################
   readdir
#################################################################*/

struct dirent *readdir( dirp )
DIR *dirp;
{
   static struct dirent *retdirent;
   struct dsc$descriptor_s retfilenamedesc;
   struct dsc$descriptor_s searchpathdesc = *((struct dsc$descriptor_s *)dirp->dd_fd);
   char retfilename[MAXNAMLEN+1];
   char *sp;
   unsigned long istatus;
   unsigned long rms_status;
   unsigned long flags;

   BEGINMESSAGE(readdir)

   retdirent = (struct dirent *)NULL;

   flags = MULTIPLE;

   retfilenamedesc.dsc$b_dtype	= DSC$K_DTYPE_T;
   retfilenamedesc.dsc$b_class	= DSC$K_CLASS_S;
   retfilenamedesc.dsc$w_length	= MAXNAMLEN;
   retfilenamedesc.dsc$a_pointer= retfilename;

   istatus = lib$find_file (&searchpathdesc,
                            &retfilenamedesc,
                            &dirp->dd_loc,
                            0, 0,
                            &rms_status,
                            &flags);

   if (!(istatus & 1) && (istatus != RMS$_NMF) && (istatus != RMS$_FNF))
   {
      lib$signal (istatus);
      ENDMESSAGE(readdir)
      return (retdirent);
   }
   else if ((istatus == RMS$_NMF) || (istatus == RMS$_FNF)) {
      ENDMESSAGE(readdir)
      return (retdirent);
   }

   retfilename[retfilenamedesc.dsc$w_length] = '\0';

   sp = strchr(retfilename, ' ');
   if (sp != NULL) *sp = '\0';

   sp = strrchr(retfilename, ']');
   if (sp != NULL) sp++;
   else sp = retfilename;

   retdirent = (struct dirent *)calloc(1, sizeof(struct dirent));

   strcpy(retdirent->d_name, sp);
   retdirent->d_namlen = strlen(sp);
   retdirent->d_fileno = 0;
   retdirent->d_off = 0;
   retdirent->d_reclen = DIRSIZ(retdirent);

   ENDMESSAGE(readdir)
   return (retdirent);
}

#if 0
/*#################################################################
   telldir
#################################################################*/

long telldir( dirp )
DIR *dirp;
{
   BEGINMESSAGE(telldir)
   INFMESSAGE(not properly implemented)
   printf("VMS_DIR.C: 'telldir' on VMS not properly implemented\n");
   ENDMESSAGE(telldir)
   return(0);
}

/*#################################################################
   seekdir
#################################################################*/

void seekdir( dirp, loc )
DIR *dirp;
long loc;
{
   BEGINMESSAGE(seekdir)
   INFMESSAGE(not properly implemented)
   printf("VMS_DIR.C: 'seekdir' on VMS not properly implemented\n");
   ENDMESSAGE(seekdir)
   return;
}
#endif

/*#################################################################
   rewinddir
#################################################################*/

void rewinddir( dirp )
DIR *dirp;
{
   BEGINMESSAGE(rewinddir)   
   lib$find_file_end (&dirp->dd_loc);
   ENDMESSAGE(rewinddir)
}

/*#################################################################
   closedir
#################################################################*/

int closedir(dirp)
   DIR *dirp;
{
   BEGINMESSAGE(closedir)
   lib$find_file_end (&dirp->dd_loc);
   cfree ((void*)dirp->dd_fd);
   cfree ((void*)dirp->dd_buf);
   cfree ((void*)dirp);
   ENDMESSAGE(closedir)
   return(0);
}

/*#################################################################
   getwd
#################################################################*/

char *getwd(p)
   char 	*p;
{
   BEGINMESSAGE(getwd)
   getcwd(p,MAXNAMLEN);
   SMESSAGE(p)
   ENDMESSAGE(getwd)
   return(p);
}
