$!------------------------------------------------------------------------------
$!  Compile and/or link JUMP under VAX or Alpha.
$!
$!  Parameter P1 set to any value will cause linking only.
$!
$!  If there is no Pascal compiler available, rename the appropriate object
$!  file to .OBJ, issue the SET COMMAND command, and then execute this
$!  procedure with any P1 parameter to link the image.
$!
$!  Author: Jonathan Ridler,
$!	    Information Technology Services,
$!	    The University of Melbourne,
$!	    Parkville, Victoria, AUSTRALIA, 3052.
$!
$!	    Internet: jonathan@unimelb.edu.au
$!
$!..............................................................................
$!  JUMP has been successfully built and tested under OpenVMS VAX v5.5-2 with
$!  Pascal v5.0, and OpenVMS Alpha v6.2 with Pascal v5.4.
$!
$!  With new releases of OpenVMS, it may be necessary to re-link JUMP.
$!
$!  When compiling on Alpha, Pascal produces multiple Informational messages
$!  concerning the optimal sizing and alignment of data structures - these can
$!  be ignored.  Use the qualifier /NOWARNINGS if you wish to hide them.
$!------------------------------------------------------------------------------
$
$ on ERROR  then  EXIT
$ say := write SYS$OUTPUT
$
$ if p1 .eqs. ""
$ then
$   say "Compiling JUMP source ..."
$   pascal jump
$   say "Compiling JUMP CLD ..."
$   set command /object jump_cld
$ endif
$
$ say "Linking JUMP ..."
$ if f$getsyi ("ARCH_NAME") .eqs. "VAX"		! "VAX" or "Alpha"
$ then
$   link /notrace jump,jump_cld,SYS$SYSTEM:SYS.STB/select,SYSDEF.STB/select
$ else
$   link /notrace /sysexe jump,jump_cld,SYS$LOADABLE_IMAGES:SYSDEF.STB/select
$ endif
$
$ say "*** JUMP built successfully ***"
$ say "Don't forget to install the image with the correct privileges."
$
$ EXIT 1
