I {************************************************************************  *									*  *  J U M P								*  *									* B *  JUMP is a program which allows selected users (Operators and 	*F *  Systems Programmers) to change elements of their process to those	*= *  of another user.  Limitations are placed on non-Systems		* G *  Programmers: they cannot target users who have more than a certain	* 9 *  set of privileges and they cannot change username.			*  *									* > *  Items which are changed to those of the target user are:		* *									* @ *    Username (Systems Programmers only, using the SETUSER or		* *	       ALL qualifier)						* *									* 9 *    UIC, Default Directory, Default Disk, LNM$GROUP.			*  *									* 5 *  Privileges and process rights are NOT changed.			*  *									* * *  The syntax of the JUMP command is					* *									* + *      $ JUMP [username] [qualifiers]					*  *									* I *  If no username is supplied, JUMP returns all item values to those of *  *  the current username.						* I *.......................................................................* = *  ****  CAUTION: KERNEL-mode code fiddles things !!! ****		*  *									* D *  INSTALL program with CMEXEC, CMKRNL, SYSPRV, SYSNAM privileges.	* *									* H *  NOTE: The definition of privilege sets has been adopted for ease of	*H *  coding.  The source for the information is SYS$LIBRARY:STARLET.PAS.	*E *  The definition will need reviewing with each release of OpenVMS!	* I *.......................................................................* D *  Note: Some ideas in this code have been drawn from Eric Wentz's	* *	 program BECOME.						* I *.......................................................................* # *  Author:  Jonathan Ridler,						* + *	    Information Technology Services,				* ' *	    The University of Melbourne,				*   *	    Parkville, Victoria,					* *	    AUSTRALIA, 3052.						*  *									* 5 *	    Internet: jonathan@ucsvc.its.unimelb.edu.au 		* I *.......................................................................*  *  History:								*' *	02-Mar-1993	JER	Original version.			* / *	09-Mar-1993	JER	Audit security violations.		* 4 *	04-Mar-1994	JER	Add change username capability. 	*; *	14-Jul-1994	JER	Allow change of UIC, etc. AND username; * " *				Allow username NOT in UAF.		*3 *	21-Nov-1995	JER	Allow Sysprogs to avoid audit.		* : *	11-Jan-1996	JER	Increase size of audit message buffer.	*I ************************************************************************}   J { ****	This is JUMP version 1.3  **** (Keep this comment up-to-date !!!) }    [INHERIT ('SYS$LIBRARY:STARLET',% 	  'SYS$LIBRARY:PASCAL$LIB_ROUTINES', & 	  'SYS$LIBRARY:PASCAL$STR_ROUTINES')]   PROGRAM Jump (OUTPUT) ;    TYPE   $UBYTE = [BYTE] 0..255 ;   $UWORD = [WORD] 0..65535 ;  6 Privilege = (Cmkrnl,	{  0: May change Mode to Kernel }A 	     Cmexec,	{  1: May change Mode to Exec; MUST follow Cmkrnl } = 	     Sysnam,	{  2: May insert in system logical name table } E 	     Grpnam,	{  3: May insert in group l.n.tab; MUST follow Sysnam } 3 	     Allspool,	{  4: May allocate spooled device } 3 	     Detach,	{  5: May create detached processes } , 	     Diagnose,	{  6: May diagnose devices }( 	     Log_Io,	{  7: May do logical I/O }A 	     Group,	{  8: May affect other processes in same UIC group } + 	     Acnt,	{  9: May suppress accounting } @ 	     Prmceb,	{ 10: May create permanent common event clusters }3 	     Prmmbx,	{ 11: May create permanent mail box } - 	     Pswapm,	{ 12: May change process mode } 0 	     Altpri,	{ 13: May set any priority value }0 	     Setprv,	{ 14: May set any privilege bits }2 	     Tmpmbx,	{ 15: May create temporary mailbox }< 	     World,	{ 16: May affect other processes in the world }4 	     Mount,	{ 17: May execute mount ACP functions }& 	     Oper,	{ 18: Operator privilege }- 	     Exquota,	{ 19: May exceed disk quotas } / 	     Netmbx,	{ 20: May create network device } 4 	     Volpro,	{ 21: May override volume protection }) 	     Phy_Io,	{ 22: May do physical I/O } : 	     Bugchk,	{ 23: May make bug check error log entries }: 	     Prmgbl,	{ 24: May create permanent global sections }< 	     Sysgbl,	{ 25: May create system-wide global sections }/ 	     Pfnmap,	{ 26: May map to section by PFN } = 	     Shmem,	{ 27: May allocate structures in shared memory } : 	     Sysprv,	{ 28: Eligible for system protection field }5 	     Bypass,	{ 29: May bypass UIC-based protection } 2 	     Syslck,	{ 30: May create system-wide locks }< 	     Share,	{ 31: May assign channel to non-shared device }3 	     Upgrade,	{ 32: May upgrade object integrity } 5 	     Downgrade, { 33: May downgrade object secrecy } > 	     Grpprv,	{ 34: Group access via system protection field }* 	     Readall,	{ 35: May read any object }A 	     Import,	{ 36: May set classification for unlabeled object } B 	     Audit,	{ 37: May direct audit to system security audit log }6 	     Security,	{ 38: May perform security functions }= 	     Pbit39, Pbit40, Pbit41, Pbit42, Pbit43, Pbit44, Pbit45, = 	     Pbit46, Pbit47, Pbit48, Pbit49, Pbit50, Pbit51, Pbit52, = 	     Pbit53, Pbit54, Pbit55, Pbit56, Pbit57, Pbit58, Pbit59, F 	     Pbit60, Pbit61, Pbit62, Pbit63) ;	{ 39-63: dummy bits: 2 LONGs }  E Privset = PACKED SET OF Privilege ;	{ To allow easy bit union, etc. }   < Status_Block_Type = [UNSAFE] PACKED ARRAY [1..4] OF $UWORD ;   Item_List_Cell = RECORD  		   CASE INTEGER OF 		     1: (			{ Normal Cell }  			 Buffer_Length : $UWORD ; 			 Item_Code     : $UWORD ; 			 Buffer_Addr   : UNSIGNED ; 			 Return_Addr   : UNSIGNED 			) ; 		     2: (			{ Terminator } 			 Terminator    : UNSIGNED 			) ; 		 END ;  I Item_List_Template (Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell ;   . Username_Type = PACKED ARRAY [1..12] OF CHAR ;   VAR			{ ***  V A R  *** }   " Log ,				{ Log success messages? }# Sysprog ,			{ Systems Programmer? } " Alter_Ego ,			{ Change Username? }# Transmute ,			{ Change UIC, etc.? } ( Auditing ,			{ Audit successful jumps? }; Figment : BOOLEAN := FALSE ;	{ Allow username NOT in UAF? }   J Max_Sys_Group : INTEGER := 0 ;	{ Maximum UIC group with system privilege }  ( Rst : UNSIGNED := 0 ;		{ Return Status }  0 User : VARYING [12] OF CHAR := PAD ('',' ',12) ;  ? New_User : [VOLATILE] VARYING [12] OF CHAR := PAD ('',' ',12) ;    Sanity_Ctl_User , 2 Sanity_Jib_User : [VOLATILE] Username_Type := '' ;  > Command : VARYING [80] OF CHAR := '' ;		{ Input command line }   Uic , 	 New_Uic , * Sanity_Uic : [VOLATILE] UIC$TYPE := ZERO ;  
 Terminal , Port ,2 Def_Dev : [VOLATILE] VARYING  [32] OF CHAR := '' ;  + Audit_Trail : VARYING [255] OF CHAR := '' ;   2 Def_Dir : [VOLATILE] VARYING [255] OF CHAR := '' ;  ( Uic_Str : VARYING [15] OF CHAR := ZERO ;   Eq_Id_Str , ' Id_Str	: VARYING [32] OF CHAR := ZERO ;   
 Def_Priv ,0 Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;  ( Flags : [VOLATILE]  FLAGS$TYPE := ZERO ;  < Jib_User_Ptr : [VOLATILE] ^[VOLATILE] Username_Type := NIL ;  4 CTL$T_USERNAME : [EXTERNAL,VOLATILE] Username_Type ;  	 Jib_Ptr , 2 Uic_Ptr : [VOLATILE] ^[VOLATILE] UNSIGNED := NIL ;   PCB$L_JIB ,  PCB$L_UIC ,  JIB$T_USERNAME ," CTL$GL_PCB : [EXTERNAL] UNSIGNED ;    % [ASYNCHRONOUS] FUNCTION SYS$SETDDIR (  	New_Dir_Addr : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 2 	VAR Length_Addr : [VOLATILE] $UWORD := %IMMED 0 ; 	%STDESCR Cur_Dir_Addr :7 		PACKED ARRAY [$L3..$U3:INTEGER] OF CHAR := %IMMED 0 )  		: UNSIGNED ; EXTERNAL ;   ' [ASYNCHRONOUS] FUNCTION CLI$DCL_PARSE (  	Command_String : A 		[CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR := %IMMED 0 ; 0 	%IMMED [ASYNCHRONOUS,UNBOUND] PROCEDURE Table ; 	%IMMED [ASYNCHRONOUS,UNBOUND]0 		FUNCTION Param_Routine	: INTEGER := %IMMED 0 ; 	%IMMED [ASYNCHRONOUS,UNBOUND]1 		FUNCTION Prompt_Routine : INTEGER := %IMMED 0 ;  	Prompt_String :A 		[CLASS_S] PACKED ARRAY [$L5..$U5:INTEGER] OF CHAR := %IMMED 0 )  		: UNSIGNED ; EXTERNAL ;   ' [ASYNCHRONOUS] FUNCTION CLI$GET_VALUE ( B 	Entity_Desc : [CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR ;) 	%DESCR Retdesc : VARYING [$L2] OF CHAR ; 0 	VAR Retlength : [VOLATILE] $UWORD := %IMMED 0 ) 		: UNSIGNED ; EXTERNAL ;   % [ASYNCHRONOUS] FUNCTION CLI$PRESENT ( B 	Entity_Desc : [CLASS_S] PACKED ARRAY [$L1..$U1:INTEGER] OF CHAR ) 		: UNSIGNED ; EXTERNAL ;      PROCEDURE Get_Logical_Name (< 		Lognam	: [CLASS_S] PACKED ARRAY [L1..U1:INTEGER] OF CHAR ;= 		Default : [CLASS_S] PACKED ARRAY [L2..U2:INTEGER] OF CHAR ; % 		VAR Actual : VARYING [Sz] OF CHAR ; < 		Table	: [CLASS_S] PACKED ARRAY [L3..U3:INTEGER] OF CHAR := 				'LNM$FILE_DEV' ; 		Mode	: $UBYTE := PSL$C_SUPER 		) ;   K { Get the translation of the logical name specified.  If it does not exist,    use the default value. }     VAR Rst : UNSIGNED := 0 ; 2       Item_List : Item_List_Template (2) := ZERO ;  "   BEGIN       { Get_Logical_Name }4   Item_List[1].Buffer_Length := SIZE (Actual.BODY) ;-   Item_List[1].Item_Code     := LNM$_STRING ; 8   Item_List[1].Buffer_Addr   := IADDRESS (Actual.BODY) ;:   Item_List[1].Return_Addr   := IADDRESS (Actual.LENGTH) ;  A   Item_List[2].Terminator    := 0 ;   { Terminate the item list }   1   Rst := $TRNLNM (Attr	 := %REF LNM$M_CASE_BLIND,  		  Tabnam := Table, 		  Lognam := Lognam,  		  Acmode := %REF Mode, 		  Itmlst := Item_List) ;   IF Rst = SS$_NOLOGNAM  THEN       Actual := Default    ELSE    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ; %   END ;       { of Get_Logical_Name }     $ FUNCTION Check_Authority : BOOLEAN ;  E { Check that the invoker has the required access to run this program. H   This is independant of any installed privileges.  Identify SysProgs. }     VAR	Rst : INTEGER := 0 ;# 	Iosb : Status_Block_Type := ZERO ; . 	Item_List : Item_List_Template (10) := ZERO ;9 	Pid , Master_Pid , Proc_Cnt : [VOLATILE] UNSIGNED := 0 ; F 	Proc_Def_Priv , Proc_Auth_Priv : [UNSAFE,VOLATILE]  Privset := ZERO ;     BEGIN 	{ Check_Authority }  #   Item_List[1].Buffer_Length := 4 ; 2   Item_List[1].Item_Code     := SYI$_MAXSYSGROUP ;:   Item_List[1].Buffer_Addr   := IADDRESS (Max_Sys_Group) ;#   Item_List[1].Return_Addr   := 0 ;   A   Item_List[2].Terminator    := 0 ;   { Terminate the item list }   '   Rst := $GETSYIW (Itmlst := Item_List,  		   Iosb   := Iosb) ;   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE    IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1]) ;   #   Item_List[1].Buffer_Length := 8 ; /   Item_List[1].Item_Code     := JPI$_PROCPRIV ; :   Item_List[1].Buffer_Addr   := IADDRESS (Proc_Def_Priv) ;#   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ; /   Item_List[2].Item_Code     := JPI$_AUTHPRIV ; ;   Item_List[2].Buffer_Addr   := IADDRESS (Proc_Auth_Priv) ; #   Item_List[2].Return_Addr   := 0 ;   #   Item_List[3].Buffer_Length := 4 ; *   Item_List[3].Item_Code     := JPI$_UIC ;:   Item_List[3].Buffer_Addr   := IADDRESS (Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;   -   Item_List[4].Buffer_Length := SIZE (User) ; /   Item_List[4].Item_Code     := JPI$_USERNAME ; 6   Item_List[4].Buffer_Addr   := IADDRESS (User.BODY) ;8   Item_List[4].Return_Addr   := IADDRESS (User.LENGTH) ;  #   Item_List[5].Buffer_Length := 4 ; *   Item_List[5].Item_Code     := JPI$_PID ;0   Item_List[5].Buffer_Addr   := IADDRESS (Pid) ;#   Item_List[5].Return_Addr   := 0 ;   #   Item_List[6].Buffer_Length := 4 ; 1   Item_List[6].Item_Code     := JPI$_MASTER_PID ; 7   Item_List[6].Buffer_Addr   := IADDRESS (Master_Pid) ; #   Item_List[6].Return_Addr   := 0 ;   #   Item_List[7].Buffer_Length := 4 ; -   Item_List[7].Item_Code     := JPI$_PRCCNT ; 5   Item_List[7].Buffer_Addr   := IADDRESS (Proc_Cnt) ; #   Item_List[7].Return_Addr   := 0 ;   2   Item_List[8].Buffer_Length := SIZE (Port.BODY) ;3   Item_List[8].Item_Code     := JPI$_TT_ACCPORNAM ; 6   Item_List[8].Buffer_Addr   := IADDRESS (Port.BODY) ;8   Item_List[8].Return_Addr   := IADDRESS (Port.LENGTH) ;  6   Item_List[9].Buffer_Length := SIZE (Terminal.BODY) ;/   Item_List[9].Item_Code     := JPI$_TERMINAL ; :   Item_List[9].Buffer_Addr   := IADDRESS (Terminal.BODY) ;<   Item_List[9].Return_Addr   := IADDRESS (Terminal.LENGTH) ;  ?   Item_List[10].Terminator   := 0 ;	{ Terminate the item list }   '   Rst := $GETJPIW (Itmlst := Item_List,  		   Iosb   := Iosb) ;     IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE    IF NOT ODD (Iosb[1])	THEN       LIB$SIGNAL (Iosb[1])     ELSE    IF Proc_Cnt > 0  THEN 
      BEGINN      WRITELN ('%JUMP-F-NOSUB, Cannot JUMP while process has sub-processes.') ;      $EXIT ;      END    ELSE    IF Pid <> Master_Pid	THEN 
      BEGINC      WRITELN ('%JUMP-F-NOINSUB, Cannot JUMP from a sub-process.') ;       $EXIT ;      END    ELSE 
      BEGIN1      Sysprog := Uic.UIC$V_GROUP < Max_Sys_Group ; 8      Sysprog := Sysprog OR (Setprv IN Proc_Auth_Priv) OR! 			   (Setprv IN Proc_Def_Priv) ; >      Check_Authority := Sysprog OR (Oper IN Proc_Auth_Priv) OR  				   (Oper IN Proc_Def_Priv) ;0      Rst := STR$TRIM (%DESCR User,%DESCR User) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ; 
      END ;   END ; 	{ of Check_Authority }       * FUNCTION Get_And_Parse_Command : BOOLEAN ;  G { Get and parse the DCL command line.  Do some basic username checks. }      VAR	Rst : UNSIGNED := 0 ;   ?   [ASYNCHRONOUS] PROCEDURE Jump_Cld ; EXTERNAL ;	{ CLD module }   "   BEGIN 	{ Get_And_Parse_Command }!   Get_And_Parse_Command := TRUE ;     Command := 'JUMP ' + Command ;>   Rst := CLI$DCL_PARSE (Command,Jump_Cld,%IMMED LIB$GET_INPUT,# 			%IMMED LIB$GET_INPUT,'JUMP> ') ; M   IF (Rst = RMS$_EOF) OR (Rst = CLI$_NOCOMD) OR (NOT ODD (Rst)) THEN  $EXIT ;   "   Rst := CLI$PRESENT ('SETUSER') ;?   Alter_Ego := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;    Transmute := NOT Alter_Ego ;     Rst := CLI$PRESENT ('ALL') ;L   Alter_Ego := Alter_Ego OR (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;  '   Rst := CLI$PRESENT ('OVERRIDE_UAF') ; =   Figment := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;      Rst := CLI$PRESENT ('LOG') ;9   Log := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;       Rst := CLI$PRESENT ('AUDIT') ;>   Auditing := (Rst = CLI$_PRESENT) OR (Rst = CLI$_DEFAULTED) ;'   IF NOT Auditing AND NOT Sysprog  THEN 
      BEGIN$      WRITELN ('%JUMP-F-MUSTAUDIT, ',: 	      'Only Systems Programmers may disable auditing.') ;      $EXIT (SS$_NOPRIV) ; 
      END ;2   Get_Logical_Name (Lognam  := 'JUMP_AUDIT_TRAIL',B 		    Default := 'SYS_MANAGER:JUMP_AUDIT.DAT',   { SITE-specific } 		    Actual  := Audit_Trail,  		    Table   := 'LNM$SYSTEM', 		    Mode    := PSL$C_EXEC) ;  G   Rst := CLI$GET_VALUE ('USERNAME',New_User) ;	{ Assume will be there }    IF Rst = CLI$_ABSENT	THEN 8      New_User := User				{ Default to current username }    ELSE    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst)     ELSE 
      BEGIN8      Rst := STR$TRIM (%DESCR New_User,%DESCR New_User) ;      IF NOT ODD (Rst)  THEN  	LIB$SIGNAL (Rst) ; 
      END ;  D   IF FIND_NONMEMBER (New_User,['A'..'Z','0'..'9','_','$']) <> 0 THEN
      BEGINI      WRITELN ('%JUMP-F-BADUSER, Username contains invalid characters.') ; %      Get_And_Parse_Command := FALSE ; 
      END ;$   END ; { of Get_And_Parse_Command }     FUNCTION Getuai : BOOLEAN ;   J { Get the required information for the particular new user from the UAF. }     VAR	Rst : INTEGER := 0 ;- 	Item_List : Item_List_Template (7) := ZERO ;      BEGIN 	{ Getuai } #   Item_List[1].Buffer_Length := 8 ; /   Item_List[1].Item_Code     := UAI$_DEF_PRIV ; 5   Item_List[1].Buffer_Addr   := IADDRESS (Def_Priv) ; #   Item_List[1].Return_Addr   := 0 ;   #   Item_List[2].Buffer_Length := 8 ; +   Item_List[2].Item_Code     := UAI$_PRIV ; 6   Item_List[2].Buffer_Addr   := IADDRESS (Auth_Priv) ;#   Item_List[2].Return_Addr   := 0 ;   #   Item_List[3].Buffer_Length := 4 ; *   Item_List[3].Item_Code     := UAI$_UIC ;>   Item_List[3].Buffer_Addr   := IADDRESS (New_Uic.UIC$L_UIC) ;#   Item_List[3].Return_Addr   := 0 ;   #   Item_List[4].Buffer_Length := 4 ; ,   Item_List[4].Item_Code     := UAI$_FLAGS ;2   Item_List[4].Buffer_Addr   := IADDRESS (Flags) ;#   Item_List[4].Return_Addr   := 0 ;   0   Item_List[5].Buffer_Length := SIZE (Def_Dir) ;-   Item_List[5].Item_Code     := UAI$_DEFDIR ; 9   Item_List[5].Buffer_Addr   := IADDRESS (Def_Dir.BODY) ; #   Item_List[5].Return_Addr   := 0 ;   0   Item_List[6].Buffer_Length := SIZE (Def_Dev) ;-   Item_List[6].Item_Code     := UAI$_DEFDEV ;M9   Item_List[6].Buffer_Addr   := IADDRESS (Def_Dev.BODY) ;w#   Item_List[6].Return_Addr   := 0 ;   ?   Item_List[7].Terminator    := 0 ;	{ Terminate the item list }*  I   Rst := $GETUAI (Usrnam := %STDESCR SUBSTR (New_User,1,New_User.LENGTH),e 		  Itmlst := Item_List) ;     Getuai := ODD (Rst) ;i     IF NOT ODD (Rst)  THEN
      BEGIN      IF Rst <> RMS$_RNF  THEN	 	LIB$SIGNAL (Rst) ;h      END    ELSEs
      BEGIN.      Def_Dir.LENGTH := INT (Def_Dir.BODY[1]) ;.      Def_Dev.LENGTH := INT (Def_Dev.BODY[1]) ;=      Def_Dir.BODY := SUBSTR (Def_Dir.BODY,2,Def_Dir.LENGTH) ;l=      Def_Dev.BODY := SUBSTR (Def_Dev.BODY,2,Def_Dev.LENGTH) ;i
      END ;   END ; 	{ of Getuai }    ( PROCEDURE Format_User (Uic : UIC$TYPE) ;  I { Create a string with the UIC in numeric and rights identifier formats }	     VAR  Rst : INTEGER := 0 ;u     BEGIN 	{ Format_User }G   Rst := $FAO ('!%U',Uic_Str.LENGTH,%STDESCR Uic_Str.BODY,%IMMED Uic) ;.   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;.E   Rst := $FAO ('!%I',Id_Str.LENGTH,%STDESCR Id_Str.BODY,%IMMED Uic) ;    IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;    IF Uic_Str = Id_Str  THENM      Eq_Id_Str := ''    ELSE "      Eq_Id_Str := ' = ' + Id_Str ;   END ; 	{ of Format_User }     % PROCEDURE Audit_Jump (Ok : BOOLEAN) ;a  7 { Record who, when, where, etc. for auditing purposes }n     VAR	Rst : UNSIGNED := 0 ; ( 	Imprint : VARYING [120] OF CHAR := '' ; 	Audit : TEXT ;.- 	Stamp : PACKED ARRAY [1..23] OF CHAR := '' ;d     BEGIN 	{ Audit_Jump }dL   OPEN	 (Audit,FILE_NAME:=Audit_Trail,HISTORY:=Unknown,SHARING:=READWRITE) ;   EXTEND (Audit) ;  -   Rst := $ASCTIM (Timbuf := %STDESCR Stamp) ;h   IF NOT ODD (Rst)  THEN      LIB$SIGNAL (Rst) ;r,   IF Stamp[1] = ' '  THEN  Stamp[1] := '0' ;/   Imprint := SUBSTR (Stamp,1,20) + ' ' + User ; 
   IF Ok  THEN.
      BEGIN      Format_User (New_Uic) ;      IF New_User = User  THEN  	Imprint := Imprint + ' from '
       ELSE  	Imprint := Imprint + '  to  ' ;/      Imprint := Imprint + Uic_Str + Eq_Id_Str ;n      END    ELSE	9      Imprint := Imprint + ' PRIV violation: ' + Command ;98   IF Port <> ''  THEN  Imprint := Imprint + ' ' + Port ;@   IF Terminal <> ''  THEN  Imprint := Imprint + ' ' + Terminal ;     WRITELN (Audit,Imprint) ;E   CLOSE (Audit) ;    END ; 	{ of Audit_Jump }      PROCEDURE Validate_User_Record ;  M { For the type of user running the program, validate the requested user's UAF*	   record.*  E   Non-SysProgs (operators) can only jump to users who do not have any .   privileges other than those that are "OK". }  @   CONST  Ok_Privs = [Group,Grpprv,Grpnam,Netmbx,Tmpmbx,Prmceb] ;  !   BEGIN 	{ Validate_User_Record }U   IF NOT Getuai  THEN 
      BEGIN      IF Figment  THENvE 	WRITELN ('%JUMP-W-INVUSER, Invalid username - user does not exist.') 
       ELSE 	BEGING 	WRITELN ('%JUMP-F-INVUSER, Invalid username - user does not exist.') ;c 	$EXIT (RMS$_RNF) ;  	END ;
      END ;     IF Alter_Ego	THEN;
      BEGIN      IF NOT Sysprog  THEN	 	BEGIN 	Audit_Jump (FALSE) ;c 	$EXIT (SS$_NOPRIV) ;5 	END
       ELSE      IF New_User = User  THENe 	BEGIN> 	WRITELN ('%JUMP-I-SAMEUSER, Same username as current (',User, 		 ') - no action taken.') ; 	$EXIT ; 	END ;
      END ;     IF Transmute	THEN /      IF New_Uic.UIC$L_UIC = Uic.UIC$L_UIC  THEN0 	BEGIN 	Format_User (Uic) ;; 	WRITELN ('%JUMP-I-SAMEUIC, Same UIC as current (',Uic_Str,i 		 ') - no action taken.') ; 	$EXIT ; 	END
       ELSE      IF (NOT Sysprog)  AND_THENr 	(New_User <> User) AND_THEN# 	(((Auth_Priv - Ok_Privs) <> []) OR # 	 ((Def_Priv  - Ok_Privs) <> []) ORy/ 	 (New_Uic.UIC$V_GROUP <= Max_Sys_Group))  THENr 	BEGIN8 	WRITELN ('%JUMP-F-PRIVUSER, Username is privileged.') ; 	$EXIT (SS$_NOPRIV) ;	 	END
       ELSE=      IF (Flags.UAI$V_RESTRICTED OR Flags.UAI$V_CAPTIVE)  THEN  	IF Sysprog  THENrD 	   WRITELN ('%JUMP-W-RESTRICT, Username is Restricted or Captive.') 	 ELSE	 	   BEGINoF 	   WRITELN ('%JUMP-F-RESTRICT, Username is Restricted or Captive.') ; 	   $EXIT (SS$_NOPRIV) ; 	   END 
       ELSE!      IF Flags.UAI$V_DISACNT  THEN  	IF Sysprog  THEN 7 	   WRITELN ('%JUMP-W-DISABLED, Username is disabled.')  	 ELSE	 	   BEGINb9 	   WRITELN ('%JUMP-F-DISABLED, Username is disabled.') ;r 	   $EXIT (SS$_NOPRIV) ;	 	   END ;g$   END ; 	{ of Validate_User_Record }    ! [ASYNCHRONOUS] PROCEDURE Getuic ;p  - { In EXEC MODE, peek at the UIC in the PCB. }e     BEGINs$   Sanity_Uic.UIC$L_UIC := Uic_Ptr^ ;   END ;n    ! [ASYNCHRONOUS] PROCEDURE Setuic ;M  0 { In KERNEL MODE, poke a new UIC into the PCB. }     BEGINg!   Uic_Ptr^ := New_Uic.UIC$L_UIC ;v   END ;r    + [ASYNCHRONOUS] PROCEDURE Get_Jib_User_Ptr ;e  - { In EXEC MODE, peek at the JIB in the PCB. }	     BEGINe&   Jib_User_Ptr::UNSIGNED := Jib_Ptr^ ;   END ;u    " [ASYNCHRONOUS] PROCEDURE Getuser ;  L { In EXEC MODE, peek at the Username in the Control Region and in the PCB. }     BEGINb%   Sanity_Ctl_User := CTL$T_USERNAME ;b$   Sanity_Jib_User := Jib_User_Ptr^ ;   END ;b    " [ASYNCHRONOUS] PROCEDURE Setuser ;  P { In KERNEL MODE, poke a new Username into the Control Region and into the PCB.}     BEGIN:#   CTL$T_USERNAME := New_User.BODY ;A#   Jib_User_Ptr^  := New_User.BODY ;s   END ;o     PROCEDURE Wallaby ;k   { Change the username. }     BEGIN 	{ Wallaby }  O   { Check that the username as returned by GETJPI and as peeked at in EXEC MODE )     agree -- do this as a sanity check. }   :   Jib_Ptr::UNSIGNED := CTL$GL_PCB + IADDRESS (PCB$L_JIB) ;'   $CMEXEC (Get_Jib_User_Ptr,%IMMED 0) ;n  P   Jib_User_Ptr::UNSIGNED := Jib_User_Ptr::UNSIGNED + IADDRESS (JIB$T_USERNAME) ;   $CMEXEC (Getuser,%IMMED 0) ;  '   IF (Sanity_Ctl_User <> User.BODY)  ORA)      (Sanity_Jib_User <> User.BODY)  THENR
      BEGINH      WRITELN ('%JUMP-F-INSANEUSER, Sanity Check FAILED for Username!') ;A      WRITELN ('%JUMP-F-USERVALUES, GetJPI = ',User,' Control = ',.3 	      Sanity_Ctl_User,' JIB = ',Sanity_Jib_User) ;n      $EXIT (SS$_ABORT) ;      END    ELSEn!      $CMKRNL (Setuser,%IMMED 0) ;    END ; 	{ of Wallaby }p     PROCEDURE Kangaroo ;  H { Do all that is required to "jump" to the new user, or to return to the   original user. }  (   VAR	Rst , Attributes : UNSIGNED := 0 ;& 	Aclstr : VARYING [64] OF CHAR := '' ;. 	Aclent : PACKED ARRAY [1..32] OF CHAR := '' ;. 	Grptbl : PACKED ARRAY [1..16] OF CHAR := '' ;- 	Item_List : Item_List_Template (3) := ZERO ;      BEGIN 	{ Kangaroo }   J   { Check that the UIC as returned by GETJPI and as peeked at in EXEC MODE)     agree -- do this as a sanity check. }5  :   Uic_Ptr::UNSIGNED := CTL$GL_PCB + IADDRESS (PCB$L_UIC) ;   $CMEXEC (Getuic,%IMMED 0) ;   0   IF Sanity_Uic.UIC$L_UIC <> Uic.UIC$L_UIC  THEN
      BEGINB      WRITELN ('%JUMP-F-INSANEUIC, Sanity Check FAILED for UIC!') ;L      WRITELN ('%JUMP-F-UICVALUES, GetUAI =',HEX (Uic.UIC$L_UIC),' Kernel =',$ 	      HEX (Sanity_Uic.UIC$L_UIC)) ;      $EXIT (SS$_ABORT) ;      END    ELSEU
      BEGINA      $CMKRNL (Setuic,%IMMED 0) ;	{ Change UIC to be target UIC. };  #      { Set new default directory. }S  B      Rst := SYS$SETDDIR (SUBSTR (Def_Dir.BODY,1,Def_Dir.LENGTH)) ;      IF NOT ODD (Rst)  THENA 	LIB$SIGNAL (Rst) ;A        { Set new default disk. }  3      Item_List[1].Buffer_Length := Def_Dev.LENGTH ;D,      Item_List[1].Item_Code	:= LNM$_STRING ;:      Item_List[1].Buffer_Addr	:= IADDRESS (Def_Dev.BODY) ;$      Item_List[1].Return_Addr	:= 0 ;  #      Item_List[2].Terminator	:= 0 ;r  6      Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS',% 		     Lognam := %STDESCR 'SYS$DISK',, 		     Acmode := PSL$C_SUPER,M 		     Itmlst := Item_List) ;U      IF NOT ODD (Rst)  THENR 	LIB$SIGNAL (Rst) ;E  <      { Point LNM$GROUP logical to group table for new UIC. }  #      Attributes := LNM$M_TERMINAL ;S=      Grptbl := 'LNM$GROUP_' + OCT (New_Uic.UIC$V_GROUP,6,6) ;   &      Item_List[1].Buffer_Length := 4 ;0      Item_List[1].Item_Code	:= LNM$_ATTRIBUTES ;8      Item_List[1].Buffer_Addr	:= IADDRESS (Attributes) ;$      Item_List[1].Return_Addr	:= 0 ;  2      Item_List[2].Buffer_Length := SIZE (Grptbl) ;,      Item_List[2].Item_Code	:= LNM$_STRING ;4      Item_List[2].Buffer_Addr	:= IADDRESS (Grptbl) ;$      Item_List[2].Return_Addr	:= 0 ;  #      Item_List[3].Terminator	:= 0 ;a  @      Rst := $CRELNM (Tabnam := %STDESCR 'LNM$PROCESS_DIRECTORY',& 		     Lognam := %STDESCR 'LNM$GROUP', 		     Acmode := PSL$C_KERNEL, 		     Itmlst := Item_List) ;       IF NOT ODD (Rst)  THEND 	LIB$SIGNAL (Rst) ;R  P      { If going to a different UIC, allow the current LNM$JOB logical name tableP        to be accessed by the new UIC.  If returning to original user, remove the'        ACL access previously applied. }:  #      Item_List[2].Terminator := 0 ;p  ;      IF New_User = User  THEN		{ Return to original user. }m 	BEGIN" 	Item_List[1].Buffer_Length := 0 ;/ 	Item_List[1].Item_Code	   := ACL$C_DELETEACL ; " 	Item_List[1].Buffer_Addr   := 0 ;" 	Item_List[1].Return_Addr   := 0 ; 	END
       ELSE 	BEGIN> 	Aclstr := '(IDENTIFIER=' + New_User + ',ACCESS=READ+WRITE)' ;C 	Rst := $PARSE_ACL (Aclstr := SUBSTR (Aclstr.BODY,1,Aclstr.LENGTH),A" 			   Aclent := %STDESCR Aclent) ; 	IF NOT ODD (Rst)  THEN  	   LIB$SIGNAL (Rst) ;  0 	Item_List[1].Buffer_Length := INT (Aclent[1]) ;/ 	Item_List[1].Item_Code	   := ACL$C_ADDACLENT ;O2 	Item_List[1].Buffer_Addr   := IADDRESS (Aclent) ;" 	Item_List[1].Return_Addr   := 0 ; 	END ;  <      Rst := $CHANGE_ACL (Objtyp := ACL$C_LOGICAL_NAME_TABLE, 			 Objnam := 'LNM$JOB', 			 Itmlst := Item_List) ;      IF NOT ODD (Rst)  THENe 	LIB$SIGNAL (Rst) ;g
      END ;   END ; 	{ of Kangaroo }     PROCEDURE Display_Jump ;  * { Display data about the requested jump. }     BEGIN 	{ Display_Jump }r   IF Transmute	THENN
      BEGIN4      WRITELN ('%JUMP-S-JUMPED, ',User,' jumped to ',- 	      New_User,' (',Uic_Str,Eq_Id_Str,')') ;i?      WRITELN ('%JUMP-I-DEFAULT, Default is ',Def_Dev,Def_Dir) ;_
      END ;     IF Alter_Ego	THENtO      WRITELN ('%JUMP-S-SETUSER, Changed username from ',User,' to ',New_User) ;r   END ; 	{ of Display_Jump }    E { * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *mC   * * * * * * * * * *	M A I N   P R O G R A M   * * * * * * * * * * G   * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }S     BEGIN	{ Jump }  ) Rst := LIB$GET_FOREIGN (%DESCR Command) ;m IF NOT ODD (Rst)  THEN    LIB$SIGNAL (Rst) ;t   IF NOT Check_Authority	THEND    BEGIN    Audit_Jump (FALSE) ;[    $EXIT (SS$_NOPRIV) ;     END ;   IF Get_And_Parse_Command  THEN    BEGIN    Validate_User_Record ;P    IF Alter_Ego  THENB       Wallaby ;A    IF Transmute  THEN        BEGINs       Kangaroo ;       IF Auditing  THEN] 	 Audit_Jump (TRUE)         ELSE[ 	 Format_User (New_Uic) ;C       END ;s    IF Log  THEN  Display_Jump ;i    END ;   END.	{ of it all }