 	options    /EXTEND_SOURCE% 	subroutine QIO_KEY(key,row,col,chan)   u c	Return a SMG compatible key code and the screen position of the cursor if either of the mouse buttons were pressed.  c r c	Method: Do a QIOW read with a buffer size of 1 to force all keys to terminate. Enable escape termination too ando c	set up a suitably big overflow buffer to catch the escape sequences. Switch off echo and filtering and use a  t c	prompt string that explicitly enables and requests a one-shot locator position or a keycode in application keypad > c	mode (to get correct key numbers for the extended keyboard). c W c	Programmed to work with all scan-codes from LK201 keyboards in all VT200/VT300 modes.  c O c	Still to do: Extra PC and UNIX (LK421) keyboard codes - if you really must...  c r c	Transparently compatible with both 7-bit and 8-bit controls and both "normal" and "application" cursor key mode. c 9 c	Tested with DECterm in VT300-7bit and VT300-8bit modes. A c	Tested with VT220 and VT240 in VT200-7bit and VT200-8bit modes.  c  c	Should work with VWS (UIS). O c	Could possibly work with VT300-series (with and without the mouse) and VT420.  c Y c	Error conditions: Failure to ASSIGN a channel to TT or doing a QIOW will halt the code. c c	Unknown codes and sequences (whatever they might be) will be returned as key 0 at position (0,0).  c I c	Terminal state on call: No assumptions made other than VT200 or better. a c	Terminal state on completion: Will be in APPLICATION mode (<esc>=) - set to NUMERIC with <esc>>  c S c	Locator state on call: No assumptions made (any position, any number of buttons). Y c	Locator state on completion: May have a pending locator request. Cancel with <csi>0;0'z  c n c	Written by Bernhard Fabricius, Department of Nuclear Physics, Australian National University, September 1992m c	This code may be freely copied, modified and distributed. If you have some good additions or find bugs then 7 c	please let me know via e-mail to BEAR@NUC.ANU.EDU.AU.  c  c " c	Parameter	Type		Access		Functionz c	------------------------------------------------------------------------------------------------------------------------] c	KEY		Integer*4	Write only	Key (SMG code) pressed during QIO (including L/C/R mouse buttons) G c	ROW		Integer*4	Write only	Row of cursor position if mouse was pressed J c	COL		Integer*4	Write only	Column of cursor position if mouse was pressed[ c	CHAN		Integer*4	Read/Write	On call: If 0: a channel to "TT" will be assigned (first time) > c								 If <> 0: no change (use previously assigned channel)= c							On return: The channel to "TT" (only done first time)    	implicit	none  = 	include		'($trmdef)'			!Need the extended mode codes by name  	byte		bbuf(1:32)  	character*32	sbuf  	equivalence	(bbuf(1),sbuf(1:1)) 	character*2	terminal/'TT'/ ; 	integer*4	status, sys$assign, sys$dassgn, sys$qiow, iofunc ' 	integer*4	key, row, col, l, k, i, chan = 	external	io$_readvblk, io$m_noecho, io$m_extend, io$m_escape    	structure	/itemlist/  	  integer*2	buffer_length 	  integer*2	item_code 	  integer*4	buffer  	  integer*4	stop/0/ 	end structure 	record		/itemlist/itml(1:3) 	integer*4	itmsize   	structure	/statusblock/ 	  integer*2	status  	  integer*2	offset  	  byte		term_char 	  byte		reserved  	  byte		term_length 	  byte		cp_eol  	end structure 	record		/statusblock/iosb	   " 	integer*2       tilde(1:34)/34*0/ 	integer*2	o_low(108:121)/14*0/   8 c       Editing keys              E1  E2  E3  E4  E5  E68 c       <esc>[i~ keys              1   2   3   4   5   6/ 	data	(tilde(i),i=1,6)/311,312,313,314,315,316/   i c       Top row function keys      F6  F7  F8  F9 F10     F11 F12 F13 F14    HELP  DO     F17 F18 F19 F20 i c       <esc>[i~ keys              17  18  19  20  21   -  23  24  25  26   -  28  29   -  31  32  33  34 ` 	data	(tilde(i),i=17,34)/25,287,288,289,290,000,291,292,293,294,000,295,296,000,297,298,299,300/  \ c       Keypad keys                    ,   -   .       0   1   2   3   4   5   6   7   8   9\ c       <esc>Oi  keys                  l   m   n   -   p   q   r   s   t   u   v   w   x   yS 	data	(o_low(i),i=108,121)/272,271,273,000,260,261,262,263,264,265,266,267,268,269/   n 	character*12	mouse		!enable and request one-shot locator position in cell units using application keypad modeZ 	mouse(1:12)=char(155)//'2;2'//char(39)//'z'//char(155)//'1'//char(39)//'{'//char(27)//'='  / 	if(chan.eq.0)then						!No channel specified - 3 	  status = sys$assign(terminal,chan,,)				!get one . 	  if(.not.status) call lib$stop(%val(status)) 	end if    	itml(1).buffer_length = 09 	itml(1).item_code = trm$_modifiers				!Modify to include o 	itml(1).buffer = trm$m_tm_noecho.or.trm$m_tm_escape.or.trm$m_tm_nofiltr		!no echo, no filter, escape terminate  	itml(2).buffer_length = 0G 	itml(2).item_code = trm$_esctrmovr				!Allow an escape overflow buffer L 	itml(2).buffer = 31						!of 31 characters (buffer is 32 characters in all)  	itml(3).buffer_length = 12					C 	itml(3).item_code = trm$_prompt					!Allow prompt of 12 characters ; 	itml(3).buffer = %loc(mouse)					!use mouse request string   8 	itmsize = 36							!There are 36 bytes in the item list  W 	iofunc = %loc(io$_readvblk).or.%loc(io$m_extend)		!Read virtual block in extended mode   I c	[efn], chan, func, iosb, [astadr], [astprm], p1, p2, [p3], [p4], p5, p6 a 	status = sys$qiow( , %val(chan), %val(iofunc), iosb, , , bbuf, %val(32), , ,itml ,%val(itmsize)) , 	if(.not.status) call lib$stop(%val(status))   	row=0								!Row is 0  	col=0								!Column is 0 	key=0								!Key is 0 O 	if(iosb.offset.eq.1.or.iosb.term_length.eq.1)then		!ASCII char or control char I 	  key=zext(bbuf(1))						!Use as read (but zero-extended for ISO-Latin1) 	 	  return " 	else								!Some escape sequence* 	  l=iosb.term_length						!Length thereofe 	  if(iosb.term_char.eq.-101.or.iosb.term_char.eq.-113)then	!<csi> (155) or <ss3> (143): 8-bit escape % 	    do k=l,2,-1							!Shuffle along 0 	      bbuf(k+1)=bbuf(k)						!Move to the right 	    end do 9 	    bbuf(2)=91							!Add [ in position 2 (never mind 1)  	    l=l+1							!Update length 	 	  end if ) 	  if(sbuf(l:l).eq.'~')then					!<esc>[k~ 1 	    read(sbuf(3:l-1),*,err=100)k				!Try to read 6 	    if(k.gt.34.or.k.lt.1)go to 100				!Must be 1<k<345 	    key=tilde(k)						!read back SMG code from array  100	    continue 	    return A 	  else if(l.eq.3.and.(sbuf(2:2).eq.'O'.or.sbuf(2:2).eq.'['))then C c	    Codes of the type <esc>Ok or <esc>[k (either Cursor Key Mode) / 	    k=ichar(sbuf(3:3))						!get the character 7 	    if(k.ge.108.and.k.le.121)then				!lowercase l to y 7 	      key=o_low(k)						!read back SMG code from array 
 	      return ? 	    end if							!Deal with the UPPERCASE codes by brute force # 	    if(k.eq.65)key=274						!A: Up % 	    if(k.eq.66)key=275						!B: Down & 	    if(k.eq.67)key=277						!C: Right% 	    if(k.eq.68)key=276						!D: Left & 	    if(k.eq.77)key=270						!M: Enter$ 	    if(k.eq.80)key=256						!P: PF1$ 	    if(k.eq.81)key=257						!Q: PF2$ 	    if(k.eq.82)key=258						!R: PF3$ 	    if(k.eq.83)key=259						!S: PF4 	    return L 	  else if(sbuf(l-1:l).eq.'&w')then				!<esc>[Pe;Pb;Pr;Pc;Pp&w - mouse codes 	    do k=3,l-2 F 	      if(bbuf(k).eq.59)bbuf(k)=44				!Replace ; with , to enable read 	    end do c 	    read(sbuf(3:l-2),*,err=200)k,i,row,col			!Read 4 integers (Pb is not used, ignore Pp if given) P 	    key=320+k/2							!Pe is 2, 4 or 6 for LEFT, MIDDLE and RIGHT respectively H 200	    continue							!The corresponding SMG codes are 321, 322 or 323. 	    return _ 	  else if(l.eq.2.and.bbuf(2).eq.27)then				!Final possibility: <esc> (^[) itself is <esc><esc>  	    key=27 	 	  end if  	end if    	end