C	VT100 VIDEO DISPLAY COMMAND PROGRAM. CALLING SEQUENCE IS
C	CALL UVT100(CMD,N1,N2), WHERE CMD IS ONE OF THE COMMANDS IN
C	THE PARAMETER LIST BELOW, AND N1 AND N2 ARE OPTIONAL PARAMETERS
C	DEPENDING UPON CMD. SEE THE UVT100 USER'S MANUAL FOR MORE DETAILS.
C
C SCREEN INDEPENDENT VARIANT FOR PORTACALC ONLY. UVT100 COMPATIBLE
C  (MORE OR LESS). IF THE TERMINAL DOES NOT HAVE REVERSE VIDEO, IT USES
C  THE LEFTMOST COLUMN OF A CELL TO HOLD A SPECIAL CHARACTER (">" IN THIS
C  CASE) TO INDICATE ONE'S POSITION ON THE SCREEN. BY MAIN FORCE &
C  AWKWARDNESS IT WILL MOVE THIS AROUND WHEREVER NEEDED. ONLY ENTRIES
C  CALLED BY PORTACALC ARE SUPPORTED HERE, MANY AS NO-OPS.
C	THIS VERSION MAY BE USED ONLY ON VAX; ITS OUTPUT IS
C  STRICTLY FORTRAN I/O TO LOGICAL UNIT 6.
C
C	AUTHOR:	GLENN EVERHART
C		LARRY W. FINGER - SCREEN INDEPENDENT VERSION
C
      SUBROUTINE UVT100 ( CMD, N1, N2 )
      IMPLICIT INTEGER ( A - Z )
	INCLUDE 'VKLUGPRM.FTN'
      PARAMETER CUP = 1, CUU = 2, CUD = 3, CUF = 4, CUB = 5, DECDWL = 6
     $, DECDHL = 7, DECRC = 8, DECSC = 9, DECSWL = 10, ED = 11, EL = 12
     $, SGR = 13, NEL = 14, SCS = 15, SM = 16, RM = 17, ANSI = 18
      BYTE OUTBUF ( 4 )
	LOGICAL*1 FVLD
	DIMENSION FVLD(RRW,RCL)
	COMMON /FVLDC/FVLD
	InTEgeR*4 PROW,PCOL,DROW,DCOL,DRWV,DCLV
	InTEgeR*4 LLCMD,LLDSP
	COMMON/DCTL/PROW,PCOL,DROW,DCOL,DRWV,DCLV,LLCMD,LLDSP
	InTEgeR*4 S7FLG,SCFG
	DATA IFIRST/0/
C
	IF(IFIRST.EQ.0)THEN
C GET TERMINAL INFORMATION AND SET KVTINC NONZERO IF VT100
	  KVTINC=0
	  CALL LIB$SCREEN_INFO(SCFG)
	  IF((SCFG.AND.2).NE.0)KVTINC=1
	  IFIRST=1
	END IF
C
	IF(.NOT.((CMD.EQ.SCS).OR.(CMD.EQ.ANSI).OR.(CMD.EQ.RM)
	1.OR.(CMD.EQ.SM)))GO TO 1000
C
C IGNORE SELECT CHARACTER SET, ANSI, RESET MODE, AND SET MODE ENTRIES
C
	SCFG=0
	RETURN
1000	IF(CMD.NE.CUP)GO TO 1010
C POSITION CURSOR
	CALL LIB$SET_CURSOR(N1,N2)
C SAVE COORDINATES
	SAVELINE=N1
	SAVECOLUMN=N2
	SCFG=1
	RETURN
1010	IF(CMD.NE.ED)GO TO 1020
C ERASE ENTIRE DISPLAY
	CALL LIB$ERASE_PAGE(1,1)
	SCFG=0
	RETURN
1020	IF(CMD.NE.EL)GO TO 1030
C ERASE LINE
	IF(N1.EQ.0)I=LIB$ERASE_LINE()
	IF(N1.EQ.2)I= LIB$ERASE_LINE(SAVELINE,1)
	IF(.NOT.I)CALL LIB$SIGNAL(%VAL(I))
	SCFG=0
	RETURN
1030	IF(CMD.NE.SGR)GO TO 1060
C SET GRAPHICS RENDITION
	IF(KVTINC.NE.0)GO TO 1050
C
C NOT VT100
	IF(N1.NE.7)GO TO 1040
	IF(SCFG.NE.1)RETURN
	IF(PROW.LE.0.OR.PCOL.LE.0)RETURN
	IF(PROW.GT.RRW.OR.PCOL.GT.RCL)RETURN
	IF(FVLD(PROW,PCOL).EQ.0)RETURN
C LOCATION VALID
	CSAVE=SAVECOLUMN
	RSAVE=SAVELINE
	S7FLG=1
	RETURN
C SGR ARGUMENT NOT 7
1040	IF(SCFG.NE.1)RETURN
	IF(S7FLG.NE.1)RETURN
C REPOSITION CURSOR
	CALL LIB$SET_CURSOR(RSAVE,CSAVE)
	WRITE(6,2)
2	FORMAT('>')
	CALL LIB$SET_CURSOR(SAVELINE,SAVECOLUMN)
	S7FLG=0
	RETURN
C VT100 TERMINAL - SET REVERSE VIDEO IF N1=7, CLEAR OTHERWISE
1050	OUTBUF(1)=27
	OUTBUF(2)='['
	IF(N1.EQ.7)THEN
	  OUTBUF(3)='7'
	ELSE
	  OUTBUF(3)='0'
	END IF
	OUTBUF(4)='m'
C REMOVE BACKSPACE THAT MADE IT NECESSARY TO HAVE JVTINC NONZERO
C SO USE PARAMETER JVTINC=0 WITH THIS ALWAYS.
C	OUTBUF(5)=8
	WRITE(6,4)OUTBUF
4	FORMAT(4A1)
	RETURN
C IGNORE ALL OTHER CODES
1060	RETURN
	END
