#include	<Xm/Xm.h>
#include	<Xm/MessageB.h>
#include	"globaldefs.h"
#include	"utils.h"

char	*errorstring ;

void		FixSize(shell, client_data, event)
Widget		shell ;
XtPointer	client_data ;
XConfigureEvent	*event ;
{
    if (event->type == ConfigureNotify)	{
/*	printf("width = %d, height = %d\n", event->width, event->height) ; */
	XtVaSetValues(shell, XmNminWidth, event->width,
	    XmNmaxWidth, event->width, XmNminHeight, event->height,
	    XmNmaxHeight, event->height, NULL) ;
	XtRemoveEventHandler(shell, StructureNotifyMask, False,
	    (XtEventHandler)FixSize, NULL) ;
    }
}

void	Doerror(parent, text, error)
Widget	parent ;
char	*text, *error ;
{
    static Widget	dialog ;
    XmString		label1, label2 ;

    if (!dialog)	{
	dialog = XmCreateErrorDialog(parent, "error", NULL, 0) ;
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON)) ;
	label1 = XmStringCreateSimple("  OK  ") ;
	label2 = XmStringCreateSimple("Help") ;
	XtVaSetValues(dialog, XmNokLabelString, label1,
	    XmNhelpLabelString, label2, NULL) ;
	XmStringFree(label1) ;
	XmStringFree(label2) ;
    }
    if (error)	{
	errorstring = error ;
	XtAddCallback(dialog, XmNhelpCallback, (XtCallbackProc)Dohelp,
	    parent) ;
	XtManageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON)) ;
    }
    else
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON)) ;
    label1 = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET) ;
    XtVaSetValues(dialog, XmNmessageString, label1, NULL) ;
    XmStringFree(label1) ;
    XtManageChild(dialog) ;
}

void	Dohelp(w, parent)
Widget		w ;
Widget		parent ;
{
    static Widget	dialog ;
    XmString		label ;

    if (!dialog)	{
	dialog = XmCreateInformationDialog(parent, "help_dialog", NULL, 0) ;
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON)) ;
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON)) ;
	label = XmStringCreateSimple("  OK  ") ;
	XtVaSetValues(dialog, XmNokLabelString, label, NULL) ;
	XmStringFree(label) ;
    }
    label = XmStringCreateLtoR(errorstring, XmSTRING_DEFAULT_CHARSET) ;
    XtVaSetValues(dialog, XmNmessageString, label, NULL) ;
    XmStringFree(label) ;
    XtManageChild(dialog) ;
}

void	Usage()
{
    fprintf(stderr, "usage: kp [options] [filename]\n") ;
    fprintf(stderr, "where options are:\n") ;
    fprintf(stderr, "  -showkeytop or -kt:   show keytop symbols\n") ;
    fprintf(stderr, "  +showkeytop or +kt:   don't show keytop symbols\n") ;
    fprintf(stderr,
	    "  -shownextkey or -nk:  show next key in reversevideo\n") ;
    fprintf(stderr, "  +shownextkey or +nk:  don't show next key\n") ;
    fprintf(stderr, "  -ignorecases or -ic:  case insensitive\n") ;
    fprintf(stderr, "  +ignorecases or +ic:  case sensitive\n") ;
    fprintf(stderr, "  -dvorak:              practice Dvorak keyboard\n") ;
    fprintf(stderr, "  -qwerty:              practice qwerty keyboard\n") ;
    fprintf(stderr, "  -physical dvorak:     your keyboard is dvorak\n") ;
    fprintf(stderr, "  -physical qwerty:     your keyboard is qwerty\n") ;
    fprintf(stderr, "  -vendor name:         your keyboard is made by vendor \"name\"\n") ;
    fprintf(stderr, "                        (where \"name\" is one of Sun, HP, DEC, PC or Kinesis)\n") ;
    fprintf(stderr, "as well as all the X Toolkit options (try \"man X\")\n") ;
}

#ifdef _NO_PROTO
void *xmalloc(size)
size_t size ;
#else
void *xmalloc(size_t size)
#endif
{
    void *vp = malloc(size) ;
    if (vp == NULL)	{
	fprintf(stderr, "Panic: memory exausted in xmalloc()\n") ;
	exit(2) ;
    }
    return (vp) ;
}

#ifdef _NO_PROTO
void *xrealloc(p, size)
void *p ;
size_t size ;
#else
void *xrealloc(void *p, size_t size)
#endif
{
    p = realloc(p, size) ;
    if (p == NULL)	{
	fprintf(stderr, "Panic: memory exausted in xrealloc()\n") ;
	exit(2) ;
    }
    return (p) ;
}

/* strcasecmp() doesn't exist on all systems */
#ifdef _NO_PROTO
int casecmp(a, b)
char *a, *b ;
#else
int casecmp(char *a, char *b)
#endif
{
    while (TRUE)	{
	if (*a == '\0')
	    if (*b == '\0')		return (0) ;
	    else			return (-1) ;
	if (*b == '\0')			return (1) ;
	if (tolower(*a) < tolower(*b))	return (-1) ;
	if (tolower(*a) > tolower(*b))	return (1) ;
	a++ ;
	b++ ;
    }
}

#ifdef ultrix
#ifdef _NO_PROTO
char *strdup(s)
char *s ;
#else
char *strdup(char *s)
#endif /* _NO_PROTO */
{
    return (strcpy(xmalloc(strlen(s)+1), s)) ;
}

#endif /* ULTRIX */
