/*
 * File:       deflection.c
 * Author:     Eric Van Gestel
 *
 * For:                xblockbuster
 *
 * No changes required for X11 support - MSW
 *
 * Implementation:
 *     Simple horizontal and vertical deflection only changes the quadrant,
 *     reversing motion along the y and x axes respectively.
 *     Deflection from the convex pallet is a function of excentricity,
 *     as well as of incoming angle (given a sliding of the edge effect).
 */

#include "xblockbuster.h"

void brick_deflection( hit, ball )
	register int    hit;	/* enumeration { HORIZONTAL, VERTICAL } */
	register struct Ball *ball;
{
	if ( hit == HORIZONTAL ) {
		switch ( ball->quadrant ) {
		case NE:
			ball->quadrant = SE;
			break;
		case NW:
			ball->quadrant = SW;
			break;
		case SW:
			ball->quadrant = NW;
			break;
		case SE:
			ball->quadrant = NE;
		}
		ball->y_speed = -( ball->y_speed );
	} else {		/* VERTICAL */
		switch ( ball->quadrant ) {
		case NE:
			ball->quadrant = NW;
			break;
		case NW:
			ball->quadrant = NE;
			break;
		case SW:
			ball->quadrant = SE;
			break;
		case SE:
			ball->quadrant = SW;
		};
		ball->x_speed = -( ball->x_speed );
	}
}

void pallet_deflection( ball )
	register struct Ball *ball;
{
	double          excentricity, true_angle;

	switch ( ball->quadrant ) {
	case SW:
		excentricity = ball->x - pallet_x;
		break;
	case SE:
		excentricity = pallet_x - ball->x;
		break;
	default:
		return;		/* bouncing up from below */
	};
	ball->angle -= 2 * atan2( excentricity, pallet_height );

	if ( ball->angle > -M_PI_4 )
		ball->quadrant = ( ball->quadrant == SW ) ? NW
			 /* SE */ : NE;
	else {			/* rebound */
		ball->angle = -M_PI_2 - ball->angle;
		ball->quadrant = ( ball->quadrant == SW ) ? NE
			 /* SE */ : NW;
	};

	/*
	 * avoid downward slide offs as well as infinite horizontal bounce
	 * loops
	 */
	if ( ball->angle > NEAR_HORIZONTAL )
		ball->angle = NEAR_HORIZONTAL;

	true_angle = ( ball->quadrant == NE ) ? M_PI_4 - ball->angle
		 /* NW */ : M_PI_3_4 + ball->angle;
	ball->x_speed = ball->speed * cos( true_angle );
	ball->y_speed = ball->speed * -sin( true_angle );
}

#ifdef DEBUG_PDEFL
main(  )
{
	pallet_xI = 0;
	pallet_x = 0;
	printf( "\npallet_length & pallet_height:  " );
	scanf( "%d%d", &pallet_lengthI, &pallet_heightI );
	pallet_length = ( double ) pallet_lengthI;
	pallet_height = ( double ) pallet_heightI;
	if ( pallet_lengthI > 0 && pallet_heightI > pallet_lengthI )
		for ( ;; ) {
			printf( "\nquadrant, in angle & excentricity:  " );
			scanf( "%d%lf%lf", &ball1.quadrant, &ball1.angle, &ball1.x );
			if ( ball1.quadrant < 1 || ball1.quadrant > 4 ||
			     ball1.angle < -45 || ball1.angle > 45 ||
			ball1.x < -pallet_length || ball1.x > pallet_length )
				break;
			ball1.angle = ( ball1.angle / 45 ) * M_PI_4;
			pallet_deflection( ball1 );
			ball1.angle = ( ball1.angle * 45 ) / M_PI_4;
			printf( "==> quadrant: %d  angle: %f\n", ball1.quadrant, ball1.angle );
		};
}
#endif DEBUG_PDEFL
