/*
 * File:       save.c
 * Author:     Eric Van Gestel
 *
 * For:                xblockbuster
 * Updated for X11 by Mark S. Wedel
 *
 */

#include "xblockbuster.h"

void start_up(  )
{
	FILE           *fd;
	char            sve[SAVEFILE_LENGTH];
	register int    stage_nb_tmp;

	sprintf(sve, SAVEFILE, playground, login );
	if ((fd = fopen(sve, "r+"))) {
		/* restoring save file */
		XDrawImageString(display, win, gc, OFFSET_BALLS,
			font_height, "Restoring...",12);

		fscanf( fd, "%d:%d::%d:%d::%d:%lf\n",
			&score, &balls_left,
			&nb_stages, &stage_nb,
			&pallet_modif, &launch_speed );
		for ( stage_nb_tmp = 0; stage_nb_tmp < MAX_NB_STAGES; )
			fscanf( fd, "%1d", &stages[stage_nb_tmp++] );
		fclose( fd );
		/* remove save file */
		unlink( sve );
		/* restart stage chosen when saved */
		get_stage(  );
	} else {
		/* no save file */
		score = 0;
		balls_left = INIT_BALLS;
		pallet_modif = 0;
		launch_speed = INIT_SPEED;
		nb_stages = 0;
		for ( stage_nb_tmp = 0; stage_nb_tmp < MAX_NB_STAGES; )
			stages[stage_nb_tmp++] = FALSE;
		/* start some stage */
		new_stage(  );
	}
}

void save(  )
{
	FILE           *fd;
	char            sve[SAVEFILE_LENGTH];
	register int    stage_nb_tmp = 0;

	sprintf( sve, SAVEFILE, playground, login );
	if ( !( fd = fopen(sve, "w" ))) {
		perror( "Can't open save file" );
		exit( 1 );
	}
	fprintf( fd, "%d:%d::%d:%d::%d:%f\n",
		 score, balls_left,
		 nb_stages, stage_nb,
		 pallet_modif, launch_speed );
	for ( stage_nb_tmp = 0; stage_nb_tmp < MAX_NB_STAGES; )
		fprintf( fd, "%1d", stages[stage_nb_tmp++] );
	fclose( fd );

	show_score_board(  );	/* BYE !! */
}
