/*
 * File:       score.c
 * Author:     Eric Van Gestel
 * Updated for X11 by Mark S. Wedel
 *
 * For:                xblockbuster
 *
 * Implementation:
 *     Upto USER_SCORES scores are logged per user.
 *     The insertion low point (i.e., the entry that will disappear) is defined
 *     to be either the user's previous save entry, or his USER_SCORES'th entry
 *     or the last entry if neither exists.
 *     Sometimes saved scores may not be completed
 *     (e.g, if the game crashed or if the player Quit explicitly).
 *     Such entries are given a negative number of balls when detected
 *     (criterium: score not bettered).
 */

#include "xblockbuster.h"
#include "lock.h"

struct Score {
	int             score, balls_left;
	char            login[9];
}               score_board[NB_SCORES];

void center_text(offset, message )
int offset;
char *message;
{
        XDrawImageString(display, win, gc, 
            ( STAGE_WIDTH_IN_PIXELS - strlen( message ) * font_width ) / 2,
                BORDER + ( 4 + offset ) * font_height, 
                message, strlen(message));
}


void show_score_board(  )
{
	register int    lows, s, ns,scorenum=0;
	int		update = FALSE,made_it = FALSE,width=0;
	FILE           *fd;
	char            buf[PATH_LENGTH];

	XClearWindow(display,win);

	/* initalize score board (in case it would be empty) */
	for ( s = 0; s < NB_SCORES; s++ ) {
		score_board[s].score = 100;
		score_board[s].balls_left = 0;
		( void ) strcpy( score_board[s].login, "computer" );
	}

	/* read the score file into the array */
#ifdef VMS
       strcpy  (buf, SCOREFILE);
#else
	sprintf( buf, SCOREFILE, playground );
#endif

#ifdef LOCK_FILE
	if (LockScoreFile(buf) == -1)
	  exit(1);
#endif

	if ( !( fd = fopen(buf, "r+" ) ) ) {
		perror( "No score file" );
		exit( 1 );
	}

#ifdef LOCK_FCNTL
	if (LockFile(fileno(fd)) == -1)
	  exit(1);
#endif

	for ( s = 0; s < NB_SCORES; s++ ) {
		fscanf( fd, "%d:%d:%s\n", &score_board[s].score,
			&score_board[s].balls_left,
			score_board[s].login );
	}

	/* find insertion low point */
	for ( lows = ns = 0; lows < NB_SCORES - 1; lows++ ) {
		if ( !strcmp( score_board[lows].login, login ) ) {
			if ( score_board[lows].balls_left > 0 ) {
				if ( score_board[lows].score > score ) {
					/*
					 * an older incomplete game: complete
					 * it
					 */
					score_board[lows].balls_left *= -1;
					ns++;
					update = TRUE;
				} else
					/* (presumably) the previous save */
					break;
			} else
				/* an older completed game */
				ns++;
			if ( ns >= USER_SCORES )
				break;
		}
	}

	/* find insertion high point */
	for ( s = 0; s <= lows && score_board[s].score > score; s++ );

	/* check to see if current score made it */
	if ( s <= lows ) {
		/* yes it did , so shift smaller scores */
		for (  /* lows = lows */ ; lows > s; lows-- )
			score_board[lows] = score_board[lows - 1];
		score_board[s].score = score;
		score_board[s].balls_left = balls_left;
		( void ) strcpy( score_board[s].login, login );
		update = TRUE;
		made_it = TRUE;
		scorenum=s;
	}
	/* write updated score board */
	if ( update ) {
		rewind( fd );
		for ( s = 0; s < NB_SCORES; s++ ) {
			fprintf( fd, "%d:%d:%s\n", score_board[s].score,
				 score_board[s].balls_left,
				 score_board[s].login );
		}
	}

#ifdef LOCK_FCNTL
	UnlockFile(fileno(fd));
#endif

	fclose( fd );

#ifdef LOCK_FILE
	UnlockScoreFile(buf);
#endif

	/* show score board */
	center_text( 0, "Top Scores" );
	for ( s = 0; s < NB_SCORES; s++ ) {
		if (score_board[s].balls_left==0)
			sprintf( buf, "%7d         %8s ",
				score_board[s].score, score_board[s].login);
		else {
			if (abs(score_board[s].balls_left)>99) width=3;
			else if (abs(score_board[s].balls_left)>9) width=2;
			else if (abs(score_board[s].balls_left)>0) width=1;

		
			sprintf( buf, "%7d %.*s(%*d) %c %8s ",
				score_board[s].score, (3-width),"    ",
				width, abs(score_board[s].balls_left),
				score_board[s].balls_left>0 ? ' ' : '+',
				score_board[s].login);
		}
		center_text(s+2, buf);
		if ((s==scorenum) && made_it)
		    XDrawImageString(display,win,gc,
			(STAGE_WIDTH_IN_PIXELS - strlen(buf)*font_width)/2 
			-4*font_width,
			BORDER+ (6+s)*font_height, ">>> ",4);
	}
			



	/* make sure the current score is on the board */
	if ( !made_it ) {
		if (balls_left==0) 
			sprintf( buf, "%7d    <>   %8s ", score, login );
		else {
			if (balls_left >99) width=3;
			else if (balls_left >9) width=2;
			else if (balls_left >0) width=1;
		
			sprintf( buf, "%7d %.*s(%*d)   %8s ",
				score, (3-width),"    ",
				width, balls_left, login);
		}
		center_text( NB_SCORES +3, buf);
	}
	/* show the current pallet shrinkage */
	sprintf( buf, "pallet >>> %2d %% <<<",
		( pallet_modif * 100 ) / PALLET_DENOMINATOR );
	center_text( NB_SCORES + 5, buf);

	XFlush(display);

	/* provide some time to read */
	sleep( 9 );
	XCloseDisplay(display);
	exit( 0 );		/* BYE !! */
}
