/*
 * File:       stage.c
 * Author:     Eric Van Gestel
 * Updated for X11 by Mark S. Wedel
 *
 * For:                xblockbuster
 */

#include "xblockbuster.h"

void get_stage(  )
{
	FILE           *fd;
	char            buf[MAX_COL + 3], stg[STAGEFILE_LENGTH];
	register int    row, col, tmp;
	register char   code;
#ifndef VMS
	extern int errno;
	extern char *sys_errlist[];
#endif

	nbricks = 0;
	score_incr = 1;
	loop_nhits = 0;
	last_busted_brick = NULL;

	/* open next stage file */
	sprintf( stg, STAGEFILE, playground, stage_nb );
	if ( !( fd = fopen(stg, "r"))) {
#ifndef VMS
		fprintf(stderr, "Can't open stage %d, error %s\n",
			stage_nb, sys_errlist[errno]);
#else
		fprintf(stderr, "Can't open stage %d\n",
			stage_nb);
#endif
		exit( 1 );
	}
	/* clear msg, but leave the top line so the bonus remains on screen */
	XFillRectangle( display,win, gc_erase,
		font_height+5, STAGE_WIDTH_IN_PIXELS - 1, 
		MSG_HEIGHT, STAGE_WIDTH_IN_PIXELS -1);

	/* read stage name */
	fscanf( fd, "%s\n", stage_name );
	for ( tmp = 0; stage_name[tmp]; tmp++ )
		if ( stage_name[tmp] == '_' )
			stage_name[tmp] = ' ';
	for (  /* tmp = tmp */ ; tmp < NAME_LENGTH - 1; tmp++ )
		stage_name[tmp] = ' ';
	stage_name[NAME_LENGTH - 1] = '\0';
	XDrawImageString(display, win, gc, OFFSET_SPEED, font_height*2,
		stage_name, strlen(stage_name));

	/* read pallet dimensions */
	fscanf( fd, "%d%d\n", &pallet_lengthI, &pallet_heightI );
	if ( pallet_lengthI < SHORT_PALLET_LENGTH ||
	     pallet_lengthI > LONG_PALLET_LENGTH ||
	     pallet_heightI < pallet_lengthI ||
	     pallet_heightI > MAX_PALLET_HEIGHT ) {
		perror( "Inconsistent pallet dimensions" );
		exit( 1 );
	}
	/* modify for difficulty level */
	pallet_lengthI -= ( pallet_modif * pallet_lengthI ) / PALLET_DENOMINATOR;
	if ( pallet_lengthI < MIN_PALLET_LENGTH )
		pallet_lengthI = MIN_PALLET_LENGTH;
	if ( pallet_lengthI > MAX_PALLET_LENGTH )
		pallet_lengthI = MAX_PALLET_LENGTH;
	if ( pallet_heightI < pallet_lengthI )
		pallet_heightI = pallet_lengthI;
	pallet_length = ( double ) pallet_lengthI;
	pallet_height = ( double ) pallet_heightI;

	/* read stage map */
	for ( row = 0; row <= MAX_ROW; row++ ) {
		if ( !fgets( buf, MAX_COL + 3, fd ) ) {
			perror( "Can't read stage" );
			exit( 1 );
		}
		for ( col = 0; col <= MAX_COL; col++ ) {
			code = buf[col];
			if ( IS_HIT_BRICK( code ) )
				nbricks++;
			switch ( code ) {
			case '/':
				launch_quadrant = NE;
				launch_row = row;
				launch_col = col;
				launch_x = ( double ) ( COL_X( col + 1 ) );
				launch_y = ( double ) ( ROW_Y( row ) );
				break;
			case '\\':
				launch_quadrant = NW;
				launch_row = row;
				launch_col = col;
				launch_x = ( double ) ( COL_X( col ) );
				launch_y = ( double ) ( ROW_Y( row ) );
				break;
			case '^':
				emit_row = row;
				emit_col = col;
			}
			stage[row][col].code = code;
			stage[row][col].nhits = 0;
		}
	}
	fclose( fd );
	XClearWindow(display, win);

	/* draw new stage */
	for ( row = 0; row <= MAX_ROW; row++ ) {
		draw_brick0( row, 0 );
		for ( col = 1; col < MAX_COL; col++ )
			draw_brick( row, col );
		draw_brick0( row, MAX_COL );
	}

	/* reset pallet location */
	pallet_y = ( double ) ( pallet_yI = PALLET_MAX_Y + 4 );
	pallet_row = MAX_ROW - 1;
	if (extra_draw) draw_pallet(gc_xor );

	/* ready ? */
	XDrawImageString(display, win, gc, OFFSET_BALLS, font_height*2,
	      "Press right mouse button when ready; Escape to save.      ",60);

}

void new_stage(  )
{
	FILE           *fd;
	register int    stage_index, stage_nb_tmp;
	char		buf[STAGEFILE_LENGTH], buf2[2*STAGEFILE_LENGTH];

	/* go faster or make the pallet smaller */
	if ( launch_speed < MAX_SPEED )
		launch_speed += SPEED_INCR;
	else
		pallet_modif += PALLET_INCR;

	/* determine stage number */
	if ( !nb_stages ) {
		/* read number of available stages */
		sprintf( buf, NB_STAGESFILE, playground );
		if ( !( fd = fopen( buf, "r"))) {

			sprintf( buf2, "Can't open number of stages file <%s>",
					 buf );
			perror(buf2);
			exit( 1 );
		}
		fscanf( fd, "%d", &nb_stages );
		fclose( fd );
		/* clear stages memory */
		for ( stage_nb_tmp = 0; stage_nb_tmp < MAX_NB_STAGES; )
			stages[stage_nb_tmp++] = FALSE;
	}
	/* search for stage index'th available stage number */
	stage_index = ( int ) ( RAND(  ) ) % nb_stages--;
	if ( stage_index < 0 )
		stage_index = -stage_index;
	for ( stage_nb = 0; stages[stage_nb]; )
		stage_nb++;
	while ( stage_index-- ) {
		while ( stages[++stage_nb] );
	}
	stages[stage_nb] = TRUE;

	get_stage(  );
}
