/*
 * Xblockbuster should run on any X11 system (bw or color) - MSW
 *
 *****************************************************************************
 * Appearance ONLY shamelessly stolen from the real video game,
 * wonderfully written by someone somewhere (I haven't got the foggiest).
 *
 * Move mouse to move pallet and keep the ball on the stage.
 *
 * Stages are built from various building blocks, some of which are based on
 * recollection from analogous blocks in the video game, others, in particular
 * the interesting ones, are new.
 *
 * The stages can be defined from the ascii map codes using any text editor.
 * They must be numbered consecutively from 0 with the total number
 * (i.e., one more than the highest number) available in the file nb_stages.
 *
 * -- Eric Van Gestel (ericvg@cs.kuleuven.ac.be)
 */

#include "xblockbuster.h"

#ifdef VMS
#include "unix_types.h"
#include "unix_time.h"
#include "dir.h"
#include "dirent.h"
#ifdef __DECC
#if __DECC_VER < 50200000
#include "stat.h"
#endif
#endif
#else
#include <sys/dir.h>
#endif

#include <sys/stat.h>
#include <signal.h>

#include "icons/blockbuster.icon"
#include "patchlevel.h"

int timer_active=FALSE;	/* has the user started the ball? */
static char *disp=NULL, *play="default";
static int winposx=0, winposy=0,geomask,no_pause=FALSE;


#ifdef Mips
#define S_ISDIR(m)      (((m)&S_IFMT) == S_IFDIR)
#endif

void event_handler()
{
	XEvent	e;
	int	row,col,sleeptime;
	double	old_pallet_y;
	char	keystr[2],str[10];
	struct	timeval	tp,oldtp;
	struct 	timezone tzp;
	int	window_active=FALSE;	/* is the pointer in the window? */

    gettimeofday(&oldtp,&tzp);
    draw_pallet(gc_xor);
    while(1) {
	/* timer function to keep things moving at a constant speed.
	We read time before servicing events so that the amount of time
	it takes to perform the event should not slow down/speed up
	the game.  Note that other factors may control speed of the
	game (such as available cpu).  Even on my unloaded sun 3/60, I
	notice that many times that sleeptime was negative, even though
	the program uses less than 20% of the cpu time- MSW*/

	gettimeofday(&tp, &tzp);
	sleeptime = ITIMER_DELAY - ((tp.tv_sec - oldtp.tv_sec)*1000000 +
			(tp.tv_usec - oldtp.tv_usec));
	if (sleeptime>0)
		usleep(sleeptime);

	gettimeofday(&oldtp,&tzp);

	if (timer_active && window_active) move_balls();

	/* Event handling (if any events need to be handled) - MSW */
	if (XPending(display)) {
	    XNextEvent(display, &e);
	    switch (e.type) {
		case ButtonPress:
		    switch (e.xbutton.button) {
			case Button3: /* right mouse button */
				/* Clear message area */
			    XFillRectangle(display, win, gc_erase,
				0,0,STAGE_WIDTH_IN_PIXELS, MSG_HEIGHT);
				/* redo messages */
			    XDrawImageString(display, win, gc,
				OFFSET_SPEED, font_height*2, stage_name,
				strlen(stage_name));
			    if (score_incr>1) {
			 	sprintf(str,"Bonus x%d",score_incr);
				XDrawImageString(display, win, gc,
				    OFFSET_SCORE, font_height*2, str, 
				    strlen(str));
			    }
			    print_balls();
			    print_score();
			    show_speeds();
			    timer_active=TRUE;
			    move_balls();
			    break;

			case Button2:
				draw_pallet(gc_xor); /* erase old */
				pallet_y = (double) (pallet_yI = PALLET_MAX_Y+4);
				pallet_row = MAX_ROW - 1;
				draw_pallet(gc_xor); /* draw new */
				break;

			case Button1:
				draw_pallet(gc_xor); /* erase old */
				if (pallet_yI > PALLET_MIN_Y) {
					old_pallet_y = pallet_y;
					pallet_y = (double) (pallet_yI -=16);
					pallet_row--;

					/* See if the ball could have been
					deflected as the pallete moved
					upwards */
					check_deflections(old_pallet_y);
				}
				draw_pallet(gc_xor); /* draw new */
				break;
		    }
		break;

		case KeyPress:
			XLookupString((XKeyEvent*) &e,keystr,2, NULL, NULL);
			if (keystr[0]==27) {	/* Escape to save */
				if (!ball1.quadrant && !ball2.quadrant &&
				    !ball3.quadrant && last_busted_brick==NULL) {
					XDrawImageString(display, win, gc,
					OFFSET_BALLS, font_height,
					"Saving...             ",
					23);
					save();
				    }
				else
					XDrawImageString(display, win, gc,
					OFFSET_BALLS, font_height,
					"Not Saved...          ",
					23);
			}
			else if ((keystr[0] == 'q' ) || (keystr[0]=='Q')) {
				XCloseDisplay(display);
				exit(0);
			}
			else if ((keystr[0] == 'p') || (keystr[0] =='P')) {
				if (no_pause) no_pause=FALSE;
				else no_pause=TRUE;
			}
		break;

		case MotionNotify:
#ifdef MOTION_HINTS
			{
				Window rw, cw;
				int xw, yw, xr, yr, keys_buttons;
				XQueryPointer(display,e.xmotion.window,
					&rw, &cw, &xr, &yr, &xw, &yw,
					&keys_buttons);
				draw_pallet(gc_xor);        /* erase old pallet */
				pallet_x = (double)(pallet_xI=xw);
				mouse_yI = yw;
				draw_pallet(gc_xor);        /* draw new one */
			}
#else

			draw_pallet(gc_xor);	/* erase old pallet */
			pallet_x = (double) (pallet_xI =e.xmotion.x);
			mouse_yI = e.xmotion.y;
			draw_pallet(gc_xor);	/* draw new one */
#endif
			break;

		case EnterNotify:
			window_active = TRUE;
			break;

		case LeaveNotify:
			if (!no_pause)
				window_active = FALSE;
			break;

		case Expose:
			if (e.xexpose.count!=0) break;
			XClearWindow(display,win);
			/* redraw the stage */

			for ( row = 0; row <= MAX_ROW; row++ ) {
                		draw_brick0( row, 0 );
                		for ( col = 1; col < MAX_COL; col++ )
                        		draw_brick( row, col );
		                draw_brick0( row, MAX_COL );
			}
			draw_pallet(gc_xor);
			print_balls();
			print_score();
			show_speeds();
			XDrawImageString(display, win, gc,
				OFFSET_SPEED, font_height*2, stage_name,
				strlen(stage_name));
			if (score_incr>1) {
			 	sprintf(str,"Bonus x%d",score_incr);
				XDrawImageString(display, win, gc,
				    OFFSET_SCORE, font_height*2, str, 
				    strlen(str));
			}
			draw_all_balls();
			break;

		default:
			printf("unknown event: %d\n",e.type);
			break;
	    }
	}
    }
}


void get_playground()
{
	DIR		*dirp;
	struct direct	*dp;
	struct stat	st;
	char		path[PATH_LENGTH];
	

	/* set default playground directory */
	strcpy( playground, STAGEDIR );
#ifndef VMS
	strcat( playground, "/" );
#endif
	
	/* check for additional arguments (specific playground) */
	if ((!strcmp(play,"list")) || (!strcmp(play,"help"))) {
		/* list available playgrounds */
		printf( "available playgrounds are:\n" );
		printf( "\tdefault\n" );
		dirp = opendir(STAGEDIR);
		for( dp=readdir( dirp ); dp!=NULL; dp=readdir( dirp ) ) {
			if ( !strncmp( dp->d_name, "STAGES.", 7 ) )
				printf( "\t%s\n", (dp->d_name)+7 );
		}
		closedir( dirp );
		exit( 0 );
	}
	/* it's a playground name or private directory */
	if( !strcmp( play, "default" ) ) {
		/* just in case someone used default */
#ifndef VMS
		strcat( playground, "STAGES" );
#endif
		return;
	}
#ifdef VMS
        	sprintf(path,"%sSTAGES.%s",STAGEDIR,play);
#else
	sprintf(path,"%s/STAGES.%s",STAGEDIR,play);
#endif
	stat(path, &st);
	if (S_ISDIR(st.st_mode))
		strcpy(playground, path);
	else {	/* private dir */
		stat(play, &st);
		if (!S_ISDIR(st.st_mode)) {
			printf("Was not able to open playground %s.\n",play);
			exit(1);
		}
		else strcpy(playground,play);
	}
}

void usage()
{
	printf("Valid option command line arguements are:\n\n");
	printf("   -display dispname     - destination display\n");
	printf("-playground playground   - playground to use\n\n");
	exit(0);
}

void parse_args(argc, argv)
int argc;
char *argv[];
{

	int	i,tmp;

	for (i=1; i<argc; i++) {
		if (!strcmp(argv[i],"-display"))
			if (++i==argc) usage();
			else disp = argv[i];
		else if (!strcmp(argv[i],"-playground"))
			if (++i==argc) usage();
			else play = argv[i];
		else if (!strcmp(argv[i],"-geometry")) {
			if (++i==argc) usage();
			else geomask = XParseGeometry(argv[i], &winposx,
				&winposy, &tmp, &tmp);
		}
		else if (!strcmp(argv[i],"-nopause"))
			no_pause=TRUE;
		else usage();
	}
}

void do_geometry()
{
	if (geomask & XNegative) 
		winposx += WidthOfScreen(ScreenOfDisplay(display,screen_num))
			 - STAGE_WIDTH_IN_PIXELS - BORDER_WIDTH*2;
	if (geomask & YNegative)
		winposy += HeightOfScreen(ScreenOfDisplay(display,screen_num))
			 - STAGE_HEIGHT_IN_PIXELS - BORDER_WIDTH*2;
}

/*** xblockbuster ***/
#ifndef VMS
void
#endif
main( argc, argv )
	int             argc;
	char           *argv[];

{
	XGCValues	xgcvalues;
	Pixmap		icon_image;
	XSizeHints	size_hints;
	XWMHints	wm_hints;
	XClassHint	class_hints;
	XTextProperty	window_name;
	char *prog_name=VERSION;

	/* who am i ? ['cuserid(3S)' is fooled by 'su(1)'] */
#ifdef VMS
        login = getenv("USER");
#else
	login = getpwuid( getuid(  ) )->pw_name;
#endif

	parse_args(argc, argv);
	get_playground();

	if ((display=XOpenDisplay(disp))==NULL) {
		fprintf(stderr, "Unable to open display: %s\n",
			XDisplayName(NULL));
		exit(1);
	}

	screen_num = DefaultScreen(display);

	do_geometry();

	whitepixel = WhitePixel(display, screen_num);
	blackpixel = BlackPixel(display, screen_num);

	win = XCreateSimpleWindow(display, RootWindow(display, screen_num),
		winposx, winposy, STAGE_WIDTH_IN_PIXELS,
		 STAGE_HEIGHT_IN_PIXELS, BORDER_WIDTH, blackpixel,
		 whitepixel);

	XSelectInput(display, win, ExposureMask | ButtonPressMask |
		LeaveWindowMask | EnterWindowMask | KeyPressMask |
#ifdef MOTION_HINTS
		PointerMotionHintMask |
#endif
		PointerMotionMask);


	if ((font_info = XLoadQueryFont(display, FONT))==NULL) {
		fprintf(stderr,"Unable to load font %s\n",FONT);
		exit(1);
	}
	font_width= font_info->max_bounds.rbearing - font_info->min_bounds.lbearing;
	font_height=font_info->max_bounds.ascent + font_info->max_bounds.descent +1;


	xgcvalues.foreground = blackpixel;
	xgcvalues.background = whitepixel;

	
	xgcvalues.graphics_exposures = False;
	xgcvalues.font = font_info->fid;

	/* create the various graphic contexts we need. gc and gc_color
	differ only in the we only change the colors on the gc_color context,
	and thus, it is only used for brick drawing.  gc_color really has no
	use on a black & white system */

	gc = XCreateGC(display, win, GCFont | 
		GCForeground | GCBackground | GCGraphicsExposures, &xgcvalues);
	gc_color = XCreateGC(display, win, GCFont | 
		GCForeground | GCBackground | GCGraphicsExposures, &xgcvalues);

	xgcvalues.function = GXclear;
	gc_erase = XCreateGC(display, win, GCForeground | GCBackground |
		GCFont | GCGraphicsExposures | GCFunction, &xgcvalues);

	/* Xor doesn't work very well (at all) if foreground is 0.  So
	 * a different function is used instead.  This seems to work,
	 * at least, from my fiddling with the foreground color on my
	 * machine. 
 	 */
	xgcvalues.line_width=0;

	if (xgcvalues.foreground==0) {
		/* GXnor, GXinvert and GXequiv  all seem to work for the 
			function */
		xgcvalues.function = GXequiv;
		xgcvalues.plane_mask = xgcvalues.background;
		gc_xor = XCreateGC(display, win, GCForeground | GCBackground |
			GCFont | GCGraphicsExposures | GCFunction | 
			GCPlaneMask | GCLineWidth, &xgcvalues);
		extra_draw = TRUE;
	}
	else {
		xgcvalues.function = GXxor;	/* Exclusive or */
		gc_xor = XCreateGC(display, win, GCForeground | GCBackground |
			GCFont | GCGraphicsExposures | GCFunction |
			GCLineWidth,
			 &xgcvalues);
		extra_draw = TRUE;
	}
	/* Create our icon for when the window is closed */

	if  (!(icon_image = XCreateBitmapFromData(display, win,
	    blockbuster_bits,blockbuster_width, blockbuster_height)))
	{
		fprintf(stderr, "Can't create icon pixmap\n");
		exit (1);
	}

	size_hints.flags = PMinSize;
	if (geomask!=0) size_hints.flags |= USPosition;
	size_hints.x = winposx;
	size_hints.y = winposy;
	size_hints.height = STAGE_HEIGHT_IN_PIXELS;
	size_hints.min_height = STAGE_HEIGHT_IN_PIXELS;
	size_hints.width = STAGE_WIDTH_IN_PIXELS;
	size_hints.min_width = STAGE_WIDTH_IN_PIXELS;

	wm_hints.flags = InputHint | IconPixmapHint;
	wm_hints.input = True;
	wm_hints.icon_pixmap = icon_image;

	class_hints.res_name = "XBlockbuster";
	class_hints.res_class =  "XBlockbuster";

	XStringListToTextProperty(&prog_name, 1, &window_name);
	XSetWMProperties(display, win, &window_name, &window_name,
		argv,argc, &size_hints, &wm_hints, &class_hints);


	XMapWindow(display, win);
	/* initialize random (used to determine next stage) */
	SRAND( time( 0 ) );


	/* and off we go */
	bricks_init();
	ball_init();
	start_up(  );
	ball1.quadrant = ball2.quadrant = ball3.quadrant = 0;

	event_handler();


}

#ifdef SYSV

/* Most SysV's don't have a usleep.  Sone of them have select. */

usleep( usecs )
unsigned usecs;
    {
    struct timeval timeout;

    timeout.tv_sec = usecs / 1000000;
    timeout.tv_usec = usecs % 1000000;
    select( 0, 0, 0, 0, &timeout );
    }

#endif /*SYSV*/
