/*
 * File:       xblockbuster.h
 * Author:     Eric Van Gestel
 * X11 Support by: Mark Wedel
 * For:                xblockbuster
 *
 */

/* file paths are defined at the end of this file */

#include <stdio.h>

#ifdef VMS
#include "pwd.h"
#else
#include <pwd.h>
#endif

#ifdef VMS
#include "math.h"
#else
#include <math.h>
#endif

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>

/*
 * SYSTEM DEPENDENT OPTIONS
 */

/* NOTE: only one of LOCK_FCTNL or LOCK_FILE should be defined. */
/* If neither are defined, no file locking will be done */

/* Use fcntl to lock the scorefile */
/*#define LOCK_FCNTL*/
/* Use a different locking method for the score file.  Maybe try it
  if fcntl does not work.  If you do use LOCK_FILE, the STAGES
directories themselves need to be publicly writable, as a lockfile
is written in them */
/*#define LOCK_FILE*/

/* STAGEDIR should, in general, be defined in the (I)Makefile */

#ifndef STAGEDIR
#ifdef VMS
#define STAGEDIR        "XBLOCKBUSTER_DIR:"
#else
#define STAGEDIR	"/usr/games/lib/blockbuster"
#endif
#endif

#ifdef VMS
#define FONT    "-Misc-Fixed-Medium-R-Normal--20-200-*-*-C-100-ISO8859-1"
#else
#define FONT	"10x20"
#endif

/* define if you want pointer motion hints used (read CHANGES file) */
/*#define MOTION_HINTS*/

#ifdef hpux
#define RAND() rand()
#define SRAND(n) srand(n)
#else
#define RAND() random()
#define SRAND(n) srandom(n)
#endif

/* You may need to uncomment some of these if your system does not have
 * them.  If you need to do so, please let me know, so I can put them
 * in an #ifdef/#endif clause to make it easier for others.
 */

/*
 * #define M_PI                3.14159265358979323846
 * #define M_PI_2      1.57079632679489661923
 * #define M_PI_4      0.78539816339744830962
 */
#define M_PI_3_4       2.35619449019234492885
#define M_SQRT2_2      0.70710678118654752440
#define NEAR_HORIZONTAL        0.7	/* < M_PI_4 */

/* Nothing below here should need to be changed. */

Display		*display;
Window		win;
GC		gc, gc_erase, gc_color,gc_xor;
XFontStruct	*font_info;
int		screen_num, font_width, font_height,extra_draw;
unsigned long	whitepixel, blackpixel;

/*** windowing objects ***/
#define BORDER_WIDTH	2	/* borderwidth X puts around the window */

#define BORDER         50
#define MSG_HEIGHT     font_height*2 + 4

#define MAX_ROW                42
#define MAX_COL                11

/* upper left corner of brick in pixels */
#define COL_X( col )   (col) ? (col) * 64 - 48 + BORDER : BORDER
#define ROW_Y( row )   (row) * 16 + BORDER

/* brick coordinates */
#define X_COL( x )     ( (int)(x) - BORDER + 48 ) / 64
#define Y_ROW( y )     ( (int)(y) - BORDER ) / 16

#define STAGE_HEIGHT_IN_PIXELS ( ( MAX_ROW + 1 ) * 16 + 2 * BORDER )
#define STAGE_WIDTH_IN_PIXELS  ( ( MAX_COL - 1 ) * 64 + 2 * ( BORDER + 16 ) )


/*** messages ***/


#define OFFSET_BALLS   20
#define OFFSET_SCORE   250
#define OFFSET_SPEED   550


/*** active objects ***/

#define NO_BALL        0
#define NE     1
#define NW     2
#define SW     3
#define SE     4

#ifndef FALSE
#define FALSE  0
#endif
#ifndef TRUE
#define TRUE   1
#endif

#define HORIZONTAL     1
#define VERTICAL       2

#define INIT_BALLS     3
#define LOOP_MAX       100

#define INIT_SPEED     3.0
#define MAX_SPEED      8.0
#define SPEED_LIMIT    12.0
#define SPEED_INCR     0.2
#define SPEED_INCR_2   0.1	/* SPEED_INCR / 2 */
#define SPEED_RESOLUTION       60	/* SPEED_LIMIT / SPEED_INCR */
#define SPEED_RESOLUTION_FACTOR        5.0	/* SPEED_RESOLUTION /
						 * SPEED_LIMI
						 */

#define NUM_BRICK_TYPES	37

/* foreground/background colors for each of the bricks - MSW */
struct	COLOR {
	unsigned long	fg, bg;
} brick_color[NUM_BRICK_TYPES+1];

/* the stage is a two
 * dimensional array of
 * bricks */

struct Brick {
	char            code;	/* Q.V. map_codes */
	short           nhits;
}               stage[MAX_ROW + 1][MAX_COL + 1];

#define IS_HIT_BRICK( code )   code > '0' && code <= '9'

struct Ball {
	int             quadrant;	/* enumeration { NO_BALL, NE, NW, SW,
					 * SE } */
	double          angle;	/* range -M_PI_4..NEAR_HORIZONTAL */
	/*
	 * NW -P4|-P4 NE +NH | +NH >>>>>>+<<<<<<  (gap to avoid infinite
	 * horizontal bounce loops) +NH | +NH SW -P4|-P4 SE
	 */
	int             row, col;	/* coordinates on the stage */
	double          x, y;	/* coordinates in pixels */
	double          speed, x_speed, y_speed;	/* motion per update in
							 * pixels */
	/*
	 * INVARIANT: x_speed == speed * cos( true_angle ) y_speed == speed *
	 * sin( true_angle )
	 */
}               ball1, ball2, ball3;

/* Macro to draw a ball */


int             launch_quadrant;/* enumeration { NE, NW } */
int             launch_row, launch_col;
double          launch_x, launch_y;
int             emit_row, emit_col;

#define MIN_PALLET_LENGTH      12
#define SHORT_PALLET_LENGTH    16
#define LONG_PALLET_LENGTH     99
#define MAX_PALLET_LENGTH      99
#define MAX_PALLET_HEIGHT      999
#define PALLET_INCR    100
#define PALLET_DENOMINATOR     20000
#define PALLET_MIN_Y   ROW_Y( MAX_ROW - 9 )
#define PALLET_MAX_Y   ROW_Y( MAX_ROW - 1 )

int             pallet_lengthI;	/* range MIN_PALLET_LENGTH..MAX_PALLET_LENGTH */
int             pallet_heightI;	/* range pallet_lengthI..MAX_PALLET_HEIGHT */
int             pallet_xI;	/* range 0..STAGE_WIDTH_IN_PIXELS */
int             pallet_yI;	/* range PALLET_MAX_Y+4..PALLET_MIN_Y-12 */
int             pallet_row;	/* range MAX_ROW-1..MAX_ROW-9 */
double          pallet_length, pallet_height, pallet_x, pallet_y;

/*
 * INVARIANT:
 *     pallet_* == (double) pallet_*I;
 *     pallet_width == 2 * pallet_length
 *     pallet_height >= pallet_length >= ABS( excentricity )
 *       =>  atan2( excentricity, pallet_height ) range -M_PI_4..M_PI_4
 */
int             mouse_yI;	/* range 0..STAGE_HEIGHT_IN_PIXELS *//* <HC> */

int             nb_stages, stage_nb, balls_left, score, score_incr, nbricks, loop_nhits, pallet_modif;
double          launch_speed;

#define NAME_LENGTH    20
char            stage_name[NAME_LENGTH];

#define MAX_NB_STAGES  100
int             stages[MAX_NB_STAGES];

struct Brick   *last_busted_brick;	/* NULL == none so far */
char            last_busted_code;
int             last_busted_row, last_busted_col;



/*** score and stages files ***/

#define PATH_LENGTH	512

char	*login;
char	playground[PATH_LENGTH];


#ifdef VMS
#define SCOREFILE      "sys$login:xblockbuster.scores"
#define NB_SCORES      12
#define USER_SCORES    3

#define NB_STAGESFILE  "%snb_stages"
#define STAGEFILE      "%sstage%d"
#define STAGEFILE_LENGTH       PATH_LENGTH

#define SAVEFILE       "%ssave%s"
#define SAVEFILE_LENGTH        PATH_LENGTH
#else
#define SCOREFILE      "%s/scores"
#define NB_SCORES      12
#define USER_SCORES    3

#define NB_STAGESFILE  "%s/nb_stages"
#define STAGEFILE      "%s/stage%d"
#define STAGEFILE_LENGTH       PATH_LENGTH

#define SAVEFILE       "%s/save/%s"
#define SAVEFILE_LENGTH        PATH_LENGTH
#endif

/* Timer information */

#define ITIMER_DELAY	5000

/* Prototype some functions here */
#ifdef __GNUC__
void fclose(FILE *);					/* system */
void fprintf(FILE*, char *, ...);			/* system */
void fscanf(FILE *, char *, ...);			/* system */
int  gettimeofday(struct timeval*, struct timezone*);	/* system */
void perror(char *);					/* system */
void printf(char *, ...);				/* system */
void rewind(FILE *);					/* system */
int  strcasecmp(char *, char*);				/* system */
time_t time(time_t*);					/* system */
void usleep(unsigned);					/* system */

int  RAND();						/* system */
void SRAND(int);					/* system */

void ball_init();					/* balls_pallet.c */
void check_deflections(double );			/* balls_pallet.c */
void draw_all_balls();					/* balls_pallet.c */
void draw_pallet(GC);					/* balls_pallet.c */
void move_balls();					/* balls_pallet.c */
void print_balls();					/* balls_pallet.c */
void print_score();					/* balls_pallet.c */
void show_speeds();					/* balls_paller.c */
void bricks_init();					/* bricks.c */
void draw_brick(int, int ) ;				/* bricks.c */
void draw_brick0(int, int ) ;				/* bricks.c */
void brick_deflection( int, struct Ball* );		/* deflection.c */
void pallet_deflection(struct Ball * );			/* deflection.c */
void save();						/* save.c */
void start_up();					/* save.c */
void get_stage();					/* stage.c */
void new_stage(  );					/* stage.c */
void show_score_board(  );				/* score.c */

#endif
