#ifndef lint
static char	*RCSid = "$Header$";
#endif

/*
 * util.c - utility routines.
 *
 * David A. Curry
 * Research Institute for Advanced Computer Science
 * Mail Stop 230-5
 * NASA Ames Research Center
 * Moffett Field, CA 94086
 * davy@riacs.edu
 *
 * $Log$
 */
#ifdef vax11c
#include <decw$include/StringDefs.h>
#include <decw$include/Intrinsic.h>
#include <X11Inc/unix_types.h>
#define MAXHOSTNAMELEN	64
#include <stdio.h>
#include <X11Inc/pwd.h>
#else
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <sys/param.h>
#include <stdio.h>
#include <pwd.h>
#endif /* vax11c */

#include "xpostit.h"

/*
 * ByeBye - clean up and exit.
 */
void
ByeBye()
{
	/*
	 * If saving notes is on, save all notes.
	 */
	if (app_res.save_notes)
		SaveAllNotes();

	XtUnmapWidget(toplevel);
	XCloseDisplay(display);

	exit(0);
}

/*
 * SetNoteDir - determine the path to the note directory.
 */
void
SetNoteDir()
{
	char *getenv();
	char *home, *s;
	struct passwd *pwd;
	char fname[MAXPATHLEN];

	/*
	 * If it's an absolute path name,
	 * we're done.
	 */
	if (app_res.note_dir[0] == '/')
		return;

	/*
	 * Find the user's home directory.
	 */
	if ((home = getenv("HOME")) == NULL) {
#ifdef vax11c
		if ((pwd = getpwnam(getenv("USER"))) == NULL) {
#else
		if ((pwd = getpwuid(getuid())) == NULL) {
#endif /* vax11c */
			fprintf(stderr, "xpostit: who are you?\n");
			exit(1);
		}

		home = pwd->pw_dir;
	}

	/*
	 * Save the path.
	 */
#ifdef vax11c
	{
	   char *sp, *ep;

	   ep = strchr(home, ']');
	   sp = strchr(app_res.note_dir, '[');
	   if (ep != NULL) *ep = '\0';
	   if (sp != NULL) sp++;
	   sprintf(fname, "%s%s", home, sp);
	}
#else
	sprintf(fname, "%s/%s", home, app_res.note_dir);
#endif /* vax11c */

	s = SafeAlloc(strlen(fname) + 1);
	app_res.note_dir = s;
	strcpy(s, fname);
}

/*
 * MakeFname - make a file name from a note index number.
 */
char *
MakeFname(index)
register int index;
{
	char *s;
	char fname[MAXPATHLEN];

#ifdef vax11c
	sprintf(fname, "%s%s.%d", app_res.note_dir, PostItNoteFname, index);
#else
	sprintf(fname, "%s/%s%d", app_res.note_dir, PostItNoteFname, index);
#endif /* vax11c */
	s = SafeAlloc(strlen(fname) + 1);
	strcpy(s, fname);
	return(s);
}

/*
 * SafeAlloc - allocate n bytes of memory, exit if we run out.
 */
char *
SafeAlloc(nbytes)
register int nbytes;
{
	char *malloc();
	register char *s;

	if ((s = malloc(nbytes)) == NULL) {
		fprintf(stderr, "xpostit: out of memory.\n");
		exit(1);
	}

	bzero(s, nbytes);
	return(s);
}
