/*
 * debug.h
 * Copyright (C) 1998 A.J. van Os
 *
 * Description:
 * Macro's for debuging.
 */

#if !defined(__debug_h)
#define __debug_h 1

#include <stdio.h>

#if defined(DEBUG)

#define DBG_MSG(s)	(void)fprintf(stderr,\
				"%s[%3d]: %.240s\n",\
				__FILE__, __LINE__, s)

#define DBG_DEC(n)	(void)fprintf(stderr,\
				"%s[%3d]: "#n" = %ld\n",\
				__FILE__, __LINE__, (long)(n))

#define DBG_HEX(n)	(void)fprintf(stderr,\
				"%s[%3d]: "#n" = 0x%02lx\n",\
				__FILE__, __LINE__, (long)(n))

#define DBG_PRINT_BLOCK(b,l)	vPrintBlock(__FILE__, __LINE__,b,l)

#define DBG_MSG_C(c,s)	do { if (c) DBG_MSG(s); } while(0)
#define DBG_DEC_C(c,n)	do { if (c) DBG_DEC(n); } while(0)
#define DBG_HEX_C(c,n)	do { if (c) DBG_HEX(n); } while(0)

#else

#define DBG_MSG(s)		/* EMPTY */
#define DBG_DEC(n)		/* EMPTY */
#define DBG_HEX(n)		/* EMPTY */
#define DBG_PRINT_BLOCK(b,l)	/* EMPTY */

#define DBG_MSG_C(s,n)		/* EMPTY */
#define DBG_DEC_C(c,n)		/* EMPTY */
#define DBG_HEX_C(c,n)		/* EMPTY */

#endif /* DEBUG */

#define NO_DBG_MSG(s)		/* EMPTY */
#define NO_DBG_DEC(n)		/* EMPTY */
#define NO_DBG_HEX(n)		/* EMPTY */
#define NO_DBG_PRINT_BLOCK(b,l)	/* EMPTY */

#define NO_DBG_MSG_C(s,n)	/* EMPTY */
#define NO_DBG_DEC_C(c,n)	/* EMPTY */
#define NO_DBG_HEX_C(c,n)	/* EMPTY */

#endif /* !__debug_h */
