/*
 * depot.c
 * Copyright (C) 1998,1999 A.J. van Os
 *
 * Description:
 * Functions to compute the depot offset
 */

#include "antiword.h"

#define SIZE_RATIO	(BIG_BLOCK_SIZE/SMALL_BLOCK_SIZE)

static int	*aiSmallBlockList = NULL;
static int	iSmallBlockListLen = 0;


/*
 * vDestroySmallBlockList - destroy the small block list
 */
void
vDestroySmallBlockList(void)
{
	DBG_MSG("vDestroySmallBlockList");

	aiSmallBlockList = xfree(aiSmallBlockList);
	iSmallBlockListLen = 0;
} /* end of vDestroySmalBlockList */

/*
 * vCreateSmallBlockList - create the small block list
 *
 * returns: TRUE when successful, otherwise FALSE
 */
BOOL
bCreateSmallBlockList(int iStartblock, const int *aiBBD, int iBBDLen)
{
	int	iIndex, iTmp;
	size_t	tSize;

	fail(aiSmallBlockList != NULL || iSmallBlockListLen != 0);
	fail(iStartblock < 0 && iStartblock != END_OF_CHAIN);
	fail(aiBBD == NULL || iBBDLen <= 0);

	/* Find the length of the small block list */
	for (iSmallBlockListLen = 0, iTmp = iStartblock;
	     iSmallBlockListLen < iBBDLen && iTmp != END_OF_CHAIN;
	     iSmallBlockListLen++, iTmp = aiBBD[iTmp]) {
		if (iTmp < 0 || iTmp >= iBBDLen) {
			werr(1, "The Big Block Depot is corrupt");
		}
	}
	DBG_DEC(iSmallBlockListLen);

	if (iSmallBlockListLen <= 0) {
		/* There is no small block list */
		fail(iStartblock != END_OF_CHAIN);
		aiSmallBlockList = NULL;
		iSmallBlockListLen = 0;
		return TRUE;
	}

	/* Create the small block list */
	tSize = iSmallBlockListLen * sizeof(int);
	aiSmallBlockList = xmalloc(tSize);
	for (iIndex = 0, iTmp = iStartblock;
	     iIndex < iBBDLen && iTmp != END_OF_CHAIN;
	     iIndex++, iTmp = aiBBD[iTmp]) {
		if (iTmp < 0 || iTmp >= iBBDLen) {
			werr(1, "The Big Block Depot is corrupt");
		}
		aiSmallBlockList[iIndex] = iTmp;
		DBG_DEC(aiSmallBlockList[iIndex]);
	}
	return TRUE;
} /* end of bCreateSmallBlockList */

/*
 * iDepotOffset - get the depot offset the small block list
 */
int
iDepotOffset(int iIndex, int iBlockSize)
{
	int	iTmp1, iTmp2;

	fail((aiSmallBlockList == NULL) != (iSmallBlockListLen == 0));

	switch (iBlockSize) {
	case BIG_BLOCK_SIZE:
		return (iIndex + 1) * BIG_BLOCK_SIZE;
	case SMALL_BLOCK_SIZE:
		iTmp1 = iIndex / SIZE_RATIO;
		iTmp2 = iIndex % SIZE_RATIO;
		if (aiSmallBlockList == NULL ||
		    iSmallBlockListLen <= iTmp1) {
			return 0;
		}
		return ((aiSmallBlockList[iTmp1] + 1) * SIZE_RATIO + iTmp2)
			* SMALL_BLOCK_SIZE;
	default:
		return 0;
	}
} /* end of iDepotOffset */
