/*
 * fail.h
 * Copyright (c) A.J. van Os
 *
 * Description:
 * Support for an alternative form of assert()
 */

#if !defined(__fail_h)
#define __fail_h 1

#if defined(NDEBUG)
#  define fail(e)	((void)0)
#else
#  define fail(e)	((e) ? __fail(#e, __FILE__, __LINE__) : (void)0)
#endif /* NDEBUG */

extern void	__fail(char *, char *, int);
extern void	(fail)(int);

#endif /* __fail_h */
