/*
 * wordtypes.h
 * Copyright (C) 1998,1999 A.J. van Os
 *
 * Description:
 * Typedefs for the interpretation of MS Word files
 */

#if !defined(__wordtypes_h)
#define __wordtypes_h 1

#if defined(__riscos)
typedef int		off_t;
typedef struct diagram_tag {
	draw_diag	tInfo;
	wimp_w		tMainWindow;
	wimp_w		tScaleWindow;
	int		iScaleFactorCurr;	/* In percentage */
	int		iScaleFactorTemp;	/* In percentage */
	int		iMemorySize;
	int		iXleft;			/* In DrawUnits */
	int		iYtop;			/* In DrawUnits */
	char		szFilename[19+1];
} diagram_type;
#else
typedef struct diagram_tag {
	FILE		*pFile;
	int		iXleft;			/* In DrawUnits */
	int		iYtop;			/* In DrawUnits */
} diagram_type;
typedef unsigned char	draw_fontref;
#endif /* __riscos */

typedef struct output_tag {
  	char		*szStorage;
	int		iStorageSize;
	int		iNextFree;
	int		iStringWidth;	/* In millipoints */
	int		iColour;
	unsigned char	ucFontstyle;
	draw_fontref	tFontRef;
	unsigned char	ucFontsize;
	struct output_tag	*pPrev;
	struct output_tag	*pNext;
} output_type;

/* Fonts */
typedef struct font_table_tag {
	unsigned char	ucWordFontnumber;
	unsigned char	ucFontstyle;
	unsigned char	ucInUse;
	char		szWordFontname[21];
	char		szOurFontname[33];
} font_table_type;

/* Options */
typedef struct options_tag {
	int	iParagraphBreak;
	BOOL	bAutofiletypeAllowed;
	BOOL	bUseOutlineFonts;
	BOOL	bUseColour;
	BOOL	bHideHiddenText;
	int	iPageHeight;		/* In DrawUnits */
} options_type;

/* Property Set Storage */
typedef struct pps_tag {
	int	iSb;
	int	iSize;
} pps_type;
typedef struct pps_info_tag {
	pps_type	tWordDocument;
	pps_type	t0Table;
	pps_type	t1Table;
} pps_info_type;

/* Record of text block information */
typedef struct text_block_tag {
	int	iFileOffset;
	int	iTextOffset;
	int	iLength;
	BOOL	bUsesUnicode;	/* Uses 16 bits per character */
} text_block_type;

/* Record of table-row block information */
typedef struct row_block_tag {
	int	iOffsetStart;
	int	iOffsetEnd;
	int	iColumnWidthSum;			/* In twips */
	short	asColumnWidth[TABLE_COLUMN_MAX+1];	/* In twips */
	unsigned char	ucNumberOfColumns;
} row_block_type;

/* Linked list of style description information */
typedef struct style_block_tag {
	int	iOffset;
	BOOL	bInList;
	BOOL	bUnmarked;
	short	sLeftIndent;	/* Left indentation in twips */
	short	sRightIndent;	/* Right indentation in twips */
	unsigned char	ucStyle;
	unsigned char	ucAlignment;
	unsigned char	ucListType;
	unsigned char	ucListLevel;
	unsigned char	ucListCharacter;
} style_block_type;
typedef struct style_desc_tag {
	style_block_type	tInfo;
	struct style_desc_tag	*pNext;
} style_desc_type;

/* Linked list of font description information */
typedef struct font_block_tag {
	int	iOffset;
	unsigned char	ucFontnumber;
	unsigned char	ucFontsize;
	unsigned char	ucFontcolour;
	unsigned char	ucFontstyle;
} font_block_type;
typedef struct font_desc_tag {
	font_block_type	tInfo;
	struct font_desc_tag	*pNext;
} font_desc_type;

typedef enum text_info_tag {
	text_success,
	text_failure,
	text_no_information
} text_info_enum;

typedef enum list_id_tag {
	text_list,
	footnote_list,
	endnote_list,
	end_of_lists
} list_id_enum;

typedef enum notetype_tag {
	notetype_is_footnote,
	notetype_is_endnote,
	notetype_is_unknown
} notetype_enum;

#endif /* __wordtypes_h */
