# SQL abstraction for Microsoft SQL Server
# Copyright (C) 1999-2000 Henrik Edlund <henrik@edlund.org>
#
# Uses the MSSQL::Sqllib module found at
# http://www.algonet.se/~sommar/mssqlperl/index.html.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place, Suite 330, Boston, MA 02111-1307 USA.



# connect(name) -> (connection)
# query(connection, query) -> (result)
# fetchrow(result) -> (tuple)
# ntuples(result) -> (ntuples)



package MSSQL;

use MSSQL::Sqllib qw(:DEFAULT :consts);
use strict;

use vars qw($product_name $product_version);
$product_name = 'SQL abstraction for Microsoft SQL Server';
$product_version = '0.1.2';



use vars qw(%config);
%config = (
	   
	   'features' =>
           {'transactions' => 1,
	    'subselects'   => 1},
	   
	   );



sub connect ($$$$$) {
    (my $host, my $port, my $name, my $user, my $password) = @_;
    my $conn = sql_init($host, $user, $password, $name);
    return($conn)
}

sub query ($$) {
    (my $conn, my $query) = @_;
    my @result = ($conn->sql($query, LIST, SINGLESET));
    return (\@result);
}

sub fetchrow ($) {
    (my $result) = @_;
    return (@{shift @$result});
}

sub ntuples ($) {
    (my $result) = @_;
    return ($#{$result} + 1);
}

1;
