/*
 *    Calc: A Programmable Calculator for GTK+
 *    Copyright (C) 2000  David Hanak (dhanak@inf.bme.hu)
 *
 *    This file can be distributed under GNU GPL.  See file COPYING.
 *
 *    $Id: memgrp.c,v 2.1 2000/02/21 22:05:07 david Exp $
 */

#include <config.h>
#include <glib.h>

#include "memgrp.h"

typedef struct _mg_item {
  struct _mg_item *next, *prev;
  char data[0];
} mg_item;

#define MG_ITEM(ptr) \
  ((mg_item *)((char *)(ptr)-(unsigned long)(((mg_item *)0)->data)))

static mg_item *rewind(void *ptr)
{
  mg_item *head;

  if (ptr == NULL) return NULL;

  head = MG_ITEM(ptr);
  while(head->prev != NULL)
    head = head->prev;

  return head;
}

void *mg_malloc(void *ptr, size_t size)
{
  mg_item *newptr, *grp;

  grp = rewind(ptr);

  newptr = (mg_item *)g_malloc(sizeof(mg_item) + size);
  if (newptr == NULL) return NULL;

  newptr->next = grp;
  if (grp) grp->prev = newptr;
  newptr->prev = NULL;

  return (void *)newptr->data;
}

void *mg_calloc(void *ptr, size_t count, size_t size)
{
  mg_item *newptr, *grp;

  grp = rewind(ptr);

  newptr = (mg_item *)g_malloc0(sizeof(mg_item) + count*size);
  if (newptr == NULL) return NULL;

  newptr->next = grp;
  if (grp) grp->prev = newptr;
  newptr->prev = NULL;

  return (void *)newptr->data;
}

void *mg_realloc(void *ptr, size_t size)
{
  mg_item *newptr, *prev, *next;

  if (ptr == NULL) return mg_malloc(MG_NEW_GRP, size);

  newptr = MG_ITEM(ptr);
  prev = newptr->prev;
  next = newptr->next;

  newptr = (mg_item *)g_realloc(newptr, sizeof(mg_item) + size);
  if (newptr == NULL) {
    if (prev) prev->next = next;
    if (next) next->prev = prev;
    return NULL;
  }

  if (prev) prev->next = newptr;
  if (next) next->prev = newptr;
  return (void *)newptr->data;
}

void mg_free_group(void *ptr)
{
  mg_item *this, *next;

  this = rewind(ptr);
  while (this != NULL) {
    next = this->next;
    g_free(this);
    this = next;
  }
}
