/*
 *    Calc: A Programmable Calculator for GTK+
 *    Copyright (C) 2000  David Hanak (dhanak@inf.bme.hu)
 *
 *    This file can be distributed under GNU GPL.  See file COPYING.
 *
 *    $Id: memgrp.h,v 2.0 2000/02/16 16:48:49 david Exp $
 */

#ifndef _MEMGRP_H
#define _MEMGRP_H

#include <stddef.h>

#define MG_NEW_GRP NULL

#ifdef __cplusplus
extern "C" {
#endif

void *mg_malloc(void *ptr, size_t size);
void *mg_calloc(void *ptr, size_t count, size_t size);
void *mg_realloc(void *ptr, size_t size);
void  mg_free_group(void *ptr);

#ifdef __cplusplus
}
#endif

#define mg_new(ptr, type, cnt) \
  ((type *)mg_malloc(ptr, (unsigned) sizeof(type) * (cnt)))

#define mg_new0(ptr, type, cnt) \
  ((type *)mg_calloc(ptr, (unsigned) sizeof(type), cnt))

#define mg_renew(ptr, type, cnt) \
  ((type *)mg_realloc(ptr, (unsigned) sizeof(type) * (cnt)))

#endif
