/*
 *    Calc: A Programmable Calculator for GTK+
 *    Copyright (C) 2000  David Hanak (dhanak@inf.bme.hu)
 *
 *    This file can be distributed under GNU GPL.  See file COPYING.
 *
 *    $Id: parse.y,v 2.0 2000/02/16 16:48:50 david Exp $
 */

%pure_parser

%{
#include <config.h>

#include <math.h>
#if HAVE_MALLOC_H
#  include <malloc.h> /* To avoid warning about missing declaration of free(). */
#endif
#include "calc.h"

/*
#include <string.h>
#define YYERROR_VERBOSE
*/

#define set_errpos(p)                                  \
  if (cparams.errpos.first_line == 0) {                \
    cparams.errpos = (p);                              \
    cparams.errpos.text = g_strdup(visited_files.top); \
  }

#define LITERAL_EXP(c) build_exp(E_LITERAL, c)

#define BUILTIN_EXP(builtin, argcnt, args...) \
  build_exp(E_OPER, builtin_lookup(builtin), build_arglist(argcnt, args))

#define OPER_EXP(operptr, argcnt, args...) \
  build_exp(E_OPER, operptr, build_arglist(argcnt, args))

#define OPEQ_EXP(op, var, arg) \
  OPER_EXP(equals, 2, var, OPER_EXP(op, 2, var, arg))

static const value_t CONSTONE = { type: V_DOUBLE, val: { d: 1.0 } };

%}
%union {
value_t  val;
char    *name;
void    *func;
arg_t   *al;
exp_t   *ptr;
}

/* Type declarations */
%token <val>  VAL
%token <func> FUNC
%token <name> ATOM
%type  <ptr>  exp0 exp var
%type  <al>   arglist optarglist switchcases

%left  ';'

%left RETURN

%nonassoc '(' ')' '[' ']' '{' '}' '|'

%right '=' ADDEQ SUBEQ MULEQ DIVEQ MODEQ POWEQ

%nonassoc IF DO WHILE FOR VAR FUN SWITCH CASE DEFAULT
%nonassoc ELSE /* ELSE must have greater precedence than THEN to recognize it */

%left OR
%left AND
%left NOT

%left EQ NEQ '<' '>' LEQ GEQ

%left  '-' '+'
%left  '*' '/' '%'
%left  NEG     /* negation--unary minus */
%right '^'     /* exponentiation        */
%left  INC DEC

/* Grammar follows */
%%
line:       { cparams.tree = LITERAL_EXP(CONSTONE);    }
    | exp   { cparams.tree = $1;                       }
;

/* This symbol is only necessary to get position information. */
exp: exp0        { $$ = $1; if ($$) $$->pos = @1;      }
   | error       { $$ = NULL; set_errpos(@1);          }
;

exp0: VAL        { $$ = LITERAL_EXP($1);               }
   | exp ';' exp { $$ = OPER_EXP(follow,   2, $1, $3); }
   | exp '+' exp { $$ = OPER_EXP(add,      2, $1, $3); }
   | exp '-' exp { $$ = OPER_EXP(subtract, 2, $1, $3); }
   | exp '*' exp { $$ = OPER_EXP(multiply, 2, $1, $3); }
   | exp '/' exp { $$ = OPER_EXP(divide,   2, $1, $3); }
   | exp '%' exp { $$ = OPER_EXP(modulo,   2, $1, $3); }
   | exp '^' exp { $$ = OPER_EXP(op_pow,   2, $1, $3); }
   | '-' exp %prec NEG { $$ = OPER_EXP(negate, 1, $2); }
   | RETURN exp  { $$ = OPER_EXP(funreturn, 1, $2);    }

   | FUNC '(' optarglist ')' { $$ = build_exp(E_OPER, $1, $3); }

   | exp EQ  exp { $$ = OPER_EXP(isequal,  2, $1, $3); }
   | exp NEQ exp { $$ = OPER_EXP(notequal, 2, $1, $3); }
   | exp '<' exp { $$ = OPER_EXP(lessthan, 2, $1, $3); }
   | exp '>' exp { $$ = OPER_EXP(grtrthan, 2, $1, $3); }
   | exp LEQ exp { $$ = OPER_EXP(lsthoreq, 2, $1, $3); }
   | exp GEQ exp { $$ = OPER_EXP(gtthoreq, 2, $1, $3); }
   | NOT exp     { $$ = OPER_EXP(not,      1, $2);     }
   | exp AND exp { $$ = OPER_EXP(and, 2, $1, $3);      }
   | exp OR  exp { $$ = OPER_EXP(or,  2, $1, $3);      }

   | '(' exp ')' { $$ = $2;                            }
   | '[' exp ']' { $$ = $2;                            }
   | '{' exp '}' { $$ = OPER_EXP(group, 1, $2);        }
   | '|' exp '|' { $$ = BUILTIN_EXP("abs", 1, $2);     }

   | var     { $$ = $1;                                         }
   | VAL var { $$ = OPER_EXP(multiply, 2, LITERAL_EXP($1), $2); }
   | VAR var { $$ = OPER_EXP(newvar, 1, $2);                    }
   | VAR '(' arglist ')' { $$ = build_exp(E_OPER, newvar, $3);  }

   | var '=' exp   { $$ = OPER_EXP(equals, 2, $1, $3); }
   | var ADDEQ exp { $$ = OPEQ_EXP(add,       $1, $3); }
   | var SUBEQ exp { $$ = OPEQ_EXP(subtract,  $1, $3); }
   | var MULEQ exp { $$ = OPEQ_EXP(multiply,  $1, $3); }
   | var DIVEQ exp { $$ = OPEQ_EXP(divide,    $1, $3); }
   | var MODEQ exp { $$ = OPEQ_EXP(modulo,    $1, $3); }
   | var POWEQ exp { $$ = OPEQ_EXP(op_pow,    $1, $3); }

   | INC var { $$ = OPEQ_EXP(add,      $2, LITERAL_EXP(CONSTONE)); }
   | var INC { $$ = OPER_EXP(postinc, 1, $1);                          }
   | DEC var { $$ = OPEQ_EXP(subtract, $2, LITERAL_EXP(CONSTONE)); }
   | var DEC { $$ = OPER_EXP(postdec, 1, $1);                          }

   | IF '(' exp ')' exp          { $$ = OPER_EXP(ifthenelse, 2, $3, $5);     }
   | IF '(' exp ')' exp ELSE exp { $$ = OPER_EXP(ifthenelse, 3, $3, $5, $7); }

   | DO exp WHILE '(' exp ')'    { $$ = OPER_EXP(dowhile, 2, $2, $5); }
   | WHILE '(' exp ')' exp       { $$ = OPER_EXP(whiledo, 2, $3, $5); }

   | FOR '(' exp ',' exp ',' exp ')' exp
       { $$ = OPER_EXP(fordo, 4, $3, $5, $7, $9); }

   | SWITCH '(' exp ')' '{' switchcases '}'
       { $$ = build_exp(E_OPER, switchcase, add_arg($6, $3)); }

   | FUN ATOM '(' optarglist ')' '=' exp
       { $$ = build_exp(E_USERDEF, $2, $4, $7); }
   | ATOM '(' optarglist ')'
       { $$ = build_exp(E_USERCALL, $1, $3); }
;

var: ATOM { $$ = build_exp(E_VARIABLE, $1); if ($$) $$->pos = @1; }
;

optarglist:      { $$ = NULL; }
       | arglist { $$ = $1;   }
;

arglist: exp             { $$ = build_arglist(1, $1); }
       | arglist ',' exp { $$ = add_arg($1, $3);      }
;

switchcases:                          { $$ = NULL;                           }
       | switchcases CASE exp ':' exp { $$ = add_arg(add_arg($1, $3), $5);   }
       | switchcases DEFAULT ':' exp  { $$ = add_arg(add_arg($1, NULL), $4); }
;
%%
