
!
!   DCLRTL grammar definition for eVAX console commands
!


grammar evax


    verb exit
    
    verb quit/alias=exit
    
    verb test
    
        parameter   what/id=161                 -
                    /type=$rest_of_line         -
                    /prompt="Code"
                    
    verb call

        qualifier step
        parameter   routine                     -
                    /type=$rest_of_line         -
                    /prompt="Routine"
    
    
    type clear_types
        keyword     breakpoint          /syntax=clear_breakpoint
        keyword     interrupt           /syntax=clear_interrupt
        keyword     memory              /syntax=clear_memory
        keyword     profiles            /syntax=clear_profiles
        keyword     symbol              /syntax=clear_symbols
        keyword     strings             /syntax=clear_strings
        keyword     tb                  /syntax=clear_tb
        keyword     translation_buffer  /syntax=clear_tb
        keyword     error               /syntax=clear_error
        
        
        
    verb clear
    
        parameter   CLEAR_TYPE/type=clear_types/prompt="What"
 
  
        syntax clear_sym_temp/id=115
        syntax clear_mem_stat/id=114
        syntax clear_error/id=113
        syntax clear_break_all/id=112
        syntax clear_sym_all/id=111
        syntax clear_interrupt_all/id=110
        syntax clear_break_fault_all/id=109
        syntax clear_break_fault/id=108
            qualifier   all                         -
                        /syntax=clear_break_fault_all
            parameter   p1 /id=2                    -
                        /type=$rest_of_line         -
                        /prompt="Fault"
        syntax clear_tb/id=107
        syntax clear_symbols/id=106
            qualifier   temporary                   -
                        /syntax=clear_sym_temp
            qualifier   all                         -
                        /syntax=clear_sym_all
            parameter   p1 /id=1003                 -
                        /type=$name                 -
                        /prompt="Symbol"
        syntax clear_strings/id=105
        syntax clear_breakpoint/id=101
            qualifier   fault                       -
                        /syntax=clear_break_fault
            qualifier   all                         -
                        /syntax=clear_break_all
            parameter   BREAK_ADDR /id=1            -
                        /type=$rest_of_line         -
                        /prompt="Address"
        syntax clear_interrupt/id=102
            qualifier   all                         -
                        /syntax=clear_interrupt_all
            parameter   INTERRUPT_ID/id=1002        -
                        /type=$rest_of_line         -
                        /prompt="Fault"
        syntax clear_memory/id=103
            qualifier   statistics                  -
                        /syntax=clear_mem_stat
        syntax clear_profiles/id=104
    
    
    type show_types
        keyword         string_pool     /syntax=show_string
        keyword         nvram           /syntax=show_nvram      
        keyword         error           /syntax=show_error
        keyword         mode            /syntax=show_mode
        keyword         shim            /syntax=show_shim
        keyword         page            /syntax=show_page
        keyword         pte             /syntax=show_page
        keyword         call_frames     /syntax=show_call_frames
        keyword         calls           /syntax=show_call_frames
        keyword         quantum         /syntax=show_quantum
        keyword         debug           /syntax=show_debug
        keyword         assembler_flags /syntax=show_assembler_flags
        keyword         instructions    /syntax=show_instructions
        keyword         breakpoints     /syntax=show_break
        keyword         registers       /syntax=show_reg
        keyword         reg             /syntax=show_reg
        keyword         step_mode       /syntax=show_step
        keyword         psl             /syntax=show_psl
        keyword         cpu_status      /syntax=show_cpu
        keyword         base            /syntax=show_base
        keyword         memory          /syntax=show_memory
        keyword         vm              /syntax=show_memory
        keyword         stack           /syntax=show_stack
        keyword         isp             /syntax=show_isp
        keyword         ksp             /syntax=show_ksp
        keyword         esp             /syntax=show_esp
        keyword         ssp             /syntax=show_ssp
        keyword         usp             /syntax=show_usp
        keyword         exceptions      /syntax=show_fault
        keyword         faults          /syntax=show_fault
        keyword         radix           /syntax=show_radix
        keyword         trace           /syntax=show_trace
        keyword         disassembly     /syntax=show_trace
        keyword         scb             /syntax=show_scb
        keyword         symbols         /syntax=show_sym
        keyword         rom             /syntax=show_rom
        keyword         tb              /syntax=show_tb
        keyword         translation_buffer/syntax=show_tb
        keyword         maps            /syntax=show_map
        keyword         images          /syntax=show_images
        keyword         regions         /syntax=show_regions
        keyword         share_prefix    /syntax=show_share
        keyword         r0
        keyword         r1
        keyword         r2
        keyword         r3
        keyword         r4
        keyword         r5
        keyword         r6
        keyword         r7
        keyword         r8
        keyword         r9
        keyword         r10
        keyword         r11
        keyword         r12
        keyword         r13
        keyword         r14
        keyword         r15
        keyword         AP
        keyword         FP
        keyword         SP
        keyword         PC
        keyword         p0br
        keyword         p0lr
        keyword         p1br
        keyword         p1l4
        keyword         sbr
        keyword         slr
        keyword         pcbb
        keyword         scbb
        keyword         ipl
        keyword         astlvl
        keyword         sirr
        keyword         sisr
        keyword         iccs
        keyword         nicr
        keyword         icr
        keyword         todr
        keyword         rxcs
        keyword         rxdb
        keyword         txcs
        keyword         txdb
        keyword         tbdr
        keyword         savisp
        keyword         savpc
        keyword         savpsl
        keyword         wcsa
        keyword         wcsb
        keyword         mapen
        keyword         tbia
        keyword         tbis
        keyword         pmr
        keyword         sid
        keyword         tbchk
                
    verb show/id=120
    
        parameter       SHOW_TYPE/id=160            -
                        /type=show_types            -
                        /prompt="What"
        
        syntax          show_map/id=156                
        syntax          show_tb/id=155
        syntax          show_rom/id=154
        syntax          show_scb/id=148
            qualifier   all/id=1032
        syntax          show_sym_all/id=150
        syntax          show_sym_sys/id=151
        syntax          show_sym_tmp/id=152
        syntax          show_sym_unres/id=153
        syntax          show_sym/id=149
            qualifier   system                      -
                        /syntax=show_sym_sys
            qualifier   temporary                   -
                        /syntax=show_sym_tmp
            qualifier   unresolved                  -
                        /syntax=show_sym_unres
            qualifier   all                         -
                        /syntax=show_sym_all
            parameter   symbol          /id=1021    -
                        /type=$name                 -
                        /prompt="Symbol name"
        syntax          show_trace/id=147
        syntax          show_radix/id=146
        syntax          show_fault/id=145
        syntax          show_stack/id=139
            parameter   count/type=$rest_of_line/id=1031
            qualifier   all/id=1030
        syntax          show_usp/id=140
            parameter   count/type=$rest_of_line/id=1031
            qualifier   all/id=1030
        syntax          show_ssp/id=141
            parameter   count/type=$rest_of_line/id=1031
            qualifier   all/id=1030
        syntax          show_esp/id=142
            parameter   count/type=$rest_of_line/id=1031
            qualifier   all/id=1030
        syntax          show_ksp/id=143
            parameter   count/type=$rest_of_line/id=1031
            qualifier   all/id=1030
        syntax          show_isp/id=144
            parameter   count/type=$rest_of_line/id=1031
            qualifier   all/id=1030
        
        syntax          show_psl/id=135
        syntax          show_cpu/id=136
        syntax          show_base/id=137
        syntax          show_memory/id=138
            qualifier   statistics/id=1016
            qualifier   runtime/id=1010
            qualifier   full/id=1011

        syntax          show_step/id=134
        syntax          show_reg/id=133
        syntax          show_break/id=132
            qualifier   faults/id=1014
            qualifier   addresses/id=1015
            disallow    faults and addresses
        syntax          show_string/id=121
        syntax          show_nvram/id=122
        syntax          show_error/id=123
            parameter   code/id=1005                -
                        /type=$rest_of_line
        syntax          show_mode/id=124
        syntax          show_shim/id=125
        syntax          show_page/id=126
            qualifier   write/id=1006               -
                        /nonegatable
            qualifier   read/id=1007                -
                        /nonegatable
            parameter   address/id=1008             -
                        /type=$rest_of_line         -
                        /prompt="Address"
            disallow    read and write
        syntax          show_call_frames/id=127
            parameter   count/id=1009               -
                        /type=$rest_of_line
        syntax          show_quantum/id=128
        syntax          show_debug/id=129
        syntax          show_assembler_flags/id=130
        syntax          show_images/id=160
        syntax          show_share/id=161
        syntax          show_regions/id=162
        syntax          show_instructions/id=131
            qualifier   modes/id=1009
            qualifier   profile/id=1010
            qualifier   unimplemented/id=1011
            qualifier   all/id=1012
            parameter   opcode/id=1013              -
                        /type=$rest_of_line
            disallow    modes and profile
            disallow    modes and unimplemented
            disallow    modes and all
            disallow    unimplemented and all
            disallow    unimplemented and profile
            disallow    profile and all
            
     
end
